// Copyright (c) 2021 Soni L.
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT license.
// Documentation and comments licensed under CC BY-SA 4.0.

// because we wanna use double underscore (__) for test names
#![allow(non_snake_case)]

use ::iosonism::suggestion::Suggestion;
use ::iosonism::suggestion::Suggestions;

#[test]
fn test_merge__empty() {
    let merged = Suggestions::merge("foo b", Vec::new());
    assert!(merged.is_empty());
}

#[test]
fn test_merge__single() {
    let suggestions = Suggestions::create("foo b", vec![
        Suggestion::new(5..5, "ar".into()),
    ]);
    let merged = Suggestions::merge("foo b", vec![suggestions.clone()]);
    assert_eq!(merged, suggestions);
}

#[test]
fn test_merge__multiple() {
    // it is possible the equivalent of this test fails sometimes in brigdier,
    // but it should never fail here.
    // also we use ASCII/UTF-8 ordering rather than locale-sensitive ordering.
    let a = Suggestions::create("foo b", vec![
        Suggestion::new(5..5, "ar".into()),
        Suggestion::new(5..5, "az".into()),
        Suggestion::new(5..5, "Ar".into()),
    ]);
    let b = Suggestions::create("foo b", vec![
        Suggestion::new(4..5, "foo".into()),
        Suggestion::new(4..5, "qux".into()),
        Suggestion::new(4..5, "apple".into()),
        Suggestion::new(4..5, "Bar".into()),
    ]);
    let merged = Suggestions::merge("foo b", vec![a, b]);
    assert_eq!(merged.get_range(), 4..5);
    assert_eq!(merged.take_list(), vec![
        Suggestion::new(4..5, "Bar".into()),
        Suggestion::new(4..5, "apple".into()),
        Suggestion::new(4..5, "bAr".into()),
        Suggestion::new(4..5, "bar".into()),
        Suggestion::new(4..5, "baz".into()),
        Suggestion::new(4..5, "foo".into()),
        Suggestion::new(4..5, "qux".into()),
    ]);
}
