// Copyright (c) 2021 Soni L.
// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT license.
// Documentation and comments licensed under CC BY-SA 4.0.

// because we wanna use double underscore (__) for test names
#![allow(non_snake_case)]

use ::iosonism::suggestion::Suggestion;

#[test]
fn test_apply__insertion_start() {
    let s = Suggestion::new(0..0, "And so I said: ".into());
    assert_eq!(s.apply("Hello world!".into()), "And so I said: Hello world!");
}

#[test]
fn test_apply__insertion_middle() {
    let s = Suggestion::new(6..6, "small ".into());
    assert_eq!(s.apply("Hello world!".into()), "Hello small world!");
}

#[test]
fn test_apply__insertion_end() {
    let s = Suggestion::new(5..5, " world!".into());
    assert_eq!(s.apply("Hello".into()), "Hello world!");
}

#[test]
fn test_apply__replacement_start() {
    let s = Suggestion::new(0..5, "Goodbye".into());
    assert_eq!(s.apply("Hello world!".into()), "Goodbye world!");
}

#[test]
fn test_apply__replacement_middle() {
    let s = Suggestion::new(6..11, "Alex".into());
    assert_eq!(s.apply("Hello world!".into()), "Hello Alex!");
}

#[test]
fn test_apply__replacement_end() {
    let s = Suggestion::new(6..12, "Creeper!".into());
    assert_eq!(s.apply("Hello world!".into()), "Hello Creeper!");
}

#[test]
fn test_apply__replacement_everything() {
    let s = Suggestion::new(0..12, "Oh dear.".into());
    assert_eq!(s.apply("Hello world!".into()), "Oh dear.");
}

#[test]
fn test_expand__unchanged() {
    let mut s = Suggestion::new(1..1, "oo".into());
    s.expand("f", 1..1);
    assert_eq!(s, Suggestion::new(1..1, "oo".into()));
}

#[test]
fn test_expand__left() {
    let mut s = Suggestion::new(1..1, "oo".into());
    s.expand("f", 0..1);
    assert_eq!(s, Suggestion::new(0..1, "foo".into()));
}

#[test]
fn test_expand__right() {
    let mut s = Suggestion::new(0..0, "minecraft:".into());
    s.expand("fish", 0..4);
    assert_eq!(s, Suggestion::new(0..4, "minecraft:fish".into()));
}

#[test]
fn test_expand__both() {
    let mut s = Suggestion::new(11..11, "minecraft:".into());
    s.expand("give Steve fish_block", 5..21);
    assert_eq!(s, Suggestion::new(5..21, "Steve minecraft:fish_block".into()));
}

#[test]
fn test_expand__replacement() {
    let mut s = Suggestion::new(6..11, "strangers".into());
    s.expand("Hello world!", 0..12);
    assert_eq!(s, Suggestion::new(0..12, "Hello strangers!".into()));
}
