// Copyright (c) 2021 Soni L.
//
// Licensed under the MIT license.
// Documentation and comments licensed under CC BY-SA 4.0.

use ::iosonism::strcursor::ReadError;
use ::iosonism::strcursor::StringReader;

/// An implementation of various Iosonism errors that just panics.
#[derive(Debug)]
pub enum ErrorPanic {
    // uninhabitable!
}

impl ::std::fmt::Display for ErrorPanic {
    fn fmt(&self, _: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        match *self {
        }
    }
}

impl ::std::error::Error for ErrorPanic {
}

impl<'a, C: StringReader<'a>> ReadError<'a, C> for ErrorPanic {
    fn invalid_integer(context: &C, from: &str) -> Self {
        if !context.get_remaining().is_empty() {
            panic!(
                "invalid integer: {} at ...{}",
                from,
                context.get_remaining(),
            );
        } else {
            panic!("invalid integer: {}", from);
        }
    }
    fn expected_integer(context: &C) -> Self {
        if !context.get_remaining().is_empty() {
            panic!("expected integer at ...{}", context.get_remaining());
        } else {
            panic!("expected integer");
        }
    }
    fn invalid_float(context: &C, from: &str) -> Self {
        if !context.get_remaining().is_empty() {
            panic!(
                "invalid float: {} at ...{}",
                from,
                context.get_remaining(),
            );
        } else {
            panic!("invalid float: {}", from);
        }
    }
    fn expected_float(context: &C) -> Self {
        if !context.get_remaining().is_empty() {
            panic!("expected float at ...{}", context.get_remaining());
        } else {
            panic!("expected float");
        }
    }
    fn invalid_bool(context: &C, from: &str) -> Self {
        if !context.get_remaining().is_empty() {
            panic!(
                "invalid bool: {} at ...{}",
                from,
                context.get_remaining(),
            );
        } else {
            panic!("invalid bool: {}", from);
        }
    }
    fn expected_bool(context: &C) -> Self {
        if !context.get_remaining().is_empty() {
            panic!("expected bool at ...{}", context.get_remaining());
        } else {
            panic!("expected bool");
        }
    }
    fn expected_start_of_quote(context: &C) -> Self {
        if !context.get_remaining().is_empty() {
            panic!("expected start of quote at ...{}", context.get_remaining());
        } else {
            panic!("expected start of quote");
        }
    }
    fn expected_end_of_quote(context: &C) -> Self {
        if !context.get_remaining().is_empty() {
            panic!("expected end of quote at ...{}", context.get_remaining());
        } else {
            panic!("expected end of quote");
        }
    }
    fn invalid_escape(context: &C, from: &str) -> Self {
        if !context.get_remaining().is_empty() {
            panic!(
                "invalid escape: {} at ...{}",
                from,
                context.get_remaining(),
            );
        } else {
            panic!("invalid escape: {}", from);
        }
    }
    fn expected_symbol(context: &C, from: &str) -> Self {
        if !context.get_remaining().is_empty() {
            panic!(
                "expected symbol: {} at ...{}",
                from,
                context.get_remaining(),
            );
        } else {
            panic!("expected symbol: {}", from);
        }
    }
}

