// Copyright (c) 2021 Soni L.
//
// Licensed under the MIT license.
// Documentation and comments licensed under CC BY-SA 4.0.

//! Iosonism is a command parsing library. It parses commands from strings, in
//! contrast with an argument parsing library, which parses arrays of strings.
//!
//! Iosonism is based on [Brigadier](https://github.com/Mojang/brigadier).
//!
//! This documentation is licensed under CC BY-SA 4.0. To view a copy of this
//! license, visit http://creativecommons.org/licenses/by-sa/4.0/

// quick overview of brigadier vs iosonism:
//
// - brigadier.StringReader -> iosonism::strcursor::StringReader + Cursor<&str>
// - brigadier.context.StringRange -> Range<usize>
// - brigadier.suggestion.Suggestion -> iosonism::suggestion::Suggestion;
// - brigadier.suggestion.Suggestions -> iosonism::suggestion::Suggestions;
// - brigadier.suggestion.SuggestionsBuilder -> iosonism::suggestion::SuggestionsBuilder;

pub mod strcursor;
pub mod suggestion;
pub mod args;

#[cfg(test)]
mod tests {
    #[test]
    fn it_works() {
        let result = 2 + 2;
        assert_eq!(result, 4);
    }
}
