# `gcc` vs `musl`

* Ubuntu 14.04 E5-2690 v3
    * rustc 1.40
    * gcc with lto
    * musl with lto
* WSL under Windows 11, Ryzen 7 5800
    * rustc 1.60.0

## `bash benchmarks/musl/run.sh`

```bash
# cargo install --path ~/Scripts/rust/intspan --force

bash ~/Scripts/intspan/benchmarks/musl/run.sh

find ~/Scripts/intspan/benchmarks/musl/* |
    grep -v "run.sh" |
    xargs rm -fr

```

## Results

* Above - Ubuntu 14.04
* Below - WSL

* sort

| Command |    Mean [ms] | Min [ms] | Max [ms] | Relative |
|:--------|-------------:|---------:|---------:|---------:|
| cargo   | 127.9 ± 22.7 |     97.3 |    147.7 |      1.2 |
| gcc     | 107.9 ± 21.6 |     92.2 |    142.5 |      1.0 |
| musl    | 132.9 ± 23.2 |    102.2 |    151.4 |      1.2 |

| Command |  Mean [ms] | Min [ms] | Max [ms] |    Relative |
|:--------|-----------:|---------:|---------:|------------:|
| `cargo` | 36.6 ± 0.5 |     35.8 |     38.0 |        1.00 |
| `gcc`   | 68.0 ± 1.3 |     63.3 |     71.4 | 1.86 ± 0.04 |
| `musl`  | 74.6 ± 1.9 |     70.1 |     77.6 | 2.04 ± 0.06 |


* clean

| Command |      Mean [s] | Min [s] | Max [s] | Relative |
|:--------|--------------:|--------:|--------:|---------:|
| cargo   | 4.266 ± 0.075 |   4.224 |   4.478 |      1.0 |
| gcc     | 6.090 ± 2.789 |   3.824 |   9.361 |      1.4 |
| musl    | 7.869 ± 3.102 |   4.839 |  11.355 |      1.8 |

| Command |      Mean [s] | Min [s] | Max [s] |    Relative |
|:--------|--------------:|--------:|--------:|------------:|
| `cargo` | 1.446 ± 0.344 |   1.279 |   2.351 | 1.06 ± 0.25 |
| `gcc`   | 1.361 ± 0.029 |   1.334 |   1.420 |        1.00 |
| `musl`  | 2.624 ± 0.029 |   2.586 |   2.697 | 1.93 ± 0.05 |

* merge

| Command |      Mean [s] | Min [s] | Max [s] | Relative |
|:--------|--------------:|--------:|--------:|---------:|
| cargo   | 2.991 ± 0.006 |   2.976 |   2.999 |      1.1 |
| gcc     | 2.712 ± 0.003 |   2.707 |   2.716 |      1.0 |
| musl    | 4.527 ± 0.086 |   4.492 |   4.770 |      1.7 |

| Command |      Mean [s] | Min [s] | Max [s] |    Relative |
|:--------|--------------:|--------:|--------:|------------:|
| `cargo` | 1.251 ± 0.041 |   1.218 |   1.335 |        1.00 |
| `gcc`   | 1.253 ± 0.022 |   1.228 |   1.289 | 1.00 ± 0.04 |
| `musl`  | 2.791 ± 0.027 |   2.766 |   2.833 | 2.23 ± 0.08 |

* clean2

| Command |      Mean [s] | Min [s] | Max [s] | Relative |
|:--------|--------------:|--------:|--------:|---------:|
| cargo   | 5.152 ± 0.026 |   5.132 |   5.221 |      1.1 |
| gcc     | 4.821 ± 0.003 |   4.817 |   4.826 |      1.0 |
| musl    | 5.983 ± 0.924 |   3.370 |   6.544 |      1.2 |

| Command |      Mean [ms] | Min [ms] | Max [ms] |    Relative |
|:--------|---------------:|---------:|---------:|------------:|
| `cargo` |    828.6 ± 6.9 |    817.6 |    838.1 |        1.00 |
| `gcc`   |   873.9 ± 15.7 |    857.5 |    915.8 | 1.05 ± 0.02 |
| `musl`  | 2198.2 ± 650.3 |   1468.9 |   3210.7 | 2.65 ± 0.79 |

* connect

| Command |    Mean [ms] | Min [ms] | Max [ms] | Relative |
|:--------|-------------:|---------:|---------:|---------:|
| cargo   |  387.0 ± 0.7 |    386.2 |    387.8 |      1.0 |
| gcc     | 374.5 ± 74.3 |    247.8 |    532.1 |      1.0 |
| musl    |  383.0 ± 0.6 |    382.0 |    384.2 |      1.0 |

| Command |   Mean [ms] | Min [ms] | Max [ms] |    Relative |
|:--------|------------:|---------:|---------:|------------:|
| `cargo` |  83.8 ± 4.2 |     79.0 |    102.0 |        1.00 |
| `gcc`   | 118.5 ± 7.9 |    107.4 |    135.2 | 1.41 ± 0.12 |
| `musl`  | 131.6 ± 3.9 |    125.5 |    138.9 | 1.57 ± 0.09 |

* filter

| Command |   Mean [ms] | Min [ms] | Max [ms] | Relative |
|:--------|------------:|---------:|---------:|---------:|
| cargo   |  59.2 ± 1.1 |     58.4 |     66.2 |      1.1 |
| gcc     |  54.7 ± 0.3 |     54.2 |     55.7 |      1.0 |
| musl    | 55.6 ± 22.3 |     30.9 |    126.5 |      1.0 |

| Command |  Mean [ms] | Min [ms] | Max [ms] |    Relative |
|:--------|-----------:|---------:|---------:|------------:|
| `cargo` | 14.8 ± 0.9 |     13.4 |     20.4 |        1.00 |
| `gcc`   | 48.7 ± 2.6 |     41.5 |     56.6 | 3.29 ± 0.27 |
| `musl`  | 49.9 ± 2.6 |     44.9 |     61.0 | 3.37 ± 0.28 |
