# `gcc` vs `musl`

* Ubuntu 14.04 E5-2690 v3
    * rustc 1.40
    * gcc with lto
    * musl with lto
* WSL under Windows 11, Ryzen 7 5800
    * rustc 1.58.1

## `bash benchmarks/musl/run.sh`

```bash
# cargo install --path ~/Scripts/rust/intspan --force

bash ~/Scripts/intspan/benchmarks/musl/run.sh

find ~/Scripts/intspan/benchmarks/musl/* |
    grep -v "run.sh" |
    xargs rm -fr

```

## Results

* Above - Ubuntu 14.04
* Below - WSL

* sort

| Command |    Mean [ms] | Min [ms] | Max [ms] | Relative |
|:--------|-------------:|---------:|---------:|---------:|
| cargo   | 127.9 ± 22.7 |     97.3 |    147.7 |      1.2 |
| gcc     | 107.9 ± 21.6 |     92.2 |    142.5 |      1.0 |
| musl    | 132.9 ± 23.2 |    102.2 |    151.4 |      1.2 |

| Command |  Mean [ms] | Min [ms] | Max [ms] |    Relative |
|:--------|-----------:|---------:|---------:|------------:|
| cargo   | 37.6 ± 1.1 |     36.0 |     43.9 |        1.00 |
| gcc     | 67.5 ± 2.1 |     63.2 |     72.5 | 1.79 ± 0.08 |
| musl    | 75.3 ± 1.8 |     70.9 |     78.8 | 2.00 ± 0.08 |

* clean

| Command |      Mean [s] | Min [s] | Max [s] | Relative |
|:--------|--------------:|--------:|--------:|---------:|
| cargo   | 4.266 ± 0.075 |   4.224 |   4.478 |      1.0 |
| gcc     | 6.090 ± 2.789 |   3.824 |   9.361 |      1.4 |
| musl    | 7.869 ± 3.102 |   4.839 |  11.355 |      1.8 |

| Command |      Mean [s] | Min [s] | Max [s] |    Relative |
|:--------|--------------:|--------:|--------:|------------:|
| cargo   | 1.598 ± 0.015 |   1.581 |   1.622 | 1.20 ± 0.02 |
| gcc     | 1.336 ± 0.019 |   1.321 |   1.383 |        1.00 |
| musl    | 2.614 ± 0.014 |   2.592 |   2.636 | 1.96 ± 0.03 |

* merge

| Command |      Mean [s] | Min [s] | Max [s] | Relative |
|:--------|--------------:|--------:|--------:|---------:|
| cargo   | 2.991 ± 0.006 |   2.976 |   2.999 |      1.1 |
| gcc     | 2.712 ± 0.003 |   2.707 |   2.716 |      1.0 |
| musl    | 4.527 ± 0.086 |   4.492 |   4.770 |      1.7 |

| Command |      Mean [s] | Min [s] | Max [s] |    Relative |
|:--------|--------------:|--------:|--------:|------------:|
| cargo   | 1.253 ± 0.017 |   1.231 |   1.286 |        1.00 |
| gcc     | 1.264 ± 0.023 |   1.239 |   1.307 | 1.01 ± 0.02 |
| musl    | 2.837 ± 0.024 |   2.805 |   2.874 | 2.26 ± 0.04 |

* clean2

| Command |      Mean [s] | Min [s] | Max [s] | Relative |
|:--------|--------------:|--------:|--------:|---------:|
| cargo   | 5.152 ± 0.026 |   5.132 |   5.221 |      1.1 |
| gcc     | 4.821 ± 0.003 |   4.817 |   4.826 |      1.0 |
| musl    | 5.983 ± 0.924 |   3.370 |   6.544 |      1.2 |

| Command |     Mean [ms] | Min [ms] | Max [ms] |    Relative |
|:--------|--------------:|---------:|---------:|------------:|
| cargo   |   954.7 ± 9.8 |    940.6 |    969.3 | 1.10 ± 0.01 |
| gcc     |   864.2 ± 6.5 |    855.5 |    874.4 |        1.00 |
| musl    | 1495.2 ± 18.1 |   1472.0 |   1531.4 | 1.73 ± 0.02 |

* connect

| Command |    Mean [ms] | Min [ms] | Max [ms] | Relative |
|:--------|-------------:|---------:|---------:|---------:|
| cargo   |  387.0 ± 0.7 |    386.2 |    387.8 |      1.0 |
| gcc     | 374.5 ± 74.3 |    247.8 |    532.1 |      1.0 |
| musl    |  383.0 ± 0.6 |    382.0 |    384.2 |      1.0 |

| Command |   Mean [ms] | Min [ms] | Max [ms] |    Relative |
|:--------|------------:|---------:|---------:|------------:|
| cargo   |  81.1 ± 2.7 |     77.9 |     88.9 |        1.00 |
| gcc     | 116.5 ± 3.6 |    110.6 |    122.5 | 1.44 ± 0.06 |
| musl    | 130.4 ± 3.7 |    123.8 |    137.6 | 1.61 ± 0.07 |

* filter

| Command |   Mean [ms] | Min [ms] | Max [ms] | Relative |
|:--------|------------:|---------:|---------:|---------:|
| cargo   |  59.2 ± 1.1 |     58.4 |     66.2 |      1.1 |
| gcc     |  54.7 ± 0.3 |     54.2 |     55.7 |      1.0 |
| musl    | 55.6 ± 22.3 |     30.9 |    126.5 |      1.0 |

| Command |  Mean [ms] | Min [ms] | Max [ms] |    Relative |
|:--------|-----------:|---------:|---------:|------------:|
| cargo   | 14.9 ± 0.8 |     13.5 |     20.1 |        1.00 |
| gcc     | 47.1 ± 3.7 |     39.4 |     54.3 | 3.17 ± 0.30 |
| musl    | 51.5 ± 3.6 |     45.6 |     61.9 | 3.46 ± 0.30 |
