#![doc = include_str!("../Readme.md")]

pub use into_variant::*;
/// Implements conversion from inner types into enum variants.
///
/// Add `#[derive(VariantFrom)]` on an enum with single-field variants. This will implement `IntoVariant<YourEnum>` for all the types contained in the variants, and, by consequence, you'll also get `VariantFrom` on `YourEnum`.
///
/// Example:
/// ```
/// use into_variant::{IntoVariant, VariantFrom};
///
/// #[derive(VariantFrom)]
/// enum Fill {
///     Color(Color),
///     Pattern(Pattern),
/// }
///
/// struct Color {}
/// struct Pattern {}
///
/// // now, this works:
/// let variant = Fill::variant_from(Color {});
/// assert!(matches!(variant, Fill::Color(_)));
///
/// // or, alternatively:
/// let variant = Color {}.into_variant();
/// assert!(matches!(variant, Fill::Color(_)));
/// ```
pub use into_variant_macro::VariantFrom;

mod into_variant;

#[test]
fn test_compile_errors() {
    let t = trybuild::TestCases::new();
    t.compile_fail("tests_error/*.rs");
}
