use into_variant::{IntoVariant, VariantFrom};

#[derive(VariantFrom, PartialEq)]
enum AppMessage {
    SaveMessage(SaveMessage),
    EditorMessage(EditorMessage),
}

#[derive(PartialEq)]
struct SaveMessage {
    overwrite: bool,
}

#[test]
fn test_from_save_message() {
    let save_message = SaveMessage { overwrite: true };

    let app_message: AppMessage = save_message.into_variant();
    assert!(app_message == AppMessage::SaveMessage(SaveMessage { overwrite: true }))
}

#[derive(VariantFrom, PartialEq)]
enum EditorMessage {
    Insert(InsertMessage),
    Formatting(FormattingMessage),
}

#[derive(VariantFrom, PartialEq)]
enum FormattingMessage {
    ClearFormatting(ClearFormattingMessage),
}

#[derive(PartialEq)]
struct ClearFormattingMessage {}

#[test]
fn test_from_clear_formatting() {
    let clear_formatting = ClearFormattingMessage {};

    let app_message: AppMessage = clear_formatting.into_variant();

    let expected = AppMessage::EditorMessage(EditorMessage::Formatting(
        FormattingMessage::ClearFormatting(ClearFormattingMessage {}),
    ));
    assert!(app_message == expected)
}

#[derive(PartialEq)]
struct InsertMessage {
    text: String,
}
