use interoptopus::util::NamespaceMappings;

/// Configures C# code generation.
#[derive(Clone, Debug)]
pub struct Config {
    /// The file header, e.g., `// (c) My Company`.
    pub file_header_comment: String,
    /// Static class for Interop methods, e.g., `Interop`.
    pub class: String,
    /// DLL to load, e.g., `my_library`.
    pub dll_name: String,
    /// Maps which namespace id belongs into which FQN (e.g., "common" => "MyCompany.Common").
    pub namespace_mappings: NamespaceMappings,
    /// Namespace ID of _this_ namespace to write (default "").
    pub namespace_id: String,
    /// Whether [`Visibility`](interoptopus::lang::c::Visibility) information should be honored.
    pub emit_rust_visibility: bool,
    /// Whether, say, a `x: [u8; 3]` should become 3 `x0: u8, ...` instead.
    ///
    /// If this is not set, interop generation with arrays in structr will fail. This is a somewhat
    /// open issue w.r.t Unity-sans-unsafe support and feedback would be greatly welcome!
    pub unroll_struct_arrays: bool,
    /// Also generate markers for easier debugging
    pub debug: bool,
}

impl Config {}

impl Default for Config {
    fn default() -> Self {
        Self {
            file_header_comment: "// Automatically generated by Interoptopus.".to_string(),
            class: "Interop".to_string(),
            dll_name: "library".to_string(),
            namespace_mappings: NamespaceMappings::new("My.Company"),
            namespace_id: "".to_string(),
            emit_rust_visibility: false,
            unroll_struct_arrays: false,
            debug: false,
        }
    }
}
