use syn::Expr;

pub fn print_expr_type(args: Expr) {
    match args {
        Expr::Array(_) => println!("ExprArray"),
        Expr::Assign(_) => println!("ExprAssign"),
        Expr::AssignOp(_) => println!("ExprAssignOp"),
        Expr::Async(_) => println!("ExprAsync"),
        Expr::Await(_) => println!("ExprAwait"),
        Expr::Binary(_) => println!("ExprBinary"),
        Expr::Block(_) => println!("ExprBlock"),
        Expr::Box(_) => println!("ExprBox"),
        Expr::Break(_) => println!("ExprBreak"),
        Expr::Call(_) => println!("ExprCall"),
        Expr::Cast(_) => println!("ExprCast"),
        Expr::Closure(_) => println!("ExprClosure"),
        Expr::Continue(_) => println!("ExprContinue"),
        Expr::Field(_) => println!("ExprField"),
        Expr::ForLoop(_) => println!("ExprForLoop"),
        Expr::Group(_) => println!("ExprGroup"),
        Expr::If(_) => println!("ExprIf"),
        Expr::Index(_) => println!("ExprIndex"),
        Expr::Let(_) => println!("ExprLet"),
        Expr::Lit(_) => println!("ExprLit"),
        Expr::Loop(_) => println!("ExprLoop"),
        Expr::Macro(_) => println!("ExprMacro"),
        Expr::Match(_) => println!("ExprMatch"),
        Expr::MethodCall(_) => println!("ExprMethodCall"),
        Expr::Paren(_) => println!("ExprParen"),
        Expr::Path(_) => println!("ExprPath"),
        Expr::Range(_) => println!("ExprRange"),
        Expr::Reference(_) => println!("ExprReference"),
        Expr::Repeat(_) => println!("ExprRepeat"),
        Expr::Return(_) => println!("ExprReturn"),
        Expr::Struct(_) => println!("ExprStruct"),
        Expr::Try(_) => println!("ExprTry"),
        Expr::TryBlock(_) => println!("ExprTryBlock"),
        Expr::Tuple(_) => println!("ExprTuple"),
        Expr::Type(_) => println!("ExprType"),
        Expr::Unary(_) => println!("ExprUnary"),
        Expr::Unsafe(_) => println!("ExprUnsafe"),
        Expr::Verbatim(_) => println!("TokenStream"),
        Expr::While(_) => println!("ExprWhile"),
        Expr::Yield(_) => println!("ExprYield"),
        _ => println!("Other"),
    }
}
