include(ExternalProject)

set(INTEGRUSTIO_INCLUDE_DIR ${CMAKE_SOURCE_DIR}/integrustio/integrustio_export/src)
set(INTEGRUSTIO_LIB_NAME ${CMAKE_STATIC_LIBRARY_PREFIX}integrustio_export${CMAKE_STATIC_LIBRARY_SUFFIX})

if (CMAKE_BUILD_TYPE MATCHES Release)
    set(INTEGRUSTIO_TARGET --release)
    set(INTEGRUSTIO_DIR ${CMAKE_SOURCE_DIR}/target/release)
else ()
    set(INTEGRUSTIO_DIR ${CMAKE_SOURCE_DIR}/target/debug)
endif ()
set(INTEGRUSTIO_LIB ${INTEGRUSTIO_DIR}/${INTEGRUSTIO_LIB_NAME})

set(INTEGRUSTIO_LIB_SRC ${INTEGRUSTIO_INCLUDE_DIR}/lib.rs ${INTEGRUSTIO_INCLUDE_DIR}/integrustio_export.h)

if (UNIX)
    set(INTEGRUSTIO_LIB ${INTEGRUSTIO_LIB} dl pthread)
endif ()

ExternalProject_Add(
        integrustio_libs
        SOURCE_DIR ${INTEGRUSTIO_INCLUDE_DIR}
        CONFIGURE_COMMAND ""
        BUILD_COMMAND ""
        INSTALL_COMMAND ""
        TEST_COMMAND ""
)

execute_process(
        COMMAND cargo build ${INTEGRUSTIO_TARGET} ${INTEGRUSTIO_LIB_ONLY}
        RESULT_VARIABLE result
        WORKING_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}
)
if (result)
    message(FATAL_ERROR "cargo build for integrustio failed: ${result}")
endif ()

include_directories(${INTEGRUSTIO_INCLUDE_DIR})
