mod msg;
mod querier;
mod query;
mod route;
mod subaccount;
mod spot;
mod derivative;
mod exchange;
mod order;
mod derivative_market;
mod spot_market;

pub use msg::{
    create_deposit_msg, create_withdraw_msg, create_subaccount_transfer_msg, create_external_transfer_msg,
    create_spot_market_order_msg, create_derivative_market_order_msg, create_increase_position_margin_msg,
    create_liquidate_position_msg, create_register_as_dmm_msg, create_batch_update_orders_msg,
    InjectiveMsg, InjectiveMsgWrapper,
};

pub use querier::InjectiveQuerier;
pub use query::{
    InjectiveQuery, InjectiveQueryWrapper, SubaccountDepositResponse,
};
pub use route::InjectiveRoute;
pub use subaccount::{
    addr_to_bech32, address_to_subaccount_id, bech32_to_hex, default_subaccount_id, subaccount_id_to_ethereum_address,
    subaccount_id_to_injective_address,
};

pub use order::{
    OrderData, OrderInfo,
};

pub use exchange::{
    Deposit,
};

pub use spot::{
    SpotLimitOrder, SpotOrder, TrimmedSpotLimitOrder, SpotMarketOrder,
};

pub use spot_market::{
    SpotMarket,
};

pub use derivative::{
    Position, EffectivePosition, DerivativePosition, DerivativeOrder, DerivativeLimitOrder,
    TrimmedDerivativeLimitOrder, DerivativeMarketOrder,
};

pub use derivative_market::{
    PerpetualMarketInfo, PerpetualMarketFunding, PerpetualMarketState, FullDerivativeMarketPerpetualInfo,
    FullDerivativeMarket, DerivativeMarket,
};

// This export is added to all contracts that import this package, signifying that they require
// "injective" support on the chain they run on.
#[no_mangle]
extern "C" fn requires_injective() {}
