use super::cpuload::{CpuReport, CpuTime};
use super::meminfo::{MemInfo, MemoryReport};
use serde::{Deserialize, Serialize};
use std::fmt;

#[derive(Deserialize, Serialize, Debug, Copy, Clone, Default)]
pub struct InfomgrReport {
    pub cpu: CpuReport,
    pub memory: MemoryReport,
}

impl fmt::Display for InfomgrReport {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{}\n{}", self.cpu, self.memory)
    }
}

#[derive(Deserialize, Serialize, Debug, Copy, Clone)]
pub struct InfomgrRawReport {
    pub cpu: CpuTime,
    pub memory: MemoryReport,
}

impl fmt::Display for InfomgrRawReport {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "{}\n{}", self.cpu, self.memory)
    }
}

impl InfomgrRawReport {
    pub fn new() -> Self {
        InfomgrRawReport {
            cpu: CpuTime::load().unwrap(),
            memory: MemInfo::load(),
        }
    }
}

impl Default for InfomgrRawReport {
    fn default() -> Self {
        InfomgrRawReport::new()
    }
}
