pub mod cpuload;
pub mod meminfo;
pub mod report;

#[cfg(feature = "enable_ipcon")]
pub mod ipcon;

use serde::{de::DeserializeOwned, Serialize};
#[allow(unused)]
use std::io::{Error, ErrorKind, Result};
use std::sync::mpsc::{Receiver, Sender};

#[allow(unused)]
use log::{debug, error, info, warn};

pub trait InfoCon {
    fn sender<T>(&mut self, source: String, receiver: Receiver<T>) -> Result<()>
    where
        T: 'static + Serialize + Send;

    fn receiver<T>(&mut self, source: String, sender: Sender<Option<T>>) -> Result<()>
    where
        T: 'static + DeserializeOwned + Send;
}
