use bitflags::bitflags;
use std::{ffi::CString, net::SocketAddr};

bitflags! {
    /// Flags that represent `eom` actions.
    #[derive(Default)]
    pub struct Actions: u32 {
        const REQUEST_MACROS = 0x100;
        const CHANGE_SENDER = 0x40;
        const ADD_RCPT = 0x4;
        const ADD_RCPT_EXT = 0x80;
        const DELETE_RCPT = 0x8;
        const ADD_HEADER = 0x1;
        const CHANGE_HEADER = 0x10;
        const REPLACE_BODY = 0x2;
        const QUARANTINE = 0x20;
    }
}

impl Actions {
    pub(crate) fn min_actions() -> Self {
        Self::ADD_RCPT | Self::DELETE_RCPT | Self::ADD_HEADER | Self::REPLACE_BODY
    }
}

bitflags! {
    /// Flags that represent milter protocol options.
    #[derive(Default)]
    pub struct ProtoOpts: u32 {
        const NO_CONNECT = 0x1;
        const NO_HELO = 0x2;
        const NO_MAIL = 0x4;
        const NO_RCPT = 0x8;
        const NO_DATA = 0x200;
        const NO_HEADER = 0x20;
        const NO_EOH = 0x40;
        const NO_BODY = 0x10;
        const NO_UNKNOWN = 0x100;

        const NOREPLY_CONNECT = 0x1000;
        const NOREPLY_HELO = 0x2000;
        const NOREPLY_MAIL = 0x4000;
        const NOREPLY_RCPT = 0x8000;
        const NOREPLY_DATA = 0x10000;
        const NOREPLY_HEADER = 0x80;
        const NOREPLY_EOH = 0x40000;
        const NOREPLY_BODY = 0x80000;
        const NOREPLY_UNKNOWN = 0x20000;

        const REJECTED_RCPT = 0x800;
        const HEADER_LEADING_SPACE = 0x100000;
        const SKIP = 0x400;
    }
}

impl ProtoOpts {
    pub(crate) fn min_proto_opts() -> Self {
        Self::NO_CONNECT
            | Self::NO_HELO
            | Self::NO_MAIL
            | Self::NO_RCPT
            | Self::NO_HEADER
            | Self::NO_BODY
    }
}

/// Socket information.
#[derive(Clone, Debug, Eq, Hash, PartialEq)]
pub enum SocketInfo {
    Unknown,
    Inet(SocketAddr),
    Unix(CString),
}
