use bitflags::bitflags;
use std::{ffi::CString, net::SocketAddr};

bitflags! {
    #[derive(Default)]
    pub struct Actions: u32 {
        const ADDHDRS = 0x1;
        const CHGBODY = 0x2;
        const ADDRCPT = 0x4;
        const DELRCPT = 0x8;
        const CHGHDRS = 0x10;
        const QUARANTINE = 0x20;
        const CHGFROM = 0x40;
        const ADDRCPT_PAR = 0x80;
        const SETSYMLIST = 0x100;

        const MIN_ACTIONS = Self::ADDHDRS.bits
            | Self::CHGBODY.bits
            | Self::ADDRCPT.bits
            | Self::DELRCPT.bits;
    }
}

bitflags! {
    #[derive(Default)]
    pub struct ProtoOpts: u32 {
        const NOCONNECT = 0x1;
        const NOHELO = 0x2;
        const NOMAIL = 0x4;
        const NORCPT = 0x8;
        const NOBODY = 0x10;
        const NOHDRS = 0x20;
        const NOEOH = 0x40;
        const NR_HDR = 0x80;
        const NOUNKNOWN = 0x100;
        const NODATA = 0x200;
        const SKIP = 0x400;
        const RCPT_REJ = 0x800;
        const NR_CONN = 0x1000;
        const NR_HELO = 0x2000;
        const NR_MAIL = 0x4000;
        const NR_RCPT = 0x8000;
        const NR_DATA = 0x10000;
        const NR_UNKN = 0x20000;
        const NR_EOH = 0x40000;
        const NR_BODY = 0x80000;
        const HDR_LEADSPC = 0x100000;

        const MIN_PROTO_OPTS = Self::NOCONNECT.bits
            | Self::NOHELO.bits
            | Self::NOMAIL.bits
            | Self::NORCPT.bits
            | Self::NOBODY.bits
            | Self::NOHDRS.bits;
    }
}

/// Socket information.
#[derive(Clone, Debug, Eq, Hash, PartialEq)]
pub enum SocketInfo {
    Inet(SocketAddr),
    Unix(CString),
}
