use crate::proto_util::Actions;
use std::time::Duration;

/// Milter configuration.
#[derive(Clone, Debug, Eq, Hash, PartialEq)]
pub struct Config {
    /// The maximum number of connections open at any time.
    ///
    /// The default is 100.
    pub max_connections: usize,

    /// Actions to enable during `eom` stage.
    ///
    /// The default is empty.
    pub actions: Actions,

    /// The connection timeout.
    ///
    /// This timeout concerns reading/writing of entire commands and replies to
    /// the connection. This limit would be reached eg when a milter client
    /// idles and does not send the next command.
    ///
    /// 30 to 300 seconds may be a reasonable value.
    ///
    /// The default is 60 seconds.
    pub connection_timeout: Duration,
}

impl Default for Config {
    fn default() -> Self {
        Self {
            max_connections: 100,
            actions: Default::default(),
            // TODO: better default to 300, because of Postfix `milter_content_timeout`
            // ^ not sure, after all we send content in chunks!
            connection_timeout: Duration::from_secs(60),
        }
    }
}
