use indymilter::{Callbacks, Context, SocketInfo, Status};
use tokio::{net::UnixListener, signal};

#[tokio::main]
async fn main() {
    let config = Default::default();

    let callbacks = Callbacks::new()
        .on_connect(|context, _, socket_info| {
            Box::pin(handle_connect(context, socket_info))
        });

    let listener = UnixListener::bind("/run/ipmilter.sock")
        .expect("cannot open milter socket");

    indymilter::run(listener, callbacks, config, signal::ctrl_c())
        .await
        .expect("milter execution failed");
}

async fn handle_connect(
    _: &mut Context<()>,
    socket_info: Option<SocketInfo>,
) -> Status {
    if let Some(SocketInfo::Inet(addr)) = socket_info {
        println!("connect from {}", addr.ip());
    }

    Status::Continue
}
