# indymilter

(in development)

Stand-alone asynchronous milter library.

* pure safe Rust, no dependency on C library
* asynchronous paradigm, implementation based on Tokio
* free software

## Example

Here is a simple but complete milter program that logs client IP addresses:

```rust
use indymilter::{Callbacks, Context, SocketInfo, Status};
use tokio::{net::UnixListener, signal};

#[tokio::main]
async fn main() {
    let config = Default::default();

    let callbacks = Callbacks::new()
        .on_connect(|context, _, socket_info| {
            Box::pin(handle_connect(context, socket_info))
        });

    let listener = UnixListener::bind("/run/ipmilter.sock")
        .expect("cannot open milter socket");

    indymilter::run(listener, callbacks, config, signal::ctrl_c())
        .await
        .expect("milter execution failed");
}

async fn handle_connect(
    _: &mut Context<()>,
    socket_info: Option<SocketInfo>,
) -> Status {
    if let Some(SocketInfo::Inet(addr)) = socket_info {
        println!("connect from {}", addr.ip());
    }

    Status::Continue
}
```

## Licence

Copyright © 2021 David Bürgin

This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation, either version 3 of the License, or (at your option) any later
version.
