mod common;

use crate::common::*;
use indymilter::{
    command::{Command, OptNegPayload},
    reply::Reply,
    Actions, Callbacks, ProtoOpts,
};
use std::collections::HashMap;
use tokio::{net::TcpListener, sync::oneshot};

#[tokio::test]
async fn basic1() {
    tracing_subscriber::fmt::init();

    let listener = TcpListener::bind("127.0.0.1:0").await.unwrap();

    let addr = listener.local_addr().unwrap();

    let (shutdown_tx, shutdown_rx) = oneshot::channel();

    let milter = tokio::spawn(indymilter::run(
        listener,
        Callbacks::<()>::new(),
        Default::default(),
        shutdown_rx,
    ));

    let mut client = Client::connect(addr).await.unwrap();

    client.write_command(Command::OptNeg(OptNegPayload {
        version: 6,
        actions: Actions::all(),
        popts: ProtoOpts::all(),
    }))
    .await
    .unwrap();

    let reply = client.read_reply().await.unwrap();
    assert_eq!(
        reply,
        Some(Reply::OptNeg {
            version: 6,
            actions: Actions::empty(),
            popts: ProtoOpts::NOCONNECT
                | ProtoOpts::NOHELO
                | ProtoOpts::NOMAIL
                | ProtoOpts::NORCPT
                | ProtoOpts::NOBODY
                | ProtoOpts::NOHDRS
                | ProtoOpts::NOEOH
                | ProtoOpts::NOUNKNOWN
                | ProtoOpts::NODATA,
            requested_macros: HashMap::new(),
        })
    );

    client.write_command(Command::Quit).await.unwrap();

    let reply = client.read_reply().await.unwrap();
    assert_eq!(reply, None);

    client.disconnect().await.unwrap();

    shutdown_tx.send(()).unwrap();

    milter.await.unwrap().unwrap();
}
