use std::ffi::{CStr, CString};

pub trait IntoCString {
    fn into_c_string(self) -> CString;
}

impl IntoCString for CString {
    fn into_c_string(self) -> Self {
        self
    }
}

impl IntoCString for &CStr {
    fn into_c_string(self) -> CString {
        self.to_owned()
    }
}

impl IntoCString for String {
    fn into_c_string(mut self) -> CString {
        if self.contains('\0') {
            self = self.replace('\0', "\u{fffd}");
        }
        CString::new(self).unwrap()
    }
}

impl IntoCString for &str {
    fn into_c_string(self) -> CString {
        if self.contains('\0') {
            CString::new(self.replace('\0', "\u{fffd}")).unwrap()
        } else {
            CString::new(self).unwrap()
        }
    }
}
