use crate::command::Actions;
use std::time::Duration;

#[derive(Clone, Debug, Eq, Hash, PartialEq)]
pub struct Config {
    // TODO "max_sessions"?:
    pub max_connections: usize,
    pub actions: Actions,

    // This timeout concerns reading/writing of entire commands and replies to
    // the connection. This limit would be reached eg when a milter client idles
    // and does not send the next command.
    //
    // 30 to 60 seconds may be a reasonable value.
    pub connection_timeout: Duration,
}

impl Default for Config {
    fn default() -> Self {
        Self {
            max_connections: 100,
            actions: Default::default(),
            connection_timeout: Duration::from_secs(60),
        }
    }
}
