use ureq::OrAnyStatus;
use url::Url;

use crate::{algorithms::ptd::Type, mf2::types::Document};

pub trait ItemPostTypeResolutionExt {
    fn post_type(&self) -> Type;
}

pub trait FetchMF2FromExt {
    fn fetch_mf2_from(&self) -> Result<Document, crate::Error>;
}

impl FetchMF2FromExt for Url {
    fn fetch_mf2_from(&self) -> Result<Document, crate::Error> {
        let req = ureq::Agent::new().request("GET", self.as_str());

        req.call()
            .or_any_status()
            .map_err(crate::Error::Client)
            .and_then(|resp| {
                microformats::from_reader(resp.into_reader(), self.clone())
                    .map_err(crate::Error::Microformats)
            })
    }
}

impl ItemPostTypeResolutionExt for crate::mf2::types::Item {
    fn post_type(&self) -> Type {
        crate::algorithms::ptd::resolve_from_object(self.clone()).unwrap_or(Type::Note)
    }
}
