#[derive(Default, Clone)]
pub struct Configuration {}

impl crate::IConfiguration for Configuration {}

impl Copy for Configuration {}

impl Configuration {
    fn new() -> Self {
        Self::default()
    }
}

pub fn init() -> Configuration {
    env_logger::builder()
        .filter_level(log::LevelFilter::max())
        .is_test(true)
        .try_init()
        .ok();
    log::debug!("Ready");
    Configuration::new()
}
