mod link_rel;

#[cfg(test)]
mod test;

static APP_USER_AGENT: &str = concat!(env!("CARGO_PKG_NAME"), "/", env!("CARGO_PKG_VERSION"),);

/// Represents the base client interface for IndieWeb activity.
pub trait Configuration {
    /// Define the base request.
    fn request(&self, reason: Option<String>) -> reqwest::Client {
        let agent = if APP_USER_AGENT == self.user_agent() {
            APP_USER_AGENT.to_owned()
        } else {
            format!("{} {}", self.user_agent(), APP_USER_AGENT)
        };

        reqwest::Client::builder()
            .user_agent(format!(
                "{} ({})",
                agent,
                reason.unwrap_or_else(|| "A generic request".to_owned())
            ))
            .timeout(std::time::Duration::new(30, 0))
            .connect_timeout(std::time::Duration::new(30, 0))
            .connection_verbose(true)
            .build()
            .expect("Failed to construct HTTP client for IndieWeb interactivity")
    }

    /// The agent string to use when making out-going requests.
    fn user_agent(&self) -> &str {
        APP_USER_AGENT
    }
}
