
pub enum Country {
	Andorra,
	UnitedArabEmirates,
	Afghanistan,
	AntiguaAndBarbuda,
	Anguilla,
	Albania,
	Armenia,
	Angola,
	Antarctica,
	Argentina,
	AmericanSamoa,
	Austria,
	Australia,
	Aruba,
	AlandIslands,
	Azerbaijan,
	BosniaAndHerzegovina,
	Barbados,
	Bangladesh,
	Belgium,
	BurkinaFaso,
	Bulgaria,
	Bahrain,
	Burundi,
	Benin,
	SaintBarthelemy,
	Bermuda,
	BruneiDarussalam,
	Bolivia,
	BonaireSintEustatiusAndSaba,
	Brazil,
	Bahamas,
	Bhutan,
	BouvetIsland,
	Botswana,
	Belarus,
	Belize,
	Canada,
	CocosKeelingIslands,
	CongoDemocraticRepublic,
	CentralAfricanRepublic,
	Congo,
	Switzerland,
	CoteDIvoire,
	CookIslands,
	Chile,
	Cameroon,
	China,
	Colombia,
	CostaRica,
	Cuba,
	CaboVerde,
	Curacao,
	ChristmasIsland,
	Cyprus,
	Czechia,
	Germany,
	Djibouti,
	Denmark,
	Dominica,
	DominicanRepublic,
	Algeria,
	Ecuador,
	Estonia,
	Egypt,
	WesternSahara,
	Eritrea,
	Spain,
	Ethiopia,
	Finland,
	Fiji,
	FalklandIslands,
	Micronesia,
	FaroeIslands,
	France,
	Gabon,
	UnitedKingdom,
	Grenada,
	Georgia,
	FrenchGuiana,
	Guernsey,
	Ghana,
	Gibraltar,
	Greenland,
	Gambia,
	Guinea,
	Guadeloupe,
	EquatorialGuinea,
	Greece,
	SouthGeorgiaAndTheSouthSandwichIslands,
	Guatemala,
	Guam,
	GuineaBissau,
	Guyana,
	HongKong,
	HeardIslandAndMcDonaldIslands,
	Honduras,
	Croatia,
	Haiti,
	Hungary,
	Indonesia,
	Ireland,
	Israel,
	IsleOfMan,
	India,
	BritishIndianOceanTerritory,
	Iraq,
	Iran,
	Iceland,
	Italy,
	Jersey,
	Jamaica,
	Jordan,
	Japan,
	Kenya,
	Kyrgyzstan,
	Cambodia,
	Kiribati,
	Comoros,
	SaintKittsAndNevis,
	NorthKorea,
	SouthKorea,
	Kuwait,
	CaymanIslands,
	Kazakhstan,
	Lao,
	Lebanon,
	SaintLucia,
	Liechtenstein,
	SriLanka,
	Liberia,
	Lesotho,
	Lithuania,
	Luxembourg,
	Latvia,
	Libya,
	Morocco,
	Monaco,
	Moldova,
	Montenegro,
	SaintMartin,
	Madagascar,
	MarshallIslands,
	NorthMacedonia,
	Mali,
	Myanmar,
	Mongolia,
	Macao,
	NorthernMarianaIslands,
	Martinique,
	Mauritania,
	Montserrat,
	Malta,
	Mauritius,
	Maldives,
	Malawi,
	Mexico,
	Malaysia,
	Mozambique,
	Namibia,
	NewCaledonia,
	Niger,
	NorfolkIsland,
	Nigeria,
	Nicaragua,
	Netherlands,
	Norway,
	Nepal,
	Nauru,
	Niue,
	NewZealand,
	Oman,
	Panama,
	Peru,
	FrenchPolynesia,
	PapuaNewGuinea,
	Philippines,
	Pakistan,
	Poland,
	SaintPierreAndMiquelon,
	Pitcairn,
	PuertoRico,
	Palestine,
	Portugal,
	Palau,
	Paraguay,
	Qatar,
	Reunion,
	Romania,
	Serbia,
	RussianFederation,
	Rwanda,
	SaudiArabia,
	SolomonIslands,
	Seychelles,
	Sudan,
	Sweden,
	Singapore,
	SaintHelenaAscensionAndTristanDaCunha,
	Slovenia,
	SvalbardAndJanMayen,
	Slovakia,
	SierraLeone,
	SanMarino,
	Senegal,
	Somalia,
	Suriname,
	SouthSudan,
	SaoTomeAndPrincipe,
	ElSalvador,
	SintMaarten,
	SyrianArabRepublic,
	Eswatini,
	TurksAndCaicosIslands,
	Chad,
	FrenchSouthernTerritories,
	Togo,
	Thailand,
	Tajikistan,
	Tokelau,
	TimorLeste,
	Turkmenistan,
	Tunisia,
	Tonga,
	Turkey,
	TrinidadAndTobago,
	Tuvalu,
	Taiwan,
	Tanzania,
	Ukraine,
	Uganda,
	UnitedStatesMinorOutlyingIslands,
	UnitedStates,
	Uruguay,
	Uzbekistan,
	HolySee,
	SaintVincentAndTheGrenadines,
	Venezuela,
	BritishVirginIslands,
	UsVirginIslands,
	VietNam,
	Vanuatu,
	WallisAndFutuna,
	Samoa,
	Yemen,
	Mayotte,
	SouthAfrica,
	Zambia,
	Zimbabwe,
};

impl std::convert::From<&Country> for String {
    /// Converts a `Country` enum to a `String` that contains a [country
    /// code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
    fn from(country: &Country) -> String {
        match country {
            Country::Andorra => String::from("AD"),
            Country::UnitedArabEmirates => String::from("AE"),
            Country::Afghanistan => String::from("AF"),
            Country::AntiguaAndBarbuda => String::from("AG"),
            Country::Anguilla => String::from("AI"),
            Country::Albania => String::from("AL"),
            Country::Armenia => String::from("AM"),
            Country::Angola => String::from("AO"),
            Country::Antarctica => String::from("AQ"),
            Country::Argentina => String::from("AR"),
            Country::AmericanSamoa => String::from("AS"),
            Country::Austria => String::from("AT"),
            Country::Australia => String::from("AU"),
            Country::Aruba => String::from("AW"),
            Country::AlandIslands => String::from("AX"),
            Country::Azerbaijan => String::from("AZ"),
            Country::BosniaAndHerzegovina => String::from("BA"),
            Country::Barbados => String::from("BB"),
            Country::Bangladesh => String::from("BD"),
            Country::Belgium => String::from("BE"),
            Country::BurkinaFaso => String::from("BF"),
            Country::Bulgaria => String::from("BG"),
            Country::Bahrain => String::from("BH"),
            Country::Burundi => String::from("BI"),
            Country::Benin => String::from("BJ"),
            Country::SaintBarthelemy => String::from("BL"),
            Country::Bermuda => String::from("BM"),
            Country::BruneiDarussalam => String::from("BN"),
            Country::Bolivia => String::from("BO"),
            Country::BonaireSintEustatiusAndSaba => String::from("BQ"),
            Country::Brazil => String::from("BR"),
            Country::Bahamas => String::from("BS"),
            Country::Bhutan => String::from("BT"),
            Country::BouvetIsland => String::from("BV"),
            Country::Botswana => String::from("BW"),
            Country::Belarus => String::from("BY"),
            Country::Belize => String::from("BZ"),
            Country::Canada => String::from("CA"),
            Country::CocosKeelingIslands => String::from("CC"),
            Country::CongoDemocraticRepublic => String::from("CD"),
            Country::CentralAfricanRepublic => String::from("CF"),
            Country::Congo => String::from("CG"),
            Country::Switzerland => String::from("CH"),
            Country::CoteDIvoire => String::from("CI"),
            Country::CookIslands => String::from("CK"),
            Country::Chile => String::from("CL"),
            Country::Cameroon => String::from("CM"),
            Country::China => String::from("CN"),
            Country::Colombia => String::from("CO"),
            Country::CostaRica => String::from("CR"),
            Country::Cuba => String::from("CU"),
            Country::CaboVerde => String::from("CV"),
            Country::Curacao => String::from("CW"),
            Country::ChristmasIsland => String::from("CX"),
            Country::Cyprus => String::from("CY"),
            Country::Czechia => String::from("CZ"),
            Country::Germany => String::from("DE"),
            Country::Djibouti => String::from("DJ"),
            Country::Denmark => String::from("DK"),
            Country::Dominica => String::from("DM"),
            Country::DominicanRepublic => String::from("DO"),
            Country::Algeria => String::from("DZ"),
            Country::Ecuador => String::from("EC"),
            Country::Estonia => String::from("EE"),
            Country::Egypt => String::from("EG"),
            Country::WesternSahara => String::from("EH"),
            Country::Eritrea => String::from("ER"),
            Country::Spain => String::from("ES"),
            Country::Ethiopia => String::from("ET"),
            Country::Finland => String::from("FI"),
            Country::Fiji => String::from("FJ"),
            Country::FalklandIslands => String::from("FK"),
            Country::Micronesia => String::from("FM"),
            Country::FaroeIslands => String::from("FO"),
            Country::France => String::from("FR"),
            Country::Gabon => String::from("GA"),
            Country::UnitedKingdom => String::from("GB"),
            Country::Grenada => String::from("GD"),
            Country::Georgia => String::from("GE"),
            Country::FrenchGuiana => String::from("GF"),
            Country::Guernsey => String::from("GG"),
            Country::Ghana => String::from("GH"),
            Country::Gibraltar => String::from("GI"),
            Country::Greenland => String::from("GL"),
            Country::Gambia => String::from("GM"),
            Country::Guinea => String::from("GN"),
            Country::Guadeloupe => String::from("GP"),
            Country::EquatorialGuinea => String::from("GQ"),
            Country::Greece => String::from("GR"),
            Country::SouthGeorgiaAndTheSouthSandwichIslands => String::from("GS"),
            Country::Guatemala => String::from("GT"),
            Country::Guam => String::from("GU"),
            Country::GuineaBissau => String::from("GW"),
            Country::Guyana => String::from("GY"),
            Country::HongKong => String::from("HK"),
            Country::HeardIslandAndMcDonaldIslands => String::from("HM"),
            Country::Honduras => String::from("HN"),
            Country::Croatia => String::from("HR"),
            Country::Haiti => String::from("HT"),
            Country::Hungary => String::from("HU"),
            Country::Indonesia => String::from("ID"),
            Country::Ireland => String::from("IE"),
            Country::Israel => String::from("IL"),
            Country::IsleOfMan => String::from("IM"),
            Country::India => String::from("IN"),
            Country::BritishIndianOcean => String::from("IO"),
            Country::Iraq => String::from("IQ"),
            Country::Iran => String::from("IR"),
            Country::Iceland => String::from("IS"),
            Country::Italy => String::from("IT"),
            Country::Jersey => String::from("JE"),
            Country::Jamaica => String::from("JM"),
            Country::Jordan => String::from("JO"),
            Country::Japan => String::from("JP"),
            Country::Kenya => String::from("KE"),
            Country::Kyrgyzstan => String::from("KG"),
            Country::Cambodia => String::from("KH"),
            Country::Kiribati => String::from("KI"),
            Country::Comoros => String::from("KM"),
            Country::SaintKittsAndNevis => String::from("KN"),
            Country::NorthKorea => String::from("KP"),
            Country::SouthKorea => String::from("KR"),
            Country::Kuwait => String::from("KW"),
            Country::CaymanIslands => String::from("KY"),
            Country::Kazakhstan => String::from("KZ"),
            Country::Lao => String::from("LA"),
            Country::Lebanon => String::from("LB"),
            Country::SaintLucia => String::from("LC"),
            Country::Liechtenstein => String::from("LI"),
            Country::SriLanka => String::from("LK"),
            Country::Liberia => String::from("LR"),
            Country::Lesotho => String::from("LS"),
            Country::Lithuania => String::from("LT"),
            Country::Luxembourg => String::from("LU"),
            Country::Latvia => String::from("LV"),
            Country::Libya => String::from("LY"),
            Country::Morocco => String::from("MA"),
            Country::Monaco => String::from("MC"),
            Country::Moldova => String::from("MD"),
            Country::Montenegro => String::from("ME"),
            Country::SaintMartin => String::from("MF"),
            Country::Madagascar => String::from("MG"),
            Country::MarshallIslands => String::from("MH"),
            Country::NorthMacedonia => String::from("MK"),
            Country::Mali => String::from("ML"),
            Country::Myanmar => String::from("MM"),
            Country::Mongolia => String::from("MN"),
            Country::Macao => String::from("MO"),
            Country::NorthernMarianaIslands => String::from("MP"),
            Country::Martinique => String::from("MQ"),
            Country::Mauritania => String::from("MR"),
            Country::Montserrat => String::from("MS"),
            Country::Malta => String::from("MT"),
            Country::Mauritius => String::from("MU"),
            Country::Maldives => String::from("MV"),
            Country::Malawi => String::from("MW"),
            Country::Mexico => String::from("MX"),
            Country::Malaysia => String::from("MY"),
            Country::Mozambique => String::from("MZ"),
            Country::Namibia => String::from("NA"),
            Country::NewCaledonia => String::from("NC"),
            Country::Niger => String::from("NE"),
            Country::NorfolkIsland => String::from("NF"),
            Country::Nigeria => String::from("NG"),
            Country::Nicaragua => String::from("NI"),
            Country::Netherlands => String::from("NL"),
            Country::Norway => String::from("NO"),
            Country::Nepal => String::from("NP"),
            Country::Nauru => String::from("NR"),
            Country::Niue => String::from("NU"),
            Country::NewZealand => String::from("NZ"),
            Country::Oman => String::from("OM"),
            Country::Panama => String::from("PA"),
            Country::Peru => String::from("PE"),
            Country::FrenchPolynesia => String::from("PF"),
            Country::PapuaNewGuinea => String::from("PG"),
            Country::Philippines => String::from("PH"),
            Country::Pakistan => String::from("PK"),
            Country::Poland => String::from("PL"),
            Country::SaintPierreAndMiquelon => String::from("PM"),
            Country::Pitcairn => String::from("PN"),
            Country::PuertoRico => String::from("PR"),
            Country::Palestine => String::from("PS"),
            Country::Portugal => String::from("PT"),
            Country::Palau => String::from("PW"),
            Country::Paraguay => String::from("PY"),
            Country::Qatar => String::from("QA"),
            Country::Reunion => String::from("RE"),
            Country::Romania => String::from("RO"),
            Country::Serbia => String::from("RS"),
            Country::Russia => String::from("RU"),
            Country::Rwanda => String::from("RW"),
            Country::SaudiArabia => String::from("SA"),
            Country::SolomonIslands => String::from("SB"),
            Country::Seychelles => String::from("SC"),
            Country::Sudan => String::from("SD"),
            Country::Sweden => String::from("SE"),
            Country::Singapore => String::from("SG"),
            Country::SaintHelenaAscensionAndTristanDaCunha => String::from("SH"),
            Country::Slovenia => String::from("SI"),
            Country::SvalbardAndJanMayen => String::from("SJ"),
            Country::Slovakia => String::from("SK"),
            Country::SierraLeone => String::from("SL"),
            Country::SanMarino => String::from("SM"),
            Country::Senegal => String::from("SN"),
            Country::Somalia => String::from("SO"),
            Country::Suriname => String::from("SR"),
            Country::SouthSudan => String::from("SS"),
            Country::SaoTomeAndPrincipe => String::from("ST"),
            Country::ElSalvador => String::from("SV"),
            Country::SintMaarten => String::from("SX"),
            Country::SyrianArabRepublic => String::from("SY"),
            Country::Eswatini => String::from("SZ"),
            Country::TurksAndCaicosIslands => String::from("TC"),
            Country::Chad => String::from("TD"),
            Country::FrenchSouthernTerritories => String::from("TF"),
            Country::Togo => String::from("TG"),
            Country::Thailand => String::from("TH"),
            Country::Tajikistan => String::from("TJ"),
            Country::Tokelau => String::from("TK"),
            Country::Timor-Leste => String::from("TL"),
            Country::Turkmenistan => String::from("TM"),
            Country::Tunisia => String::from("TN"),
            Country::Tonga => String::from("TO"),
            Country::Turkey => String::from("TR"),
            Country::TrinidadAndTobago => String::from("TT"),
            Country::Tuvalu => String::from("TV"),
            Country::Taiwan => String::from("TW"),
            Country::Tanzania => String::from("TZ"),
            Country::Ukraine => String::from("UA"),
            Country::Uganda => String::from("UG"),
            Country::UnitedStatesMinorOutlyingIslands => String::from("UM"),
            Country::UnitedStates => String::from("US"),
            Country::Uruguay => String::from("UY"),
            Country::Uzbekistan => String::from("UZ"),
            Country::HolySee => String::from("VA"),
            Country::SaintVincentAndTheGrenadines => String::from("VC"),
            Country::Venezuela => String::from("VE"),
            Country::BritishVirginIslands => String::from("VG"),
            Country::UsVirginIslands => String::from("VI"),
            Country::VietNam => String::from("VN"),
            Country::Vanuatu => String::from("VU"),
            Country::WallisAndFutuna => String::from("WF"),
            Country::Samoa => String::from("WS"),
            Country::Yemen => String::from("YE"),
            Country::Mayotte => String::from("YT"),
            Country::SouthAfrica => String::from("ZA"),
            Country::Zambia => String::from("ZM"),
            Country::Zimbabwe => String::from("ZW"),
        } // match
    } // fn
} // impl



impl std::fmt::Display for Language {
    /// Formats a `Language` enum into a string that is presentable to the
    /// end user.
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        match self {
            Country::Andorra => String::from("Andorra"),
            Country::UnitedArabEmirates => String::from("United Arab Emirates"),
            Country::Afghanistan => String::from("Afghanistan"),
            Country::AntiguaAndBarbuda => String::from("Antigua and Barbuda"),
            Country::Anguilla => String::from("Anguilla"),
            Country::Albania => String::from("Albania"),
            Country::Armenia => String::from("Armenia"),
            Country::Angola => String::from("Angola"),
            Country::Antarctica => String::from("Antarctica"),
            Country::Argentina => String::from("Argentina"),
            Country::AmericanSamoa => String::from("AmericanSamoa"),
            Country::Austria => String::from("Austria"),
            Country::Australia => String::from("Australia"),
            Country::Aruba => String::from("Aruba"),
            Country::AlandIslands => String::from("Åland Islands"),
            Country::Azerbaijan => String::from("Azerbaijan"),
            Country::BosniaAndHerzegovina => String::from("Bosnia and Herzegovina"),
            Country::Barbados => String::from("Barbados"),
            Country::Bangladesh => String::from("Bangladesh"),
            Country::Belgium => String::from("Belgium"),
            Country::BurkinaFaso => String::from("Burkina Faso"),
            Country::Bulgaria => String::from("Bulgaria"),
            Country::Bahrain => String::from("Bahrain"),
            Country::Burundi => String::from("Burundi"),
            Country::Benin => String::from("Benin"),
            Country::SaintBarthelemy => String::from("Saint Barthélemy"),
            Country::Bermuda => String::from("Bermuda"),
            Country::BruneiDarussalam => String::from("Brunei Darussalam"),
            Country::Bolivia => String::from("Bolivia (Plurinational State of)"),
            Country::BonaireSintEustatiusAndSaba => String::from("Bonaire, Sint Eustatius and Saba"),
            Country::Brazil => String::from("Brazil"),
            Country::Bahamas => String::from("Bahamas"),
            Country::Bhutan => String::from("Bhutan"),
            Country::BouvetIsland => String::from("Bouvet Island"),
            Country::Botswana => String::from("Botswana"),
            Country::Belarus => String::from("Belarus"),
            Country::Belize => String::from("Belize"),
            Country::Canada => String::from("Canada"),
            Country::CocosKeelingIslands => String::from("Cocos (Keeling) Islands"),
            Country::CongoDemocraticRepublic => String::from("Congo, Democratic Republic of the"),
            Country::CentralAfricanRepublic => String::from("Central African Republic"),
            Country::Congo => String::from("Congo"),
            Country::Switzerland => String::from("Switzerland"),
            Country::CoteDIvoire => String::from("Côte d'Ivoire"),
            Country::CookIslands => String::from("Cook Islands"),
            Country::Chile => String::from("Chile"),
            Country::Cameroon => String::from("Cameroon"),
            Country::China => String::from("China"),
            Country::Colombia => String::from("Colombia"),
            Country::CostaRica => String::from("Costa Rica"),
            Country::Cuba => String::from("Cuba"),
            Country::CaboVerde => String::from("Cabo Verde"),
            Country::Curacao => String::from("Curaçao"),
            Country::ChristmasIsland => String::from("Christmas Island"),
            Country::Cyprus => String::from("Cyprus"),
            Country::Czechia => String::from("Czechia"),
            Country::Germany => String::from("Germany"),
            Country::Djibouti => String::from("Djibouti"),
            Country::Denmark => String::from("Denmark"),
            Country::Dominica => String::from("Dominica"),
            Country::DominicanRepublic => String::from("Dominican Republic"),
            Country::Algeria => String::from("Algeria"),
            Country::Ecuador => String::from("Ecuador"),
            Country::Estonia => String::from("Estonia"),
            Country::Egypt => String::from("Egypt"),
            Country::WesternSahara => String::from("Western Sahara"),
            Country::Eritrea => String::from("Eritrea"),
            Country::Spain => String::from("Spain"),
            Country::Ethiopia => String::from("Ethiopia"),
            Country::Finland => String::from("Finland"),
            Country::Fiji => String::from("Fiji"),
            Country::FalklandIslands => String::from("Falkland Islands (Malvinas)"),
            Country::Micronesia => String::from("Micronesia (Federated States of)"),
            Country::FaroeIslands => String::from("Faroe Islands"),
            Country::France => String::from("France"),
            Country::Gabon => String::from("Gabon"),
            Country::UnitedKingdom => String::from("United Kingdom of Great Britain and Northern Ireland"),
            Country::Grenada => String::from("Grenada"),
            Country::Georgia => String::from("Georgia"),
            Country::FrenchGuiana => String::from("French Guiana"),
            Country::Guernsey => String::from("Guernsey"),
            Country::Ghana => String::from("Ghana"),
            Country::Gibraltar => String::from("Gibraltar"),
            Country::Greenland => String::from("Greenland"),
            Country::Gambia => String::from("Gambia"),
            Country::Guinea => String::from("Guinea"),
            Country::Guadeloupe => String::from("Guadeloupe"),
            Country::EquatorialGuinea => String::from("Equatorial Guinea"),
            Country::Greece => String::from("Greece"),
            Country::SouthGeorgiaAndTheSouthSandwichIslands => String::from("South Georgia and the South Sandwich Islands"),
            Country::Guatemala => String::from("Guatemala"),
            Country::Guam => String::from("Guam"),
            Country::GuineaBissau => String::from("Guinea-Bissau"),
            Country::Guyana => String::from("Guyana"),
            Country::HongKong => String::from("Hong Kong"),
            Country::HeardIslandAndMcDonaldIslands => String::from("Heard Island and McDonald Islands"),
            Country::Honduras => String::from("Honduras"),
            Country::Croatia => String::from("Croatia"),
            Country::Haiti => String::from("Haiti"),
            Country::Hungary => String::from("Hungary"),
            Country::Indonesia => String::from("Indonesia"),
            Country::Ireland => String::from("Ireland"),
            Country::Israel => String::from("Israel"),
            Country::IsleOfMan => String::from("Isle of Man"),
            Country::India => String::from("India"),
            Country::BritishIndianOcean => String::from("British Indian Ocean Territory"),
            Country::Iraq => String::from("Iraq"),
            Country::Iran => String::from("Iran (Islamic Republic of)"),
            Country::Iceland => String::from("Iceland"),
            Country::Italy => String::from("Iceland"),
            Country::Jersey => String::from("Jersey"),
            Country::Jamaica => String::from("Jamaica"),
            Country::Jordan => String::from("Jordan"),
            Country::Japan => String::from("Japan"),
            Country::Kenya => String::from("Kenya"),
            Country::Kyrgyzstan => String::from("Kyrgyzstan"),
            Country::Cambodia => String::from("Cambodia"),
            Country::Kiribati => String::from("Kiribati"),
            Country::Comoros => String::from("Comoros"),
            Country::SaintKittsAndNevis => String::from("Saint Kitts and Nevis"),
            Country::NorthKorea => String::from("   Korea (Democratic People's Republic of)"),
            Country::SouthKorea => String::from("KR"),
            Country::Kuwait => String::from("KW"),
            Country::CaymanIslands => String::from("KY"),
            Country::Kazakhstan => String::from("KZ"),
            Country::Lao => String::from("LA"),
            Country::Lebanon => String::from("LB"),
            Country::SaintLucia => String::from("LC"),
            Country::Liechtenstein => String::from("LI"),
            Country::SriLanka => String::from("LK"),
            Country::Liberia => String::from("LR"),
            Country::Lesotho => String::from("LS"),
            Country::Lithuania => String::from("LT"),
            Country::Luxembourg => String::from("LU"),
            Country::Latvia => String::from("LV"),
            Country::Libya => String::from("LY"),
            Country::Morocco => String::from("MA"),
            Country::Monaco => String::from("MC"),
            Country::Moldova => String::from("MD"),
            Country::Montenegro => String::from("ME"),
            Country::SaintMartin => String::from("MF"),
            Country::Madagascar => String::from("MG"),
            Country::MarshallIslands => String::from("MH"),
            Country::NorthMacedonia => String::from("MK"),
            Country::Mali => String::from("ML"),
            Country::Myanmar => String::from("MM"),
            Country::Mongolia => String::from("MN"),
            Country::Macao => String::from("MO"),
            Country::NorthernMarianaIslands => String::from("MP"),
            Country::Martinique => String::from("MQ"),
            Country::Mauritania => String::from("MR"),
            Country::Montserrat => String::from("MS"),
            Country::Malta => String::from("MT"),
            Country::Mauritius => String::from("MU"),
            Country::Maldives => String::from("MV"),
            Country::Malawi => String::from("MW"),
            Country::Mexico => String::from("MX"),
            Country::Malaysia => String::from("MY"),
            Country::Mozambique => String::from("MZ"),
            Country::Namibia => String::from("NA"),
            Country::NewCaledonia => String::from("NC"),
            Country::Niger => String::from("NE"),
            Country::NorfolkIsland => String::from("NF"),
            Country::Nigeria => String::from("NG"),
            Country::Nicaragua => String::from("NI"),
            Country::Netherlands => String::from("NL"),
            Country::Norway => String::from("NO"),
            Country::Nepal => String::from("NP"),
            Country::Nauru => String::from("NR"),
            Country::Niue => String::from("NU"),
            Country::NewZealand => String::from("NZ"),
            Country::Oman => String::from("OM"),
            Country::Panama => String::from("PA"),
            Country::Peru => String::from("PE"),
            Country::FrenchPolynesia => String::from("PF"),
            Country::PapuaNewGuinea => String::from("PG"),
            Country::Philippines => String::from("PH"),
            Country::Pakistan => String::from("PK"),
            Country::Poland => String::from("PL"),
            Country::SaintPierreAndMiquelon => String::from("PM"),
            Country::Pitcairn => String::from("PN"),
            Country::PuertoRico => String::from("PR"),
            Country::Palestine => String::from("PS"),
            Country::Portugal => String::from("PT"),
            Country::Palau => String::from("PW"),
            Country::Paraguay => String::from("PY"),
            Country::Qatar => String::from("QA"),
            Country::Reunion => String::from("RE"),
            Country::Romania => String::from("RO"),
            Country::Serbia => String::from("RS"),
            Country::Russia => String::from("RU"),
            Country::Rwanda => String::from("RW"),
            Country::SaudiArabia => String::from("SA"),
            Country::SolomonIslands => String::from("SB"),
            Country::Seychelles => String::from("SC"),
            Country::Sudan => String::from("SD"),
            Country::Sweden => String::from("SE"),
            Country::Singapore => String::from("SG"),
            Country::SaintHelenaAscensionAndTristanDaCunha => String::from("SH"),
            Country::Slovenia => String::from("SI"),
            Country::SvalbardAndJanMayen => String::from("SJ"),
            Country::Slovakia => String::from("SK"),
            Country::SierraLeone => String::from("SL"),
            Country::SanMarino => String::from("SM"),
            Country::Senegal => String::from("SN"),
            Country::Somalia => String::from("SO"),
            Country::Suriname => String::from("SR"),
            Country::SouthSudan => String::from("SS"),
            Country::SaoTomeAndPrincipe => String::from("ST"),
            Country::ElSalvador => String::from("SV"),
            Country::SintMaarten => String::from("SX"),
            Country::SyrianArabRepublic => String::from("SY"),
            Country::Eswatini => String::from("SZ"),
            Country::TurksAndCaicosIslands => String::from("TC"),
            Country::Chad => String::from("TD"),
            Country::FrenchSouthernTerritories => String::from("TF"),
            Country::Togo => String::from("TG"),
            Country::Thailand => String::from("TH"),
            Country::Tajikistan => String::from("TJ"),
            Country::Tokelau => String::from("TK"),
            Country::Timor-Leste => String::from("TL"),
            Country::Turkmenistan => String::from("TM"),
            Country::Tunisia => String::from("TN"),
            Country::Tonga => String::from("TO"),
            Country::Turkey => String::from("TR"),
            Country::TrinidadAndTobago => String::from("TT"),
            Country::Tuvalu => String::from("TV"),
            Country::Taiwan => String::from("TW"),
            Country::Tanzania => String::from("TZ"),
            Country::Ukraine => String::from("UA"),
            Country::Uganda => String::from("UG"),
            Country::UnitedStatesMinorOutlyingIslands => String::from("UM"),
            Country::UnitedStates => String::from("US"),
            Country::Uruguay => String::from("UY"),
            Country::Uzbekistan => String::from("UZ"),
            Country::HolySee => String::from("VA"),
            Country::SaintVincentAndTheGrenadines => String::from("VC"),
            Country::Venezuela => String::from("VE"),
            Country::BritishVirginIslands => String::from("VG"),
            Country::UsVirginIslands => String::from("VI"),
            Country::VietNam => String::from("VN"),
            Country::Vanuatu => String::from("VU"),
            Country::WallisAndFutuna => String::from("WF"),
            Country::Samoa => String::from("WS"),
            Country::Yemen => String::from("YE"),
            Country::Mayotte => String::from("YT"),
            Country::SouthAfrica => String::from("ZA"),
            Country::Zambia => String::from("ZM"),
            Country::Zimbabwe => String::from("ZW"),
        } // match
    } // fn
} // impl


