mod instructions;
pub mod state;

use {anchor_lang::prelude::*, instructions::*};

declare_id!("Fg6PaFpoGXkYsidMpWTK6W2BeZ7FEfcYkg476zPFsLnS");

#[program]
pub mod indexor {
    use super::*;

    pub fn create_index(ctx: Context<CreateIndex>, namespace: String, bump: u8) -> ProgramResult {
        create_index::handler(ctx, namespace, bump)
    }

    pub fn create_item(
        ctx: Context<CreateItem>,
        reference: Pubkey,
        item_bump: u8,
        proof_bump: u8,
    ) -> ProgramResult {
        create_item::handler(ctx, reference, item_bump, proof_bump)
    }
}
