use anchor_lang::prelude::*;

/// Root seed for Item accounts.
pub const SEED_ITEM: &[u8] = b"itm";

/// Item accounts are the entries in an index.
/// Their IDs are auto-incrementing (0, 1, 2, ...) and they each hold a reference to a public key address.
#[account]
pub struct Item {
    pub id: u128,
    pub reference: Pubkey,
    pub bump: u8,
}
