use {
    anchor_lang::{
        prelude::*,
        solana_program::system_program
    },
    crate::state,
    std::mem::size_of
};

#[derive(Accounts)]
#[instruction(
    owner: Pubkey,
    namespace: String,
    bump: u8,
)]
pub struct CreateIndex<'info> {
    #[account(
        init, 
        seeds = [
            state::SEED_INDEX, 
            owner.as_ref(), 
            namespace.as_ref()
        ], 
        bump = bump, 
        payer = signer, 
        space = 8 + size_of::<state::Index>()
    )]
    pub index: Account<'info, state::Index>,

    #[account(mut)]
    pub signer: Signer<'info>,
    
    #[account(address = system_program::ID)]
    pub system_program: Program<'info, System>,
}

pub fn handler(
    ctx: Context<CreateIndex>, 
    owner: Pubkey,
    namespace: String,
    bump: u8,
) -> ProgramResult {
    // Get accounts.
    let index = &mut ctx.accounts.index;

    // Initialize index account.
    index.namespace = namespace;
    index.owner = owner;
    index.item_count = 0;
    index.bump = bump;
    
    return Ok(());
}
