mod instructions;
pub mod state;

use {anchor_lang::prelude::*, instructions::*};

declare_id!("Fg6PaFpoGXkYsidMpWTK6W2BeZ7FEfcYkg476zPFsLnS");

#[program]
pub mod indexor {
    use super::*;

    pub fn create_index(ctx: Context<CreateIndex>, namespace: String, bump: u8) -> ProgramResult {
        create_index::handler(ctx, namespace, bump)
    }

    pub fn create_reference(
        ctx: Context<CreateReference>,
        account: Pubkey,
        record_bump: u8,
        reference_bump: u8,
    ) -> ProgramResult {
        create_reference::handler(ctx, account, record_bump, reference_bump)
    }
}
