# indent
This crate provides 4 functions useful for inserting a multiline string into an
already indented context in another string:

- `indent_by`: Indents every line that is not empty by the given number of spaces,
  starting from the second line.
- `indent_with`: Indents every line that is not empty with the given prefix,
  starting from the second line.
- `indent_all_by`: Indents every line that is not empty by the given number of spaces.
- `indent_all_with`: Indents every line that is not empty with the given prefix.

## Examples
```rust
use indent::indent;

fn main() {
    let string = "line one

line two
";
    assert_eq!("line one\n\n  line two\n", indent(2, string);
}
```

## License
[Mozilla Public License 2.0](LICENSE.txt)

## Contribution
Unless you explicitly state otherwise, any contribution intentionally submitted
for inclusion in the work by you shall be licensed under the Mozilla Public
License 2.0, without any additional terms or conditions.
