/*
 * iNaturalist API
 *
 * # https://api.inaturalist.org/v1/  [iNaturalist](https://www.inaturalist.org/) is a global community of naturalists, scientists, and members of the public sharing over a million wildlife sightings to teach one another about the natural world while creating high quality citizen science data for science and conservation. The iNaturalist technology infrastructure and open source software is administered by the [California Academy of Sciences](https://www.calacademy.org/) as part of their mission to explore, explain, and sustain life on Earth.  These API methods return data in JSON/JSONP and PNG response formats. They are meant to supplement the existing [iNaturalist API](https://www.inaturalist.org/pages/api+reference), implemented in Ruby on Rails, which has more functionality and supports more write operations, but tends to be slower and have less consistent response formats. Visit our [developers page](https://www.inaturalist.org/pages/developers) for more information. Write operations that expect and return JSON describe a single `body` parameter that represents the request body, which should be specified as JSON. See the \"Model\" of each body parameter for attributes that we accept in these JSON objects.  Multiple values for a single URL parameter should be separated by commas, e.g. `taxon_id=1,2,3`.  Map tiles are generated using the [node-mapnik](https://github.com/mapnik/node-mapnik) library, following the XYZ map tiling scheme. The \"Observation Tile\" methods accept nearly all the parameters of the observation search APIs, and will generate map tiles reflecting the same observations returned by searches. These \"Observation Tile\" methods have corresponding [UTFGrid](https://github.com/mapbox/utfgrid-spec) JSON responses which return information needed to make interactive maps.  Authentication in the Node API is handled via JSON Web Tokens (JWT). To obtain one, make an [OAuth-authenticated request](http://www.inaturalist.org/pages/api+reference#auth) to https://www.inaturalist.org/users/api_token. Each JWT will expire after 24 hours. Authentication required for all PUT and POST requests. Some GET requests will also include private information like hidden coordinates if the authenticated user has permission to view them.  iNaturalist Website: https://www.inaturalist.org/  Open Source Software: https://github.com/inaturalist/  ## Terms of Use  Use of this API is subject to the iNaturalist [Terms of Service](https://www.inaturalist.org/terms) and [Privacy Policy](https://www.inaturalist.org/privacy). We will block any use of our API that violates our Terms or Privacy Policy without notice. The API is intended to support application development, not data scraping. For pre- generated data exports, see https://www.inaturalist.org/pages/developers.  Please note that we throttle API usage to a max of 100 requests per minute, though we ask that you try to keep it to 60 requests per minute or lower, and to keep under 10,000 requests per day. If we notice usage that has serious impact on our performance we may institute blocks without notification.  Terms of Service: https://www.inaturalist.org/terms  Privacy Policy: https://www.inaturalist.org/privacy 
 *
 * The version of the OpenAPI document: 1.3.0
 * 
 * Generated by: https://openapi-generator.tech
 */


use reqwest;

use crate::apis::ResponseContent;
use super::{Error, configuration};

/// struct for passing parameters to the method [`colored_heatmap_zoom_xy_grid_json_get`]
#[derive(Clone, Debug, Default)]
pub struct ColoredHeatmapZoomXyGridJsonGetParams {
    /// Zoom level. Z coordinate in the XYZ tiling scheme
    pub zoom: i32,
    /// X coordinate in the XYZ tiling scheme. Must be less than 2^zoom
    pub x: i32,
    /// Y coordinate in the XYZ tiling scheme. Must be less than 2^zoom
    pub y: i32,
    /// Primary color to use in tile creation. Accepts common colors by string (e.g. `color=blue`), and accepts escaped color HEX codes (e.g. `color=%2386a91c`) 
    pub color: Option<String>,
    /// Whether or not positional accuracy / coordinate uncertainty has been specified
    pub acc: Option<bool>,
    /// Captive or cultivated observations
    pub captive: Option<bool>,
    /// Observations whose taxa are endemic to their location
    pub endemic: Option<bool>,
    /// Observations that are georeferenced
    pub geo: Option<bool>,
    /// Observations with the deprecated `ID, Please!` flag. Note that this will return observations, but that this attribute is no longer used.
    pub id_please: Option<bool>,
    /// Observations that have community identifications
    pub identified: Option<bool>,
    /// Observations whose taxa are introduced in their location 
    pub introduced: Option<bool>,
    /// Observations that show on map tiles
    pub mappable: Option<bool>,
    /// Observations whose taxa are native to their location
    pub native: Option<bool>,
    /// Observations whose taxa are outside their known ranges
    pub out_of_range: Option<bool>,
    /// Observations identified by the curator of a project. If the `project_id` parameter is also specified, this will only consider observations identified by curators of the specified project(s) 
    pub pcid: Option<bool>,
    /// Observations with photos
    pub photos: Option<bool>,
    /// Observations that have been favorited by at least one user 
    pub popular: Option<bool>,
    /// Observations with sounds
    pub sounds: Option<bool>,
    /// Observations of active taxon concepts 
    pub taxon_is_active: Option<bool>,
    /// Observations whose taxa are threatened in their location 
    pub threatened: Option<bool>,
    /// Observations with a `quality_grade` of either `needs_id` or `research`. Equivalent to `quality_grade=needs_id,research` 
    pub verifiable: Option<bool>,
    /// License attribute of an observation must not be null
    pub licensed: Option<bool>,
    /// License attribute of at least one photo of an observation must not be null
    pub photo_licensed: Option<bool>,
    /// Must have this ID
    pub id: Option<Vec<String>>,
    /// Must not have this ID
    pub not_id: Option<Vec<String>>,
    /// Observation must have this license
    pub license: Option<Vec<String>>,
    /// Must have an observation field value with this datatype
    pub ofv_datatype: Option<Vec<String>>,
    /// Must have at least one photo with this license
    pub photo_license: Option<Vec<String>>,
    /// Must be observed within the place with this ID
    pub place_id: Option<Vec<i32>>,
    /// Must be added to the project this ID or slug
    pub project_id: Option<Vec<String>>,
    /// Taxon must have this rank
    pub rank: Option<Vec<String>>,
    /// Must be affiliated with the iNaturalist network website with this ID 
    pub site_id: Option<Vec<String>>,
    /// Must have at least one sound with this license
    pub sound_license: Option<Vec<String>>,
    /// Only show observations of these taxa and their descendants
    pub taxon_id: Option<Vec<String>>,
    /// Exclude observations of these taxa and their descendants
    pub without_taxon_id: Option<Vec<String>>,
    /// Taxon must have a scientific or common name matching this string 
    pub taxon_name: Option<Vec<String>>,
    /// User must have this ID or login
    pub user_id: Option<Vec<String>>,
    /// User must have this login
    pub user_login: Option<Vec<String>>,
    /// Observations identified by a particular user
    pub ident_user_id: Option<i32>,
    /// Must be observed within this day of the month
    pub day: Option<Vec<String>>,
    /// Must be observed within this month
    pub month: Option<Vec<String>>,
    /// Must be observed within this year
    pub year: Option<Vec<String>>,
    /// Must have an annotation using this controlled term ID
    pub term_id: Option<Vec<i32>>,
    /// Must have an annotation using this controlled value ID. Must be combined with the `term_id` parameter 
    pub term_value_id: Option<Vec<i32>>,
    /// Exclude observations with annotations using this controlled value ID. Must be combined with the `term_id` parameter 
    pub without_term_value_id: Option<Vec<i32>>,
    /// Must have a positional accuracy above this value (meters)
    pub acc_above: Option<String>,
    /// Must have a positional accuracy below this value (meters)
    pub acc_below: Option<String>,
    /// Positional accuracy must be below this value (in meters) or be unknown
    pub acc_below_or_unknown: Option<String>,
    /// Must be observed on or after this date
    pub d1: Option<String>,
    /// Must be observed on or before this date
    pub d2: Option<String>,
    /// Must be created at or after this time
    pub created_d1: Option<String>,
    /// Must be created at or before this time
    pub created_d2: Option<String>,
    /// Must be created on this date
    pub created_on: Option<String>,
    /// Must be observed on this date
    pub observed_on: Option<String>,
    /// Must not be of a taxon previously observed by this user
    pub unobserved_by_user_id: Option<i32>,
    /// Must match the rules of the project with this ID or slug
    pub apply_project_rules_for: Option<String>,
    /// Taxon must have this conservation status code. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub cs: Option<String>,
    /// Taxon must have a conservation status from this authority. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub csa: Option<String>,
    /// Taxon must have this IUCN conservation status. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub csi: Option<Vec<String>>,
    /// Must have this geoprivacy setting
    pub geoprivacy: Option<Vec<String>>,
    /// Filter observations by the most conservative geoprivacy applied by a conservation status associated with one of the taxa proposed in the current identifications. 
    pub taxon_geoprivacy: Option<Vec<String>>,
    /// Taxon must have this rank or lower
    pub hrank: Option<String>,
    /// Taxon must have this rank or higher
    pub lrank: Option<String>,
    /// Taxon must by within this iconic taxon
    pub iconic_taxa: Option<Vec<String>>,
    /// Must have an ID above this value
    pub id_above: Option<String>,
    /// Must have an ID below this value
    pub id_below: Option<String>,
    /// Identifications must meet these criteria
    pub identifications: Option<String>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub lat: Option<f64>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub lng: Option<f64>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub radius: Option<String>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelat: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelng: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlat: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlng: Option<f64>,
    /// Taxon must be in the list with this ID
    pub list_id: Option<i32>,
    /// Must not be in the project with this ID or slug
    pub not_in_project: Option<String>,
    /// Must not match the rules of the project with this ID or slug
    pub not_matching_project_rules_for: Option<String>,
    /// Search observation properties. Can be combined with `search_on`
    pub q: Option<String>,
    /// Properties to search on, when combined with `q`. Searches across all properties by default 
    pub search_on: Option<String>,
    /// Must have this quality grade
    pub quality_grade: Option<String>,
    /// Must be updated since this time
    pub updated_since: Option<String>,
    /// See `reviewed`
    pub viewer_id: Option<String>,
    /// Observations have been reviewed by the user with ID equal to the value of the `viewer_id` parameter 
    pub reviewed: Option<bool>
}

/// struct for passing parameters to the method [`grid_zoom_xy_grid_json_get`]
#[derive(Clone, Debug, Default)]
pub struct GridZoomXyGridJsonGetParams {
    /// Zoom level. Z coordinate in the XYZ tiling scheme
    pub zoom: i32,
    /// X coordinate in the XYZ tiling scheme. Must be less than 2^zoom
    pub x: i32,
    /// Y coordinate in the XYZ tiling scheme. Must be less than 2^zoom
    pub y: i32,
    /// Primary color to use in tile creation. Accepts common colors by string (e.g. `color=blue`), and accepts escaped color HEX codes (e.g. `color=%2386a91c`) 
    pub color: Option<String>,
    /// Whether or not positional accuracy / coordinate uncertainty has been specified
    pub acc: Option<bool>,
    /// Captive or cultivated observations
    pub captive: Option<bool>,
    /// Observations whose taxa are endemic to their location
    pub endemic: Option<bool>,
    /// Observations that are georeferenced
    pub geo: Option<bool>,
    /// Observations with the deprecated `ID, Please!` flag. Note that this will return observations, but that this attribute is no longer used.
    pub id_please: Option<bool>,
    /// Observations that have community identifications
    pub identified: Option<bool>,
    /// Observations whose taxa are introduced in their location 
    pub introduced: Option<bool>,
    /// Observations that show on map tiles
    pub mappable: Option<bool>,
    /// Observations whose taxa are native to their location
    pub native: Option<bool>,
    /// Observations whose taxa are outside their known ranges
    pub out_of_range: Option<bool>,
    /// Observations identified by the curator of a project. If the `project_id` parameter is also specified, this will only consider observations identified by curators of the specified project(s) 
    pub pcid: Option<bool>,
    /// Observations with photos
    pub photos: Option<bool>,
    /// Observations that have been favorited by at least one user 
    pub popular: Option<bool>,
    /// Observations with sounds
    pub sounds: Option<bool>,
    /// Observations of active taxon concepts 
    pub taxon_is_active: Option<bool>,
    /// Observations whose taxa are threatened in their location 
    pub threatened: Option<bool>,
    /// Observations with a `quality_grade` of either `needs_id` or `research`. Equivalent to `quality_grade=needs_id,research` 
    pub verifiable: Option<bool>,
    /// License attribute of an observation must not be null
    pub licensed: Option<bool>,
    /// License attribute of at least one photo of an observation must not be null
    pub photo_licensed: Option<bool>,
    /// Must have this ID
    pub id: Option<Vec<String>>,
    /// Must not have this ID
    pub not_id: Option<Vec<String>>,
    /// Observation must have this license
    pub license: Option<Vec<String>>,
    /// Must have an observation field value with this datatype
    pub ofv_datatype: Option<Vec<String>>,
    /// Must have at least one photo with this license
    pub photo_license: Option<Vec<String>>,
    /// Must be observed within the place with this ID
    pub place_id: Option<Vec<i32>>,
    /// Must be added to the project this ID or slug
    pub project_id: Option<Vec<String>>,
    /// Taxon must have this rank
    pub rank: Option<Vec<String>>,
    /// Must be affiliated with the iNaturalist network website with this ID 
    pub site_id: Option<Vec<String>>,
    /// Must have at least one sound with this license
    pub sound_license: Option<Vec<String>>,
    /// Only show observations of these taxa and their descendants
    pub taxon_id: Option<Vec<String>>,
    /// Exclude observations of these taxa and their descendants
    pub without_taxon_id: Option<Vec<String>>,
    /// Taxon must have a scientific or common name matching this string 
    pub taxon_name: Option<Vec<String>>,
    /// User must have this ID or login
    pub user_id: Option<Vec<String>>,
    /// User must have this login
    pub user_login: Option<Vec<String>>,
    /// Observations identified by a particular user
    pub ident_user_id: Option<i32>,
    /// Must be observed within this day of the month
    pub day: Option<Vec<String>>,
    /// Must be observed within this month
    pub month: Option<Vec<String>>,
    /// Must be observed within this year
    pub year: Option<Vec<String>>,
    /// Must have an annotation using this controlled term ID
    pub term_id: Option<Vec<i32>>,
    /// Must have an annotation using this controlled value ID. Must be combined with the `term_id` parameter 
    pub term_value_id: Option<Vec<i32>>,
    /// Exclude observations with annotations using this controlled value ID. Must be combined with the `term_id` parameter 
    pub without_term_value_id: Option<Vec<i32>>,
    /// Must have a positional accuracy above this value (meters)
    pub acc_above: Option<String>,
    /// Must have a positional accuracy below this value (meters)
    pub acc_below: Option<String>,
    /// Positional accuracy must be below this value (in meters) or be unknown
    pub acc_below_or_unknown: Option<String>,
    /// Must be observed on or after this date
    pub d1: Option<String>,
    /// Must be observed on or before this date
    pub d2: Option<String>,
    /// Must be created at or after this time
    pub created_d1: Option<String>,
    /// Must be created at or before this time
    pub created_d2: Option<String>,
    /// Must be created on this date
    pub created_on: Option<String>,
    /// Must be observed on this date
    pub observed_on: Option<String>,
    /// Must not be of a taxon previously observed by this user
    pub unobserved_by_user_id: Option<i32>,
    /// Must match the rules of the project with this ID or slug
    pub apply_project_rules_for: Option<String>,
    /// Taxon must have this conservation status code. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub cs: Option<String>,
    /// Taxon must have a conservation status from this authority. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub csa: Option<String>,
    /// Taxon must have this IUCN conservation status. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub csi: Option<Vec<String>>,
    /// Must have this geoprivacy setting
    pub geoprivacy: Option<Vec<String>>,
    /// Filter observations by the most conservative geoprivacy applied by a conservation status associated with one of the taxa proposed in the current identifications. 
    pub taxon_geoprivacy: Option<Vec<String>>,
    /// Taxon must have this rank or lower
    pub hrank: Option<String>,
    /// Taxon must have this rank or higher
    pub lrank: Option<String>,
    /// Taxon must by within this iconic taxon
    pub iconic_taxa: Option<Vec<String>>,
    /// Must have an ID above this value
    pub id_above: Option<String>,
    /// Must have an ID below this value
    pub id_below: Option<String>,
    /// Identifications must meet these criteria
    pub identifications: Option<String>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub lat: Option<f64>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub lng: Option<f64>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub radius: Option<String>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelat: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelng: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlat: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlng: Option<f64>,
    /// Taxon must be in the list with this ID
    pub list_id: Option<i32>,
    /// Must not be in the project with this ID or slug
    pub not_in_project: Option<String>,
    /// Must not match the rules of the project with this ID or slug
    pub not_matching_project_rules_for: Option<String>,
    /// Search observation properties. Can be combined with `search_on`
    pub q: Option<String>,
    /// Properties to search on, when combined with `q`. Searches across all properties by default 
    pub search_on: Option<String>,
    /// Must have this quality grade
    pub quality_grade: Option<String>,
    /// Must be updated since this time
    pub updated_since: Option<String>,
    /// See `reviewed`
    pub viewer_id: Option<String>,
    /// Observations have been reviewed by the user with ID equal to the value of the `viewer_id` parameter 
    pub reviewed: Option<bool>
}

/// struct for passing parameters to the method [`heatmap_zoom_xy_grid_json_get`]
#[derive(Clone, Debug, Default)]
pub struct HeatmapZoomXyGridJsonGetParams {
    /// Zoom level. Z coordinate in the XYZ tiling scheme
    pub zoom: i32,
    /// X coordinate in the XYZ tiling scheme. Must be less than 2^zoom
    pub x: i32,
    /// Y coordinate in the XYZ tiling scheme. Must be less than 2^zoom
    pub y: i32,
    /// Primary color to use in tile creation. Accepts common colors by string (e.g. `color=blue`), and accepts escaped color HEX codes (e.g. `color=%2386a91c`) 
    pub color: Option<String>,
    /// Whether or not positional accuracy / coordinate uncertainty has been specified
    pub acc: Option<bool>,
    /// Captive or cultivated observations
    pub captive: Option<bool>,
    /// Observations whose taxa are endemic to their location
    pub endemic: Option<bool>,
    /// Observations that are georeferenced
    pub geo: Option<bool>,
    /// Observations with the deprecated `ID, Please!` flag. Note that this will return observations, but that this attribute is no longer used.
    pub id_please: Option<bool>,
    /// Observations that have community identifications
    pub identified: Option<bool>,
    /// Observations whose taxa are introduced in their location 
    pub introduced: Option<bool>,
    /// Observations that show on map tiles
    pub mappable: Option<bool>,
    /// Observations whose taxa are native to their location
    pub native: Option<bool>,
    /// Observations whose taxa are outside their known ranges
    pub out_of_range: Option<bool>,
    /// Observations identified by the curator of a project. If the `project_id` parameter is also specified, this will only consider observations identified by curators of the specified project(s) 
    pub pcid: Option<bool>,
    /// Observations with photos
    pub photos: Option<bool>,
    /// Observations that have been favorited by at least one user 
    pub popular: Option<bool>,
    /// Observations with sounds
    pub sounds: Option<bool>,
    /// Observations of active taxon concepts 
    pub taxon_is_active: Option<bool>,
    /// Observations whose taxa are threatened in their location 
    pub threatened: Option<bool>,
    /// Observations with a `quality_grade` of either `needs_id` or `research`. Equivalent to `quality_grade=needs_id,research` 
    pub verifiable: Option<bool>,
    /// License attribute of an observation must not be null
    pub licensed: Option<bool>,
    /// License attribute of at least one photo of an observation must not be null
    pub photo_licensed: Option<bool>,
    /// Must have this ID
    pub id: Option<Vec<String>>,
    /// Must not have this ID
    pub not_id: Option<Vec<String>>,
    /// Observation must have this license
    pub license: Option<Vec<String>>,
    /// Must have an observation field value with this datatype
    pub ofv_datatype: Option<Vec<String>>,
    /// Must have at least one photo with this license
    pub photo_license: Option<Vec<String>>,
    /// Must be observed within the place with this ID
    pub place_id: Option<Vec<i32>>,
    /// Must be added to the project this ID or slug
    pub project_id: Option<Vec<String>>,
    /// Taxon must have this rank
    pub rank: Option<Vec<String>>,
    /// Must be affiliated with the iNaturalist network website with this ID 
    pub site_id: Option<Vec<String>>,
    /// Must have at least one sound with this license
    pub sound_license: Option<Vec<String>>,
    /// Only show observations of these taxa and their descendants
    pub taxon_id: Option<Vec<String>>,
    /// Exclude observations of these taxa and their descendants
    pub without_taxon_id: Option<Vec<String>>,
    /// Taxon must have a scientific or common name matching this string 
    pub taxon_name: Option<Vec<String>>,
    /// User must have this ID or login
    pub user_id: Option<Vec<String>>,
    /// User must have this login
    pub user_login: Option<Vec<String>>,
    /// Observations identified by a particular user
    pub ident_user_id: Option<i32>,
    /// Must be observed within this day of the month
    pub day: Option<Vec<String>>,
    /// Must be observed within this month
    pub month: Option<Vec<String>>,
    /// Must be observed within this year
    pub year: Option<Vec<String>>,
    /// Must have an annotation using this controlled term ID
    pub term_id: Option<Vec<i32>>,
    /// Must have an annotation using this controlled value ID. Must be combined with the `term_id` parameter 
    pub term_value_id: Option<Vec<i32>>,
    /// Exclude observations with annotations using this controlled value ID. Must be combined with the `term_id` parameter 
    pub without_term_value_id: Option<Vec<i32>>,
    /// Must have a positional accuracy above this value (meters)
    pub acc_above: Option<String>,
    /// Must have a positional accuracy below this value (meters)
    pub acc_below: Option<String>,
    /// Positional accuracy must be below this value (in meters) or be unknown
    pub acc_below_or_unknown: Option<String>,
    /// Must be observed on or after this date
    pub d1: Option<String>,
    /// Must be observed on or before this date
    pub d2: Option<String>,
    /// Must be created at or after this time
    pub created_d1: Option<String>,
    /// Must be created at or before this time
    pub created_d2: Option<String>,
    /// Must be created on this date
    pub created_on: Option<String>,
    /// Must be observed on this date
    pub observed_on: Option<String>,
    /// Must not be of a taxon previously observed by this user
    pub unobserved_by_user_id: Option<i32>,
    /// Must match the rules of the project with this ID or slug
    pub apply_project_rules_for: Option<String>,
    /// Taxon must have this conservation status code. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub cs: Option<String>,
    /// Taxon must have a conservation status from this authority. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub csa: Option<String>,
    /// Taxon must have this IUCN conservation status. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub csi: Option<Vec<String>>,
    /// Must have this geoprivacy setting
    pub geoprivacy: Option<Vec<String>>,
    /// Filter observations by the most conservative geoprivacy applied by a conservation status associated with one of the taxa proposed in the current identifications. 
    pub taxon_geoprivacy: Option<Vec<String>>,
    /// Taxon must have this rank or lower
    pub hrank: Option<String>,
    /// Taxon must have this rank or higher
    pub lrank: Option<String>,
    /// Taxon must by within this iconic taxon
    pub iconic_taxa: Option<Vec<String>>,
    /// Must have an ID above this value
    pub id_above: Option<String>,
    /// Must have an ID below this value
    pub id_below: Option<String>,
    /// Identifications must meet these criteria
    pub identifications: Option<String>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub lat: Option<f64>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub lng: Option<f64>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub radius: Option<String>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelat: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelng: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlat: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlng: Option<f64>,
    /// Taxon must be in the list with this ID
    pub list_id: Option<i32>,
    /// Must not be in the project with this ID or slug
    pub not_in_project: Option<String>,
    /// Must not match the rules of the project with this ID or slug
    pub not_matching_project_rules_for: Option<String>,
    /// Search observation properties. Can be combined with `search_on`
    pub q: Option<String>,
    /// Properties to search on, when combined with `q`. Searches across all properties by default 
    pub search_on: Option<String>,
    /// Must have this quality grade
    pub quality_grade: Option<String>,
    /// Must be updated since this time
    pub updated_since: Option<String>,
    /// See `reviewed`
    pub viewer_id: Option<String>,
    /// Observations have been reviewed by the user with ID equal to the value of the `viewer_id` parameter 
    pub reviewed: Option<bool>
}

/// struct for passing parameters to the method [`points_zoom_xy_grid_json_get`]
#[derive(Clone, Debug, Default)]
pub struct PointsZoomXyGridJsonGetParams {
    /// Zoom level. Z coordinate in the XYZ tiling scheme
    pub zoom: i32,
    /// X coordinate in the XYZ tiling scheme. Must be less than 2^zoom
    pub x: i32,
    /// Y coordinate in the XYZ tiling scheme. Must be less than 2^zoom
    pub y: i32,
    /// Primary color to use in tile creation. Accepts common colors by string (e.g. `color=blue`), and accepts escaped color HEX codes (e.g. `color=%2386a91c`) 
    pub color: Option<String>,
    /// Whether or not positional accuracy / coordinate uncertainty has been specified
    pub acc: Option<bool>,
    /// Captive or cultivated observations
    pub captive: Option<bool>,
    /// Observations whose taxa are endemic to their location
    pub endemic: Option<bool>,
    /// Observations that are georeferenced
    pub geo: Option<bool>,
    /// Observations with the deprecated `ID, Please!` flag. Note that this will return observations, but that this attribute is no longer used.
    pub id_please: Option<bool>,
    /// Observations that have community identifications
    pub identified: Option<bool>,
    /// Observations whose taxa are introduced in their location 
    pub introduced: Option<bool>,
    /// Observations that show on map tiles
    pub mappable: Option<bool>,
    /// Observations whose taxa are native to their location
    pub native: Option<bool>,
    /// Observations whose taxa are outside their known ranges
    pub out_of_range: Option<bool>,
    /// Observations identified by the curator of a project. If the `project_id` parameter is also specified, this will only consider observations identified by curators of the specified project(s) 
    pub pcid: Option<bool>,
    /// Observations with photos
    pub photos: Option<bool>,
    /// Observations that have been favorited by at least one user 
    pub popular: Option<bool>,
    /// Observations with sounds
    pub sounds: Option<bool>,
    /// Observations of active taxon concepts 
    pub taxon_is_active: Option<bool>,
    /// Observations whose taxa are threatened in their location 
    pub threatened: Option<bool>,
    /// Observations with a `quality_grade` of either `needs_id` or `research`. Equivalent to `quality_grade=needs_id,research` 
    pub verifiable: Option<bool>,
    /// License attribute of an observation must not be null
    pub licensed: Option<bool>,
    /// License attribute of at least one photo of an observation must not be null
    pub photo_licensed: Option<bool>,
    /// Must have this ID
    pub id: Option<Vec<String>>,
    /// Must not have this ID
    pub not_id: Option<Vec<String>>,
    /// Observation must have this license
    pub license: Option<Vec<String>>,
    /// Must have an observation field value with this datatype
    pub ofv_datatype: Option<Vec<String>>,
    /// Must have at least one photo with this license
    pub photo_license: Option<Vec<String>>,
    /// Must be observed within the place with this ID
    pub place_id: Option<Vec<i32>>,
    /// Must be added to the project this ID or slug
    pub project_id: Option<Vec<String>>,
    /// Taxon must have this rank
    pub rank: Option<Vec<String>>,
    /// Must be affiliated with the iNaturalist network website with this ID 
    pub site_id: Option<Vec<String>>,
    /// Must have at least one sound with this license
    pub sound_license: Option<Vec<String>>,
    /// Only show observations of these taxa and their descendants
    pub taxon_id: Option<Vec<String>>,
    /// Exclude observations of these taxa and their descendants
    pub without_taxon_id: Option<Vec<String>>,
    /// Taxon must have a scientific or common name matching this string 
    pub taxon_name: Option<Vec<String>>,
    /// User must have this ID or login
    pub user_id: Option<Vec<String>>,
    /// User must have this login
    pub user_login: Option<Vec<String>>,
    /// Observations identified by a particular user
    pub ident_user_id: Option<i32>,
    /// Must be observed within this day of the month
    pub day: Option<Vec<String>>,
    /// Must be observed within this month
    pub month: Option<Vec<String>>,
    /// Must be observed within this year
    pub year: Option<Vec<String>>,
    /// Must have an annotation using this controlled term ID
    pub term_id: Option<Vec<i32>>,
    /// Must have an annotation using this controlled value ID. Must be combined with the `term_id` parameter 
    pub term_value_id: Option<Vec<i32>>,
    /// Exclude observations with annotations using this controlled value ID. Must be combined with the `term_id` parameter 
    pub without_term_value_id: Option<Vec<i32>>,
    /// Must have a positional accuracy above this value (meters)
    pub acc_above: Option<String>,
    /// Must have a positional accuracy below this value (meters)
    pub acc_below: Option<String>,
    /// Positional accuracy must be below this value (in meters) or be unknown
    pub acc_below_or_unknown: Option<String>,
    /// Must be observed on or after this date
    pub d1: Option<String>,
    /// Must be observed on or before this date
    pub d2: Option<String>,
    /// Must be created at or after this time
    pub created_d1: Option<String>,
    /// Must be created at or before this time
    pub created_d2: Option<String>,
    /// Must be created on this date
    pub created_on: Option<String>,
    /// Must be observed on this date
    pub observed_on: Option<String>,
    /// Must not be of a taxon previously observed by this user
    pub unobserved_by_user_id: Option<i32>,
    /// Must match the rules of the project with this ID or slug
    pub apply_project_rules_for: Option<String>,
    /// Taxon must have this conservation status code. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub cs: Option<String>,
    /// Taxon must have a conservation status from this authority. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub csa: Option<String>,
    /// Taxon must have this IUCN conservation status. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub csi: Option<Vec<String>>,
    /// Must have this geoprivacy setting
    pub geoprivacy: Option<Vec<String>>,
    /// Filter observations by the most conservative geoprivacy applied by a conservation status associated with one of the taxa proposed in the current identifications. 
    pub taxon_geoprivacy: Option<Vec<String>>,
    /// Taxon must have this rank or lower
    pub hrank: Option<String>,
    /// Taxon must have this rank or higher
    pub lrank: Option<String>,
    /// Taxon must by within this iconic taxon
    pub iconic_taxa: Option<Vec<String>>,
    /// Must have an ID above this value
    pub id_above: Option<String>,
    /// Must have an ID below this value
    pub id_below: Option<String>,
    /// Identifications must meet these criteria
    pub identifications: Option<String>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub lat: Option<f64>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub lng: Option<f64>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub radius: Option<String>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelat: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelng: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlat: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlng: Option<f64>,
    /// Taxon must be in the list with this ID
    pub list_id: Option<i32>,
    /// Must not be in the project with this ID or slug
    pub not_in_project: Option<String>,
    /// Must not match the rules of the project with this ID or slug
    pub not_matching_project_rules_for: Option<String>,
    /// Search observation properties. Can be combined with `search_on`
    pub q: Option<String>,
    /// Properties to search on, when combined with `q`. Searches across all properties by default 
    pub search_on: Option<String>,
    /// Must have this quality grade
    pub quality_grade: Option<String>,
    /// Must be updated since this time
    pub updated_since: Option<String>,
    /// See `reviewed`
    pub viewer_id: Option<String>,
    /// Observations have been reviewed by the user with ID equal to the value of the `viewer_id` parameter 
    pub reviewed: Option<bool>
}


/// struct for typed errors of method [`colored_heatmap_zoom_xy_grid_json_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ColoredHeatmapZoomXyGridJsonGetError {
    DefaultResponse(crate::models::Error),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`grid_zoom_xy_grid_json_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum GridZoomXyGridJsonGetError {
    DefaultResponse(crate::models::Error),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`heatmap_zoom_xy_grid_json_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum HeatmapZoomXyGridJsonGetError {
    DefaultResponse(crate::models::Error),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`points_zoom_xy_grid_json_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PointsZoomXyGridJsonGetError {
    DefaultResponse(crate::models::Error),
    UnknownValue(serde_json::Value),
}


/// Given zero to many of following parameters, returns a JSON file following the UTFGrid spec, representing observations matching the search criteria 
pub async fn colored_heatmap_zoom_xy_grid_json_get(configuration: &configuration::Configuration, params: ColoredHeatmapZoomXyGridJsonGetParams) -> Result<crate::models::UtfGridResponse, Error<ColoredHeatmapZoomXyGridJsonGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let zoom = params.zoom;
    let x = params.x;
    let y = params.y;
    let color = params.color;
    let acc = params.acc;
    let captive = params.captive;
    let endemic = params.endemic;
    let geo = params.geo;
    let id_please = params.id_please;
    let identified = params.identified;
    let introduced = params.introduced;
    let mappable = params.mappable;
    let native = params.native;
    let out_of_range = params.out_of_range;
    let pcid = params.pcid;
    let photos = params.photos;
    let popular = params.popular;
    let sounds = params.sounds;
    let taxon_is_active = params.taxon_is_active;
    let threatened = params.threatened;
    let verifiable = params.verifiable;
    let licensed = params.licensed;
    let photo_licensed = params.photo_licensed;
    let id = params.id;
    let not_id = params.not_id;
    let license = params.license;
    let ofv_datatype = params.ofv_datatype;
    let photo_license = params.photo_license;
    let place_id = params.place_id;
    let project_id = params.project_id;
    let rank = params.rank;
    let site_id = params.site_id;
    let sound_license = params.sound_license;
    let taxon_id = params.taxon_id;
    let without_taxon_id = params.without_taxon_id;
    let taxon_name = params.taxon_name;
    let user_id = params.user_id;
    let user_login = params.user_login;
    let ident_user_id = params.ident_user_id;
    let day = params.day;
    let month = params.month;
    let year = params.year;
    let term_id = params.term_id;
    let term_value_id = params.term_value_id;
    let without_term_value_id = params.without_term_value_id;
    let acc_above = params.acc_above;
    let acc_below = params.acc_below;
    let acc_below_or_unknown = params.acc_below_or_unknown;
    let d1 = params.d1;
    let d2 = params.d2;
    let created_d1 = params.created_d1;
    let created_d2 = params.created_d2;
    let created_on = params.created_on;
    let observed_on = params.observed_on;
    let unobserved_by_user_id = params.unobserved_by_user_id;
    let apply_project_rules_for = params.apply_project_rules_for;
    let cs = params.cs;
    let csa = params.csa;
    let csi = params.csi;
    let geoprivacy = params.geoprivacy;
    let taxon_geoprivacy = params.taxon_geoprivacy;
    let hrank = params.hrank;
    let lrank = params.lrank;
    let iconic_taxa = params.iconic_taxa;
    let id_above = params.id_above;
    let id_below = params.id_below;
    let identifications = params.identifications;
    let lat = params.lat;
    let lng = params.lng;
    let radius = params.radius;
    let nelat = params.nelat;
    let nelng = params.nelng;
    let swlat = params.swlat;
    let swlng = params.swlng;
    let list_id = params.list_id;
    let not_in_project = params.not_in_project;
    let not_matching_project_rules_for = params.not_matching_project_rules_for;
    let q = params.q;
    let search_on = params.search_on;
    let quality_grade = params.quality_grade;
    let updated_since = params.updated_since;
    let viewer_id = params.viewer_id;
    let reviewed = params.reviewed;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/colored_heatmap/{zoom}/{x}/{y}.grid.json", local_var_configuration.base_path, zoom=zoom, x=x, y=y);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = color {
        local_var_req_builder = local_var_req_builder.query(&[("color", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc {
        local_var_req_builder = local_var_req_builder.query(&[("acc", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = captive {
        local_var_req_builder = local_var_req_builder.query(&[("captive", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = endemic {
        local_var_req_builder = local_var_req_builder.query(&[("endemic", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = geo {
        local_var_req_builder = local_var_req_builder.query(&[("geo", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_please {
        local_var_req_builder = local_var_req_builder.query(&[("id_please", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = identified {
        local_var_req_builder = local_var_req_builder.query(&[("identified", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = introduced {
        local_var_req_builder = local_var_req_builder.query(&[("introduced", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = mappable {
        local_var_req_builder = local_var_req_builder.query(&[("mappable", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = native {
        local_var_req_builder = local_var_req_builder.query(&[("native", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = out_of_range {
        local_var_req_builder = local_var_req_builder.query(&[("out_of_range", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = pcid {
        local_var_req_builder = local_var_req_builder.query(&[("pcid", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = photos {
        local_var_req_builder = local_var_req_builder.query(&[("photos", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = popular {
        local_var_req_builder = local_var_req_builder.query(&[("popular", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = sounds {
        local_var_req_builder = local_var_req_builder.query(&[("sounds", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = taxon_is_active {
        local_var_req_builder = local_var_req_builder.query(&[("taxon_is_active", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = threatened {
        local_var_req_builder = local_var_req_builder.query(&[("threatened", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = verifiable {
        local_var_req_builder = local_var_req_builder.query(&[("verifiable", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = licensed {
        local_var_req_builder = local_var_req_builder.query(&[("licensed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = photo_licensed {
        local_var_req_builder = local_var_req_builder.query(&[("photo_licensed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = not_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("not_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("not_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = ofv_datatype {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("ofv_datatype".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("ofv_datatype", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = photo_license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("photo_license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("photo_license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = place_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("place_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("place_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = project_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("project_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("project_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = rank {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("rank".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("rank", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = site_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("site_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("site_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = sound_license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("sound_license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("sound_license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = without_taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("without_taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("without_taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_name {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_name".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_name", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = user_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("user_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("user_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = user_login {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("user_login".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("user_login", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = ident_user_id {
        local_var_req_builder = local_var_req_builder.query(&[("ident_user_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = day {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("day".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("day", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = month {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("month".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("month", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = year {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("year".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("year", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = term_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("term_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("term_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = term_value_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("term_value_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("term_value_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = without_term_value_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("without_term_value_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("without_term_value_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = acc_above {
        local_var_req_builder = local_var_req_builder.query(&[("acc_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc_below {
        local_var_req_builder = local_var_req_builder.query(&[("acc_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc_below_or_unknown {
        local_var_req_builder = local_var_req_builder.query(&[("acc_below_or_unknown", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = d1 {
        local_var_req_builder = local_var_req_builder.query(&[("d1", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = d2 {
        local_var_req_builder = local_var_req_builder.query(&[("d2", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_d1 {
        local_var_req_builder = local_var_req_builder.query(&[("created_d1", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_d2 {
        local_var_req_builder = local_var_req_builder.query(&[("created_d2", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_on {
        local_var_req_builder = local_var_req_builder.query(&[("created_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = observed_on {
        local_var_req_builder = local_var_req_builder.query(&[("observed_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = unobserved_by_user_id {
        local_var_req_builder = local_var_req_builder.query(&[("unobserved_by_user_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = apply_project_rules_for {
        local_var_req_builder = local_var_req_builder.query(&[("apply_project_rules_for", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cs {
        local_var_req_builder = local_var_req_builder.query(&[("cs", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = csa {
        local_var_req_builder = local_var_req_builder.query(&[("csa", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = csi {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("csi".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("csi", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = geoprivacy {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("geoprivacy".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("geoprivacy", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_geoprivacy {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_geoprivacy".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_geoprivacy", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = hrank {
        local_var_req_builder = local_var_req_builder.query(&[("hrank", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lrank {
        local_var_req_builder = local_var_req_builder.query(&[("lrank", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = iconic_taxa {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("iconic_taxa".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("iconic_taxa", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = id_above {
        local_var_req_builder = local_var_req_builder.query(&[("id_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_below {
        local_var_req_builder = local_var_req_builder.query(&[("id_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = identifications {
        local_var_req_builder = local_var_req_builder.query(&[("identifications", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lat {
        local_var_req_builder = local_var_req_builder.query(&[("lat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lng {
        local_var_req_builder = local_var_req_builder.query(&[("lng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = radius {
        local_var_req_builder = local_var_req_builder.query(&[("radius", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = nelat {
        local_var_req_builder = local_var_req_builder.query(&[("nelat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = nelng {
        local_var_req_builder = local_var_req_builder.query(&[("nelng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = swlat {
        local_var_req_builder = local_var_req_builder.query(&[("swlat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = swlng {
        local_var_req_builder = local_var_req_builder.query(&[("swlng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = list_id {
        local_var_req_builder = local_var_req_builder.query(&[("list_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = not_in_project {
        local_var_req_builder = local_var_req_builder.query(&[("not_in_project", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = not_matching_project_rules_for {
        local_var_req_builder = local_var_req_builder.query(&[("not_matching_project_rules_for", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = q {
        local_var_req_builder = local_var_req_builder.query(&[("q", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = search_on {
        local_var_req_builder = local_var_req_builder.query(&[("search_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = quality_grade {
        local_var_req_builder = local_var_req_builder.query(&[("quality_grade", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = updated_since {
        local_var_req_builder = local_var_req_builder.query(&[("updated_since", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = viewer_id {
        local_var_req_builder = local_var_req_builder.query(&[("viewer_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = reviewed {
        local_var_req_builder = local_var_req_builder.query(&[("reviewed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<ColoredHeatmapZoomXyGridJsonGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Given zero to many of following parameters, returns a JSON file following the UTFGrid spec, representing observations matching the search criteria 
pub async fn grid_zoom_xy_grid_json_get(configuration: &configuration::Configuration, params: GridZoomXyGridJsonGetParams) -> Result<crate::models::UtfGridResponse, Error<GridZoomXyGridJsonGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let zoom = params.zoom;
    let x = params.x;
    let y = params.y;
    let color = params.color;
    let acc = params.acc;
    let captive = params.captive;
    let endemic = params.endemic;
    let geo = params.geo;
    let id_please = params.id_please;
    let identified = params.identified;
    let introduced = params.introduced;
    let mappable = params.mappable;
    let native = params.native;
    let out_of_range = params.out_of_range;
    let pcid = params.pcid;
    let photos = params.photos;
    let popular = params.popular;
    let sounds = params.sounds;
    let taxon_is_active = params.taxon_is_active;
    let threatened = params.threatened;
    let verifiable = params.verifiable;
    let licensed = params.licensed;
    let photo_licensed = params.photo_licensed;
    let id = params.id;
    let not_id = params.not_id;
    let license = params.license;
    let ofv_datatype = params.ofv_datatype;
    let photo_license = params.photo_license;
    let place_id = params.place_id;
    let project_id = params.project_id;
    let rank = params.rank;
    let site_id = params.site_id;
    let sound_license = params.sound_license;
    let taxon_id = params.taxon_id;
    let without_taxon_id = params.without_taxon_id;
    let taxon_name = params.taxon_name;
    let user_id = params.user_id;
    let user_login = params.user_login;
    let ident_user_id = params.ident_user_id;
    let day = params.day;
    let month = params.month;
    let year = params.year;
    let term_id = params.term_id;
    let term_value_id = params.term_value_id;
    let without_term_value_id = params.without_term_value_id;
    let acc_above = params.acc_above;
    let acc_below = params.acc_below;
    let acc_below_or_unknown = params.acc_below_or_unknown;
    let d1 = params.d1;
    let d2 = params.d2;
    let created_d1 = params.created_d1;
    let created_d2 = params.created_d2;
    let created_on = params.created_on;
    let observed_on = params.observed_on;
    let unobserved_by_user_id = params.unobserved_by_user_id;
    let apply_project_rules_for = params.apply_project_rules_for;
    let cs = params.cs;
    let csa = params.csa;
    let csi = params.csi;
    let geoprivacy = params.geoprivacy;
    let taxon_geoprivacy = params.taxon_geoprivacy;
    let hrank = params.hrank;
    let lrank = params.lrank;
    let iconic_taxa = params.iconic_taxa;
    let id_above = params.id_above;
    let id_below = params.id_below;
    let identifications = params.identifications;
    let lat = params.lat;
    let lng = params.lng;
    let radius = params.radius;
    let nelat = params.nelat;
    let nelng = params.nelng;
    let swlat = params.swlat;
    let swlng = params.swlng;
    let list_id = params.list_id;
    let not_in_project = params.not_in_project;
    let not_matching_project_rules_for = params.not_matching_project_rules_for;
    let q = params.q;
    let search_on = params.search_on;
    let quality_grade = params.quality_grade;
    let updated_since = params.updated_since;
    let viewer_id = params.viewer_id;
    let reviewed = params.reviewed;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/grid/{zoom}/{x}/{y}.grid.json", local_var_configuration.base_path, zoom=zoom, x=x, y=y);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = color {
        local_var_req_builder = local_var_req_builder.query(&[("color", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc {
        local_var_req_builder = local_var_req_builder.query(&[("acc", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = captive {
        local_var_req_builder = local_var_req_builder.query(&[("captive", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = endemic {
        local_var_req_builder = local_var_req_builder.query(&[("endemic", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = geo {
        local_var_req_builder = local_var_req_builder.query(&[("geo", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_please {
        local_var_req_builder = local_var_req_builder.query(&[("id_please", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = identified {
        local_var_req_builder = local_var_req_builder.query(&[("identified", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = introduced {
        local_var_req_builder = local_var_req_builder.query(&[("introduced", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = mappable {
        local_var_req_builder = local_var_req_builder.query(&[("mappable", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = native {
        local_var_req_builder = local_var_req_builder.query(&[("native", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = out_of_range {
        local_var_req_builder = local_var_req_builder.query(&[("out_of_range", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = pcid {
        local_var_req_builder = local_var_req_builder.query(&[("pcid", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = photos {
        local_var_req_builder = local_var_req_builder.query(&[("photos", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = popular {
        local_var_req_builder = local_var_req_builder.query(&[("popular", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = sounds {
        local_var_req_builder = local_var_req_builder.query(&[("sounds", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = taxon_is_active {
        local_var_req_builder = local_var_req_builder.query(&[("taxon_is_active", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = threatened {
        local_var_req_builder = local_var_req_builder.query(&[("threatened", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = verifiable {
        local_var_req_builder = local_var_req_builder.query(&[("verifiable", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = licensed {
        local_var_req_builder = local_var_req_builder.query(&[("licensed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = photo_licensed {
        local_var_req_builder = local_var_req_builder.query(&[("photo_licensed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = not_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("not_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("not_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = ofv_datatype {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("ofv_datatype".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("ofv_datatype", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = photo_license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("photo_license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("photo_license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = place_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("place_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("place_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = project_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("project_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("project_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = rank {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("rank".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("rank", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = site_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("site_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("site_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = sound_license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("sound_license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("sound_license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = without_taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("without_taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("without_taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_name {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_name".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_name", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = user_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("user_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("user_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = user_login {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("user_login".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("user_login", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = ident_user_id {
        local_var_req_builder = local_var_req_builder.query(&[("ident_user_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = day {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("day".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("day", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = month {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("month".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("month", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = year {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("year".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("year", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = term_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("term_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("term_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = term_value_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("term_value_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("term_value_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = without_term_value_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("without_term_value_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("without_term_value_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = acc_above {
        local_var_req_builder = local_var_req_builder.query(&[("acc_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc_below {
        local_var_req_builder = local_var_req_builder.query(&[("acc_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc_below_or_unknown {
        local_var_req_builder = local_var_req_builder.query(&[("acc_below_or_unknown", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = d1 {
        local_var_req_builder = local_var_req_builder.query(&[("d1", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = d2 {
        local_var_req_builder = local_var_req_builder.query(&[("d2", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_d1 {
        local_var_req_builder = local_var_req_builder.query(&[("created_d1", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_d2 {
        local_var_req_builder = local_var_req_builder.query(&[("created_d2", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_on {
        local_var_req_builder = local_var_req_builder.query(&[("created_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = observed_on {
        local_var_req_builder = local_var_req_builder.query(&[("observed_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = unobserved_by_user_id {
        local_var_req_builder = local_var_req_builder.query(&[("unobserved_by_user_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = apply_project_rules_for {
        local_var_req_builder = local_var_req_builder.query(&[("apply_project_rules_for", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cs {
        local_var_req_builder = local_var_req_builder.query(&[("cs", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = csa {
        local_var_req_builder = local_var_req_builder.query(&[("csa", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = csi {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("csi".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("csi", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = geoprivacy {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("geoprivacy".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("geoprivacy", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_geoprivacy {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_geoprivacy".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_geoprivacy", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = hrank {
        local_var_req_builder = local_var_req_builder.query(&[("hrank", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lrank {
        local_var_req_builder = local_var_req_builder.query(&[("lrank", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = iconic_taxa {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("iconic_taxa".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("iconic_taxa", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = id_above {
        local_var_req_builder = local_var_req_builder.query(&[("id_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_below {
        local_var_req_builder = local_var_req_builder.query(&[("id_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = identifications {
        local_var_req_builder = local_var_req_builder.query(&[("identifications", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lat {
        local_var_req_builder = local_var_req_builder.query(&[("lat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lng {
        local_var_req_builder = local_var_req_builder.query(&[("lng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = radius {
        local_var_req_builder = local_var_req_builder.query(&[("radius", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = nelat {
        local_var_req_builder = local_var_req_builder.query(&[("nelat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = nelng {
        local_var_req_builder = local_var_req_builder.query(&[("nelng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = swlat {
        local_var_req_builder = local_var_req_builder.query(&[("swlat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = swlng {
        local_var_req_builder = local_var_req_builder.query(&[("swlng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = list_id {
        local_var_req_builder = local_var_req_builder.query(&[("list_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = not_in_project {
        local_var_req_builder = local_var_req_builder.query(&[("not_in_project", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = not_matching_project_rules_for {
        local_var_req_builder = local_var_req_builder.query(&[("not_matching_project_rules_for", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = q {
        local_var_req_builder = local_var_req_builder.query(&[("q", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = search_on {
        local_var_req_builder = local_var_req_builder.query(&[("search_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = quality_grade {
        local_var_req_builder = local_var_req_builder.query(&[("quality_grade", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = updated_since {
        local_var_req_builder = local_var_req_builder.query(&[("updated_since", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = viewer_id {
        local_var_req_builder = local_var_req_builder.query(&[("viewer_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = reviewed {
        local_var_req_builder = local_var_req_builder.query(&[("reviewed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<GridZoomXyGridJsonGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Given zero to many of following parameters, returns a JSON file following the UTFGrid spec, representing observations matching the search criteria 
pub async fn heatmap_zoom_xy_grid_json_get(configuration: &configuration::Configuration, params: HeatmapZoomXyGridJsonGetParams) -> Result<crate::models::UtfGridResponse, Error<HeatmapZoomXyGridJsonGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let zoom = params.zoom;
    let x = params.x;
    let y = params.y;
    let color = params.color;
    let acc = params.acc;
    let captive = params.captive;
    let endemic = params.endemic;
    let geo = params.geo;
    let id_please = params.id_please;
    let identified = params.identified;
    let introduced = params.introduced;
    let mappable = params.mappable;
    let native = params.native;
    let out_of_range = params.out_of_range;
    let pcid = params.pcid;
    let photos = params.photos;
    let popular = params.popular;
    let sounds = params.sounds;
    let taxon_is_active = params.taxon_is_active;
    let threatened = params.threatened;
    let verifiable = params.verifiable;
    let licensed = params.licensed;
    let photo_licensed = params.photo_licensed;
    let id = params.id;
    let not_id = params.not_id;
    let license = params.license;
    let ofv_datatype = params.ofv_datatype;
    let photo_license = params.photo_license;
    let place_id = params.place_id;
    let project_id = params.project_id;
    let rank = params.rank;
    let site_id = params.site_id;
    let sound_license = params.sound_license;
    let taxon_id = params.taxon_id;
    let without_taxon_id = params.without_taxon_id;
    let taxon_name = params.taxon_name;
    let user_id = params.user_id;
    let user_login = params.user_login;
    let ident_user_id = params.ident_user_id;
    let day = params.day;
    let month = params.month;
    let year = params.year;
    let term_id = params.term_id;
    let term_value_id = params.term_value_id;
    let without_term_value_id = params.without_term_value_id;
    let acc_above = params.acc_above;
    let acc_below = params.acc_below;
    let acc_below_or_unknown = params.acc_below_or_unknown;
    let d1 = params.d1;
    let d2 = params.d2;
    let created_d1 = params.created_d1;
    let created_d2 = params.created_d2;
    let created_on = params.created_on;
    let observed_on = params.observed_on;
    let unobserved_by_user_id = params.unobserved_by_user_id;
    let apply_project_rules_for = params.apply_project_rules_for;
    let cs = params.cs;
    let csa = params.csa;
    let csi = params.csi;
    let geoprivacy = params.geoprivacy;
    let taxon_geoprivacy = params.taxon_geoprivacy;
    let hrank = params.hrank;
    let lrank = params.lrank;
    let iconic_taxa = params.iconic_taxa;
    let id_above = params.id_above;
    let id_below = params.id_below;
    let identifications = params.identifications;
    let lat = params.lat;
    let lng = params.lng;
    let radius = params.radius;
    let nelat = params.nelat;
    let nelng = params.nelng;
    let swlat = params.swlat;
    let swlng = params.swlng;
    let list_id = params.list_id;
    let not_in_project = params.not_in_project;
    let not_matching_project_rules_for = params.not_matching_project_rules_for;
    let q = params.q;
    let search_on = params.search_on;
    let quality_grade = params.quality_grade;
    let updated_since = params.updated_since;
    let viewer_id = params.viewer_id;
    let reviewed = params.reviewed;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/heatmap/{zoom}/{x}/{y}.grid.json", local_var_configuration.base_path, zoom=zoom, x=x, y=y);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = color {
        local_var_req_builder = local_var_req_builder.query(&[("color", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc {
        local_var_req_builder = local_var_req_builder.query(&[("acc", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = captive {
        local_var_req_builder = local_var_req_builder.query(&[("captive", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = endemic {
        local_var_req_builder = local_var_req_builder.query(&[("endemic", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = geo {
        local_var_req_builder = local_var_req_builder.query(&[("geo", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_please {
        local_var_req_builder = local_var_req_builder.query(&[("id_please", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = identified {
        local_var_req_builder = local_var_req_builder.query(&[("identified", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = introduced {
        local_var_req_builder = local_var_req_builder.query(&[("introduced", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = mappable {
        local_var_req_builder = local_var_req_builder.query(&[("mappable", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = native {
        local_var_req_builder = local_var_req_builder.query(&[("native", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = out_of_range {
        local_var_req_builder = local_var_req_builder.query(&[("out_of_range", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = pcid {
        local_var_req_builder = local_var_req_builder.query(&[("pcid", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = photos {
        local_var_req_builder = local_var_req_builder.query(&[("photos", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = popular {
        local_var_req_builder = local_var_req_builder.query(&[("popular", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = sounds {
        local_var_req_builder = local_var_req_builder.query(&[("sounds", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = taxon_is_active {
        local_var_req_builder = local_var_req_builder.query(&[("taxon_is_active", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = threatened {
        local_var_req_builder = local_var_req_builder.query(&[("threatened", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = verifiable {
        local_var_req_builder = local_var_req_builder.query(&[("verifiable", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = licensed {
        local_var_req_builder = local_var_req_builder.query(&[("licensed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = photo_licensed {
        local_var_req_builder = local_var_req_builder.query(&[("photo_licensed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = not_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("not_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("not_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = ofv_datatype {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("ofv_datatype".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("ofv_datatype", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = photo_license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("photo_license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("photo_license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = place_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("place_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("place_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = project_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("project_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("project_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = rank {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("rank".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("rank", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = site_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("site_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("site_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = sound_license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("sound_license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("sound_license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = without_taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("without_taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("without_taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_name {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_name".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_name", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = user_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("user_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("user_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = user_login {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("user_login".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("user_login", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = ident_user_id {
        local_var_req_builder = local_var_req_builder.query(&[("ident_user_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = day {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("day".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("day", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = month {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("month".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("month", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = year {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("year".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("year", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = term_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("term_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("term_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = term_value_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("term_value_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("term_value_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = without_term_value_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("without_term_value_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("without_term_value_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = acc_above {
        local_var_req_builder = local_var_req_builder.query(&[("acc_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc_below {
        local_var_req_builder = local_var_req_builder.query(&[("acc_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc_below_or_unknown {
        local_var_req_builder = local_var_req_builder.query(&[("acc_below_or_unknown", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = d1 {
        local_var_req_builder = local_var_req_builder.query(&[("d1", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = d2 {
        local_var_req_builder = local_var_req_builder.query(&[("d2", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_d1 {
        local_var_req_builder = local_var_req_builder.query(&[("created_d1", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_d2 {
        local_var_req_builder = local_var_req_builder.query(&[("created_d2", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_on {
        local_var_req_builder = local_var_req_builder.query(&[("created_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = observed_on {
        local_var_req_builder = local_var_req_builder.query(&[("observed_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = unobserved_by_user_id {
        local_var_req_builder = local_var_req_builder.query(&[("unobserved_by_user_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = apply_project_rules_for {
        local_var_req_builder = local_var_req_builder.query(&[("apply_project_rules_for", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cs {
        local_var_req_builder = local_var_req_builder.query(&[("cs", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = csa {
        local_var_req_builder = local_var_req_builder.query(&[("csa", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = csi {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("csi".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("csi", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = geoprivacy {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("geoprivacy".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("geoprivacy", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_geoprivacy {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_geoprivacy".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_geoprivacy", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = hrank {
        local_var_req_builder = local_var_req_builder.query(&[("hrank", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lrank {
        local_var_req_builder = local_var_req_builder.query(&[("lrank", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = iconic_taxa {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("iconic_taxa".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("iconic_taxa", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = id_above {
        local_var_req_builder = local_var_req_builder.query(&[("id_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_below {
        local_var_req_builder = local_var_req_builder.query(&[("id_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = identifications {
        local_var_req_builder = local_var_req_builder.query(&[("identifications", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lat {
        local_var_req_builder = local_var_req_builder.query(&[("lat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lng {
        local_var_req_builder = local_var_req_builder.query(&[("lng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = radius {
        local_var_req_builder = local_var_req_builder.query(&[("radius", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = nelat {
        local_var_req_builder = local_var_req_builder.query(&[("nelat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = nelng {
        local_var_req_builder = local_var_req_builder.query(&[("nelng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = swlat {
        local_var_req_builder = local_var_req_builder.query(&[("swlat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = swlng {
        local_var_req_builder = local_var_req_builder.query(&[("swlng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = list_id {
        local_var_req_builder = local_var_req_builder.query(&[("list_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = not_in_project {
        local_var_req_builder = local_var_req_builder.query(&[("not_in_project", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = not_matching_project_rules_for {
        local_var_req_builder = local_var_req_builder.query(&[("not_matching_project_rules_for", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = q {
        local_var_req_builder = local_var_req_builder.query(&[("q", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = search_on {
        local_var_req_builder = local_var_req_builder.query(&[("search_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = quality_grade {
        local_var_req_builder = local_var_req_builder.query(&[("quality_grade", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = updated_since {
        local_var_req_builder = local_var_req_builder.query(&[("updated_since", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = viewer_id {
        local_var_req_builder = local_var_req_builder.query(&[("viewer_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = reviewed {
        local_var_req_builder = local_var_req_builder.query(&[("reviewed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<HeatmapZoomXyGridJsonGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Given zero to many of following parameters, returns a JSON file following the UTFGrid spec, representing observations matching the search criteria 
pub async fn points_zoom_xy_grid_json_get(configuration: &configuration::Configuration, params: PointsZoomXyGridJsonGetParams) -> Result<crate::models::UtfGridResponse, Error<PointsZoomXyGridJsonGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let zoom = params.zoom;
    let x = params.x;
    let y = params.y;
    let color = params.color;
    let acc = params.acc;
    let captive = params.captive;
    let endemic = params.endemic;
    let geo = params.geo;
    let id_please = params.id_please;
    let identified = params.identified;
    let introduced = params.introduced;
    let mappable = params.mappable;
    let native = params.native;
    let out_of_range = params.out_of_range;
    let pcid = params.pcid;
    let photos = params.photos;
    let popular = params.popular;
    let sounds = params.sounds;
    let taxon_is_active = params.taxon_is_active;
    let threatened = params.threatened;
    let verifiable = params.verifiable;
    let licensed = params.licensed;
    let photo_licensed = params.photo_licensed;
    let id = params.id;
    let not_id = params.not_id;
    let license = params.license;
    let ofv_datatype = params.ofv_datatype;
    let photo_license = params.photo_license;
    let place_id = params.place_id;
    let project_id = params.project_id;
    let rank = params.rank;
    let site_id = params.site_id;
    let sound_license = params.sound_license;
    let taxon_id = params.taxon_id;
    let without_taxon_id = params.without_taxon_id;
    let taxon_name = params.taxon_name;
    let user_id = params.user_id;
    let user_login = params.user_login;
    let ident_user_id = params.ident_user_id;
    let day = params.day;
    let month = params.month;
    let year = params.year;
    let term_id = params.term_id;
    let term_value_id = params.term_value_id;
    let without_term_value_id = params.without_term_value_id;
    let acc_above = params.acc_above;
    let acc_below = params.acc_below;
    let acc_below_or_unknown = params.acc_below_or_unknown;
    let d1 = params.d1;
    let d2 = params.d2;
    let created_d1 = params.created_d1;
    let created_d2 = params.created_d2;
    let created_on = params.created_on;
    let observed_on = params.observed_on;
    let unobserved_by_user_id = params.unobserved_by_user_id;
    let apply_project_rules_for = params.apply_project_rules_for;
    let cs = params.cs;
    let csa = params.csa;
    let csi = params.csi;
    let geoprivacy = params.geoprivacy;
    let taxon_geoprivacy = params.taxon_geoprivacy;
    let hrank = params.hrank;
    let lrank = params.lrank;
    let iconic_taxa = params.iconic_taxa;
    let id_above = params.id_above;
    let id_below = params.id_below;
    let identifications = params.identifications;
    let lat = params.lat;
    let lng = params.lng;
    let radius = params.radius;
    let nelat = params.nelat;
    let nelng = params.nelng;
    let swlat = params.swlat;
    let swlng = params.swlng;
    let list_id = params.list_id;
    let not_in_project = params.not_in_project;
    let not_matching_project_rules_for = params.not_matching_project_rules_for;
    let q = params.q;
    let search_on = params.search_on;
    let quality_grade = params.quality_grade;
    let updated_since = params.updated_since;
    let viewer_id = params.viewer_id;
    let reviewed = params.reviewed;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/points/{zoom}/{x}/{y}.grid.json", local_var_configuration.base_path, zoom=zoom, x=x, y=y);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = color {
        local_var_req_builder = local_var_req_builder.query(&[("color", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc {
        local_var_req_builder = local_var_req_builder.query(&[("acc", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = captive {
        local_var_req_builder = local_var_req_builder.query(&[("captive", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = endemic {
        local_var_req_builder = local_var_req_builder.query(&[("endemic", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = geo {
        local_var_req_builder = local_var_req_builder.query(&[("geo", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_please {
        local_var_req_builder = local_var_req_builder.query(&[("id_please", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = identified {
        local_var_req_builder = local_var_req_builder.query(&[("identified", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = introduced {
        local_var_req_builder = local_var_req_builder.query(&[("introduced", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = mappable {
        local_var_req_builder = local_var_req_builder.query(&[("mappable", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = native {
        local_var_req_builder = local_var_req_builder.query(&[("native", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = out_of_range {
        local_var_req_builder = local_var_req_builder.query(&[("out_of_range", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = pcid {
        local_var_req_builder = local_var_req_builder.query(&[("pcid", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = photos {
        local_var_req_builder = local_var_req_builder.query(&[("photos", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = popular {
        local_var_req_builder = local_var_req_builder.query(&[("popular", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = sounds {
        local_var_req_builder = local_var_req_builder.query(&[("sounds", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = taxon_is_active {
        local_var_req_builder = local_var_req_builder.query(&[("taxon_is_active", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = threatened {
        local_var_req_builder = local_var_req_builder.query(&[("threatened", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = verifiable {
        local_var_req_builder = local_var_req_builder.query(&[("verifiable", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = licensed {
        local_var_req_builder = local_var_req_builder.query(&[("licensed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = photo_licensed {
        local_var_req_builder = local_var_req_builder.query(&[("photo_licensed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = not_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("not_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("not_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = ofv_datatype {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("ofv_datatype".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("ofv_datatype", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = photo_license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("photo_license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("photo_license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = place_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("place_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("place_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = project_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("project_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("project_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = rank {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("rank".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("rank", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = site_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("site_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("site_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = sound_license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("sound_license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("sound_license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = without_taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("without_taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("without_taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_name {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_name".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_name", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = user_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("user_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("user_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = user_login {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("user_login".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("user_login", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = ident_user_id {
        local_var_req_builder = local_var_req_builder.query(&[("ident_user_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = day {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("day".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("day", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = month {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("month".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("month", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = year {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("year".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("year", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = term_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("term_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("term_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = term_value_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("term_value_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("term_value_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = without_term_value_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("without_term_value_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("without_term_value_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = acc_above {
        local_var_req_builder = local_var_req_builder.query(&[("acc_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc_below {
        local_var_req_builder = local_var_req_builder.query(&[("acc_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc_below_or_unknown {
        local_var_req_builder = local_var_req_builder.query(&[("acc_below_or_unknown", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = d1 {
        local_var_req_builder = local_var_req_builder.query(&[("d1", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = d2 {
        local_var_req_builder = local_var_req_builder.query(&[("d2", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_d1 {
        local_var_req_builder = local_var_req_builder.query(&[("created_d1", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_d2 {
        local_var_req_builder = local_var_req_builder.query(&[("created_d2", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_on {
        local_var_req_builder = local_var_req_builder.query(&[("created_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = observed_on {
        local_var_req_builder = local_var_req_builder.query(&[("observed_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = unobserved_by_user_id {
        local_var_req_builder = local_var_req_builder.query(&[("unobserved_by_user_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = apply_project_rules_for {
        local_var_req_builder = local_var_req_builder.query(&[("apply_project_rules_for", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cs {
        local_var_req_builder = local_var_req_builder.query(&[("cs", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = csa {
        local_var_req_builder = local_var_req_builder.query(&[("csa", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = csi {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("csi".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("csi", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = geoprivacy {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("geoprivacy".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("geoprivacy", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_geoprivacy {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_geoprivacy".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_geoprivacy", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = hrank {
        local_var_req_builder = local_var_req_builder.query(&[("hrank", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lrank {
        local_var_req_builder = local_var_req_builder.query(&[("lrank", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = iconic_taxa {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("iconic_taxa".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("iconic_taxa", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = id_above {
        local_var_req_builder = local_var_req_builder.query(&[("id_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_below {
        local_var_req_builder = local_var_req_builder.query(&[("id_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = identifications {
        local_var_req_builder = local_var_req_builder.query(&[("identifications", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lat {
        local_var_req_builder = local_var_req_builder.query(&[("lat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lng {
        local_var_req_builder = local_var_req_builder.query(&[("lng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = radius {
        local_var_req_builder = local_var_req_builder.query(&[("radius", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = nelat {
        local_var_req_builder = local_var_req_builder.query(&[("nelat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = nelng {
        local_var_req_builder = local_var_req_builder.query(&[("nelng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = swlat {
        local_var_req_builder = local_var_req_builder.query(&[("swlat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = swlng {
        local_var_req_builder = local_var_req_builder.query(&[("swlng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = list_id {
        local_var_req_builder = local_var_req_builder.query(&[("list_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = not_in_project {
        local_var_req_builder = local_var_req_builder.query(&[("not_in_project", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = not_matching_project_rules_for {
        local_var_req_builder = local_var_req_builder.query(&[("not_matching_project_rules_for", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = q {
        local_var_req_builder = local_var_req_builder.query(&[("q", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = search_on {
        local_var_req_builder = local_var_req_builder.query(&[("search_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = quality_grade {
        local_var_req_builder = local_var_req_builder.query(&[("quality_grade", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = updated_since {
        local_var_req_builder = local_var_req_builder.query(&[("updated_since", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = viewer_id {
        local_var_req_builder = local_var_req_builder.query(&[("viewer_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = reviewed {
        local_var_req_builder = local_var_req_builder.query(&[("reviewed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<PointsZoomXyGridJsonGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

