/*
 * iNaturalist API
 *
 * # https://api.inaturalist.org/v1/  [iNaturalist](https://www.inaturalist.org/) is a global community of naturalists, scientists, and members of the public sharing over a million wildlife sightings to teach one another about the natural world while creating high quality citizen science data for science and conservation. The iNaturalist technology infrastructure and open source software is administered by the [California Academy of Sciences](https://www.calacademy.org/) as part of their mission to explore, explain, and sustain life on Earth.  These API methods return data in JSON/JSONP and PNG response formats. They are meant to supplement the existing [iNaturalist API](https://www.inaturalist.org/pages/api+reference), implemented in Ruby on Rails, which has more functionality and supports more write operations, but tends to be slower and have less consistent response formats. Visit our [developers page](https://www.inaturalist.org/pages/developers) for more information. Write operations that expect and return JSON describe a single `body` parameter that represents the request body, which should be specified as JSON. See the \"Model\" of each body parameter for attributes that we accept in these JSON objects.  Multiple values for a single URL parameter should be separated by commas, e.g. `taxon_id=1,2,3`.  Map tiles are generated using the [node-mapnik](https://github.com/mapnik/node-mapnik) library, following the XYZ map tiling scheme. The \"Observation Tile\" methods accept nearly all the parameters of the observation search APIs, and will generate map tiles reflecting the same observations returned by searches. These \"Observation Tile\" methods have corresponding [UTFGrid](https://github.com/mapbox/utfgrid-spec) JSON responses which return information needed to make interactive maps.  Authentication in the Node API is handled via JSON Web Tokens (JWT). To obtain one, make an [OAuth-authenticated request](http://www.inaturalist.org/pages/api+reference#auth) to https://www.inaturalist.org/users/api_token. Each JWT will expire after 24 hours. Authentication required for all PUT and POST requests. Some GET requests will also include private information like hidden coordinates if the authenticated user has permission to view them.  iNaturalist Website: https://www.inaturalist.org/  Open Source Software: https://github.com/inaturalist/  ## Terms of Use  Use of this API is subject to the iNaturalist [Terms of Service](https://www.inaturalist.org/terms) and [Privacy Policy](https://www.inaturalist.org/privacy). We will block any use of our API that violates our Terms or Privacy Policy without notice. The API is intended to support application development, not data scraping. For pre- generated data exports, see https://www.inaturalist.org/pages/developers.  Please note that we throttle API usage to a max of 100 requests per minute, though we ask that you try to keep it to 60 requests per minute or lower, and to keep under 10,000 requests per day. If we notice usage that has serious impact on our performance we may institute blocks without notification.  Terms of Service: https://www.inaturalist.org/terms  Privacy Policy: https://www.inaturalist.org/privacy 
 *
 * The version of the OpenAPI document: 1.3.0
 * 
 * Generated by: https://openapi-generator.tech
 */


use reqwest;

use crate::apis::ResponseContent;
use super::{Error, configuration};

/// struct for passing parameters to the method [`taxa_autocomplete_get`]
#[derive(Clone, Debug, Default)]
pub struct TaxaAutocompleteGetParams {
    /// Name must begin with this value
    pub q: String,
    /// Taxon is `active`
    pub is_active: Option<bool>,
    /// Only show taxa with this ID, or its descendants
    pub taxon_id: Option<Vec<String>>,
    /// Taxon must have this rank
    pub rank: Option<Vec<String>>,
    /// Taxon must have this rank level. Some example values are 70 (kingdom), 60 (phylum), 50 (class), 40 (order), 30 (family), 20 (genus), 10 (species), 5 (subspecies) 
    pub rank_level: Option<i32>,
    /// Number of results to return in a `page`. The maximum value is 30 for this endpoint
    pub per_page: Option<String>,
    /// Locale preference for taxon common names 
    pub locale: Option<String>,
    /// Place preference for regional taxon common names 
    pub preferred_place_id: Option<i32>,
    /// Include all taxon names in the response
    pub all_names: Option<bool>
}

/// struct for passing parameters to the method [`taxa_get`]
#[derive(Clone, Debug, Default)]
pub struct TaxaGetParams {
    /// Name must begin with this value
    pub q: Option<String>,
    /// Taxon is `active`
    pub is_active: Option<bool>,
    /// Only show taxa with this ID, or its descendants
    pub taxon_id: Option<Vec<String>>,
    /// Taxon's parent must have this ID
    pub parent_id: Option<i32>,
    /// Taxon must have this rank
    pub rank: Option<Vec<String>>,
    /// Taxon must have this rank level. Some example values are 70 (kingdom), 60 (phylum), 50 (class), 40 (order), 30 (family), 20 (genus), 10 (species), 5 (subspecies) 
    pub rank_level: Option<i32>,
    /// Must have an ID above this value
    pub id_above: Option<String>,
    /// Must have an ID below this value
    pub id_below: Option<String>,
    /// Number of results to return in a `page`. The maximum value is generally 200 unless otherwise noted 
    pub per_page: Option<String>,
    /// Locale preference for taxon common names 
    pub locale: Option<String>,
    /// Place preference for regional taxon common names 
    pub preferred_place_id: Option<i32>,
    /// Return only the record IDs
    pub only_id: Option<bool>,
    /// Include all taxon names in the response
    pub all_names: Option<bool>
}

/// struct for passing parameters to the method [`taxa_id_get`]
#[derive(Clone, Debug, Default)]
pub struct TaxaIdGetParams {
    /// Must have this ID
    pub id: Vec<i32>
}


/// struct for typed errors of method [`taxa_autocomplete_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum TaxaAutocompleteGetError {
    DefaultResponse(crate::models::Error),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`taxa_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum TaxaGetError {
    DefaultResponse(crate::models::Error),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`taxa_id_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum TaxaIdGetError {
    DefaultResponse(crate::models::Error),
    UnknownValue(serde_json::Value),
}


/// Given an string, returns taxa with names starting with the search term 
pub async fn taxa_autocomplete_get(configuration: &configuration::Configuration, params: TaxaAutocompleteGetParams) -> Result<crate::models::TaxaAutocompleteResponse, Error<TaxaAutocompleteGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let q = params.q;
    let is_active = params.is_active;
    let taxon_id = params.taxon_id;
    let rank = params.rank;
    let rank_level = params.rank_level;
    let per_page = params.per_page;
    let locale = params.locale;
    let preferred_place_id = params.preferred_place_id;
    let all_names = params.all_names;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/taxa/autocomplete", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("q", &q.to_string())]);
    if let Some(ref local_var_str) = is_active {
        local_var_req_builder = local_var_req_builder.query(&[("is_active", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = rank {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("rank".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("rank", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = rank_level {
        local_var_req_builder = local_var_req_builder.query(&[("rank_level", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = per_page {
        local_var_req_builder = local_var_req_builder.query(&[("per_page", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = locale {
        local_var_req_builder = local_var_req_builder.query(&[("locale", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = preferred_place_id {
        local_var_req_builder = local_var_req_builder.query(&[("preferred_place_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = all_names {
        local_var_req_builder = local_var_req_builder.query(&[("all_names", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<TaxaAutocompleteGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Given zero to many of following parameters, returns taxa matching the search criteria 
pub async fn taxa_get(configuration: &configuration::Configuration, params: TaxaGetParams) -> Result<crate::models::TaxaShowResponse, Error<TaxaGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let q = params.q;
    let is_active = params.is_active;
    let taxon_id = params.taxon_id;
    let parent_id = params.parent_id;
    let rank = params.rank;
    let rank_level = params.rank_level;
    let id_above = params.id_above;
    let id_below = params.id_below;
    let per_page = params.per_page;
    let locale = params.locale;
    let preferred_place_id = params.preferred_place_id;
    let only_id = params.only_id;
    let all_names = params.all_names;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/taxa", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = q {
        local_var_req_builder = local_var_req_builder.query(&[("q", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = is_active {
        local_var_req_builder = local_var_req_builder.query(&[("is_active", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = parent_id {
        local_var_req_builder = local_var_req_builder.query(&[("parent_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = rank {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("rank".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("rank", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = rank_level {
        local_var_req_builder = local_var_req_builder.query(&[("rank_level", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_above {
        local_var_req_builder = local_var_req_builder.query(&[("id_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_below {
        local_var_req_builder = local_var_req_builder.query(&[("id_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = per_page {
        local_var_req_builder = local_var_req_builder.query(&[("per_page", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = locale {
        local_var_req_builder = local_var_req_builder.query(&[("locale", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = preferred_place_id {
        local_var_req_builder = local_var_req_builder.query(&[("preferred_place_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = only_id {
        local_var_req_builder = local_var_req_builder.query(&[("only_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = all_names {
        local_var_req_builder = local_var_req_builder.query(&[("all_names", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<TaxaGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Given an ID, or an array of IDs in comma-delimited format, returns corresponding taxa. A maximum of 30 results will be returned 
pub async fn taxa_id_get(configuration: &configuration::Configuration, params: TaxaIdGetParams) -> Result<crate::models::TaxaShowResponse, Error<TaxaIdGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/taxa/{id}", local_var_configuration.base_path, id=id.into_iter().map(|i| i.to_string()).collect::<Vec<_>>().join(","));
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<TaxaIdGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

