/*
 * iNaturalist API
 *
 * # https://api.inaturalist.org/v1/  [iNaturalist](https://www.inaturalist.org/) is a global community of naturalists, scientists, and members of the public sharing over a million wildlife sightings to teach one another about the natural world while creating high quality citizen science data for science and conservation. The iNaturalist technology infrastructure and open source software is administered by the [California Academy of Sciences](https://www.calacademy.org/) as part of their mission to explore, explain, and sustain life on Earth.  These API methods return data in JSON/JSONP and PNG response formats. They are meant to supplement the existing [iNaturalist API](https://www.inaturalist.org/pages/api+reference), implemented in Ruby on Rails, which has more functionality and supports more write operations, but tends to be slower and have less consistent response formats. Visit our [developers page](https://www.inaturalist.org/pages/developers) for more information. Write operations that expect and return JSON describe a single `body` parameter that represents the request body, which should be specified as JSON. See the \"Model\" of each body parameter for attributes that we accept in these JSON objects.  Multiple values for a single URL parameter should be separated by commas, e.g. `taxon_id=1,2,3`.  Map tiles are generated using the [node-mapnik](https://github.com/mapnik/node-mapnik) library, following the XYZ map tiling scheme. The \"Observation Tile\" methods accept nearly all the parameters of the observation search APIs, and will generate map tiles reflecting the same observations returned by searches. These \"Observation Tile\" methods have corresponding [UTFGrid](https://github.com/mapbox/utfgrid-spec) JSON responses which return information needed to make interactive maps.  Authentication in the Node API is handled via JSON Web Tokens (JWT). To obtain one, make an [OAuth-authenticated request](http://www.inaturalist.org/pages/api+reference#auth) to https://www.inaturalist.org/users/api_token. Each JWT will expire after 24 hours. Authentication required for all PUT and POST requests. Some GET requests will also include private information like hidden coordinates if the authenticated user has permission to view them.  iNaturalist Website: https://www.inaturalist.org/  Open Source Software: https://github.com/inaturalist/  ## Terms of Use  Use of this API is subject to the iNaturalist [Terms of Service](https://www.inaturalist.org/terms) and [Privacy Policy](https://www.inaturalist.org/privacy). We will block any use of our API that violates our Terms or Privacy Policy without notice. The API is intended to support application development, not data scraping. For pre- generated data exports, see https://www.inaturalist.org/pages/developers.  Please note that we throttle API usage to a max of 100 requests per minute, though we ask that you try to keep it to 60 requests per minute or lower, and to keep under 10,000 requests per day. If we notice usage that has serious impact on our performance we may institute blocks without notification.  Terms of Service: https://www.inaturalist.org/terms  Privacy Policy: https://www.inaturalist.org/privacy 
 *
 * The version of the OpenAPI document: 1.3.0
 * 
 * Generated by: https://openapi-generator.tech
 */


use reqwest;

use crate::apis::ResponseContent;
use super::{Error, configuration};

/// struct for passing parameters to the method [`places_autocomplete_get`]
#[derive(Clone, Debug, Default)]
pub struct PlacesAutocompleteGetParams {
    /// Name must begin with this value
    pub q: String,
    /// Sort field
    pub order_by: Option<String>
}

/// struct for passing parameters to the method [`places_id_get`]
#[derive(Clone, Debug, Default)]
pub struct PlacesIdGetParams {
    /// Must have this ID or slug
    pub id: Vec<String>,
    /// Admin level of a place, or an array of admin levels in comma-delimited format. Supported admin levels are: -1 (continent), 0 (country), 1 (state), 2 (county), 3 (town), 10 (park)
    pub admin_level: Option<Vec<i32>>
}

/// struct for passing parameters to the method [`places_nearby_get`]
#[derive(Clone, Debug, Default)]
pub struct PlacesNearbyGetParams {
    /// Must be nearby this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelat: f64,
    /// Must be nearby this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelng: f64,
    /// Must be nearby this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlat: f64,
    /// Must be nearby this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlng: f64,
    /// Name must match this value
    pub name: Option<String>,
    /// Number of results to return in a `page`. The maximum value is generally 200 unless otherwise noted 
    pub per_page: Option<String>
}


/// struct for typed errors of method [`places_autocomplete_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PlacesAutocompleteGetError {
    DefaultResponse(crate::models::Error),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`places_id_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PlacesIdGetError {
    DefaultResponse(crate::models::Error),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`places_nearby_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PlacesNearbyGetError {
    DefaultResponse(crate::models::Error),
    UnknownValue(serde_json::Value),
}


/// Given an string, returns places with names starting with the search term. 
pub async fn places_autocomplete_get(configuration: &configuration::Configuration, params: PlacesAutocompleteGetParams) -> Result<crate::models::PlacesResponse, Error<PlacesAutocompleteGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let q = params.q;
    let order_by = params.order_by;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/places/autocomplete", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("q", &q.to_string())]);
    if let Some(ref local_var_str) = order_by {
        local_var_req_builder = local_var_req_builder.query(&[("order_by", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<PlacesAutocompleteGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Given an ID, or an array of IDs in comma-delimited format, returns corresponding places. A maximum of 500 results will be returned 
pub async fn places_id_get(configuration: &configuration::Configuration, params: PlacesIdGetParams) -> Result<crate::models::PlacesResponse, Error<PlacesIdGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let admin_level = params.admin_level;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/places/{id}", local_var_configuration.base_path, id=id.into_iter().map(|i| i.to_string()).collect::<Vec<_>>().join(","));
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = admin_level {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("admin_level".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("admin_level", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<PlacesIdGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Given an bounding box, and an optional name query, return `standard` iNaturalist curator approved and `community` non-curated places nearby 
pub async fn places_nearby_get(configuration: &configuration::Configuration, params: PlacesNearbyGetParams) -> Result<crate::models::NearbyPlacesResponse, Error<PlacesNearbyGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let nelat = params.nelat;
    let nelng = params.nelng;
    let swlat = params.swlat;
    let swlng = params.swlng;
    let name = params.name;
    let per_page = params.per_page;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/places/nearby", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("nelat", &nelat.to_string())]);
    local_var_req_builder = local_var_req_builder.query(&[("nelng", &nelng.to_string())]);
    local_var_req_builder = local_var_req_builder.query(&[("swlat", &swlat.to_string())]);
    local_var_req_builder = local_var_req_builder.query(&[("swlng", &swlng.to_string())]);
    if let Some(ref local_var_str) = name {
        local_var_req_builder = local_var_req_builder.query(&[("name", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = per_page {
        local_var_req_builder = local_var_req_builder.query(&[("per_page", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<PlacesNearbyGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

