/*
 * iNaturalist API
 *
 * # https://api.inaturalist.org/v1/  [iNaturalist](https://www.inaturalist.org/) is a global community of naturalists, scientists, and members of the public sharing over a million wildlife sightings to teach one another about the natural world while creating high quality citizen science data for science and conservation. The iNaturalist technology infrastructure and open source software is administered by the [California Academy of Sciences](https://www.calacademy.org/) as part of their mission to explore, explain, and sustain life on Earth.  These API methods return data in JSON/JSONP and PNG response formats. They are meant to supplement the existing [iNaturalist API](https://www.inaturalist.org/pages/api+reference), implemented in Ruby on Rails, which has more functionality and supports more write operations, but tends to be slower and have less consistent response formats. Visit our [developers page](https://www.inaturalist.org/pages/developers) for more information. Write operations that expect and return JSON describe a single `body` parameter that represents the request body, which should be specified as JSON. See the \"Model\" of each body parameter for attributes that we accept in these JSON objects.  Multiple values for a single URL parameter should be separated by commas, e.g. `taxon_id=1,2,3`.  Map tiles are generated using the [node-mapnik](https://github.com/mapnik/node-mapnik) library, following the XYZ map tiling scheme. The \"Observation Tile\" methods accept nearly all the parameters of the observation search APIs, and will generate map tiles reflecting the same observations returned by searches. These \"Observation Tile\" methods have corresponding [UTFGrid](https://github.com/mapbox/utfgrid-spec) JSON responses which return information needed to make interactive maps.  Authentication in the Node API is handled via JSON Web Tokens (JWT). To obtain one, make an [OAuth-authenticated request](http://www.inaturalist.org/pages/api+reference#auth) to https://www.inaturalist.org/users/api_token. Each JWT will expire after 24 hours. Authentication required for all PUT and POST requests. Some GET requests will also include private information like hidden coordinates if the authenticated user has permission to view them.  iNaturalist Website: https://www.inaturalist.org/  Open Source Software: https://github.com/inaturalist/  ## Terms of Use  Use of this API is subject to the iNaturalist [Terms of Service](https://www.inaturalist.org/terms) and [Privacy Policy](https://www.inaturalist.org/privacy). We will block any use of our API that violates our Terms or Privacy Policy without notice. The API is intended to support application development, not data scraping. For pre- generated data exports, see https://www.inaturalist.org/pages/developers.  Please note that we throttle API usage to a max of 100 requests per minute, though we ask that you try to keep it to 60 requests per minute or lower, and to keep under 10,000 requests per day. If we notice usage that has serious impact on our performance we may institute blocks without notification.  Terms of Service: https://www.inaturalist.org/terms  Privacy Policy: https://www.inaturalist.org/privacy 
 *
 * The version of the OpenAPI document: 1.3.0
 * 
 * Generated by: https://openapi-generator.tech
 */


use reqwest;

use crate::apis::ResponseContent;
use super::{Error, configuration};

/// struct for passing parameters to the method [`observations_deleted_get`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsDeletedGetParams {
    /// Deleted at or after this time
    pub since: String
}

/// struct for passing parameters to the method [`observations_get`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsGetParams {
    /// Whether or not positional accuracy / coordinate uncertainty has been specified
    pub acc: Option<bool>,
    /// Captive or cultivated observations
    pub captive: Option<bool>,
    /// Observations whose taxa are endemic to their location
    pub endemic: Option<bool>,
    /// Observations that are georeferenced
    pub geo: Option<bool>,
    /// Observations with the deprecated `ID, Please!` flag. Note that this will return observations, but that this attribute is no longer used.
    pub id_please: Option<bool>,
    /// Observations that have community identifications
    pub identified: Option<bool>,
    /// Observations whose taxa are introduced in their location 
    pub introduced: Option<bool>,
    /// Observations that show on map tiles
    pub mappable: Option<bool>,
    /// Observations whose taxa are native to their location
    pub native: Option<bool>,
    /// Observations whose taxa are outside their known ranges
    pub out_of_range: Option<bool>,
    /// Observations identified by the curator of a project. If the `project_id` parameter is also specified, this will only consider observations identified by curators of the specified project(s) 
    pub pcid: Option<bool>,
    /// Observations with photos
    pub photos: Option<bool>,
    /// Observations that have been favorited by at least one user 
    pub popular: Option<bool>,
    /// Observations with sounds
    pub sounds: Option<bool>,
    /// Observations of active taxon concepts 
    pub taxon_is_active: Option<bool>,
    /// Observations whose taxa are threatened in their location 
    pub threatened: Option<bool>,
    /// Observations with a `quality_grade` of either `needs_id` or `research`. Equivalent to `quality_grade=needs_id,research` 
    pub verifiable: Option<bool>,
    /// License attribute of an observation must not be null
    pub licensed: Option<bool>,
    /// License attribute of at least one photo of an observation must not be null
    pub photo_licensed: Option<bool>,
    /// Must have this ID
    pub id: Option<Vec<String>>,
    /// Must not have this ID
    pub not_id: Option<Vec<String>>,
    /// Observation must have this license
    pub license: Option<Vec<String>>,
    /// Must have an observation field value with this datatype
    pub ofv_datatype: Option<Vec<String>>,
    /// Must have at least one photo with this license
    pub photo_license: Option<Vec<String>>,
    /// Must be observed within the place with this ID
    pub place_id: Option<Vec<i32>>,
    /// Must be added to the project this ID or slug
    pub project_id: Option<Vec<String>>,
    /// Taxon must have this rank
    pub rank: Option<Vec<String>>,
    /// Must be affiliated with the iNaturalist network website with this ID 
    pub site_id: Option<Vec<String>>,
    /// Must have at least one sound with this license
    pub sound_license: Option<Vec<String>>,
    /// Only show observations of these taxa and their descendants
    pub taxon_id: Option<Vec<String>>,
    /// Exclude observations of these taxa and their descendants
    pub without_taxon_id: Option<Vec<String>>,
    /// Taxon must have a scientific or common name matching this string 
    pub taxon_name: Option<Vec<String>>,
    /// User must have this ID or login
    pub user_id: Option<Vec<String>>,
    /// User must have this login
    pub user_login: Option<Vec<String>>,
    /// Observations identified by a particular user
    pub ident_user_id: Option<i32>,
    /// Must be observed within this day of the month
    pub day: Option<Vec<String>>,
    /// Must be observed within this month
    pub month: Option<Vec<String>>,
    /// Must be observed within this year
    pub year: Option<Vec<String>>,
    /// Must have an annotation using this controlled term ID
    pub term_id: Option<Vec<i32>>,
    /// Must have an annotation using this controlled value ID. Must be combined with the `term_id` parameter 
    pub term_value_id: Option<Vec<i32>>,
    /// Exclude observations with annotations using this controlled value ID. Must be combined with the `term_id` parameter 
    pub without_term_value_id: Option<Vec<i32>>,
    /// Must have a positional accuracy above this value (meters)
    pub acc_above: Option<String>,
    /// Must have a positional accuracy below this value (meters)
    pub acc_below: Option<String>,
    /// Positional accuracy must be below this value (in meters) or be unknown
    pub acc_below_or_unknown: Option<String>,
    /// Must be observed on or after this date
    pub d1: Option<String>,
    /// Must be observed on or before this date
    pub d2: Option<String>,
    /// Must be created at or after this time
    pub created_d1: Option<String>,
    /// Must be created at or before this time
    pub created_d2: Option<String>,
    /// Must be created on this date
    pub created_on: Option<String>,
    /// Must be observed on this date
    pub observed_on: Option<String>,
    /// Must not be of a taxon previously observed by this user
    pub unobserved_by_user_id: Option<i32>,
    /// Must match the rules of the project with this ID or slug
    pub apply_project_rules_for: Option<String>,
    /// Taxon must have this conservation status code. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub cs: Option<String>,
    /// Taxon must have a conservation status from this authority. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub csa: Option<String>,
    /// Taxon must have this IUCN conservation status. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub csi: Option<Vec<String>>,
    /// Must have this geoprivacy setting
    pub geoprivacy: Option<Vec<String>>,
    /// Filter observations by the most conservative geoprivacy applied by a conservation status associated with one of the taxa proposed in the current identifications. 
    pub taxon_geoprivacy: Option<Vec<String>>,
    /// Taxon must have this rank or lower
    pub hrank: Option<String>,
    /// Taxon must have this rank or higher
    pub lrank: Option<String>,
    /// Taxon must by within this iconic taxon
    pub iconic_taxa: Option<Vec<String>>,
    /// Must have an ID above this value
    pub id_above: Option<String>,
    /// Must have an ID below this value
    pub id_below: Option<String>,
    /// Identifications must meet these criteria
    pub identifications: Option<String>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub lat: Option<f64>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub lng: Option<f64>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub radius: Option<String>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelat: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelng: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlat: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlng: Option<f64>,
    /// Taxon must be in the list with this ID
    pub list_id: Option<i32>,
    /// Must not be in the project with this ID or slug
    pub not_in_project: Option<String>,
    /// Must not match the rules of the project with this ID or slug
    pub not_matching_project_rules_for: Option<String>,
    /// Search observation properties. Can be combined with `search_on`
    pub q: Option<String>,
    /// Properties to search on, when combined with `q`. Searches across all properties by default 
    pub search_on: Option<String>,
    /// Must have this quality grade
    pub quality_grade: Option<String>,
    /// Must be updated since this time
    pub updated_since: Option<String>,
    /// See `reviewed`
    pub viewer_id: Option<String>,
    /// Observations have been reviewed by the user with ID equal to the value of the `viewer_id` parameter 
    pub reviewed: Option<bool>,
    /// Locale preference for taxon common names 
    pub locale: Option<String>,
    /// Place preference for regional taxon common names 
    pub preferred_place_id: Option<i32>,
    /// Set the `Cache-Control` HTTP header with this value as `max-age`, in seconds. This means subsequent identical requests will be cached on iNaturalist servers, and commonly within web browsers 
    pub ttl: Option<String>,
    /// Pagination `page` number
    pub page: Option<String>,
    /// Number of results to return in a `page`. The maximum value is generally 200 unless otherwise noted 
    pub per_page: Option<String>,
    /// Sort order
    pub order: Option<String>,
    /// Sort field
    pub order_by: Option<String>,
    /// Return only the record IDs
    pub only_id: Option<bool>
}

/// struct for passing parameters to the method [`observations_histogram_get`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsHistogramGetParams {
    /// Whether or not positional accuracy / coordinate uncertainty has been specified
    pub acc: Option<bool>,
    /// Captive or cultivated observations
    pub captive: Option<bool>,
    /// Observations whose taxa are endemic to their location
    pub endemic: Option<bool>,
    /// Observations that are georeferenced
    pub geo: Option<bool>,
    /// Observations with the deprecated `ID, Please!` flag. Note that this will return observations, but that this attribute is no longer used.
    pub id_please: Option<bool>,
    /// Observations that have community identifications
    pub identified: Option<bool>,
    /// Observations whose taxa are introduced in their location 
    pub introduced: Option<bool>,
    /// Observations that show on map tiles
    pub mappable: Option<bool>,
    /// Observations whose taxa are native to their location
    pub native: Option<bool>,
    /// Observations whose taxa are outside their known ranges
    pub out_of_range: Option<bool>,
    /// Observations identified by the curator of a project. If the `project_id` parameter is also specified, this will only consider observations identified by curators of the specified project(s) 
    pub pcid: Option<bool>,
    /// Observations with photos
    pub photos: Option<bool>,
    /// Observations that have been favorited by at least one user 
    pub popular: Option<bool>,
    /// Observations with sounds
    pub sounds: Option<bool>,
    /// Observations of active taxon concepts 
    pub taxon_is_active: Option<bool>,
    /// Observations whose taxa are threatened in their location 
    pub threatened: Option<bool>,
    /// Observations with a `quality_grade` of either `needs_id` or `research`. Equivalent to `quality_grade=needs_id,research` 
    pub verifiable: Option<bool>,
    /// License attribute of an observation must not be null
    pub licensed: Option<bool>,
    /// License attribute of at least one photo of an observation must not be null
    pub photo_licensed: Option<bool>,
    /// Must have this ID
    pub id: Option<Vec<String>>,
    /// Must not have this ID
    pub not_id: Option<Vec<String>>,
    /// Observation must have this license
    pub license: Option<Vec<String>>,
    /// Must have an observation field value with this datatype
    pub ofv_datatype: Option<Vec<String>>,
    /// Must have at least one photo with this license
    pub photo_license: Option<Vec<String>>,
    /// Must be observed within the place with this ID
    pub place_id: Option<Vec<i32>>,
    /// Must be added to the project this ID or slug
    pub project_id: Option<Vec<String>>,
    /// Taxon must have this rank
    pub rank: Option<Vec<String>>,
    /// Must be affiliated with the iNaturalist network website with this ID 
    pub site_id: Option<Vec<String>>,
    /// Must have at least one sound with this license
    pub sound_license: Option<Vec<String>>,
    /// Only show observations of these taxa and their descendants
    pub taxon_id: Option<Vec<String>>,
    /// Exclude observations of these taxa and their descendants
    pub without_taxon_id: Option<Vec<String>>,
    /// Taxon must have a scientific or common name matching this string 
    pub taxon_name: Option<Vec<String>>,
    /// User must have this ID or login
    pub user_id: Option<Vec<String>>,
    /// User must have this login
    pub user_login: Option<Vec<String>>,
    /// Observations identified by a particular user
    pub ident_user_id: Option<i32>,
    /// Must be observed within this day of the month
    pub day: Option<Vec<String>>,
    /// Must be observed within this month
    pub month: Option<Vec<String>>,
    /// Must be observed within this year
    pub year: Option<Vec<String>>,
    /// Must have an annotation using this controlled term ID
    pub term_id: Option<Vec<i32>>,
    /// Must have an annotation using this controlled value ID. Must be combined with the `term_id` parameter 
    pub term_value_id: Option<Vec<i32>>,
    /// Exclude observations with annotations using this controlled value ID. Must be combined with the `term_id` parameter 
    pub without_term_value_id: Option<Vec<i32>>,
    /// Must have a positional accuracy above this value (meters)
    pub acc_above: Option<String>,
    /// Must have a positional accuracy below this value (meters)
    pub acc_below: Option<String>,
    /// Positional accuracy must be below this value (in meters) or be unknown
    pub acc_below_or_unknown: Option<String>,
    /// Must be observed on or after this date
    pub d1: Option<String>,
    /// Must be observed on or before this date
    pub d2: Option<String>,
    /// Must be created at or after this time
    pub created_d1: Option<String>,
    /// Must be created at or before this time
    pub created_d2: Option<String>,
    /// Must be created on this date
    pub created_on: Option<String>,
    /// Must be observed on this date
    pub observed_on: Option<String>,
    /// Must not be of a taxon previously observed by this user
    pub unobserved_by_user_id: Option<i32>,
    /// Must match the rules of the project with this ID or slug
    pub apply_project_rules_for: Option<String>,
    /// Taxon must have this conservation status code. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub cs: Option<String>,
    /// Taxon must have a conservation status from this authority. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub csa: Option<String>,
    /// Taxon must have this IUCN conservation status. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub csi: Option<Vec<String>>,
    /// Must have this geoprivacy setting
    pub geoprivacy: Option<Vec<String>>,
    /// Filter observations by the most conservative geoprivacy applied by a conservation status associated with one of the taxa proposed in the current identifications. 
    pub taxon_geoprivacy: Option<Vec<String>>,
    /// Taxon must have this rank or lower
    pub hrank: Option<String>,
    /// Taxon must have this rank or higher
    pub lrank: Option<String>,
    /// Taxon must by within this iconic taxon
    pub iconic_taxa: Option<Vec<String>>,
    /// Must have an ID above this value
    pub id_above: Option<String>,
    /// Must have an ID below this value
    pub id_below: Option<String>,
    /// Identifications must meet these criteria
    pub identifications: Option<String>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub lat: Option<f64>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub lng: Option<f64>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub radius: Option<String>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelat: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelng: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlat: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlng: Option<f64>,
    /// Taxon must be in the list with this ID
    pub list_id: Option<i32>,
    /// Must not be in the project with this ID or slug
    pub not_in_project: Option<String>,
    /// Must not match the rules of the project with this ID or slug
    pub not_matching_project_rules_for: Option<String>,
    /// Search observation properties. Can be combined with `search_on`
    pub q: Option<String>,
    /// Properties to search on, when combined with `q`. Searches across all properties by default 
    pub search_on: Option<String>,
    /// Must have this quality grade
    pub quality_grade: Option<String>,
    /// Must be updated since this time
    pub updated_since: Option<String>,
    /// See `reviewed`
    pub viewer_id: Option<String>,
    /// Observations have been reviewed by the user with ID equal to the value of the `viewer_id` parameter 
    pub reviewed: Option<bool>,
    /// Locale preference for taxon common names 
    pub locale: Option<String>,
    /// Place preference for regional taxon common names 
    pub preferred_place_id: Option<i32>,
    /// Set the `Cache-Control` HTTP header with this value as `max-age`, in seconds. This means subsequent identical requests will be cached on iNaturalist servers, and commonly within web browsers 
    pub ttl: Option<String>,
    /// Histogram basis: when the observation was created or observed 
    pub date_field: Option<String>,
    /// Time interval for histogram, with groups starting on or contained within the group value. The year, month, week, day, and hour options will set default values for `d1` or `created_d1` depending on the value of `date_field`, to limit the number of groups returned. You can override those values if you want data from a longer or shorter time span. The `hour` interval only works with `date_field=created`, and this you should filter dates with `created_d[1,2]` 
    pub interval: Option<String>
}

/// struct for passing parameters to the method [`observations_id_delete`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsIdDeleteParams {
    /// ID of the record
    pub id: i32
}

/// struct for passing parameters to the method [`observations_id_fave_post`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsIdFavePostParams {
    /// ID of the record
    pub id: i32
}

/// struct for passing parameters to the method [`observations_id_get`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsIdGetParams {
    /// Must have this ID
    pub id: Vec<i32>
}

/// struct for passing parameters to the method [`observations_id_put`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsIdPutParams {
    /// ID of the record
    pub id: i32,
    /// Comment object
    pub body: Option<crate::models::PostObservation>
}

/// struct for passing parameters to the method [`observations_id_quality_metric_delete`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsIdQualityMetricDeleteParams {
    /// ID of the record
    pub id: i32,
    /// Data quality category
    pub metric: String
}

/// struct for passing parameters to the method [`observations_id_quality_metric_post`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsIdQualityMetricPostParams {
    /// ID of the record
    pub id: i32,
    /// Data quality category
    pub metric: String,
    /// Quality object
    pub body: Option<crate::models::PostQuality>
}

/// struct for passing parameters to the method [`observations_id_review_post`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsIdReviewPostParams {
    /// ID of the record
    pub id: i32
}

/// struct for passing parameters to the method [`observations_id_subscriptions_get`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsIdSubscriptionsGetParams {
    /// ID of the record
    pub id: i32
}

/// struct for passing parameters to the method [`observations_id_taxon_summary_get`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsIdTaxonSummaryGetParams {
    /// ID of the record
    pub id: i32
}

/// struct for passing parameters to the method [`observations_id_unfave_delete`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsIdUnfaveDeleteParams {
    /// ID of the record
    pub id: i32
}

/// struct for passing parameters to the method [`observations_id_unreview_post`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsIdUnreviewPostParams {
    /// ID of the record
    pub id: i32
}

/// struct for passing parameters to the method [`observations_id_viewed_updates_put`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsIdViewedUpdatesPutParams {
    /// ID of the record
    pub id: i32
}

/// struct for passing parameters to the method [`observations_identifiers_get`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsIdentifiersGetParams {
    /// Whether or not positional accuracy / coordinate uncertainty has been specified
    pub acc: Option<bool>,
    /// Captive or cultivated observations
    pub captive: Option<bool>,
    /// Observations whose taxa are endemic to their location
    pub endemic: Option<bool>,
    /// Observations that are georeferenced
    pub geo: Option<bool>,
    /// Observations with the deprecated `ID, Please!` flag. Note that this will return observations, but that this attribute is no longer used.
    pub id_please: Option<bool>,
    /// Observations that have community identifications
    pub identified: Option<bool>,
    /// Observations whose taxa are introduced in their location 
    pub introduced: Option<bool>,
    /// Observations that show on map tiles
    pub mappable: Option<bool>,
    /// Observations whose taxa are native to their location
    pub native: Option<bool>,
    /// Observations whose taxa are outside their known ranges
    pub out_of_range: Option<bool>,
    /// Observations identified by the curator of a project. If the `project_id` parameter is also specified, this will only consider observations identified by curators of the specified project(s) 
    pub pcid: Option<bool>,
    /// Observations with photos
    pub photos: Option<bool>,
    /// Observations that have been favorited by at least one user 
    pub popular: Option<bool>,
    /// Observations with sounds
    pub sounds: Option<bool>,
    /// Observations of active taxon concepts 
    pub taxon_is_active: Option<bool>,
    /// Observations whose taxa are threatened in their location 
    pub threatened: Option<bool>,
    /// Observations with a `quality_grade` of either `needs_id` or `research`. Equivalent to `quality_grade=needs_id,research` 
    pub verifiable: Option<bool>,
    /// License attribute of an observation must not be null
    pub licensed: Option<bool>,
    /// License attribute of at least one photo of an observation must not be null
    pub photo_licensed: Option<bool>,
    /// Must have this ID
    pub id: Option<Vec<String>>,
    /// Must not have this ID
    pub not_id: Option<Vec<String>>,
    /// Observation must have this license
    pub license: Option<Vec<String>>,
    /// Must have an observation field value with this datatype
    pub ofv_datatype: Option<Vec<String>>,
    /// Must have at least one photo with this license
    pub photo_license: Option<Vec<String>>,
    /// Must be observed within the place with this ID
    pub place_id: Option<Vec<i32>>,
    /// Must be added to the project this ID or slug
    pub project_id: Option<Vec<String>>,
    /// Taxon must have this rank
    pub rank: Option<Vec<String>>,
    /// Must be affiliated with the iNaturalist network website with this ID 
    pub site_id: Option<Vec<String>>,
    /// Must have at least one sound with this license
    pub sound_license: Option<Vec<String>>,
    /// Only show observations of these taxa and their descendants
    pub taxon_id: Option<Vec<String>>,
    /// Exclude observations of these taxa and their descendants
    pub without_taxon_id: Option<Vec<String>>,
    /// Taxon must have a scientific or common name matching this string 
    pub taxon_name: Option<Vec<String>>,
    /// User must have this ID or login
    pub user_id: Option<Vec<String>>,
    /// User must have this login
    pub user_login: Option<Vec<String>>,
    /// Observations identified by a particular user
    pub ident_user_id: Option<i32>,
    /// Must be observed within this day of the month
    pub day: Option<Vec<String>>,
    /// Must be observed within this month
    pub month: Option<Vec<String>>,
    /// Must be observed within this year
    pub year: Option<Vec<String>>,
    /// Must have an annotation using this controlled term ID
    pub term_id: Option<Vec<i32>>,
    /// Must have an annotation using this controlled value ID. Must be combined with the `term_id` parameter 
    pub term_value_id: Option<Vec<i32>>,
    /// Exclude observations with annotations using this controlled value ID. Must be combined with the `term_id` parameter 
    pub without_term_value_id: Option<Vec<i32>>,
    /// Must have a positional accuracy above this value (meters)
    pub acc_above: Option<String>,
    /// Must have a positional accuracy below this value (meters)
    pub acc_below: Option<String>,
    /// Positional accuracy must be below this value (in meters) or be unknown
    pub acc_below_or_unknown: Option<String>,
    /// Must be observed on or after this date
    pub d1: Option<String>,
    /// Must be observed on or before this date
    pub d2: Option<String>,
    /// Must be created at or after this time
    pub created_d1: Option<String>,
    /// Must be created at or before this time
    pub created_d2: Option<String>,
    /// Must be created on this date
    pub created_on: Option<String>,
    /// Must be observed on this date
    pub observed_on: Option<String>,
    /// Must not be of a taxon previously observed by this user
    pub unobserved_by_user_id: Option<i32>,
    /// Must match the rules of the project with this ID or slug
    pub apply_project_rules_for: Option<String>,
    /// Taxon must have this conservation status code. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub cs: Option<String>,
    /// Taxon must have a conservation status from this authority. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub csa: Option<String>,
    /// Taxon must have this IUCN conservation status. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub csi: Option<Vec<String>>,
    /// Must have this geoprivacy setting
    pub geoprivacy: Option<Vec<String>>,
    /// Filter observations by the most conservative geoprivacy applied by a conservation status associated with one of the taxa proposed in the current identifications. 
    pub taxon_geoprivacy: Option<Vec<String>>,
    /// Taxon must have this rank or lower
    pub hrank: Option<String>,
    /// Taxon must have this rank or higher
    pub lrank: Option<String>,
    /// Taxon must by within this iconic taxon
    pub iconic_taxa: Option<Vec<String>>,
    /// Must have an ID above this value
    pub id_above: Option<String>,
    /// Must have an ID below this value
    pub id_below: Option<String>,
    /// Identifications must meet these criteria
    pub identifications: Option<String>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub lat: Option<f64>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub lng: Option<f64>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub radius: Option<String>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelat: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelng: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlat: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlng: Option<f64>,
    /// Taxon must be in the list with this ID
    pub list_id: Option<i32>,
    /// Must not be in the project with this ID or slug
    pub not_in_project: Option<String>,
    /// Must not match the rules of the project with this ID or slug
    pub not_matching_project_rules_for: Option<String>,
    /// Search observation properties. Can be combined with `search_on`
    pub q: Option<String>,
    /// Properties to search on, when combined with `q`. Searches across all properties by default 
    pub search_on: Option<String>,
    /// Must have this quality grade
    pub quality_grade: Option<String>,
    /// Must be updated since this time
    pub updated_since: Option<String>,
    /// See `reviewed`
    pub viewer_id: Option<String>,
    /// Observations have been reviewed by the user with ID equal to the value of the `viewer_id` parameter 
    pub reviewed: Option<bool>,
    /// Locale preference for taxon common names 
    pub locale: Option<String>,
    /// Place preference for regional taxon common names 
    pub preferred_place_id: Option<i32>,
    /// Set the `Cache-Control` HTTP header with this value as `max-age`, in seconds. This means subsequent identical requests will be cached on iNaturalist servers, and commonly within web browsers 
    pub ttl: Option<String>
}

/// struct for passing parameters to the method [`observations_observers_get`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsObserversGetParams {
    /// Whether or not positional accuracy / coordinate uncertainty has been specified
    pub acc: Option<bool>,
    /// Captive or cultivated observations
    pub captive: Option<bool>,
    /// Observations whose taxa are endemic to their location
    pub endemic: Option<bool>,
    /// Observations that are georeferenced
    pub geo: Option<bool>,
    /// Observations with the deprecated `ID, Please!` flag. Note that this will return observations, but that this attribute is no longer used.
    pub id_please: Option<bool>,
    /// Observations that have community identifications
    pub identified: Option<bool>,
    /// Observations whose taxa are introduced in their location 
    pub introduced: Option<bool>,
    /// Observations that show on map tiles
    pub mappable: Option<bool>,
    /// Observations whose taxa are native to their location
    pub native: Option<bool>,
    /// Observations whose taxa are outside their known ranges
    pub out_of_range: Option<bool>,
    /// Observations identified by the curator of a project. If the `project_id` parameter is also specified, this will only consider observations identified by curators of the specified project(s) 
    pub pcid: Option<bool>,
    /// Observations with photos
    pub photos: Option<bool>,
    /// Observations that have been favorited by at least one user 
    pub popular: Option<bool>,
    /// Observations with sounds
    pub sounds: Option<bool>,
    /// Observations of active taxon concepts 
    pub taxon_is_active: Option<bool>,
    /// Observations whose taxa are threatened in their location 
    pub threatened: Option<bool>,
    /// Observations with a `quality_grade` of either `needs_id` or `research`. Equivalent to `quality_grade=needs_id,research` 
    pub verifiable: Option<bool>,
    /// License attribute of an observation must not be null
    pub licensed: Option<bool>,
    /// License attribute of at least one photo of an observation must not be null
    pub photo_licensed: Option<bool>,
    /// Must have this ID
    pub id: Option<Vec<String>>,
    /// Must not have this ID
    pub not_id: Option<Vec<String>>,
    /// Observation must have this license
    pub license: Option<Vec<String>>,
    /// Must have an observation field value with this datatype
    pub ofv_datatype: Option<Vec<String>>,
    /// Must have at least one photo with this license
    pub photo_license: Option<Vec<String>>,
    /// Must be observed within the place with this ID
    pub place_id: Option<Vec<i32>>,
    /// Must be added to the project this ID or slug
    pub project_id: Option<Vec<String>>,
    /// Taxon must have this rank
    pub rank: Option<Vec<String>>,
    /// Must be affiliated with the iNaturalist network website with this ID 
    pub site_id: Option<Vec<String>>,
    /// Must have at least one sound with this license
    pub sound_license: Option<Vec<String>>,
    /// Only show observations of these taxa and their descendants
    pub taxon_id: Option<Vec<String>>,
    /// Exclude observations of these taxa and their descendants
    pub without_taxon_id: Option<Vec<String>>,
    /// Taxon must have a scientific or common name matching this string 
    pub taxon_name: Option<Vec<String>>,
    /// User must have this ID or login
    pub user_id: Option<Vec<String>>,
    /// User must have this login
    pub user_login: Option<Vec<String>>,
    /// Observations identified by a particular user
    pub ident_user_id: Option<i32>,
    /// Must be observed within this day of the month
    pub day: Option<Vec<String>>,
    /// Must be observed within this month
    pub month: Option<Vec<String>>,
    /// Must be observed within this year
    pub year: Option<Vec<String>>,
    /// Must have an annotation using this controlled term ID
    pub term_id: Option<Vec<i32>>,
    /// Must have an annotation using this controlled value ID. Must be combined with the `term_id` parameter 
    pub term_value_id: Option<Vec<i32>>,
    /// Exclude observations with annotations using this controlled value ID. Must be combined with the `term_id` parameter 
    pub without_term_value_id: Option<Vec<i32>>,
    /// Must have a positional accuracy above this value (meters)
    pub acc_above: Option<String>,
    /// Must have a positional accuracy below this value (meters)
    pub acc_below: Option<String>,
    /// Positional accuracy must be below this value (in meters) or be unknown
    pub acc_below_or_unknown: Option<String>,
    /// Must be observed on or after this date
    pub d1: Option<String>,
    /// Must be observed on or before this date
    pub d2: Option<String>,
    /// Must be created at or after this time
    pub created_d1: Option<String>,
    /// Must be created at or before this time
    pub created_d2: Option<String>,
    /// Must be created on this date
    pub created_on: Option<String>,
    /// Must be observed on this date
    pub observed_on: Option<String>,
    /// Must not be of a taxon previously observed by this user
    pub unobserved_by_user_id: Option<i32>,
    /// Must match the rules of the project with this ID or slug
    pub apply_project_rules_for: Option<String>,
    /// Taxon must have this conservation status code. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub cs: Option<String>,
    /// Taxon must have a conservation status from this authority. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub csa: Option<String>,
    /// Taxon must have this IUCN conservation status. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub csi: Option<Vec<String>>,
    /// Must have this geoprivacy setting
    pub geoprivacy: Option<Vec<String>>,
    /// Filter observations by the most conservative geoprivacy applied by a conservation status associated with one of the taxa proposed in the current identifications. 
    pub taxon_geoprivacy: Option<Vec<String>>,
    /// Taxon must have this rank or lower
    pub hrank: Option<String>,
    /// Taxon must have this rank or higher
    pub lrank: Option<String>,
    /// Taxon must by within this iconic taxon
    pub iconic_taxa: Option<Vec<String>>,
    /// Must have an ID above this value
    pub id_above: Option<String>,
    /// Must have an ID below this value
    pub id_below: Option<String>,
    /// Identifications must meet these criteria
    pub identifications: Option<String>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub lat: Option<f64>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub lng: Option<f64>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub radius: Option<String>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelat: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelng: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlat: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlng: Option<f64>,
    /// Taxon must be in the list with this ID
    pub list_id: Option<i32>,
    /// Must not be in the project with this ID or slug
    pub not_in_project: Option<String>,
    /// Must not match the rules of the project with this ID or slug
    pub not_matching_project_rules_for: Option<String>,
    /// Search observation properties. Can be combined with `search_on`
    pub q: Option<String>,
    /// Properties to search on, when combined with `q`. Searches across all properties by default 
    pub search_on: Option<String>,
    /// Must have this quality grade
    pub quality_grade: Option<String>,
    /// Must be updated since this time
    pub updated_since: Option<String>,
    /// See `reviewed`
    pub viewer_id: Option<String>,
    /// Observations have been reviewed by the user with ID equal to the value of the `viewer_id` parameter 
    pub reviewed: Option<bool>,
    /// Locale preference for taxon common names 
    pub locale: Option<String>,
    /// Place preference for regional taxon common names 
    pub preferred_place_id: Option<i32>,
    /// Set the `Cache-Control` HTTP header with this value as `max-age`, in seconds. This means subsequent identical requests will be cached on iNaturalist servers, and commonly within web browsers 
    pub ttl: Option<String>
}

/// struct for passing parameters to the method [`observations_popular_field_values_get`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsPopularFieldValuesGetParams {
    /// Whether or not positional accuracy / coordinate uncertainty has been specified
    pub acc: Option<bool>,
    /// Captive or cultivated observations
    pub captive: Option<bool>,
    /// Observations whose taxa are endemic to their location
    pub endemic: Option<bool>,
    /// Observations that are georeferenced
    pub geo: Option<bool>,
    /// Observations with the deprecated `ID, Please!` flag. Note that this will return observations, but that this attribute is no longer used.
    pub id_please: Option<bool>,
    /// Observations that have community identifications
    pub identified: Option<bool>,
    /// Observations whose taxa are introduced in their location 
    pub introduced: Option<bool>,
    /// Observations that show on map tiles
    pub mappable: Option<bool>,
    /// Observations whose taxa are native to their location
    pub native: Option<bool>,
    /// Observations whose taxa are outside their known ranges
    pub out_of_range: Option<bool>,
    /// Observations identified by the curator of a project. If the `project_id` parameter is also specified, this will only consider observations identified by curators of the specified project(s) 
    pub pcid: Option<bool>,
    /// Observations with photos
    pub photos: Option<bool>,
    /// Observations that have been favorited by at least one user 
    pub popular: Option<bool>,
    /// Observations with sounds
    pub sounds: Option<bool>,
    /// Observations of active taxon concepts 
    pub taxon_is_active: Option<bool>,
    /// Observations whose taxa are threatened in their location 
    pub threatened: Option<bool>,
    /// Observations with a `quality_grade` of either `needs_id` or `research`. Equivalent to `quality_grade=needs_id,research` 
    pub verifiable: Option<bool>,
    /// License attribute of an observation must not be null
    pub licensed: Option<bool>,
    /// License attribute of at least one photo of an observation must not be null
    pub photo_licensed: Option<bool>,
    /// Must have this ID
    pub id: Option<Vec<String>>,
    /// Must not have this ID
    pub not_id: Option<Vec<String>>,
    /// Observation must have this license
    pub license: Option<Vec<String>>,
    /// Must have an observation field value with this datatype
    pub ofv_datatype: Option<Vec<String>>,
    /// Must have at least one photo with this license
    pub photo_license: Option<Vec<String>>,
    /// Must be observed within the place with this ID
    pub place_id: Option<Vec<i32>>,
    /// Must be added to the project this ID or slug
    pub project_id: Option<Vec<String>>,
    /// Taxon must have this rank
    pub rank: Option<Vec<String>>,
    /// Must be affiliated with the iNaturalist network website with this ID 
    pub site_id: Option<Vec<String>>,
    /// Must have at least one sound with this license
    pub sound_license: Option<Vec<String>>,
    /// Only show observations of these taxa and their descendants
    pub taxon_id: Option<Vec<String>>,
    /// Exclude observations of these taxa and their descendants
    pub without_taxon_id: Option<Vec<String>>,
    /// Taxon must have a scientific or common name matching this string 
    pub taxon_name: Option<Vec<String>>,
    /// User must have this ID or login
    pub user_id: Option<Vec<String>>,
    /// User must have this login
    pub user_login: Option<Vec<String>>,
    /// Observations identified by a particular user
    pub ident_user_id: Option<i32>,
    /// Must be observed within this day of the month
    pub day: Option<Vec<String>>,
    /// Must be observed within this month
    pub month: Option<Vec<String>>,
    /// Must be observed within this year
    pub year: Option<Vec<String>>,
    /// Must have an annotation using this controlled term ID
    pub term_id: Option<Vec<i32>>,
    /// Must have an annotation using this controlled value ID. Must be combined with the `term_id` parameter 
    pub term_value_id: Option<Vec<i32>>,
    /// Exclude observations with annotations using this controlled value ID. Must be combined with the `term_id` parameter 
    pub without_term_value_id: Option<Vec<i32>>,
    /// Must have a positional accuracy above this value (meters)
    pub acc_above: Option<String>,
    /// Must have a positional accuracy below this value (meters)
    pub acc_below: Option<String>,
    /// Positional accuracy must be below this value (in meters) or be unknown
    pub acc_below_or_unknown: Option<String>,
    /// Must be observed on or after this date
    pub d1: Option<String>,
    /// Must be observed on or before this date
    pub d2: Option<String>,
    /// Must be created at or after this time
    pub created_d1: Option<String>,
    /// Must be created at or before this time
    pub created_d2: Option<String>,
    /// Must be created on this date
    pub created_on: Option<String>,
    /// Must be observed on this date
    pub observed_on: Option<String>,
    /// Must not be of a taxon previously observed by this user
    pub unobserved_by_user_id: Option<i32>,
    /// Must match the rules of the project with this ID or slug
    pub apply_project_rules_for: Option<String>,
    /// Taxon must have this conservation status code. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub cs: Option<String>,
    /// Taxon must have a conservation status from this authority. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub csa: Option<String>,
    /// Taxon must have this IUCN conservation status. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub csi: Option<Vec<String>>,
    /// Must have this geoprivacy setting
    pub geoprivacy: Option<Vec<String>>,
    /// Filter observations by the most conservative geoprivacy applied by a conservation status associated with one of the taxa proposed in the current identifications. 
    pub taxon_geoprivacy: Option<Vec<String>>,
    /// Taxon must have this rank or lower
    pub hrank: Option<String>,
    /// Taxon must have this rank or higher
    pub lrank: Option<String>,
    /// Taxon must by within this iconic taxon
    pub iconic_taxa: Option<Vec<String>>,
    /// Must have an ID above this value
    pub id_above: Option<String>,
    /// Must have an ID below this value
    pub id_below: Option<String>,
    /// Identifications must meet these criteria
    pub identifications: Option<String>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub lat: Option<f64>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub lng: Option<f64>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub radius: Option<String>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelat: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelng: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlat: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlng: Option<f64>,
    /// Taxon must be in the list with this ID
    pub list_id: Option<i32>,
    /// Must not be in the project with this ID or slug
    pub not_in_project: Option<String>,
    /// Must not match the rules of the project with this ID or slug
    pub not_matching_project_rules_for: Option<String>,
    /// Search observation properties. Can be combined with `search_on`
    pub q: Option<String>,
    /// Properties to search on, when combined with `q`. Searches across all properties by default 
    pub search_on: Option<String>,
    /// Must have this quality grade
    pub quality_grade: Option<String>,
    /// Must be updated since this time
    pub updated_since: Option<String>,
    /// See `reviewed`
    pub viewer_id: Option<String>,
    /// Observations have been reviewed by the user with ID equal to the value of the `viewer_id` parameter 
    pub reviewed: Option<bool>,
    /// Locale preference for taxon common names 
    pub locale: Option<String>,
    /// Place preference for regional taxon common names 
    pub preferred_place_id: Option<i32>,
    /// Set the `Cache-Control` HTTP header with this value as `max-age`, in seconds. This means subsequent identical requests will be cached on iNaturalist servers, and commonly within web browsers 
    pub ttl: Option<String>
}

/// struct for passing parameters to the method [`observations_post`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsPostParams {
    /// Comment object
    pub body: Option<crate::models::PostObservation>
}

/// struct for passing parameters to the method [`observations_species_counts_get`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsSpeciesCountsGetParams {
    /// Whether or not positional accuracy / coordinate uncertainty has been specified
    pub acc: Option<bool>,
    /// Captive or cultivated observations
    pub captive: Option<bool>,
    /// Observations whose taxa are endemic to their location
    pub endemic: Option<bool>,
    /// Observations that are georeferenced
    pub geo: Option<bool>,
    /// Observations with the deprecated `ID, Please!` flag. Note that this will return observations, but that this attribute is no longer used.
    pub id_please: Option<bool>,
    /// Observations that have community identifications
    pub identified: Option<bool>,
    /// Observations whose taxa are introduced in their location 
    pub introduced: Option<bool>,
    /// Observations that show on map tiles
    pub mappable: Option<bool>,
    /// Observations whose taxa are native to their location
    pub native: Option<bool>,
    /// Observations whose taxa are outside their known ranges
    pub out_of_range: Option<bool>,
    /// Observations identified by the curator of a project. If the `project_id` parameter is also specified, this will only consider observations identified by curators of the specified project(s) 
    pub pcid: Option<bool>,
    /// Observations with photos
    pub photos: Option<bool>,
    /// Observations that have been favorited by at least one user 
    pub popular: Option<bool>,
    /// Observations with sounds
    pub sounds: Option<bool>,
    /// Observations of active taxon concepts 
    pub taxon_is_active: Option<bool>,
    /// Observations whose taxa are threatened in their location 
    pub threatened: Option<bool>,
    /// Observations with a `quality_grade` of either `needs_id` or `research`. Equivalent to `quality_grade=needs_id,research` 
    pub verifiable: Option<bool>,
    /// License attribute of an observation must not be null
    pub licensed: Option<bool>,
    /// License attribute of at least one photo of an observation must not be null
    pub photo_licensed: Option<bool>,
    /// Must have this ID
    pub id: Option<Vec<String>>,
    /// Must not have this ID
    pub not_id: Option<Vec<String>>,
    /// Observation must have this license
    pub license: Option<Vec<String>>,
    /// Must have an observation field value with this datatype
    pub ofv_datatype: Option<Vec<String>>,
    /// Must have at least one photo with this license
    pub photo_license: Option<Vec<String>>,
    /// Must be observed within the place with this ID
    pub place_id: Option<Vec<i32>>,
    /// Must be added to the project this ID or slug
    pub project_id: Option<Vec<String>>,
    /// Taxon must have this rank
    pub rank: Option<Vec<String>>,
    /// Must be affiliated with the iNaturalist network website with this ID 
    pub site_id: Option<Vec<String>>,
    /// Must have at least one sound with this license
    pub sound_license: Option<Vec<String>>,
    /// Only show observations of these taxa and their descendants
    pub taxon_id: Option<Vec<String>>,
    /// Exclude observations of these taxa and their descendants
    pub without_taxon_id: Option<Vec<String>>,
    /// Taxon must have a scientific or common name matching this string 
    pub taxon_name: Option<Vec<String>>,
    /// User must have this ID or login
    pub user_id: Option<Vec<String>>,
    /// User must have this login
    pub user_login: Option<Vec<String>>,
    /// Observations identified by a particular user
    pub ident_user_id: Option<i32>,
    /// Must be observed within this day of the month
    pub day: Option<Vec<String>>,
    /// Must be observed within this month
    pub month: Option<Vec<String>>,
    /// Must be observed within this year
    pub year: Option<Vec<String>>,
    /// Must have an annotation using this controlled term ID
    pub term_id: Option<Vec<i32>>,
    /// Must have an annotation using this controlled value ID. Must be combined with the `term_id` parameter 
    pub term_value_id: Option<Vec<i32>>,
    /// Exclude observations with annotations using this controlled value ID. Must be combined with the `term_id` parameter 
    pub without_term_value_id: Option<Vec<i32>>,
    /// Must have a positional accuracy above this value (meters)
    pub acc_above: Option<String>,
    /// Must have a positional accuracy below this value (meters)
    pub acc_below: Option<String>,
    /// Positional accuracy must be below this value (in meters) or be unknown
    pub acc_below_or_unknown: Option<String>,
    /// Must be observed on or after this date
    pub d1: Option<String>,
    /// Must be observed on or before this date
    pub d2: Option<String>,
    /// Must be created at or after this time
    pub created_d1: Option<String>,
    /// Must be created at or before this time
    pub created_d2: Option<String>,
    /// Must be created on this date
    pub created_on: Option<String>,
    /// Must be observed on this date
    pub observed_on: Option<String>,
    /// Must not be of a taxon previously observed by this user
    pub unobserved_by_user_id: Option<i32>,
    /// Must match the rules of the project with this ID or slug
    pub apply_project_rules_for: Option<String>,
    /// Taxon must have this conservation status code. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub cs: Option<String>,
    /// Taxon must have a conservation status from this authority. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub csa: Option<String>,
    /// Taxon must have this IUCN conservation status. If the `place_id` parameter is also specified, this will only consider statuses specific to that place 
    pub csi: Option<Vec<String>>,
    /// Must have this geoprivacy setting
    pub geoprivacy: Option<Vec<String>>,
    /// Filter observations by the most conservative geoprivacy applied by a conservation status associated with one of the taxa proposed in the current identifications. 
    pub taxon_geoprivacy: Option<Vec<String>>,
    /// Taxon must have this rank or lower
    pub hrank: Option<String>,
    /// Taxon must have this rank or higher
    pub lrank: Option<String>,
    /// Taxon must by within this iconic taxon
    pub iconic_taxa: Option<Vec<String>>,
    /// Must have an ID above this value
    pub id_above: Option<String>,
    /// Must have an ID below this value
    pub id_below: Option<String>,
    /// Identifications must meet these criteria
    pub identifications: Option<String>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub lat: Option<f64>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub lng: Option<f64>,
    /// Must be within a {`radius`} kilometer circle around this lat/lng (*lat, *lng, radius) 
    pub radius: Option<String>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelat: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub nelng: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlat: Option<f64>,
    /// Must be within this bounding box (*nelat, *nelng, *swlat, *swlng) 
    pub swlng: Option<f64>,
    /// Taxon must be in the list with this ID
    pub list_id: Option<i32>,
    /// Must not be in the project with this ID or slug
    pub not_in_project: Option<String>,
    /// Must not match the rules of the project with this ID or slug
    pub not_matching_project_rules_for: Option<String>,
    /// Search observation properties. Can be combined with `search_on`
    pub q: Option<String>,
    /// Properties to search on, when combined with `q`. Searches across all properties by default 
    pub search_on: Option<String>,
    /// Must have this quality grade
    pub quality_grade: Option<String>,
    /// Must be updated since this time
    pub updated_since: Option<String>,
    /// See `reviewed`
    pub viewer_id: Option<String>,
    /// Observations have been reviewed by the user with ID equal to the value of the `viewer_id` parameter 
    pub reviewed: Option<bool>,
    /// Locale preference for taxon common names 
    pub locale: Option<String>,
    /// Place preference for regional taxon common names 
    pub preferred_place_id: Option<i32>,
    /// Set the `Cache-Control` HTTP header with this value as `max-age`, in seconds. This means subsequent identical requests will be cached on iNaturalist servers, and commonly within web browsers 
    pub ttl: Option<String>
}

/// struct for passing parameters to the method [`observations_updates_get`]
#[derive(Clone, Debug, Default)]
pub struct ObservationsUpdatesGetParams {
    /// Must be created at or after this time
    pub created_after: Option<String>,
    /// Notification has been viewed by the user before
    pub viewed: Option<bool>,
    /// Only show updates on observations owned by the currently authenticated user or on observations the authenticated user is following but does not own. 
    pub observations_by: Option<String>,
    /// Pagination `page` number
    pub page: Option<String>,
    /// Number of results to return in a `page`. The maximum value is generally 200 unless otherwise noted 
    pub per_page: Option<String>
}

/// struct for passing parameters to the method [`subscriptions_observation_id_subscribe_post`]
#[derive(Clone, Debug, Default)]
pub struct SubscriptionsObservationIdSubscribePostParams {
    /// ID of the record
    pub id: i32
}

/// struct for passing parameters to the method [`votes_unvote_observation_id_delete`]
#[derive(Clone, Debug, Default)]
pub struct VotesUnvoteObservationIdDeleteParams {
    /// ID of the record
    pub id: i32,
    /// Vote object
    pub body: Option<crate::models::PostObservationVote>
}

/// struct for passing parameters to the method [`votes_vote_observation_id_post`]
#[derive(Clone, Debug, Default)]
pub struct VotesVoteObservationIdPostParams {
    /// ID of the record
    pub id: i32,
    /// Vote object
    pub body: Option<crate::models::PostObservationVote>
}


/// struct for typed errors of method [`observations_deleted_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsDeletedGetError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`observations_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsGetError {
    DefaultResponse(crate::models::Error),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`observations_histogram_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsHistogramGetError {
    DefaultResponse(crate::models::Error),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`observations_id_delete`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsIdDeleteError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`observations_id_fave_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsIdFavePostError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`observations_id_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsIdGetError {
    DefaultResponse(crate::models::Error),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`observations_id_put`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsIdPutError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`observations_id_quality_metric_delete`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsIdQualityMetricDeleteError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`observations_id_quality_metric_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsIdQualityMetricPostError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`observations_id_review_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsIdReviewPostError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`observations_id_subscriptions_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsIdSubscriptionsGetError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`observations_id_taxon_summary_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsIdTaxonSummaryGetError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`observations_id_unfave_delete`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsIdUnfaveDeleteError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`observations_id_unreview_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsIdUnreviewPostError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`observations_id_viewed_updates_put`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsIdViewedUpdatesPutError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`observations_identifiers_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsIdentifiersGetError {
    DefaultResponse(crate::models::Error),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`observations_observers_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsObserversGetError {
    DefaultResponse(crate::models::Error),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`observations_popular_field_values_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsPopularFieldValuesGetError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`observations_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsPostError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`observations_species_counts_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsSpeciesCountsGetError {
    DefaultResponse(crate::models::Error),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`observations_updates_get`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum ObservationsUpdatesGetError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`subscriptions_observation_id_subscribe_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum SubscriptionsObservationIdSubscribePostError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`votes_unvote_observation_id_delete`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum VotesUnvoteObservationIdDeleteError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`votes_vote_observation_id_post`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum VotesVoteObservationIdPostError {
    UnknownValue(serde_json::Value),
}


/// Given a starting date, return an array of IDs of the authenticated user's observations that have been deleted since that date. Requires authentication 
pub async fn observations_deleted_get(configuration: &configuration::Configuration, params: ObservationsDeletedGetParams) -> Result<(), Error<ObservationsDeletedGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let since = params.since;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations/deleted", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    local_var_req_builder = local_var_req_builder.query(&[("since", &since.to_string())]);
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = local_var_configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("Authorization", local_var_value);
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<ObservationsDeletedGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Given zero to many of following parameters, returns observations matching the search criteria. The large size of the observations index prevents us from supporting the `page` parameter when retrieving records from large result sets. If you need to retrieve large numbers of records, use the `per_page` and `id_above` or `id_below` parameters instead. 
pub async fn observations_get(configuration: &configuration::Configuration, params: ObservationsGetParams) -> Result<crate::models::ObservationsResponse, Error<ObservationsGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let acc = params.acc;
    let captive = params.captive;
    let endemic = params.endemic;
    let geo = params.geo;
    let id_please = params.id_please;
    let identified = params.identified;
    let introduced = params.introduced;
    let mappable = params.mappable;
    let native = params.native;
    let out_of_range = params.out_of_range;
    let pcid = params.pcid;
    let photos = params.photos;
    let popular = params.popular;
    let sounds = params.sounds;
    let taxon_is_active = params.taxon_is_active;
    let threatened = params.threatened;
    let verifiable = params.verifiable;
    let licensed = params.licensed;
    let photo_licensed = params.photo_licensed;
    let id = params.id;
    let not_id = params.not_id;
    let license = params.license;
    let ofv_datatype = params.ofv_datatype;
    let photo_license = params.photo_license;
    let place_id = params.place_id;
    let project_id = params.project_id;
    let rank = params.rank;
    let site_id = params.site_id;
    let sound_license = params.sound_license;
    let taxon_id = params.taxon_id;
    let without_taxon_id = params.without_taxon_id;
    let taxon_name = params.taxon_name;
    let user_id = params.user_id;
    let user_login = params.user_login;
    let ident_user_id = params.ident_user_id;
    let day = params.day;
    let month = params.month;
    let year = params.year;
    let term_id = params.term_id;
    let term_value_id = params.term_value_id;
    let without_term_value_id = params.without_term_value_id;
    let acc_above = params.acc_above;
    let acc_below = params.acc_below;
    let acc_below_or_unknown = params.acc_below_or_unknown;
    let d1 = params.d1;
    let d2 = params.d2;
    let created_d1 = params.created_d1;
    let created_d2 = params.created_d2;
    let created_on = params.created_on;
    let observed_on = params.observed_on;
    let unobserved_by_user_id = params.unobserved_by_user_id;
    let apply_project_rules_for = params.apply_project_rules_for;
    let cs = params.cs;
    let csa = params.csa;
    let csi = params.csi;
    let geoprivacy = params.geoprivacy;
    let taxon_geoprivacy = params.taxon_geoprivacy;
    let hrank = params.hrank;
    let lrank = params.lrank;
    let iconic_taxa = params.iconic_taxa;
    let id_above = params.id_above;
    let id_below = params.id_below;
    let identifications = params.identifications;
    let lat = params.lat;
    let lng = params.lng;
    let radius = params.radius;
    let nelat = params.nelat;
    let nelng = params.nelng;
    let swlat = params.swlat;
    let swlng = params.swlng;
    let list_id = params.list_id;
    let not_in_project = params.not_in_project;
    let not_matching_project_rules_for = params.not_matching_project_rules_for;
    let q = params.q;
    let search_on = params.search_on;
    let quality_grade = params.quality_grade;
    let updated_since = params.updated_since;
    let viewer_id = params.viewer_id;
    let reviewed = params.reviewed;
    let locale = params.locale;
    let preferred_place_id = params.preferred_place_id;
    let ttl = params.ttl;
    let page = params.page;
    let per_page = params.per_page;
    let order = params.order;
    let order_by = params.order_by;
    let only_id = params.only_id;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = acc {
        local_var_req_builder = local_var_req_builder.query(&[("acc", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = captive {
        local_var_req_builder = local_var_req_builder.query(&[("captive", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = endemic {
        local_var_req_builder = local_var_req_builder.query(&[("endemic", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = geo {
        local_var_req_builder = local_var_req_builder.query(&[("geo", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_please {
        local_var_req_builder = local_var_req_builder.query(&[("id_please", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = identified {
        local_var_req_builder = local_var_req_builder.query(&[("identified", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = introduced {
        local_var_req_builder = local_var_req_builder.query(&[("introduced", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = mappable {
        local_var_req_builder = local_var_req_builder.query(&[("mappable", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = native {
        local_var_req_builder = local_var_req_builder.query(&[("native", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = out_of_range {
        local_var_req_builder = local_var_req_builder.query(&[("out_of_range", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = pcid {
        local_var_req_builder = local_var_req_builder.query(&[("pcid", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = photos {
        local_var_req_builder = local_var_req_builder.query(&[("photos", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = popular {
        local_var_req_builder = local_var_req_builder.query(&[("popular", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = sounds {
        local_var_req_builder = local_var_req_builder.query(&[("sounds", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = taxon_is_active {
        local_var_req_builder = local_var_req_builder.query(&[("taxon_is_active", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = threatened {
        local_var_req_builder = local_var_req_builder.query(&[("threatened", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = verifiable {
        local_var_req_builder = local_var_req_builder.query(&[("verifiable", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = licensed {
        local_var_req_builder = local_var_req_builder.query(&[("licensed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = photo_licensed {
        local_var_req_builder = local_var_req_builder.query(&[("photo_licensed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = not_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("not_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("not_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = ofv_datatype {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("ofv_datatype".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("ofv_datatype", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = photo_license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("photo_license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("photo_license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = place_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("place_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("place_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = project_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("project_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("project_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = rank {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("rank".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("rank", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = site_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("site_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("site_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = sound_license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("sound_license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("sound_license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = without_taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("without_taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("without_taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_name {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_name".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_name", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = user_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("user_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("user_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = user_login {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("user_login".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("user_login", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = ident_user_id {
        local_var_req_builder = local_var_req_builder.query(&[("ident_user_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = day {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("day".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("day", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = month {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("month".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("month", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = year {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("year".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("year", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = term_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("term_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("term_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = term_value_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("term_value_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("term_value_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = without_term_value_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("without_term_value_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("without_term_value_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = acc_above {
        local_var_req_builder = local_var_req_builder.query(&[("acc_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc_below {
        local_var_req_builder = local_var_req_builder.query(&[("acc_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc_below_or_unknown {
        local_var_req_builder = local_var_req_builder.query(&[("acc_below_or_unknown", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = d1 {
        local_var_req_builder = local_var_req_builder.query(&[("d1", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = d2 {
        local_var_req_builder = local_var_req_builder.query(&[("d2", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_d1 {
        local_var_req_builder = local_var_req_builder.query(&[("created_d1", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_d2 {
        local_var_req_builder = local_var_req_builder.query(&[("created_d2", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_on {
        local_var_req_builder = local_var_req_builder.query(&[("created_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = observed_on {
        local_var_req_builder = local_var_req_builder.query(&[("observed_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = unobserved_by_user_id {
        local_var_req_builder = local_var_req_builder.query(&[("unobserved_by_user_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = apply_project_rules_for {
        local_var_req_builder = local_var_req_builder.query(&[("apply_project_rules_for", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cs {
        local_var_req_builder = local_var_req_builder.query(&[("cs", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = csa {
        local_var_req_builder = local_var_req_builder.query(&[("csa", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = csi {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("csi".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("csi", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = geoprivacy {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("geoprivacy".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("geoprivacy", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_geoprivacy {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_geoprivacy".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_geoprivacy", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = hrank {
        local_var_req_builder = local_var_req_builder.query(&[("hrank", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lrank {
        local_var_req_builder = local_var_req_builder.query(&[("lrank", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = iconic_taxa {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("iconic_taxa".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("iconic_taxa", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = id_above {
        local_var_req_builder = local_var_req_builder.query(&[("id_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_below {
        local_var_req_builder = local_var_req_builder.query(&[("id_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = identifications {
        local_var_req_builder = local_var_req_builder.query(&[("identifications", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lat {
        local_var_req_builder = local_var_req_builder.query(&[("lat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lng {
        local_var_req_builder = local_var_req_builder.query(&[("lng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = radius {
        local_var_req_builder = local_var_req_builder.query(&[("radius", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = nelat {
        local_var_req_builder = local_var_req_builder.query(&[("nelat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = nelng {
        local_var_req_builder = local_var_req_builder.query(&[("nelng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = swlat {
        local_var_req_builder = local_var_req_builder.query(&[("swlat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = swlng {
        local_var_req_builder = local_var_req_builder.query(&[("swlng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = list_id {
        local_var_req_builder = local_var_req_builder.query(&[("list_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = not_in_project {
        local_var_req_builder = local_var_req_builder.query(&[("not_in_project", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = not_matching_project_rules_for {
        local_var_req_builder = local_var_req_builder.query(&[("not_matching_project_rules_for", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = q {
        local_var_req_builder = local_var_req_builder.query(&[("q", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = search_on {
        local_var_req_builder = local_var_req_builder.query(&[("search_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = quality_grade {
        local_var_req_builder = local_var_req_builder.query(&[("quality_grade", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = updated_since {
        local_var_req_builder = local_var_req_builder.query(&[("updated_since", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = viewer_id {
        local_var_req_builder = local_var_req_builder.query(&[("viewer_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = reviewed {
        local_var_req_builder = local_var_req_builder.query(&[("reviewed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = locale {
        local_var_req_builder = local_var_req_builder.query(&[("locale", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = preferred_place_id {
        local_var_req_builder = local_var_req_builder.query(&[("preferred_place_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = ttl {
        local_var_req_builder = local_var_req_builder.query(&[("ttl", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = page {
        local_var_req_builder = local_var_req_builder.query(&[("page", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = per_page {
        local_var_req_builder = local_var_req_builder.query(&[("per_page", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = order {
        local_var_req_builder = local_var_req_builder.query(&[("order", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = order_by {
        local_var_req_builder = local_var_req_builder.query(&[("order_by", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = only_id {
        local_var_req_builder = local_var_req_builder.query(&[("only_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<ObservationsGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Given zero to many of following parameters, returns histogram data about observations matching the search criteria 
pub async fn observations_histogram_get(configuration: &configuration::Configuration, params: ObservationsHistogramGetParams) -> Result<(), Error<ObservationsHistogramGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let acc = params.acc;
    let captive = params.captive;
    let endemic = params.endemic;
    let geo = params.geo;
    let id_please = params.id_please;
    let identified = params.identified;
    let introduced = params.introduced;
    let mappable = params.mappable;
    let native = params.native;
    let out_of_range = params.out_of_range;
    let pcid = params.pcid;
    let photos = params.photos;
    let popular = params.popular;
    let sounds = params.sounds;
    let taxon_is_active = params.taxon_is_active;
    let threatened = params.threatened;
    let verifiable = params.verifiable;
    let licensed = params.licensed;
    let photo_licensed = params.photo_licensed;
    let id = params.id;
    let not_id = params.not_id;
    let license = params.license;
    let ofv_datatype = params.ofv_datatype;
    let photo_license = params.photo_license;
    let place_id = params.place_id;
    let project_id = params.project_id;
    let rank = params.rank;
    let site_id = params.site_id;
    let sound_license = params.sound_license;
    let taxon_id = params.taxon_id;
    let without_taxon_id = params.without_taxon_id;
    let taxon_name = params.taxon_name;
    let user_id = params.user_id;
    let user_login = params.user_login;
    let ident_user_id = params.ident_user_id;
    let day = params.day;
    let month = params.month;
    let year = params.year;
    let term_id = params.term_id;
    let term_value_id = params.term_value_id;
    let without_term_value_id = params.without_term_value_id;
    let acc_above = params.acc_above;
    let acc_below = params.acc_below;
    let acc_below_or_unknown = params.acc_below_or_unknown;
    let d1 = params.d1;
    let d2 = params.d2;
    let created_d1 = params.created_d1;
    let created_d2 = params.created_d2;
    let created_on = params.created_on;
    let observed_on = params.observed_on;
    let unobserved_by_user_id = params.unobserved_by_user_id;
    let apply_project_rules_for = params.apply_project_rules_for;
    let cs = params.cs;
    let csa = params.csa;
    let csi = params.csi;
    let geoprivacy = params.geoprivacy;
    let taxon_geoprivacy = params.taxon_geoprivacy;
    let hrank = params.hrank;
    let lrank = params.lrank;
    let iconic_taxa = params.iconic_taxa;
    let id_above = params.id_above;
    let id_below = params.id_below;
    let identifications = params.identifications;
    let lat = params.lat;
    let lng = params.lng;
    let radius = params.radius;
    let nelat = params.nelat;
    let nelng = params.nelng;
    let swlat = params.swlat;
    let swlng = params.swlng;
    let list_id = params.list_id;
    let not_in_project = params.not_in_project;
    let not_matching_project_rules_for = params.not_matching_project_rules_for;
    let q = params.q;
    let search_on = params.search_on;
    let quality_grade = params.quality_grade;
    let updated_since = params.updated_since;
    let viewer_id = params.viewer_id;
    let reviewed = params.reviewed;
    let locale = params.locale;
    let preferred_place_id = params.preferred_place_id;
    let ttl = params.ttl;
    let date_field = params.date_field;
    let interval = params.interval;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations/histogram", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = acc {
        local_var_req_builder = local_var_req_builder.query(&[("acc", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = captive {
        local_var_req_builder = local_var_req_builder.query(&[("captive", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = endemic {
        local_var_req_builder = local_var_req_builder.query(&[("endemic", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = geo {
        local_var_req_builder = local_var_req_builder.query(&[("geo", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_please {
        local_var_req_builder = local_var_req_builder.query(&[("id_please", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = identified {
        local_var_req_builder = local_var_req_builder.query(&[("identified", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = introduced {
        local_var_req_builder = local_var_req_builder.query(&[("introduced", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = mappable {
        local_var_req_builder = local_var_req_builder.query(&[("mappable", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = native {
        local_var_req_builder = local_var_req_builder.query(&[("native", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = out_of_range {
        local_var_req_builder = local_var_req_builder.query(&[("out_of_range", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = pcid {
        local_var_req_builder = local_var_req_builder.query(&[("pcid", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = photos {
        local_var_req_builder = local_var_req_builder.query(&[("photos", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = popular {
        local_var_req_builder = local_var_req_builder.query(&[("popular", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = sounds {
        local_var_req_builder = local_var_req_builder.query(&[("sounds", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = taxon_is_active {
        local_var_req_builder = local_var_req_builder.query(&[("taxon_is_active", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = threatened {
        local_var_req_builder = local_var_req_builder.query(&[("threatened", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = verifiable {
        local_var_req_builder = local_var_req_builder.query(&[("verifiable", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = licensed {
        local_var_req_builder = local_var_req_builder.query(&[("licensed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = photo_licensed {
        local_var_req_builder = local_var_req_builder.query(&[("photo_licensed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = not_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("not_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("not_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = ofv_datatype {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("ofv_datatype".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("ofv_datatype", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = photo_license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("photo_license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("photo_license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = place_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("place_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("place_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = project_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("project_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("project_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = rank {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("rank".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("rank", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = site_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("site_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("site_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = sound_license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("sound_license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("sound_license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = without_taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("without_taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("without_taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_name {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_name".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_name", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = user_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("user_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("user_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = user_login {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("user_login".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("user_login", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = ident_user_id {
        local_var_req_builder = local_var_req_builder.query(&[("ident_user_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = day {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("day".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("day", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = month {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("month".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("month", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = year {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("year".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("year", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = term_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("term_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("term_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = term_value_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("term_value_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("term_value_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = without_term_value_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("without_term_value_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("without_term_value_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = acc_above {
        local_var_req_builder = local_var_req_builder.query(&[("acc_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc_below {
        local_var_req_builder = local_var_req_builder.query(&[("acc_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc_below_or_unknown {
        local_var_req_builder = local_var_req_builder.query(&[("acc_below_or_unknown", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = d1 {
        local_var_req_builder = local_var_req_builder.query(&[("d1", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = d2 {
        local_var_req_builder = local_var_req_builder.query(&[("d2", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_d1 {
        local_var_req_builder = local_var_req_builder.query(&[("created_d1", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_d2 {
        local_var_req_builder = local_var_req_builder.query(&[("created_d2", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_on {
        local_var_req_builder = local_var_req_builder.query(&[("created_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = observed_on {
        local_var_req_builder = local_var_req_builder.query(&[("observed_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = unobserved_by_user_id {
        local_var_req_builder = local_var_req_builder.query(&[("unobserved_by_user_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = apply_project_rules_for {
        local_var_req_builder = local_var_req_builder.query(&[("apply_project_rules_for", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cs {
        local_var_req_builder = local_var_req_builder.query(&[("cs", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = csa {
        local_var_req_builder = local_var_req_builder.query(&[("csa", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = csi {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("csi".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("csi", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = geoprivacy {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("geoprivacy".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("geoprivacy", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_geoprivacy {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_geoprivacy".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_geoprivacy", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = hrank {
        local_var_req_builder = local_var_req_builder.query(&[("hrank", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lrank {
        local_var_req_builder = local_var_req_builder.query(&[("lrank", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = iconic_taxa {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("iconic_taxa".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("iconic_taxa", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = id_above {
        local_var_req_builder = local_var_req_builder.query(&[("id_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_below {
        local_var_req_builder = local_var_req_builder.query(&[("id_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = identifications {
        local_var_req_builder = local_var_req_builder.query(&[("identifications", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lat {
        local_var_req_builder = local_var_req_builder.query(&[("lat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lng {
        local_var_req_builder = local_var_req_builder.query(&[("lng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = radius {
        local_var_req_builder = local_var_req_builder.query(&[("radius", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = nelat {
        local_var_req_builder = local_var_req_builder.query(&[("nelat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = nelng {
        local_var_req_builder = local_var_req_builder.query(&[("nelng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = swlat {
        local_var_req_builder = local_var_req_builder.query(&[("swlat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = swlng {
        local_var_req_builder = local_var_req_builder.query(&[("swlng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = list_id {
        local_var_req_builder = local_var_req_builder.query(&[("list_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = not_in_project {
        local_var_req_builder = local_var_req_builder.query(&[("not_in_project", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = not_matching_project_rules_for {
        local_var_req_builder = local_var_req_builder.query(&[("not_matching_project_rules_for", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = q {
        local_var_req_builder = local_var_req_builder.query(&[("q", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = search_on {
        local_var_req_builder = local_var_req_builder.query(&[("search_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = quality_grade {
        local_var_req_builder = local_var_req_builder.query(&[("quality_grade", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = updated_since {
        local_var_req_builder = local_var_req_builder.query(&[("updated_since", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = viewer_id {
        local_var_req_builder = local_var_req_builder.query(&[("viewer_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = reviewed {
        local_var_req_builder = local_var_req_builder.query(&[("reviewed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = locale {
        local_var_req_builder = local_var_req_builder.query(&[("locale", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = preferred_place_id {
        local_var_req_builder = local_var_req_builder.query(&[("preferred_place_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = ttl {
        local_var_req_builder = local_var_req_builder.query(&[("ttl", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = date_field {
        local_var_req_builder = local_var_req_builder.query(&[("date_field", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = interval {
        local_var_req_builder = local_var_req_builder.query(&[("interval", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<ObservationsHistogramGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Delete an observation 
pub async fn observations_id_delete(configuration: &configuration::Configuration, params: ObservationsIdDeleteParams) -> Result<(), Error<ObservationsIdDeleteError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations/{id}", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::DELETE, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = local_var_configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("Authorization", local_var_value);
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<ObservationsIdDeleteError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Fave an observation 
pub async fn observations_id_fave_post(configuration: &configuration::Configuration, params: ObservationsIdFavePostParams) -> Result<(), Error<ObservationsIdFavePostError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations/{id}/fave", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = local_var_configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("Authorization", local_var_value);
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<ObservationsIdFavePostError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Given an ID, or an array of IDs in comma-delimited format, returns corresponding observations. A maximum of 200 results will be returned 
pub async fn observations_id_get(configuration: &configuration::Configuration, params: ObservationsIdGetParams) -> Result<crate::models::ObservationsShowResponse, Error<ObservationsIdGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations/{id}", local_var_configuration.base_path, id=id.into_iter().map(|i| i.to_string()).collect::<Vec<_>>().join(","));
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<ObservationsIdGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Update an observation 
pub async fn observations_id_put(configuration: &configuration::Configuration, params: ObservationsIdPutParams) -> Result<(), Error<ObservationsIdPutError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let body = params.body;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations/{id}", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::PUT, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = local_var_configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("Authorization", local_var_value);
    };
    local_var_req_builder = local_var_req_builder.json(&body);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<ObservationsIdPutError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Delete a quality metric 
pub async fn observations_id_quality_metric_delete(configuration: &configuration::Configuration, params: ObservationsIdQualityMetricDeleteParams) -> Result<(), Error<ObservationsIdQualityMetricDeleteError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let metric = params.metric;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations/{id}/quality/{metric}", local_var_configuration.base_path, id=id, metric=crate::apis::urlencode(metric));
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::DELETE, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = local_var_configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("Authorization", local_var_value);
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<ObservationsIdQualityMetricDeleteError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Set the value of a quality metric 
pub async fn observations_id_quality_metric_post(configuration: &configuration::Configuration, params: ObservationsIdQualityMetricPostParams) -> Result<(), Error<ObservationsIdQualityMetricPostError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let metric = params.metric;
    let body = params.body;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations/{id}/quality/{metric}", local_var_configuration.base_path, id=id, metric=crate::apis::urlencode(metric));
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = local_var_configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("Authorization", local_var_value);
    };
    local_var_req_builder = local_var_req_builder.json(&body);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<ObservationsIdQualityMetricPostError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Review an observation 
pub async fn observations_id_review_post(configuration: &configuration::Configuration, params: ObservationsIdReviewPostParams) -> Result<(), Error<ObservationsIdReviewPostError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations/{id}/review", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = local_var_configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("Authorization", local_var_value);
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<ObservationsIdReviewPostError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Fetches any subscriptions the current user has to this observation or the observer 
pub async fn observations_id_subscriptions_get(configuration: &configuration::Configuration, params: ObservationsIdSubscriptionsGetParams) -> Result<(), Error<ObservationsIdSubscriptionsGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations/{id}/subscriptions", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = local_var_configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("Authorization", local_var_value);
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<ObservationsIdSubscriptionsGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Fetches information about this observation's taxon, within the context of this observation's location 
pub async fn observations_id_taxon_summary_get(configuration: &configuration::Configuration, params: ObservationsIdTaxonSummaryGetParams) -> Result<(), Error<ObservationsIdTaxonSummaryGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations/{id}/taxon_summary", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<ObservationsIdTaxonSummaryGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Unfave an observation 
pub async fn observations_id_unfave_delete(configuration: &configuration::Configuration, params: ObservationsIdUnfaveDeleteParams) -> Result<(), Error<ObservationsIdUnfaveDeleteError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations/{id}/unfave", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::DELETE, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = local_var_configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("Authorization", local_var_value);
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<ObservationsIdUnfaveDeleteError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Unreview an observation 
pub async fn observations_id_unreview_post(configuration: &configuration::Configuration, params: ObservationsIdUnreviewPostParams) -> Result<(), Error<ObservationsIdUnreviewPostError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations/{id}/unreview", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = local_var_configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("Authorization", local_var_value);
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<ObservationsIdUnreviewPostError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Mark all updates associated with this observation as viewed by logged-in user 
pub async fn observations_id_viewed_updates_put(configuration: &configuration::Configuration, params: ObservationsIdViewedUpdatesPutParams) -> Result<(), Error<ObservationsIdViewedUpdatesPutError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations/{id}/viewed_updates", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::PUT, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = local_var_configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("Authorization", local_var_value);
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<ObservationsIdViewedUpdatesPutError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Given zero to many of following parameters, returns identifiers of observations matching the search criteria and the count of observations they have identified, ordered by count descending. A maximum of 500 results will be returned 
pub async fn observations_identifiers_get(configuration: &configuration::Configuration, params: ObservationsIdentifiersGetParams) -> Result<crate::models::UserCountsResponse, Error<ObservationsIdentifiersGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let acc = params.acc;
    let captive = params.captive;
    let endemic = params.endemic;
    let geo = params.geo;
    let id_please = params.id_please;
    let identified = params.identified;
    let introduced = params.introduced;
    let mappable = params.mappable;
    let native = params.native;
    let out_of_range = params.out_of_range;
    let pcid = params.pcid;
    let photos = params.photos;
    let popular = params.popular;
    let sounds = params.sounds;
    let taxon_is_active = params.taxon_is_active;
    let threatened = params.threatened;
    let verifiable = params.verifiable;
    let licensed = params.licensed;
    let photo_licensed = params.photo_licensed;
    let id = params.id;
    let not_id = params.not_id;
    let license = params.license;
    let ofv_datatype = params.ofv_datatype;
    let photo_license = params.photo_license;
    let place_id = params.place_id;
    let project_id = params.project_id;
    let rank = params.rank;
    let site_id = params.site_id;
    let sound_license = params.sound_license;
    let taxon_id = params.taxon_id;
    let without_taxon_id = params.without_taxon_id;
    let taxon_name = params.taxon_name;
    let user_id = params.user_id;
    let user_login = params.user_login;
    let ident_user_id = params.ident_user_id;
    let day = params.day;
    let month = params.month;
    let year = params.year;
    let term_id = params.term_id;
    let term_value_id = params.term_value_id;
    let without_term_value_id = params.without_term_value_id;
    let acc_above = params.acc_above;
    let acc_below = params.acc_below;
    let acc_below_or_unknown = params.acc_below_or_unknown;
    let d1 = params.d1;
    let d2 = params.d2;
    let created_d1 = params.created_d1;
    let created_d2 = params.created_d2;
    let created_on = params.created_on;
    let observed_on = params.observed_on;
    let unobserved_by_user_id = params.unobserved_by_user_id;
    let apply_project_rules_for = params.apply_project_rules_for;
    let cs = params.cs;
    let csa = params.csa;
    let csi = params.csi;
    let geoprivacy = params.geoprivacy;
    let taxon_geoprivacy = params.taxon_geoprivacy;
    let hrank = params.hrank;
    let lrank = params.lrank;
    let iconic_taxa = params.iconic_taxa;
    let id_above = params.id_above;
    let id_below = params.id_below;
    let identifications = params.identifications;
    let lat = params.lat;
    let lng = params.lng;
    let radius = params.radius;
    let nelat = params.nelat;
    let nelng = params.nelng;
    let swlat = params.swlat;
    let swlng = params.swlng;
    let list_id = params.list_id;
    let not_in_project = params.not_in_project;
    let not_matching_project_rules_for = params.not_matching_project_rules_for;
    let q = params.q;
    let search_on = params.search_on;
    let quality_grade = params.quality_grade;
    let updated_since = params.updated_since;
    let viewer_id = params.viewer_id;
    let reviewed = params.reviewed;
    let locale = params.locale;
    let preferred_place_id = params.preferred_place_id;
    let ttl = params.ttl;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations/identifiers", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = acc {
        local_var_req_builder = local_var_req_builder.query(&[("acc", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = captive {
        local_var_req_builder = local_var_req_builder.query(&[("captive", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = endemic {
        local_var_req_builder = local_var_req_builder.query(&[("endemic", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = geo {
        local_var_req_builder = local_var_req_builder.query(&[("geo", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_please {
        local_var_req_builder = local_var_req_builder.query(&[("id_please", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = identified {
        local_var_req_builder = local_var_req_builder.query(&[("identified", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = introduced {
        local_var_req_builder = local_var_req_builder.query(&[("introduced", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = mappable {
        local_var_req_builder = local_var_req_builder.query(&[("mappable", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = native {
        local_var_req_builder = local_var_req_builder.query(&[("native", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = out_of_range {
        local_var_req_builder = local_var_req_builder.query(&[("out_of_range", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = pcid {
        local_var_req_builder = local_var_req_builder.query(&[("pcid", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = photos {
        local_var_req_builder = local_var_req_builder.query(&[("photos", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = popular {
        local_var_req_builder = local_var_req_builder.query(&[("popular", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = sounds {
        local_var_req_builder = local_var_req_builder.query(&[("sounds", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = taxon_is_active {
        local_var_req_builder = local_var_req_builder.query(&[("taxon_is_active", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = threatened {
        local_var_req_builder = local_var_req_builder.query(&[("threatened", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = verifiable {
        local_var_req_builder = local_var_req_builder.query(&[("verifiable", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = licensed {
        local_var_req_builder = local_var_req_builder.query(&[("licensed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = photo_licensed {
        local_var_req_builder = local_var_req_builder.query(&[("photo_licensed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = not_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("not_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("not_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = ofv_datatype {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("ofv_datatype".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("ofv_datatype", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = photo_license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("photo_license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("photo_license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = place_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("place_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("place_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = project_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("project_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("project_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = rank {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("rank".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("rank", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = site_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("site_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("site_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = sound_license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("sound_license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("sound_license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = without_taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("without_taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("without_taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_name {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_name".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_name", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = user_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("user_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("user_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = user_login {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("user_login".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("user_login", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = ident_user_id {
        local_var_req_builder = local_var_req_builder.query(&[("ident_user_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = day {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("day".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("day", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = month {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("month".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("month", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = year {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("year".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("year", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = term_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("term_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("term_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = term_value_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("term_value_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("term_value_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = without_term_value_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("without_term_value_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("without_term_value_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = acc_above {
        local_var_req_builder = local_var_req_builder.query(&[("acc_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc_below {
        local_var_req_builder = local_var_req_builder.query(&[("acc_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc_below_or_unknown {
        local_var_req_builder = local_var_req_builder.query(&[("acc_below_or_unknown", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = d1 {
        local_var_req_builder = local_var_req_builder.query(&[("d1", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = d2 {
        local_var_req_builder = local_var_req_builder.query(&[("d2", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_d1 {
        local_var_req_builder = local_var_req_builder.query(&[("created_d1", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_d2 {
        local_var_req_builder = local_var_req_builder.query(&[("created_d2", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_on {
        local_var_req_builder = local_var_req_builder.query(&[("created_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = observed_on {
        local_var_req_builder = local_var_req_builder.query(&[("observed_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = unobserved_by_user_id {
        local_var_req_builder = local_var_req_builder.query(&[("unobserved_by_user_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = apply_project_rules_for {
        local_var_req_builder = local_var_req_builder.query(&[("apply_project_rules_for", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cs {
        local_var_req_builder = local_var_req_builder.query(&[("cs", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = csa {
        local_var_req_builder = local_var_req_builder.query(&[("csa", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = csi {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("csi".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("csi", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = geoprivacy {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("geoprivacy".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("geoprivacy", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_geoprivacy {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_geoprivacy".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_geoprivacy", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = hrank {
        local_var_req_builder = local_var_req_builder.query(&[("hrank", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lrank {
        local_var_req_builder = local_var_req_builder.query(&[("lrank", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = iconic_taxa {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("iconic_taxa".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("iconic_taxa", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = id_above {
        local_var_req_builder = local_var_req_builder.query(&[("id_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_below {
        local_var_req_builder = local_var_req_builder.query(&[("id_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = identifications {
        local_var_req_builder = local_var_req_builder.query(&[("identifications", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lat {
        local_var_req_builder = local_var_req_builder.query(&[("lat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lng {
        local_var_req_builder = local_var_req_builder.query(&[("lng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = radius {
        local_var_req_builder = local_var_req_builder.query(&[("radius", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = nelat {
        local_var_req_builder = local_var_req_builder.query(&[("nelat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = nelng {
        local_var_req_builder = local_var_req_builder.query(&[("nelng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = swlat {
        local_var_req_builder = local_var_req_builder.query(&[("swlat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = swlng {
        local_var_req_builder = local_var_req_builder.query(&[("swlng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = list_id {
        local_var_req_builder = local_var_req_builder.query(&[("list_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = not_in_project {
        local_var_req_builder = local_var_req_builder.query(&[("not_in_project", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = not_matching_project_rules_for {
        local_var_req_builder = local_var_req_builder.query(&[("not_matching_project_rules_for", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = q {
        local_var_req_builder = local_var_req_builder.query(&[("q", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = search_on {
        local_var_req_builder = local_var_req_builder.query(&[("search_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = quality_grade {
        local_var_req_builder = local_var_req_builder.query(&[("quality_grade", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = updated_since {
        local_var_req_builder = local_var_req_builder.query(&[("updated_since", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = viewer_id {
        local_var_req_builder = local_var_req_builder.query(&[("viewer_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = reviewed {
        local_var_req_builder = local_var_req_builder.query(&[("reviewed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = locale {
        local_var_req_builder = local_var_req_builder.query(&[("locale", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = preferred_place_id {
        local_var_req_builder = local_var_req_builder.query(&[("preferred_place_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = ttl {
        local_var_req_builder = local_var_req_builder.query(&[("ttl", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<ObservationsIdentifiersGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Given zero to many of following parameters, returns observers of observations matching the search criteria and the count of observations and distinct taxa of rank `species` they have observed. A maximum of 500 results will be returned 
pub async fn observations_observers_get(configuration: &configuration::Configuration, params: ObservationsObserversGetParams) -> Result<crate::models::ObservationsObserversResponse, Error<ObservationsObserversGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let acc = params.acc;
    let captive = params.captive;
    let endemic = params.endemic;
    let geo = params.geo;
    let id_please = params.id_please;
    let identified = params.identified;
    let introduced = params.introduced;
    let mappable = params.mappable;
    let native = params.native;
    let out_of_range = params.out_of_range;
    let pcid = params.pcid;
    let photos = params.photos;
    let popular = params.popular;
    let sounds = params.sounds;
    let taxon_is_active = params.taxon_is_active;
    let threatened = params.threatened;
    let verifiable = params.verifiable;
    let licensed = params.licensed;
    let photo_licensed = params.photo_licensed;
    let id = params.id;
    let not_id = params.not_id;
    let license = params.license;
    let ofv_datatype = params.ofv_datatype;
    let photo_license = params.photo_license;
    let place_id = params.place_id;
    let project_id = params.project_id;
    let rank = params.rank;
    let site_id = params.site_id;
    let sound_license = params.sound_license;
    let taxon_id = params.taxon_id;
    let without_taxon_id = params.without_taxon_id;
    let taxon_name = params.taxon_name;
    let user_id = params.user_id;
    let user_login = params.user_login;
    let ident_user_id = params.ident_user_id;
    let day = params.day;
    let month = params.month;
    let year = params.year;
    let term_id = params.term_id;
    let term_value_id = params.term_value_id;
    let without_term_value_id = params.without_term_value_id;
    let acc_above = params.acc_above;
    let acc_below = params.acc_below;
    let acc_below_or_unknown = params.acc_below_or_unknown;
    let d1 = params.d1;
    let d2 = params.d2;
    let created_d1 = params.created_d1;
    let created_d2 = params.created_d2;
    let created_on = params.created_on;
    let observed_on = params.observed_on;
    let unobserved_by_user_id = params.unobserved_by_user_id;
    let apply_project_rules_for = params.apply_project_rules_for;
    let cs = params.cs;
    let csa = params.csa;
    let csi = params.csi;
    let geoprivacy = params.geoprivacy;
    let taxon_geoprivacy = params.taxon_geoprivacy;
    let hrank = params.hrank;
    let lrank = params.lrank;
    let iconic_taxa = params.iconic_taxa;
    let id_above = params.id_above;
    let id_below = params.id_below;
    let identifications = params.identifications;
    let lat = params.lat;
    let lng = params.lng;
    let radius = params.radius;
    let nelat = params.nelat;
    let nelng = params.nelng;
    let swlat = params.swlat;
    let swlng = params.swlng;
    let list_id = params.list_id;
    let not_in_project = params.not_in_project;
    let not_matching_project_rules_for = params.not_matching_project_rules_for;
    let q = params.q;
    let search_on = params.search_on;
    let quality_grade = params.quality_grade;
    let updated_since = params.updated_since;
    let viewer_id = params.viewer_id;
    let reviewed = params.reviewed;
    let locale = params.locale;
    let preferred_place_id = params.preferred_place_id;
    let ttl = params.ttl;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations/observers", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = acc {
        local_var_req_builder = local_var_req_builder.query(&[("acc", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = captive {
        local_var_req_builder = local_var_req_builder.query(&[("captive", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = endemic {
        local_var_req_builder = local_var_req_builder.query(&[("endemic", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = geo {
        local_var_req_builder = local_var_req_builder.query(&[("geo", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_please {
        local_var_req_builder = local_var_req_builder.query(&[("id_please", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = identified {
        local_var_req_builder = local_var_req_builder.query(&[("identified", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = introduced {
        local_var_req_builder = local_var_req_builder.query(&[("introduced", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = mappable {
        local_var_req_builder = local_var_req_builder.query(&[("mappable", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = native {
        local_var_req_builder = local_var_req_builder.query(&[("native", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = out_of_range {
        local_var_req_builder = local_var_req_builder.query(&[("out_of_range", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = pcid {
        local_var_req_builder = local_var_req_builder.query(&[("pcid", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = photos {
        local_var_req_builder = local_var_req_builder.query(&[("photos", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = popular {
        local_var_req_builder = local_var_req_builder.query(&[("popular", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = sounds {
        local_var_req_builder = local_var_req_builder.query(&[("sounds", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = taxon_is_active {
        local_var_req_builder = local_var_req_builder.query(&[("taxon_is_active", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = threatened {
        local_var_req_builder = local_var_req_builder.query(&[("threatened", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = verifiable {
        local_var_req_builder = local_var_req_builder.query(&[("verifiable", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = licensed {
        local_var_req_builder = local_var_req_builder.query(&[("licensed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = photo_licensed {
        local_var_req_builder = local_var_req_builder.query(&[("photo_licensed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = not_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("not_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("not_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = ofv_datatype {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("ofv_datatype".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("ofv_datatype", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = photo_license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("photo_license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("photo_license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = place_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("place_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("place_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = project_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("project_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("project_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = rank {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("rank".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("rank", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = site_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("site_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("site_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = sound_license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("sound_license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("sound_license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = without_taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("without_taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("without_taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_name {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_name".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_name", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = user_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("user_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("user_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = user_login {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("user_login".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("user_login", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = ident_user_id {
        local_var_req_builder = local_var_req_builder.query(&[("ident_user_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = day {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("day".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("day", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = month {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("month".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("month", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = year {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("year".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("year", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = term_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("term_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("term_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = term_value_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("term_value_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("term_value_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = without_term_value_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("without_term_value_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("without_term_value_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = acc_above {
        local_var_req_builder = local_var_req_builder.query(&[("acc_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc_below {
        local_var_req_builder = local_var_req_builder.query(&[("acc_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc_below_or_unknown {
        local_var_req_builder = local_var_req_builder.query(&[("acc_below_or_unknown", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = d1 {
        local_var_req_builder = local_var_req_builder.query(&[("d1", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = d2 {
        local_var_req_builder = local_var_req_builder.query(&[("d2", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_d1 {
        local_var_req_builder = local_var_req_builder.query(&[("created_d1", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_d2 {
        local_var_req_builder = local_var_req_builder.query(&[("created_d2", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_on {
        local_var_req_builder = local_var_req_builder.query(&[("created_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = observed_on {
        local_var_req_builder = local_var_req_builder.query(&[("observed_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = unobserved_by_user_id {
        local_var_req_builder = local_var_req_builder.query(&[("unobserved_by_user_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = apply_project_rules_for {
        local_var_req_builder = local_var_req_builder.query(&[("apply_project_rules_for", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cs {
        local_var_req_builder = local_var_req_builder.query(&[("cs", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = csa {
        local_var_req_builder = local_var_req_builder.query(&[("csa", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = csi {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("csi".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("csi", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = geoprivacy {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("geoprivacy".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("geoprivacy", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_geoprivacy {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_geoprivacy".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_geoprivacy", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = hrank {
        local_var_req_builder = local_var_req_builder.query(&[("hrank", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lrank {
        local_var_req_builder = local_var_req_builder.query(&[("lrank", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = iconic_taxa {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("iconic_taxa".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("iconic_taxa", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = id_above {
        local_var_req_builder = local_var_req_builder.query(&[("id_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_below {
        local_var_req_builder = local_var_req_builder.query(&[("id_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = identifications {
        local_var_req_builder = local_var_req_builder.query(&[("identifications", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lat {
        local_var_req_builder = local_var_req_builder.query(&[("lat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lng {
        local_var_req_builder = local_var_req_builder.query(&[("lng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = radius {
        local_var_req_builder = local_var_req_builder.query(&[("radius", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = nelat {
        local_var_req_builder = local_var_req_builder.query(&[("nelat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = nelng {
        local_var_req_builder = local_var_req_builder.query(&[("nelng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = swlat {
        local_var_req_builder = local_var_req_builder.query(&[("swlat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = swlng {
        local_var_req_builder = local_var_req_builder.query(&[("swlng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = list_id {
        local_var_req_builder = local_var_req_builder.query(&[("list_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = not_in_project {
        local_var_req_builder = local_var_req_builder.query(&[("not_in_project", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = not_matching_project_rules_for {
        local_var_req_builder = local_var_req_builder.query(&[("not_matching_project_rules_for", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = q {
        local_var_req_builder = local_var_req_builder.query(&[("q", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = search_on {
        local_var_req_builder = local_var_req_builder.query(&[("search_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = quality_grade {
        local_var_req_builder = local_var_req_builder.query(&[("quality_grade", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = updated_since {
        local_var_req_builder = local_var_req_builder.query(&[("updated_since", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = viewer_id {
        local_var_req_builder = local_var_req_builder.query(&[("viewer_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = reviewed {
        local_var_req_builder = local_var_req_builder.query(&[("reviewed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = locale {
        local_var_req_builder = local_var_req_builder.query(&[("locale", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = preferred_place_id {
        local_var_req_builder = local_var_req_builder.query(&[("preferred_place_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = ttl {
        local_var_req_builder = local_var_req_builder.query(&[("ttl", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<ObservationsObserversGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Given zero to many of following parameters, returns an array of relevant controlled terms values and a monthly histogram 
pub async fn observations_popular_field_values_get(configuration: &configuration::Configuration, params: ObservationsPopularFieldValuesGetParams) -> Result<(), Error<ObservationsPopularFieldValuesGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let acc = params.acc;
    let captive = params.captive;
    let endemic = params.endemic;
    let geo = params.geo;
    let id_please = params.id_please;
    let identified = params.identified;
    let introduced = params.introduced;
    let mappable = params.mappable;
    let native = params.native;
    let out_of_range = params.out_of_range;
    let pcid = params.pcid;
    let photos = params.photos;
    let popular = params.popular;
    let sounds = params.sounds;
    let taxon_is_active = params.taxon_is_active;
    let threatened = params.threatened;
    let verifiable = params.verifiable;
    let licensed = params.licensed;
    let photo_licensed = params.photo_licensed;
    let id = params.id;
    let not_id = params.not_id;
    let license = params.license;
    let ofv_datatype = params.ofv_datatype;
    let photo_license = params.photo_license;
    let place_id = params.place_id;
    let project_id = params.project_id;
    let rank = params.rank;
    let site_id = params.site_id;
    let sound_license = params.sound_license;
    let taxon_id = params.taxon_id;
    let without_taxon_id = params.without_taxon_id;
    let taxon_name = params.taxon_name;
    let user_id = params.user_id;
    let user_login = params.user_login;
    let ident_user_id = params.ident_user_id;
    let day = params.day;
    let month = params.month;
    let year = params.year;
    let term_id = params.term_id;
    let term_value_id = params.term_value_id;
    let without_term_value_id = params.without_term_value_id;
    let acc_above = params.acc_above;
    let acc_below = params.acc_below;
    let acc_below_or_unknown = params.acc_below_or_unknown;
    let d1 = params.d1;
    let d2 = params.d2;
    let created_d1 = params.created_d1;
    let created_d2 = params.created_d2;
    let created_on = params.created_on;
    let observed_on = params.observed_on;
    let unobserved_by_user_id = params.unobserved_by_user_id;
    let apply_project_rules_for = params.apply_project_rules_for;
    let cs = params.cs;
    let csa = params.csa;
    let csi = params.csi;
    let geoprivacy = params.geoprivacy;
    let taxon_geoprivacy = params.taxon_geoprivacy;
    let hrank = params.hrank;
    let lrank = params.lrank;
    let iconic_taxa = params.iconic_taxa;
    let id_above = params.id_above;
    let id_below = params.id_below;
    let identifications = params.identifications;
    let lat = params.lat;
    let lng = params.lng;
    let radius = params.radius;
    let nelat = params.nelat;
    let nelng = params.nelng;
    let swlat = params.swlat;
    let swlng = params.swlng;
    let list_id = params.list_id;
    let not_in_project = params.not_in_project;
    let not_matching_project_rules_for = params.not_matching_project_rules_for;
    let q = params.q;
    let search_on = params.search_on;
    let quality_grade = params.quality_grade;
    let updated_since = params.updated_since;
    let viewer_id = params.viewer_id;
    let reviewed = params.reviewed;
    let locale = params.locale;
    let preferred_place_id = params.preferred_place_id;
    let ttl = params.ttl;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations/popular_field_values", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = acc {
        local_var_req_builder = local_var_req_builder.query(&[("acc", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = captive {
        local_var_req_builder = local_var_req_builder.query(&[("captive", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = endemic {
        local_var_req_builder = local_var_req_builder.query(&[("endemic", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = geo {
        local_var_req_builder = local_var_req_builder.query(&[("geo", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_please {
        local_var_req_builder = local_var_req_builder.query(&[("id_please", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = identified {
        local_var_req_builder = local_var_req_builder.query(&[("identified", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = introduced {
        local_var_req_builder = local_var_req_builder.query(&[("introduced", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = mappable {
        local_var_req_builder = local_var_req_builder.query(&[("mappable", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = native {
        local_var_req_builder = local_var_req_builder.query(&[("native", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = out_of_range {
        local_var_req_builder = local_var_req_builder.query(&[("out_of_range", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = pcid {
        local_var_req_builder = local_var_req_builder.query(&[("pcid", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = photos {
        local_var_req_builder = local_var_req_builder.query(&[("photos", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = popular {
        local_var_req_builder = local_var_req_builder.query(&[("popular", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = sounds {
        local_var_req_builder = local_var_req_builder.query(&[("sounds", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = taxon_is_active {
        local_var_req_builder = local_var_req_builder.query(&[("taxon_is_active", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = threatened {
        local_var_req_builder = local_var_req_builder.query(&[("threatened", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = verifiable {
        local_var_req_builder = local_var_req_builder.query(&[("verifiable", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = licensed {
        local_var_req_builder = local_var_req_builder.query(&[("licensed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = photo_licensed {
        local_var_req_builder = local_var_req_builder.query(&[("photo_licensed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = not_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("not_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("not_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = ofv_datatype {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("ofv_datatype".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("ofv_datatype", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = photo_license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("photo_license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("photo_license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = place_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("place_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("place_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = project_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("project_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("project_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = rank {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("rank".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("rank", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = site_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("site_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("site_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = sound_license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("sound_license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("sound_license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = without_taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("without_taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("without_taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_name {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_name".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_name", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = user_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("user_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("user_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = user_login {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("user_login".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("user_login", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = ident_user_id {
        local_var_req_builder = local_var_req_builder.query(&[("ident_user_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = day {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("day".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("day", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = month {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("month".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("month", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = year {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("year".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("year", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = term_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("term_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("term_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = term_value_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("term_value_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("term_value_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = without_term_value_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("without_term_value_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("without_term_value_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = acc_above {
        local_var_req_builder = local_var_req_builder.query(&[("acc_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc_below {
        local_var_req_builder = local_var_req_builder.query(&[("acc_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc_below_or_unknown {
        local_var_req_builder = local_var_req_builder.query(&[("acc_below_or_unknown", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = d1 {
        local_var_req_builder = local_var_req_builder.query(&[("d1", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = d2 {
        local_var_req_builder = local_var_req_builder.query(&[("d2", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_d1 {
        local_var_req_builder = local_var_req_builder.query(&[("created_d1", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_d2 {
        local_var_req_builder = local_var_req_builder.query(&[("created_d2", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_on {
        local_var_req_builder = local_var_req_builder.query(&[("created_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = observed_on {
        local_var_req_builder = local_var_req_builder.query(&[("observed_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = unobserved_by_user_id {
        local_var_req_builder = local_var_req_builder.query(&[("unobserved_by_user_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = apply_project_rules_for {
        local_var_req_builder = local_var_req_builder.query(&[("apply_project_rules_for", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cs {
        local_var_req_builder = local_var_req_builder.query(&[("cs", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = csa {
        local_var_req_builder = local_var_req_builder.query(&[("csa", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = csi {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("csi".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("csi", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = geoprivacy {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("geoprivacy".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("geoprivacy", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_geoprivacy {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_geoprivacy".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_geoprivacy", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = hrank {
        local_var_req_builder = local_var_req_builder.query(&[("hrank", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lrank {
        local_var_req_builder = local_var_req_builder.query(&[("lrank", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = iconic_taxa {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("iconic_taxa".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("iconic_taxa", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = id_above {
        local_var_req_builder = local_var_req_builder.query(&[("id_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_below {
        local_var_req_builder = local_var_req_builder.query(&[("id_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = identifications {
        local_var_req_builder = local_var_req_builder.query(&[("identifications", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lat {
        local_var_req_builder = local_var_req_builder.query(&[("lat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lng {
        local_var_req_builder = local_var_req_builder.query(&[("lng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = radius {
        local_var_req_builder = local_var_req_builder.query(&[("radius", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = nelat {
        local_var_req_builder = local_var_req_builder.query(&[("nelat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = nelng {
        local_var_req_builder = local_var_req_builder.query(&[("nelng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = swlat {
        local_var_req_builder = local_var_req_builder.query(&[("swlat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = swlng {
        local_var_req_builder = local_var_req_builder.query(&[("swlng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = list_id {
        local_var_req_builder = local_var_req_builder.query(&[("list_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = not_in_project {
        local_var_req_builder = local_var_req_builder.query(&[("not_in_project", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = not_matching_project_rules_for {
        local_var_req_builder = local_var_req_builder.query(&[("not_matching_project_rules_for", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = q {
        local_var_req_builder = local_var_req_builder.query(&[("q", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = search_on {
        local_var_req_builder = local_var_req_builder.query(&[("search_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = quality_grade {
        local_var_req_builder = local_var_req_builder.query(&[("quality_grade", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = updated_since {
        local_var_req_builder = local_var_req_builder.query(&[("updated_since", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = viewer_id {
        local_var_req_builder = local_var_req_builder.query(&[("viewer_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = reviewed {
        local_var_req_builder = local_var_req_builder.query(&[("reviewed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = locale {
        local_var_req_builder = local_var_req_builder.query(&[("locale", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = preferred_place_id {
        local_var_req_builder = local_var_req_builder.query(&[("preferred_place_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = ttl {
        local_var_req_builder = local_var_req_builder.query(&[("ttl", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<ObservationsPopularFieldValuesGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Create an observation 
pub async fn observations_post(configuration: &configuration::Configuration, params: ObservationsPostParams) -> Result<(), Error<ObservationsPostError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let body = params.body;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = local_var_configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("Authorization", local_var_value);
    };
    local_var_req_builder = local_var_req_builder.json(&body);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<ObservationsPostError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Given zero to many of following parameters, returns `leaf taxa` associated with observations matching the search criteria and the count of observations they are associated with, ordered by count descending. `Leaf taxa` are the leaves of the taxonomic tree containing only the taxa associated with observations matching the search criteria. 
pub async fn observations_species_counts_get(configuration: &configuration::Configuration, params: ObservationsSpeciesCountsGetParams) -> Result<crate::models::SpeciesCountsResponse, Error<ObservationsSpeciesCountsGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let acc = params.acc;
    let captive = params.captive;
    let endemic = params.endemic;
    let geo = params.geo;
    let id_please = params.id_please;
    let identified = params.identified;
    let introduced = params.introduced;
    let mappable = params.mappable;
    let native = params.native;
    let out_of_range = params.out_of_range;
    let pcid = params.pcid;
    let photos = params.photos;
    let popular = params.popular;
    let sounds = params.sounds;
    let taxon_is_active = params.taxon_is_active;
    let threatened = params.threatened;
    let verifiable = params.verifiable;
    let licensed = params.licensed;
    let photo_licensed = params.photo_licensed;
    let id = params.id;
    let not_id = params.not_id;
    let license = params.license;
    let ofv_datatype = params.ofv_datatype;
    let photo_license = params.photo_license;
    let place_id = params.place_id;
    let project_id = params.project_id;
    let rank = params.rank;
    let site_id = params.site_id;
    let sound_license = params.sound_license;
    let taxon_id = params.taxon_id;
    let without_taxon_id = params.without_taxon_id;
    let taxon_name = params.taxon_name;
    let user_id = params.user_id;
    let user_login = params.user_login;
    let ident_user_id = params.ident_user_id;
    let day = params.day;
    let month = params.month;
    let year = params.year;
    let term_id = params.term_id;
    let term_value_id = params.term_value_id;
    let without_term_value_id = params.without_term_value_id;
    let acc_above = params.acc_above;
    let acc_below = params.acc_below;
    let acc_below_or_unknown = params.acc_below_or_unknown;
    let d1 = params.d1;
    let d2 = params.d2;
    let created_d1 = params.created_d1;
    let created_d2 = params.created_d2;
    let created_on = params.created_on;
    let observed_on = params.observed_on;
    let unobserved_by_user_id = params.unobserved_by_user_id;
    let apply_project_rules_for = params.apply_project_rules_for;
    let cs = params.cs;
    let csa = params.csa;
    let csi = params.csi;
    let geoprivacy = params.geoprivacy;
    let taxon_geoprivacy = params.taxon_geoprivacy;
    let hrank = params.hrank;
    let lrank = params.lrank;
    let iconic_taxa = params.iconic_taxa;
    let id_above = params.id_above;
    let id_below = params.id_below;
    let identifications = params.identifications;
    let lat = params.lat;
    let lng = params.lng;
    let radius = params.radius;
    let nelat = params.nelat;
    let nelng = params.nelng;
    let swlat = params.swlat;
    let swlng = params.swlng;
    let list_id = params.list_id;
    let not_in_project = params.not_in_project;
    let not_matching_project_rules_for = params.not_matching_project_rules_for;
    let q = params.q;
    let search_on = params.search_on;
    let quality_grade = params.quality_grade;
    let updated_since = params.updated_since;
    let viewer_id = params.viewer_id;
    let reviewed = params.reviewed;
    let locale = params.locale;
    let preferred_place_id = params.preferred_place_id;
    let ttl = params.ttl;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations/species_counts", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = acc {
        local_var_req_builder = local_var_req_builder.query(&[("acc", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = captive {
        local_var_req_builder = local_var_req_builder.query(&[("captive", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = endemic {
        local_var_req_builder = local_var_req_builder.query(&[("endemic", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = geo {
        local_var_req_builder = local_var_req_builder.query(&[("geo", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_please {
        local_var_req_builder = local_var_req_builder.query(&[("id_please", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = identified {
        local_var_req_builder = local_var_req_builder.query(&[("identified", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = introduced {
        local_var_req_builder = local_var_req_builder.query(&[("introduced", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = mappable {
        local_var_req_builder = local_var_req_builder.query(&[("mappable", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = native {
        local_var_req_builder = local_var_req_builder.query(&[("native", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = out_of_range {
        local_var_req_builder = local_var_req_builder.query(&[("out_of_range", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = pcid {
        local_var_req_builder = local_var_req_builder.query(&[("pcid", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = photos {
        local_var_req_builder = local_var_req_builder.query(&[("photos", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = popular {
        local_var_req_builder = local_var_req_builder.query(&[("popular", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = sounds {
        local_var_req_builder = local_var_req_builder.query(&[("sounds", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = taxon_is_active {
        local_var_req_builder = local_var_req_builder.query(&[("taxon_is_active", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = threatened {
        local_var_req_builder = local_var_req_builder.query(&[("threatened", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = verifiable {
        local_var_req_builder = local_var_req_builder.query(&[("verifiable", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = licensed {
        local_var_req_builder = local_var_req_builder.query(&[("licensed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = photo_licensed {
        local_var_req_builder = local_var_req_builder.query(&[("photo_licensed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = not_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("not_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("not_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = ofv_datatype {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("ofv_datatype".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("ofv_datatype", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = photo_license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("photo_license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("photo_license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = place_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("place_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("place_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = project_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("project_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("project_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = rank {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("rank".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("rank", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = site_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("site_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("site_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = sound_license {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("sound_license".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("sound_license", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = without_taxon_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("without_taxon_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("without_taxon_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_name {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_name".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_name", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = user_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("user_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("user_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = user_login {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("user_login".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("user_login", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = ident_user_id {
        local_var_req_builder = local_var_req_builder.query(&[("ident_user_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = day {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("day".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("day", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = month {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("month".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("month", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = year {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("year".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("year", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = term_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("term_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("term_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = term_value_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("term_value_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("term_value_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = without_term_value_id {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("without_term_value_id".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("without_term_value_id", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = acc_above {
        local_var_req_builder = local_var_req_builder.query(&[("acc_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc_below {
        local_var_req_builder = local_var_req_builder.query(&[("acc_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = acc_below_or_unknown {
        local_var_req_builder = local_var_req_builder.query(&[("acc_below_or_unknown", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = d1 {
        local_var_req_builder = local_var_req_builder.query(&[("d1", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = d2 {
        local_var_req_builder = local_var_req_builder.query(&[("d2", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_d1 {
        local_var_req_builder = local_var_req_builder.query(&[("created_d1", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_d2 {
        local_var_req_builder = local_var_req_builder.query(&[("created_d2", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = created_on {
        local_var_req_builder = local_var_req_builder.query(&[("created_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = observed_on {
        local_var_req_builder = local_var_req_builder.query(&[("observed_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = unobserved_by_user_id {
        local_var_req_builder = local_var_req_builder.query(&[("unobserved_by_user_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = apply_project_rules_for {
        local_var_req_builder = local_var_req_builder.query(&[("apply_project_rules_for", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = cs {
        local_var_req_builder = local_var_req_builder.query(&[("cs", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = csa {
        local_var_req_builder = local_var_req_builder.query(&[("csa", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = csi {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("csi".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("csi", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = geoprivacy {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("geoprivacy".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("geoprivacy", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = taxon_geoprivacy {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("taxon_geoprivacy".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("taxon_geoprivacy", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = hrank {
        local_var_req_builder = local_var_req_builder.query(&[("hrank", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lrank {
        local_var_req_builder = local_var_req_builder.query(&[("lrank", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = iconic_taxa {
        local_var_req_builder = match "csv" {
            "multi" => local_var_req_builder.query(&local_var_str.into_iter().map(|p| ("iconic_taxa".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => local_var_req_builder.query(&[("iconic_taxa", &local_var_str.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref local_var_str) = id_above {
        local_var_req_builder = local_var_req_builder.query(&[("id_above", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = id_below {
        local_var_req_builder = local_var_req_builder.query(&[("id_below", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = identifications {
        local_var_req_builder = local_var_req_builder.query(&[("identifications", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lat {
        local_var_req_builder = local_var_req_builder.query(&[("lat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = lng {
        local_var_req_builder = local_var_req_builder.query(&[("lng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = radius {
        local_var_req_builder = local_var_req_builder.query(&[("radius", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = nelat {
        local_var_req_builder = local_var_req_builder.query(&[("nelat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = nelng {
        local_var_req_builder = local_var_req_builder.query(&[("nelng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = swlat {
        local_var_req_builder = local_var_req_builder.query(&[("swlat", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = swlng {
        local_var_req_builder = local_var_req_builder.query(&[("swlng", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = list_id {
        local_var_req_builder = local_var_req_builder.query(&[("list_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = not_in_project {
        local_var_req_builder = local_var_req_builder.query(&[("not_in_project", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = not_matching_project_rules_for {
        local_var_req_builder = local_var_req_builder.query(&[("not_matching_project_rules_for", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = q {
        local_var_req_builder = local_var_req_builder.query(&[("q", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = search_on {
        local_var_req_builder = local_var_req_builder.query(&[("search_on", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = quality_grade {
        local_var_req_builder = local_var_req_builder.query(&[("quality_grade", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = updated_since {
        local_var_req_builder = local_var_req_builder.query(&[("updated_since", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = viewer_id {
        local_var_req_builder = local_var_req_builder.query(&[("viewer_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = reviewed {
        local_var_req_builder = local_var_req_builder.query(&[("reviewed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = locale {
        local_var_req_builder = local_var_req_builder.query(&[("locale", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = preferred_place_id {
        local_var_req_builder = local_var_req_builder.query(&[("preferred_place_id", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = ttl {
        local_var_req_builder = local_var_req_builder.query(&[("ttl", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        serde_json::from_str(&local_var_content).map_err(Error::from)
    } else {
        let local_var_entity: Option<ObservationsSpeciesCountsGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Given zero to many of following parameters, returns an array of objects representing new comments and identifications on observations the authenticated user has subscribed to. Requires authentication 
pub async fn observations_updates_get(configuration: &configuration::Configuration, params: ObservationsUpdatesGetParams) -> Result<(), Error<ObservationsUpdatesGetError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let created_after = params.created_after;
    let viewed = params.viewed;
    let observations_by = params.observations_by;
    let page = params.page;
    let per_page = params.per_page;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/observations/updates", local_var_configuration.base_path);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::GET, local_var_uri_str.as_str());

    if let Some(ref local_var_str) = created_after {
        local_var_req_builder = local_var_req_builder.query(&[("created_after", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = viewed {
        local_var_req_builder = local_var_req_builder.query(&[("viewed", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = observations_by {
        local_var_req_builder = local_var_req_builder.query(&[("observations_by", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = page {
        local_var_req_builder = local_var_req_builder.query(&[("page", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_str) = per_page {
        local_var_req_builder = local_var_req_builder.query(&[("per_page", &local_var_str.to_string())]);
    }
    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = local_var_configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("Authorization", local_var_value);
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<ObservationsUpdatesGetError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Toggles current user's subscription to this observation. If the logged-in user is not subscribed, POSTing here will subscribe them. If they are already subscribed, this will remove the subscription 
pub async fn subscriptions_observation_id_subscribe_post(configuration: &configuration::Configuration, params: SubscriptionsObservationIdSubscribePostParams) -> Result<(), Error<SubscriptionsObservationIdSubscribePostError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/subscriptions/observation/{id}/subscribe", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = local_var_configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("Authorization", local_var_value);
    };

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<SubscriptionsObservationIdSubscribePostError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Remove a vote from an observation
pub async fn votes_unvote_observation_id_delete(configuration: &configuration::Configuration, params: VotesUnvoteObservationIdDeleteParams) -> Result<(), Error<VotesUnvoteObservationIdDeleteError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let body = params.body;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/votes/unvote/observation/{id}", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::DELETE, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = local_var_configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("Authorization", local_var_value);
    };
    local_var_req_builder = local_var_req_builder.json(&body);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<VotesUnvoteObservationIdDeleteError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

/// Vote on an observation. A vote with an empty `scope` is recorded as a `fave` of the observation. A vote with scope `needs_id` is recorded as a vote on the Quality Grade criterion \"can the Community ID still be confirmed or improved?\", and can be an up or down vote 
pub async fn votes_vote_observation_id_post(configuration: &configuration::Configuration, params: VotesVoteObservationIdPostParams) -> Result<(), Error<VotesVoteObservationIdPostError>> {
    let local_var_configuration = configuration;

    // unbox the parameters
    let id = params.id;
    let body = params.body;


    let local_var_client = &local_var_configuration.client;

    let local_var_uri_str = format!("{}/votes/vote/observation/{id}", local_var_configuration.base_path, id=id);
    let mut local_var_req_builder = local_var_client.request(reqwest::Method::POST, local_var_uri_str.as_str());

    if let Some(ref local_var_user_agent) = local_var_configuration.user_agent {
        local_var_req_builder = local_var_req_builder.header(reqwest::header::USER_AGENT, local_var_user_agent.clone());
    }
    if let Some(ref local_var_apikey) = local_var_configuration.api_key {
        let local_var_key = local_var_apikey.key.clone();
        let local_var_value = match local_var_apikey.prefix {
            Some(ref local_var_prefix) => format!("{} {}", local_var_prefix, local_var_key),
            None => local_var_key,
        };
        local_var_req_builder = local_var_req_builder.header("Authorization", local_var_value);
    };
    local_var_req_builder = local_var_req_builder.json(&body);

    let local_var_req = local_var_req_builder.build()?;
    let local_var_resp = local_var_client.execute(local_var_req).await?;

    let local_var_status = local_var_resp.status();
    let local_var_content = local_var_resp.text().await?;

    if !local_var_status.is_client_error() && !local_var_status.is_server_error() {
        Ok(())
    } else {
        let local_var_entity: Option<VotesVoteObservationIdPostError> = serde_json::from_str(&local_var_content).ok();
        let local_var_error = ResponseContent { status: local_var_status, content: local_var_content, entity: local_var_entity };
        Err(Error::ResponseError(local_var_error))
    }
}

