# Rust API client for inaturalist

# https://api.inaturalist.org/v1/

[iNaturalist](https://www.inaturalist.org/) is a global community of
naturalists, scientists, and members of the public sharing over a million
wildlife sightings to teach one another about the natural world while
creating high quality citizen science data for science and conservation.
The iNaturalist technology infrastructure and open source software is
administered by the
[California Academy of Sciences](https://www.calacademy.org/) as
part of their mission to explore, explain, and sustain life on Earth.

These API methods return data in JSON/JSONP and PNG response formats. They
are meant to supplement the existing [iNaturalist
API](https://www.inaturalist.org/pages/api+reference), implemented in Ruby
on Rails, which has more functionality and supports more write operations,
but tends to be slower and have less consistent response formats. Visit our
[developers page](https://www.inaturalist.org/pages/developers) for more
information. Write operations that expect and return JSON describe a single
`body` parameter that represents the request body, which should be specified
as JSON. See the \"Model\" of each body parameter for attributes that we
accept in these JSON objects.

Multiple values for a single URL parameter should be separated by commas,
e.g. `taxon_id=1,2,3`.

Map tiles are generated using the
[node-mapnik](https://github.com/mapnik/node-mapnik) library, following the
XYZ map tiling scheme. The \"Observation Tile\" methods accept nearly all the
parameters of the observation search APIs, and will generate map tiles
reflecting the same observations returned by searches. These
\"Observation Tile\" methods have corresponding
[UTFGrid](https://github.com/mapbox/utfgrid-spec) JSON
responses which return information needed to make interactive maps.

Authentication in the Node API is handled via JSON Web Tokens (JWT). To
obtain one, make an [OAuth-authenticated
request](http://www.inaturalist.org/pages/api+reference#auth) to
https://www.inaturalist.org/users/api_token. Each JWT will expire after 24
hours. Authentication required for all PUT and POST requests. Some GET
requests will also include private information like hidden coordinates if
the authenticated user has permission to view them.

iNaturalist Website: https://www.inaturalist.org/

Open Source Software: https://github.com/inaturalist/

## Terms of Use

Use of this API is subject to the iNaturalist
[Terms of Service](https://www.inaturalist.org/terms) and
[Privacy Policy](https://www.inaturalist.org/privacy). We will block any
use of our API that violates our Terms or Privacy Policy without notice.
The API is intended to support application development, not data scraping.
For pre- generated data exports, see
https://www.inaturalist.org/pages/developers.

Please note that we throttle API usage to a max of 100 requests per minute,
though we ask that you try to keep it to 60 requests per minute or lower,
and to keep under 10,000 requests per day. If we notice usage that has
serious impact on our performance we may institute blocks without
notification.

Terms of Service: https://www.inaturalist.org/terms

Privacy Policy: https://www.inaturalist.org/privacy



## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 1.3.0
- Package version: 0.1.0
- Build package: `org.openapitools.codegen.languages.RustClientCodegen`

## Installation

Put the package under your project folder in a directory named `inaturalist` and add the following to `Cargo.toml` under `[dependencies]`:

```
inaturalist = { path = "./inaturalist" }
```

## Documentation for API Endpoints

All URIs are relative to */v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AnnotationsApi* | [**annotations_id_delete**](docs/AnnotationsApi.md#annotations_id_delete) | **DELETE** /annotations/{id} | Annotation Delete
*AnnotationsApi* | [**annotations_post**](docs/AnnotationsApi.md#annotations_post) | **POST** /annotations | Annotation Create
*AnnotationsApi* | [**votes_unvote_annotation_id_delete**](docs/AnnotationsApi.md#votes_unvote_annotation_id_delete) | **DELETE** /votes/unvote/annotation/{id} | Annotation Unvote
*AnnotationsApi* | [**votes_vote_annotation_id_post**](docs/AnnotationsApi.md#votes_vote_annotation_id_post) | **POST** /votes/vote/annotation/{id} | Annotation Vote
*CommentsApi* | [**comments_id_delete**](docs/CommentsApi.md#comments_id_delete) | **DELETE** /comments/{id} | Comment Delete
*CommentsApi* | [**comments_id_put**](docs/CommentsApi.md#comments_id_put) | **PUT** /comments/{id} | Comment Update
*CommentsApi* | [**comments_post**](docs/CommentsApi.md#comments_post) | **POST** /comments | Comment Create
*ControlledTermsApi* | [**controlled_terms_for_taxon_get**](docs/ControlledTermsApi.md#controlled_terms_for_taxon_get) | **GET** /controlled_terms/for_taxon | Terms for Taxon
*ControlledTermsApi* | [**controlled_terms_get**](docs/ControlledTermsApi.md#controlled_terms_get) | **GET** /controlled_terms | Terms Index
*FlagsApi* | [**flags_id_delete**](docs/FlagsApi.md#flags_id_delete) | **DELETE** /flags/{id} | Flag Delete
*FlagsApi* | [**flags_id_put**](docs/FlagsApi.md#flags_id_put) | **PUT** /flags/{id} | Flag Update
*FlagsApi* | [**flags_post**](docs/FlagsApi.md#flags_post) | **POST** /flags | Flag Create
*IdentificationsApi* | [**identifications_categories_get**](docs/IdentificationsApi.md#identifications_categories_get) | **GET** /identifications/categories | Identification Categories
*IdentificationsApi* | [**identifications_get**](docs/IdentificationsApi.md#identifications_get) | **GET** /identifications | Identification Search
*IdentificationsApi* | [**identifications_id_delete**](docs/IdentificationsApi.md#identifications_id_delete) | **DELETE** /identifications/{id} | Identification Delete
*IdentificationsApi* | [**identifications_id_get**](docs/IdentificationsApi.md#identifications_id_get) | **GET** /identifications/{id} | Identification Details
*IdentificationsApi* | [**identifications_id_put**](docs/IdentificationsApi.md#identifications_id_put) | **PUT** /identifications/{id} | Identification Update
*IdentificationsApi* | [**identifications_identifiers_get**](docs/IdentificationsApi.md#identifications_identifiers_get) | **GET** /identifications/identifiers | Identification Identifiers
*IdentificationsApi* | [**identifications_observers_get**](docs/IdentificationsApi.md#identifications_observers_get) | **GET** /identifications/observers | Identification Observers
*IdentificationsApi* | [**identifications_post**](docs/IdentificationsApi.md#identifications_post) | **POST** /identifications | Identification Create
*IdentificationsApi* | [**identifications_recent_taxa_get**](docs/IdentificationsApi.md#identifications_recent_taxa_get) | **GET** /identifications/recent_taxa | Identification Recent Taxa
*IdentificationsApi* | [**identifications_similar_species_get**](docs/IdentificationsApi.md#identifications_similar_species_get) | **GET** /identifications/similar_species | Identification Similar Species
*IdentificationsApi* | [**identifications_species_counts_get**](docs/IdentificationsApi.md#identifications_species_counts_get) | **GET** /identifications/species_counts | Identification Species Counts
*MessagesApi* | [**messages_get**](docs/MessagesApi.md#messages_get) | **GET** /messages | Retrieve messages for the authenticated user. This does not mark them as read.
*MessagesApi* | [**messages_id_delete**](docs/MessagesApi.md#messages_id_delete) | **DELETE** /messages/{id} | Delete a message / thread
*MessagesApi* | [**messages_id_get**](docs/MessagesApi.md#messages_id_get) | **GET** /messages/{id} | Retrieve messages in a thread
*MessagesApi* | [**messages_post**](docs/MessagesApi.md#messages_post) | **POST** /messages | Create a new message
*MessagesApi* | [**messages_unread_get**](docs/MessagesApi.md#messages_unread_get) | **GET** /messages/unread | Gets a count of messages the authenticated user has not read
*ObservationFieldValuesApi* | [**observation_field_values_id_delete**](docs/ObservationFieldValuesApi.md#observation_field_values_id_delete) | **DELETE** /observation_field_values/{id} | Observation Field Value Delete
*ObservationFieldValuesApi* | [**observation_field_values_id_put**](docs/ObservationFieldValuesApi.md#observation_field_values_id_put) | **PUT** /observation_field_values/{id} | Observation Field Value Update
*ObservationFieldValuesApi* | [**observation_field_values_post**](docs/ObservationFieldValuesApi.md#observation_field_values_post) | **POST** /observation_field_values | Observation Field Value Create
*ObservationPhotosApi* | [**observation_photos_id_delete**](docs/ObservationPhotosApi.md#observation_photos_id_delete) | **DELETE** /observation_photos/{id} | Observation Photo Delete
*ObservationPhotosApi* | [**observation_photos_id_put**](docs/ObservationPhotosApi.md#observation_photos_id_put) | **PUT** /observation_photos/{id} | Observation Photo Update
*ObservationPhotosApi* | [**observation_photos_post**](docs/ObservationPhotosApi.md#observation_photos_post) | **POST** /observation_photos | Observation Photo Create
*ObservationTilesApi* | [**colored_heatmap_zoom_xy_png_get**](docs/ObservationTilesApi.md#colored_heatmap_zoom_xy_png_get) | **GET** /colored_heatmap/{zoom}/{x}/{y}.png | Colored Heatmap Tiles
*ObservationTilesApi* | [**grid_zoom_xy_png_get**](docs/ObservationTilesApi.md#grid_zoom_xy_png_get) | **GET** /grid/{zoom}/{x}/{y}.png | Grid Tiles
*ObservationTilesApi* | [**heatmap_zoom_xy_png_get**](docs/ObservationTilesApi.md#heatmap_zoom_xy_png_get) | **GET** /heatmap/{zoom}/{x}/{y}.png | Heatmap Tiles
*ObservationTilesApi* | [**points_zoom_xy_png_get**](docs/ObservationTilesApi.md#points_zoom_xy_png_get) | **GET** /points/{zoom}/{x}/{y}.png | Points Tiles
*ObservationsApi* | [**observations_deleted_get**](docs/ObservationsApi.md#observations_deleted_get) | **GET** /observations/deleted | Observations Deleted
*ObservationsApi* | [**observations_get**](docs/ObservationsApi.md#observations_get) | **GET** /observations | Observation Search
*ObservationsApi* | [**observations_histogram_get**](docs/ObservationsApi.md#observations_histogram_get) | **GET** /observations/histogram | Observation Histogram
*ObservationsApi* | [**observations_id_delete**](docs/ObservationsApi.md#observations_id_delete) | **DELETE** /observations/{id} | Observation Delete
*ObservationsApi* | [**observations_id_fave_post**](docs/ObservationsApi.md#observations_id_fave_post) | **POST** /observations/{id}/fave | Observations Fave
*ObservationsApi* | [**observations_id_get**](docs/ObservationsApi.md#observations_id_get) | **GET** /observations/{id} | Observation Details
*ObservationsApi* | [**observations_id_put**](docs/ObservationsApi.md#observations_id_put) | **PUT** /observations/{id} | Observation Update
*ObservationsApi* | [**observations_id_quality_metric_delete**](docs/ObservationsApi.md#observations_id_quality_metric_delete) | **DELETE** /observations/{id}/quality/{metric} | Quality Metric Delete
*ObservationsApi* | [**observations_id_quality_metric_post**](docs/ObservationsApi.md#observations_id_quality_metric_post) | **POST** /observations/{id}/quality/{metric} | Quality Metric Set
*ObservationsApi* | [**observations_id_review_post**](docs/ObservationsApi.md#observations_id_review_post) | **POST** /observations/{id}/review | Observations Review
*ObservationsApi* | [**observations_id_subscriptions_get**](docs/ObservationsApi.md#observations_id_subscriptions_get) | **GET** /observations/{id}/subscriptions | Observation Subscriptions
*ObservationsApi* | [**observations_id_taxon_summary_get**](docs/ObservationsApi.md#observations_id_taxon_summary_get) | **GET** /observations/{id}/taxon_summary | Observation Taxon Summary
*ObservationsApi* | [**observations_id_unfave_delete**](docs/ObservationsApi.md#observations_id_unfave_delete) | **DELETE** /observations/{id}/unfave | Observations Unfave
*ObservationsApi* | [**observations_id_unreview_post**](docs/ObservationsApi.md#observations_id_unreview_post) | **POST** /observations/{id}/unreview | Observations Unreview
*ObservationsApi* | [**observations_id_viewed_updates_put**](docs/ObservationsApi.md#observations_id_viewed_updates_put) | **PUT** /observations/{id}/viewed_updates | Observation Field Value Update
*ObservationsApi* | [**observations_identifiers_get**](docs/ObservationsApi.md#observations_identifiers_get) | **GET** /observations/identifiers | Observation Identifiers
*ObservationsApi* | [**observations_observers_get**](docs/ObservationsApi.md#observations_observers_get) | **GET** /observations/observers | Observation Observers
*ObservationsApi* | [**observations_popular_field_values_get**](docs/ObservationsApi.md#observations_popular_field_values_get) | **GET** /observations/popular_field_values | Observation Popular Field Values
*ObservationsApi* | [**observations_post**](docs/ObservationsApi.md#observations_post) | **POST** /observations | Observation Create
*ObservationsApi* | [**observations_species_counts_get**](docs/ObservationsApi.md#observations_species_counts_get) | **GET** /observations/species_counts | Observation Species Counts
*ObservationsApi* | [**observations_updates_get**](docs/ObservationsApi.md#observations_updates_get) | **GET** /observations/updates | Observation User Updates
*ObservationsApi* | [**subscriptions_observation_id_subscribe_post**](docs/ObservationsApi.md#subscriptions_observation_id_subscribe_post) | **POST** /subscriptions/observation/{id}/subscribe | Observation Subscribe
*ObservationsApi* | [**votes_unvote_observation_id_delete**](docs/ObservationsApi.md#votes_unvote_observation_id_delete) | **DELETE** /votes/unvote/observation/{id} | Observation Unvote
*ObservationsApi* | [**votes_vote_observation_id_post**](docs/ObservationsApi.md#votes_vote_observation_id_post) | **POST** /votes/vote/observation/{id} | Observation Vote
*PhotosApi* | [**photos_post**](docs/PhotosApi.md#photos_post) | **POST** /photos | Photo Create
*PlacesApi* | [**places_autocomplete_get**](docs/PlacesApi.md#places_autocomplete_get) | **GET** /places/autocomplete | Place Autocomplete
*PlacesApi* | [**places_id_get**](docs/PlacesApi.md#places_id_get) | **GET** /places/{id} | Place Details
*PlacesApi* | [**places_nearby_get**](docs/PlacesApi.md#places_nearby_get) | **GET** /places/nearby | Nearby Places
*PolygonTilesApi* | [**places_place_id_zoom_xy_png_get**](docs/PolygonTilesApi.md#places_place_id_zoom_xy_png_get) | **GET** /places/{place_id}/{zoom}/{x}/{y}.png | Place Tiles
*PolygonTilesApi* | [**taxon_places_taxon_id_zoom_xy_png_get**](docs/PolygonTilesApi.md#taxon_places_taxon_id_zoom_xy_png_get) | **GET** /taxon_places/{taxon_id}/{zoom}/{x}/{y}.png | Taxon Place Tiles
*PolygonTilesApi* | [**taxon_ranges_taxon_id_zoom_xy_png_get**](docs/PolygonTilesApi.md#taxon_ranges_taxon_id_zoom_xy_png_get) | **GET** /taxon_ranges/{taxon_id}/{zoom}/{x}/{y}.png | Taxon Range Tiles
*PostsApi* | [**posts_for_user_get**](docs/PostsApi.md#posts_for_user_get) | **GET** /posts/for_user | Posts For User
*PostsApi* | [**posts_get**](docs/PostsApi.md#posts_get) | **GET** /posts | Posts Search
*PostsApi* | [**posts_id_delete**](docs/PostsApi.md#posts_id_delete) | **DELETE** /posts/{id} | Post Delete
*PostsApi* | [**posts_id_put**](docs/PostsApi.md#posts_id_put) | **PUT** /posts/{id} | Post Update
*PostsApi* | [**posts_post**](docs/PostsApi.md#posts_post) | **POST** /posts | Post Create
*ProjectObservationsApi* | [**project_observations_id_delete**](docs/ProjectObservationsApi.md#project_observations_id_delete) | **DELETE** /project_observations/{id} | Project Observation Delete
*ProjectObservationsApi* | [**project_observations_id_put**](docs/ProjectObservationsApi.md#project_observations_id_put) | **PUT** /project_observations/{id} | Project Observation Update
*ProjectObservationsApi* | [**project_observations_post**](docs/ProjectObservationsApi.md#project_observations_post) | **POST** /project_observations | Project Observation Create
*ProjectsApi* | [**projects_autocomplete_get**](docs/ProjectsApi.md#projects_autocomplete_get) | **GET** /projects/autocomplete | Project Autocomplete
*ProjectsApi* | [**projects_get**](docs/ProjectsApi.md#projects_get) | **GET** /projects | Project Search
*ProjectsApi* | [**projects_id_add_post**](docs/ProjectsApi.md#projects_id_add_post) | **POST** /projects/{id}/add | Project Add
*ProjectsApi* | [**projects_id_get**](docs/ProjectsApi.md#projects_id_get) | **GET** /projects/{id} | Project Details
*ProjectsApi* | [**projects_id_join_post**](docs/ProjectsApi.md#projects_id_join_post) | **POST** /projects/{id}/join | Projects Join
*ProjectsApi* | [**projects_id_leave_delete**](docs/ProjectsApi.md#projects_id_leave_delete) | **DELETE** /projects/{id}/leave | Projects Leave
*ProjectsApi* | [**projects_id_members_get**](docs/ProjectsApi.md#projects_id_members_get) | **GET** /projects/{id}/members | Project Members
*ProjectsApi* | [**projects_id_membership_get**](docs/ProjectsApi.md#projects_id_membership_get) | **GET** /projects/{id}/membership | Membership of current user
*ProjectsApi* | [**projects_id_remove_delete**](docs/ProjectsApi.md#projects_id_remove_delete) | **DELETE** /projects/{id}/remove | Project Add
*ProjectsApi* | [**projects_id_subscriptions_get**](docs/ProjectsApi.md#projects_id_subscriptions_get) | **GET** /projects/{id}/subscriptions | Project Subscriptions
*ProjectsApi* | [**subscriptions_project_id_subscribe_post**](docs/ProjectsApi.md#subscriptions_project_id_subscribe_post) | **POST** /subscriptions/project/{id}/subscribe | Project Subscribe
*SearchApi* | [**search_get**](docs/SearchApi.md#search_get) | **GET** /search | Site Search
*TaxaApi* | [**taxa_autocomplete_get**](docs/TaxaApi.md#taxa_autocomplete_get) | **GET** /taxa/autocomplete | Taxon Autocomplete
*TaxaApi* | [**taxa_get**](docs/TaxaApi.md#taxa_get) | **GET** /taxa | Taxon Search
*TaxaApi* | [**taxa_id_get**](docs/TaxaApi.md#taxa_id_get) | **GET** /taxa/{id} | Taxon Details
*UTFGridApi* | [**colored_heatmap_zoom_xy_grid_json_get**](docs/UTFGridApi.md#colored_heatmap_zoom_xy_grid_json_get) | **GET** /colored_heatmap/{zoom}/{x}/{y}.grid.json | Colored Heatmap Tiles UTFGrid
*UTFGridApi* | [**grid_zoom_xy_grid_json_get**](docs/UTFGridApi.md#grid_zoom_xy_grid_json_get) | **GET** /grid/{zoom}/{x}/{y}.grid.json | Grid Tiles UTFGrid
*UTFGridApi* | [**heatmap_zoom_xy_grid_json_get**](docs/UTFGridApi.md#heatmap_zoom_xy_grid_json_get) | **GET** /heatmap/{zoom}/{x}/{y}.grid.json | Heatmap Tiles UTFGrid
*UTFGridApi* | [**points_zoom_xy_grid_json_get**](docs/UTFGridApi.md#points_zoom_xy_grid_json_get) | **GET** /points/{zoom}/{x}/{y}.grid.json | Points Tiles UTFGrid
*UsersApi* | [**users_autocomplete_get**](docs/UsersApi.md#users_autocomplete_get) | **GET** /users/autocomplete | User Autocomplete
*UsersApi* | [**users_id_get**](docs/UsersApi.md#users_id_get) | **GET** /users/{id} | User Details
*UsersApi* | [**users_id_mute_delete**](docs/UsersApi.md#users_id_mute_delete) | **DELETE** /users/{id}/mute | Unmute a User
*UsersApi* | [**users_id_mute_post**](docs/UsersApi.md#users_id_mute_post) | **POST** /users/{id}/mute | Mute a User
*UsersApi* | [**users_id_projects_get**](docs/UsersApi.md#users_id_projects_get) | **GET** /users/{id}/projects | User Projects
*UsersApi* | [**users_id_put**](docs/UsersApi.md#users_id_put) | **PUT** /users/{id} | User Update
*UsersApi* | [**users_me_get**](docs/UsersApi.md#users_me_get) | **GET** /users/me | Users Me
*UsersApi* | [**users_update_session_put**](docs/UsersApi.md#users_update_session_put) | **PUT** /users/update_session | User Update Session


## Documentation For Models

 - [AutocompleteTaxon](docs/AutocompleteTaxon.md)
 - [AutocompleteTaxonAllOf](docs/AutocompleteTaxonAllOf.md)
 - [BaseResponse](docs/BaseResponse.md)
 - [Color](docs/Color.md)
 - [Comment](docs/Comment.md)
 - [ConservationStatus](docs/ConservationStatus.md)
 - [CorePlace](docs/CorePlace.md)
 - [CoreTaxon](docs/CoreTaxon.md)
 - [DateDetails](docs/DateDetails.md)
 - [Error](docs/Error.md)
 - [EstablishmentMeans](docs/EstablishmentMeans.md)
 - [Fave](docs/Fave.md)
 - [FieldValue](docs/FieldValue.md)
 - [Identification](docs/Identification.md)
 - [IdentificationsResponse](docs/IdentificationsResponse.md)
 - [IdentificationsResponseAllOf](docs/IdentificationsResponseAllOf.md)
 - [Message](docs/Message.md)
 - [MessagesResponse](docs/MessagesResponse.md)
 - [MessagesResponseAllOf](docs/MessagesResponseAllOf.md)
 - [NearbyPlacesResponse](docs/NearbyPlacesResponse.md)
 - [NearbyPlacesResponseAllOf](docs/NearbyPlacesResponseAllOf.md)
 - [NearbyPlacesResponseAllOfResults](docs/NearbyPlacesResponseAllOfResults.md)
 - [NonOwnerIdentification](docs/NonOwnerIdentification.md)
 - [Observation](docs/Observation.md)
 - [ObservationTaxon](docs/ObservationTaxon.md)
 - [ObservationTaxonAllOf](docs/ObservationTaxonAllOf.md)
 - [ObservationsObserversResponse](docs/ObservationsObserversResponse.md)
 - [ObservationsObserversResponseAllOf](docs/ObservationsObserversResponseAllOf.md)
 - [ObservationsObserversResponseAllOfResults](docs/ObservationsObserversResponseAllOfResults.md)
 - [ObservationsResponse](docs/ObservationsResponse.md)
 - [ObservationsResponseAllOf](docs/ObservationsResponseAllOf.md)
 - [ObservationsShowResponse](docs/ObservationsShowResponse.md)
 - [ObservationsShowResponseAllOf](docs/ObservationsShowResponseAllOf.md)
 - [Photo](docs/Photo.md)
 - [PlacesResponse](docs/PlacesResponse.md)
 - [PlacesResponseAllOf](docs/PlacesResponseAllOf.md)
 - [PointGeoJson](docs/PointGeoJson.md)
 - [PolygonGeoJson](docs/PolygonGeoJson.md)
 - [PostAnnotation](docs/PostAnnotation.md)
 - [PostAnnotationAnnotation](docs/PostAnnotationAnnotation.md)
 - [PostComment](docs/PostComment.md)
 - [PostCommentComment](docs/PostCommentComment.md)
 - [PostFlag](docs/PostFlag.md)
 - [PostFlagFlag](docs/PostFlagFlag.md)
 - [PostIdentification](docs/PostIdentification.md)
 - [PostIdentificationIdentification](docs/PostIdentificationIdentification.md)
 - [PostMessage](docs/PostMessage.md)
 - [PostMessageMessage](docs/PostMessageMessage.md)
 - [PostObservation](docs/PostObservation.md)
 - [PostObservationFieldValue](docs/PostObservationFieldValue.md)
 - [PostObservationFieldValueObservationFieldValue](docs/PostObservationFieldValueObservationFieldValue.md)
 - [PostObservationObservation](docs/PostObservationObservation.md)
 - [PostObservationPhoto](docs/PostObservationPhoto.md)
 - [PostObservationPhotoObservationPhoto](docs/PostObservationPhotoObservationPhoto.md)
 - [PostObservationVote](docs/PostObservationVote.md)
 - [PostPost](docs/PostPost.md)
 - [PostPostPost](docs/PostPostPost.md)
 - [PostProjectAdd](docs/PostProjectAdd.md)
 - [PostProjectObservation](docs/PostProjectObservation.md)
 - [PostQuality](docs/PostQuality.md)
 - [PostUser](docs/PostUser.md)
 - [PostUserUpdateSession](docs/PostUserUpdateSession.md)
 - [PostUserUser](docs/PostUserUser.md)
 - [PostVote](docs/PostVote.md)
 - [Project](docs/Project.md)
 - [ProjectMember](docs/ProjectMember.md)
 - [ProjectMembersResponse](docs/ProjectMembersResponse.md)
 - [ProjectMembersResponseAllOf](docs/ProjectMembersResponseAllOf.md)
 - [ProjectsResponse](docs/ProjectsResponse.md)
 - [ProjectsResponseAllOf](docs/ProjectsResponseAllOf.md)
 - [PutFlag](docs/PutFlag.md)
 - [PutFlagFlag](docs/PutFlagFlag.md)
 - [RawConservationStatus](docs/RawConservationStatus.md)
 - [ShowObservation](docs/ShowObservation.md)
 - [ShowObservationAllOf](docs/ShowObservationAllOf.md)
 - [ShowPlace](docs/ShowPlace.md)
 - [ShowPlaceAllOf](docs/ShowPlaceAllOf.md)
 - [ShowTaxon](docs/ShowTaxon.md)
 - [ShowTaxonAllOf](docs/ShowTaxonAllOf.md)
 - [Sound](docs/Sound.md)
 - [SpeciesCountsResponse](docs/SpeciesCountsResponse.md)
 - [SpeciesCountsResponseAllOf](docs/SpeciesCountsResponseAllOf.md)
 - [SpeciesCountsResponseAllOfResults](docs/SpeciesCountsResponseAllOfResults.md)
 - [TaxaAutocompleteResponse](docs/TaxaAutocompleteResponse.md)
 - [TaxaAutocompleteResponseAllOf](docs/TaxaAutocompleteResponseAllOf.md)
 - [TaxaShowResponse](docs/TaxaShowResponse.md)
 - [TaxaShowResponseAllOf](docs/TaxaShowResponseAllOf.md)
 - [TaxonConservationStatus](docs/TaxonConservationStatus.md)
 - [TaxonConservationStatusAllOf](docs/TaxonConservationStatusAllOf.md)
 - [TaxonPhoto](docs/TaxonPhoto.md)
 - [TaxonPhotoAllOf](docs/TaxonPhotoAllOf.md)
 - [UpdateProjectObservation](docs/UpdateProjectObservation.md)
 - [UpdateProjectObservationProjectObservation](docs/UpdateProjectObservationProjectObservation.md)
 - [User](docs/User.md)
 - [UserCountsResponse](docs/UserCountsResponse.md)
 - [UserCountsResponseAllOf](docs/UserCountsResponseAllOf.md)
 - [UserCountsResponseAllOfResults](docs/UserCountsResponseAllOfResults.md)
 - [UtfGridResponse](docs/UtfGridResponse.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```

## Author



