/*
 *
 * Unit tests from FI_LIB version 1.2
 * (Original authors: Werner Hofschuster and Walter Kraemer)
 * converted into portable ITL format by Oliver Heimlich.
 *
 * Copyright 1997-2000 Institut fuer Wissenschaftliches Rechnen
 *                     und Mathematische Modellbildung (IWRMM)
 *                                      and
 *                     Institut fuer Angewandte Mathematik
 *                     Universitaet Karlsruhe, Germany
 * Copyright 2000-2005 Wiss. Rechnen/Softwaretechnologie
 *                     Universitaet Wuppertal, Germany
 * Copyright 2015-2016 Oliver Heimlich (oheim@posteo.de)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
//Language imports
#![rustfmt::skip]

//Test library imports

//Arithmetic library imports

//Preamble
use crate::*;
use inari::{DecInterval as DI, Decoration as D, Interval as I, Overlap as O};

#[test]
fn fi_lib_addii() {
    assert_eq2!(n2i(0.0, 0.0) + n2i(0.0, 0.0), n2i(0.0, 0.0));
    assert_eq2!(n2i(1.0, 1.0) + n2i(2.0, 2.0), n2i(3.0, 3.0));
    assert_eq2!(n2i(-1.0, -1.0) + n2i(-2.0, -2.0), n2i(-3.0, -3.0));
    assert_eq2!(n2i(1.0, 1.0) + n2i(-1.0, -1.0), n2i(0.0, 0.0));
    assert_eq2!(n2i(-1.0, -1.0) + n2i(1.0, 1.0), n2i(0.0, 0.0));
    assert_eq2!(n2i(1e-320, 1e-320) + n2i(1e-320, 1e-320), n2i(2e-320, 2e-320));
    assert_eq2!(n2i(1e-320, 1e-320) + n2i(1.0, 1.0), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-1e-320, -1e-320) + n2i(-1e-320, -1e-320), n2i(-2e-320, -2e-320));
    assert_eq2!(n2i(-1e-320, -1e-320) + n2i(1.0, 1.0), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(1.7976931348623157e+308, 1.7976931348623157e+308) + n2i(-1.0, -1.0), n2i(1.7976931348623155e+308, 1.7976931348623157e+308));
    assert_eq2!(n2i(-1.7976931348623157e+308, -1.7976931348623157e+308) + n2i(1.0, 1.0), n2i(-1.7976931348623157e+308, -1.7976931348623155e+308));
    assert_eq2!(n2i(0.0, 1.0) + n2i(1.0, 2.0), n2i(1.0, 3.0));
    assert_eq2!(n2i(1.0, 2.0) + n2i(0.0, 1.0), n2i(1.0, 3.0));
    assert_eq2!(n2i(1.0, 2.0) + n2i(3.0, 4.0), n2i(4.0, 6.0));
    assert_eq2!(n2i(3.0, 4.0) + n2i(1.0, 2.0), n2i(4.0, 6.0));
    assert_eq2!(n2i(-1.0, 0.0) + n2i(-4.0, -3.0), n2i(-5.0, -3.0));
    assert_eq2!(n2i(-4.0, -3.0) + n2i(-1.0, 0.0), n2i(-5.0, -3.0));
    assert_eq2!(n2i(-5.0, -4.0) + n2i(4.0, 5.0), n2i(-1.0, 1.0));
    assert_eq2!(n2i(4.0, 5.0) + n2i(-5.0, -4.0), n2i(-1.0, 1.0));
}

#[test]
fn fi_lib_subii() {
    assert_eq2!(n2i(0.0, 0.0) - n2i(0.0, 0.0), n2i(0.0, 0.0));
    assert_eq2!(n2i(1.0, 1.0) - n2i(2.0, 2.0), n2i(-1.0, -1.0));
    assert_eq2!(n2i(-1.0, -1.0) - n2i(-2.0, -2.0), n2i(1.0, 1.0));
    assert_eq2!(n2i(1.0, 1.0) - n2i(-1.0, -1.0), n2i(2.0, 2.0));
    assert_eq2!(n2i(-1.0, -1.0) - n2i(1.0, 1.0), n2i(-2.0, -2.0));
    assert_eq2!(n2i(1e-320, 1e-320) - n2i(1e-320, 1e-320), n2i(0.0, 0.0));
    assert_eq2!(n2i(1e-320, 1e-320) - n2i(1.0, 1.0), n2i(-1.0, -0.9999999999999999));
    assert_eq2!(n2i(-1e-320, -1e-320) - n2i(-1e-320, -1e-320), n2i(0.0, 0.0));
    assert_eq2!(n2i(-1e-320, -1e-320) - n2i(1.0, 1.0), n2i(-1.0000000000000002, -1.0));
    assert_eq2!(n2i(1.7976931348623157e+308, 1.7976931348623157e+308) - n2i(1.0, 1.0), n2i(1.7976931348623155e+308, 1.7976931348623157e+308));
    assert_eq2!(n2i(-1.7976931348623157e+308, -1.7976931348623157e+308) - n2i(-1.0, -1.0), n2i(-1.7976931348623157e+308, -1.7976931348623155e+308));
    assert_eq2!(n2i(0.0, 1.0) - n2i(1.0, 2.0), n2i(-2.0, 0.0));
    assert_eq2!(n2i(1.0, 2.0) - n2i(0.0, 1.0), n2i(0.0, 2.0));
    assert_eq2!(n2i(1.0, 2.0) - n2i(3.0, 4.0), n2i(-3.0, -1.0));
    assert_eq2!(n2i(3.0, 4.0) - n2i(1.0, 2.0), n2i(1.0, 3.0));
    assert_eq2!(n2i(-1.0, 0.0) - n2i(-4.0, -3.0), n2i(2.0, 4.0));
    assert_eq2!(n2i(-4.0, -3.0) - n2i(-1.0, 0.0), n2i(-4.0, -2.0));
    assert_eq2!(n2i(-5.0, -4.0) - n2i(4.0, 5.0), n2i(-10.0, -8.0));
    assert_eq2!(n2i(4.0, 5.0) - n2i(-5.0, -4.0), n2i(8.0, 10.0));
}

#[test]
fn fi_lib_mulii() {
    assert_eq2!(n2i(0.0, 0.0) * n2i(0.0, 0.0), n2i(0.0, 0.0));
    assert_eq2!(n2i(-1.0, -1.0) * n2i(-1.0, -1.0), n2i(1.0, 1.0));
    assert_eq2!(n2i(-1.0, -1.0) * n2i(0.0, 0.0), n2i(0.0, 0.0));
    assert_eq2!(n2i(-1.0, -1.0) * n2i(1.0, 1.0), n2i(-1.0, -1.0));
    assert_eq2!(n2i(0.0, 0.0) * n2i(-1.0, -1.0), n2i(0.0, 0.0));
    assert_eq2!(n2i(0.0, 0.0) * n2i(1.0, 1.0), n2i(0.0, 0.0));
    assert_eq2!(n2i(1.0, 1.0) * n2i(-1.0, -1.0), n2i(-1.0, -1.0));
    assert_eq2!(n2i(1.0, 1.0) * n2i(0.0, 0.0), n2i(0.0, 0.0));
    assert_eq2!(n2i(1.0, 1.0) * n2i(1.0, 1.0), n2i(1.0, 1.0));
    assert_eq2!(n2i(1.7976931348623157e+308, 1.7976931348623157e+308) * n2i(0.5, 0.5), n2i(8.988465674311579e+307, 8.988465674311579e+307));
    assert_eq2!(n2i(-1.7976931348623157e+308, -1.7976931348623157e+308) * n2i(0.5, 0.5), n2i(-8.988465674311579e+307, -8.988465674311579e+307));
    assert_eq2!(n2i(1e-320, 1e-320) * n2i(1e-320, 1e-320), n2i(0.0, 5e-324));
    assert_eq2!(n2i(1e-320, 1e-320) * n2i(1.0, 1.0), n2i(1e-320, 1e-320));
    assert_eq2!(n2i(1e-320, 1e-320) * n2i(-1.0, -1.0), n2i(-1e-320, -1e-320));
    assert_eq2!(n2i(-3.0, -2.0) * n2i(-3.0, -2.0), n2i(4.0, 9.0));
    assert_eq2!(n2i(-3.0, -2.0) * n2i(-1.0, 1.0), n2i(-3.0, 3.0));
    assert_eq2!(n2i(-3.0, -2.0) * n2i(2.0, 3.0), n2i(-9.0, -4.0));
    assert_eq2!(n2i(-1.0, 1.0) * n2i(-3.0, -2.0), n2i(-3.0, 3.0));
    assert_eq2!(n2i(-1.0, 1.0) * n2i(-1.0, 1.0), n2i(-1.0, 1.0));
    assert_eq2!(n2i(-1.0, 1.0) * n2i(2.0, 3.0), n2i(-3.0, 3.0));
    assert_eq2!(n2i(2.0, 3.0) * n2i(-3.0, -2.0), n2i(-9.0, -4.0));
    assert_eq2!(n2i(2.0, 3.0) * n2i(-1.0, 1.0), n2i(-3.0, 3.0));
    assert_eq2!(n2i(2.0, 3.0) * n2i(2.0, 3.0), n2i(4.0, 9.0));
    assert_eq2!(n2i(-5.0, 2.0) * n2i(-4.0, 3.0), n2i(-15.0, 20.0));
    assert_eq2!(n2i(-5.0, 2.0) * n2i(-3.0, 8.0), n2i(-40.0, 16.0));
    assert_eq2!(n2i(-2.0, 5.0) * n2i(-4.0, 3.0), n2i(-20.0, 15.0));
    assert_eq2!(n2i(-4.0, 5.0) * n2i(-4.0, 3.0), n2i(-20.0, 16.0));
    assert_eq2!(n2i(-3.0, 0.0) * n2i(-3.0, -2.0), n2i(0.0, 9.0));
    assert_eq2!(n2i(-3.0, 0.0) * n2i(-1.0, 1.0), n2i(-3.0, 3.0));
    assert_eq2!(n2i(-3.0, 0.0) * n2i(2.0, 3.0), n2i(-9.0, 0.0));
    assert_eq2!(n2i(-3.0, -2.0) * n2i(-3.0, 0.0), n2i(0.0, 9.0));
    assert_eq2!(n2i(-3.0, -2.0) * n2i(0.0, 3.0), n2i(-9.0, 0.0));
    assert_eq2!(n2i(-1.0, 1.0) * n2i(-3.0, 0.0), n2i(-3.0, 3.0));
    assert_eq2!(n2i(-1.0, 1.0) * n2i(0.0, 3.0), n2i(-3.0, 3.0));
    assert_eq2!(n2i(0.0, 3.0) * n2i(-3.0, -2.0), n2i(-9.0, 0.0));
    assert_eq2!(n2i(0.0, 3.0) * n2i(-1.0, 1.0), n2i(-3.0, 3.0));
    assert_eq2!(n2i(0.0, 3.0) * n2i(2.0, 3.0), n2i(0.0, 9.0));
    assert_eq2!(n2i(2.0, 3.0) * n2i(-3.0, 0.0), n2i(-9.0, 0.0));
    assert_eq2!(n2i(2.0, 3.0) * n2i(-3.0, 0.0), n2i(-9.0, 0.0));
    assert_eq2!(n2i(0.0, 2.0) * n2i(-3.0, 0.0), n2i(-6.0, 0.0));
    assert_eq2!(n2i(-1e-320, -1e-320) * n2i(-1e-320, -1e-320), n2i(0.0, 5e-324));
    assert_eq2!(n2i(-1e-320, -1e-320) * n2i(1.0, 1.0), n2i(-1e-320, -1e-320));
    assert_eq2!(n2i(-1e-320, -1e-320) * n2i(-1.0, -1.0), n2i(1e-320, 1e-320));
    assert_eq2!(n2i(-1e-320, -1e-320) * n2i(1e-320, 1e-320), n2i(-5e-324, 0.0));
    assert_eq2!(n2i(-1e-320, -1e-320) * n2i(0.0, 0.0), n2i(0.0, 0.0));
    assert_eq2!(n2i(1e-320, 1e-320) * n2i(0.0, 0.0), n2i(0.0, 0.0));
}

#[test]
fn fi_lib_divii() {
    assert_eq2!(n2i(-1.0, -1.0) / n2i(-1.0, -1.0), n2i(1.0, 1.0));
    assert_eq2!(n2i(-1.0, -1.0) / n2i(1.0, 1.0), n2i(-1.0, -1.0));
    assert_eq2!(n2i(0.0, 0.0) / n2i(-1.0, -1.0), n2i(0.0, 0.0));
    assert_eq2!(n2i(0.0, 0.0) / n2i(1.0, 1.0), n2i(0.0, 0.0));
    assert_eq2!(n2i(1.0, 1.0) / n2i(-1.0, -1.0), n2i(-1.0, -1.0));
    assert_eq2!(n2i(1.0, 1.0) / n2i(1.0, 1.0), n2i(1.0, 1.0));
    assert_eq2!(n2i(1.7976931348623157e+308, 1.7976931348623157e+308) / n2i(2.0, 2.0), n2i(8.988465674311579e+307, 8.988465674311579e+307));
    assert_eq2!(n2i(-1.7976931348623157e+308, -1.7976931348623157e+308) / n2i(2.0, 2.0), n2i(-8.988465674311579e+307, -8.988465674311579e+307));
    assert_eq2!(n2i(1e-320, 1e-320) / n2i(1e-320, 1e-320), n2i(1.0, 1.0));
    assert_eq2!(n2i(1e-320, 1e-320) / n2i(1.0, 1.0), n2i(1e-320, 1e-320));
    assert_eq2!(n2i(1e-320, 1e-320) / n2i(-1.0, -1.0), n2i(-1e-320, -1e-320));
    assert_eq2!(n2i(-3.0, -2.0) / n2i(-3.0, -2.0), n2i(0.6666666666666666, 1.5));
    assert_eq2!(n2i(-3.0, -2.0) / n2i(2.0, 3.0), n2i(-1.5, -0.6666666666666666));
    assert_eq2!(n2i(-1.0, 1.0) / n2i(-3.0, -2.0), n2i(-0.5, 0.5));
    assert_eq2!(n2i(-1.0, 1.0) / n2i(2.0, 3.0), n2i(-0.5, 0.5));
    assert_eq2!(n2i(2.0, 3.0) / n2i(-3.0, -2.0), n2i(-1.5, -0.6666666666666666));
    assert_eq2!(n2i(2.0, 3.0) / n2i(2.0, 3.0), n2i(0.6666666666666666, 1.5));
    assert_eq2!(n2i(-3.0, 0.0) / n2i(-3.0, -2.0), n2i(0.0, 1.5));
    assert_eq2!(n2i(-3.0, 0.0) / n2i(2.0, 3.0), n2i(-1.5, 0.0));
    assert_eq2!(n2i(0.0, 3.0) / n2i(-3.0, -2.0), n2i(-1.5, 0.0));
    assert_eq2!(n2i(0.0, 3.0) / n2i(2.0, 3.0), n2i(0.0, 1.5));
}

#[cfg(feature = "gmp")]
#[test]
fn fi_lib_unary_functions_gmp() {
    assert_eq2!(n2i(-5.654676730021286e+33, -2.467054147405824e-70).exp(), n2i(0.0, 1.0));
    assert_eq2!(n2i(-1.3399884870763106e-66, -3.142176739251406e-153).exp(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-1.5597455265844553e+82, -8.494812002392629e-61).exp(), n2i(0.0, 1.0));
    assert_eq2!(n2i(-1.215647583031333e-125, -2.1463635439861205e-137).exp(), n2i(0.9999999999999999, 1.0));
    //exp [-0X6.FF424CB26239CP+292, -0X2.89F6682121BA8P+252] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
    assert_eq2!(n2i(-7.439842988767637e+100, -1.7691706606766744).exp(), n2i(0.0, 0.17047431126513002));
    assert_eq2!(n2i(-7.499234869798134e+71, -1.7403411180886717e-132).exp(), n2i(0.0, 1.0));
    assert_eq2!(n2i(-2.9324066544090417e+52, -5.3524819746577617e-104).exp(), n2i(0.0, 1.0));
    assert_eq2!(n2i(-5.017847776764404e-87, -2.227977792271395e-227).exp(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-1.827668734769395e-22, -1.3261758590671888e-169).exp(), n2i(0.9999999999999999, 1.0));
    //exp [-0X1.582D3AFB2C63DP+312, -0X5.08DC843E57ED4P+180] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
    assert_eq2!(n2i(-5.423963041733561e+77, -2.0593050880629278e-14).exp(), n2i(0.0, 0.9999999999999795));
    assert_eq2!(n2i(-3.360610542799653e+197, -587.4775479904158).exp(), n2i(0.0, 7.273486979199257e-256));
    //exp [-0X3.2FD3FDE325402P+688, -0X2.738623C238270P+48] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
    assert_eq2!(n2i(-324.94560707197695, -3.9159391610352426e-52).exp(), n2i(7.549460722130908e-142, 1.0));
    assert_eq2!(n2i(-6.756234292039407e+297, -1.2326806901455692e-163).exp(), n2i(0.0, 1.0));
    assert_eq2!(n2i(-3.7684325044819983e-45, -1.4254487154939715e-132).exp(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-6.868984884638794e+105, -1.1245455425372901e-153).exp(), n2i(0.0, 1.0));
    //exp [-0XD.F2552B8F60978P+236, -0X7.FBDBC320979A4P+188] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
    assert_eq2!(n2i(-4.825221040561268e-72, -3.741418656433786e-95).exp(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(1.0, 2.0).exp(), n2i(2.718281828459045, 7.38905609893065));
    assert_eq2!(n2i(-1.0, 2.0).exp(), n2i(0.3678794411714423, 7.38905609893065));
    assert_eq2!(n2i(-5.0, -3.0).exp(), n2i(0.006737946999085467, 0.049787068367863944));
    assert_eq2!(n2i(-2.0, 0.6).exp(), n2i(0.13533528323661267, 1.822118800390509));
    assert_eq2!(n2i(5e-324, 5.52603e-318).exp(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(2.1586e-320, 1.0).exp(), n2i(1.0, 2.7182818284590455));
    assert_eq2!(n2i(-3.45377e-319, 3.45377e-319).exp(), n2i(0.9999999999999999, 1.0000000000000002));
    assert_eq2!(n2i(-1.35e-321, 1.999755859375).exp(), n2i(0.9999999999999999, 7.38725235034961));
    assert_eq2!(n2i(-1.9999847412109375, -1.7683298e-316).exp(), n2i(0.13533734830490748, 1.0));
    assert_eq2!(n2i(-1.9999999962747097, 4.6689455016e-314).exp(), n2i(0.13533528374077589, 1.0000000000000002));
    assert_eq2!(n2i(-5.654676730021286e+33, -2.467054147405824e-70).exp2(), n2i(0.0, 1.0));
    assert_eq2!(n2i(-1.3399884870763106e-66, -3.142176739251406e-153).exp2(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-1.5597455265844553e+82, -8.494812002392629e-61).exp2(), n2i(0.0, 1.0));
    assert_eq2!(n2i(-1.215647583031333e-125, -2.1463635439861205e-137).exp2(), n2i(0.9999999999999999, 1.0));
    //exp2 [-0X6.FF424CB26239CP+292, -0X2.89F6682121BA8P+252] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
    assert_eq2!(n2i(-7.439842988767637e+100, -1.7691706606766744).exp2(), n2i(0.0, 0.2933773380418803));
    assert_eq2!(n2i(-7.499234869798134e+71, -1.7403411180886717e-132).exp2(), n2i(0.0, 1.0));
    assert_eq2!(n2i(-2.9324066544090417e+52, -5.3524819746577617e-104).exp2(), n2i(0.0, 1.0));
    assert_eq2!(n2i(-5.017847776764404e-87, -2.227977792271395e-227).exp2(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-1.827668734769395e-22, -1.3261758590671888e-169).exp2(), n2i(0.9999999999999999, 1.0));
    //exp2 [-0X1.582D3AFB2C63DP+312, -0X5.08DC843E57ED4P+180] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
    assert_eq2!(n2i(-5.423963041733561e+77, -2.0593050880629278e-14).exp2(), n2i(0.0, 0.9999999999999858));
    assert_eq2!(n2i(-3.360610542799653e+197, -587.4775479904158).exp2(), n2i(0.0, 1.4178695500142108e-177));
    //exp2 [-0X3.2FD3FDE325402P+688, -0X2.738623C238270P+48] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
    assert_eq2!(n2i(-324.94560707197695, -3.9159391610352426e-52).exp2(), n2i(1.5192362418900192e-98, 1.0));
    assert_eq2!(n2i(-6.756234292039407e+297, -1.2326806901455692e-163).exp2(), n2i(0.0, 1.0));
    assert_eq2!(n2i(-3.7684325044819983e-45, -1.4254487154939715e-132).exp2(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-6.868984884638794e+105, -1.1245455425372901e-153).exp2(), n2i(0.0, 1.0));
    //exp2 [-0XD.F2552B8F60978P+236, -0X7.FBDBC320979A4P+188] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
    assert_eq2!(n2i(-4.825221040561268e-72, -3.741418656433786e-95).exp2(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(1.0, 2.0).exp2(), n2i(2.0, 4.0));
    assert_eq2!(n2i(-1.0, 2.0).exp2(), n2i(0.5, 4.0));
    assert_eq2!(n2i(-5.0, -3.0).exp2(), n2i(0.03125, 0.125));
    assert_eq2!(n2i(-2.0, 0.6).exp2(), n2i(0.25, 1.5157165665103982));
    assert_eq2!(n2i(1.35e-321, 8.8783537e-317).exp2(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-3.8629678793e-313, 1.508953107e-315).exp2(), n2i(0.9999999999999999, 1.0000000000000002));
    assert_eq2!(n2i(6.9141719123e-314, 1.000000194699775).exp2(), n2i(1.0, 2.0000002699112187));
    assert_eq2!(n2i(-1.110510763557e-312, 1.50897191e-315).exp2(), n2i(0.9999999999999999, 1.0000000000000002));
    assert_eq2!(n2i(-1.50897478e-315, 1.9999999426305293).exp2(), n2i(0.9999999999999999, 3.999999840938056));
    assert_eq2!(n2i(-1.9999999999999998, 9.1770835183e-314).exp2(), n2i(0.25, 1.0000000000000002));
    assert_eq2!(n2i(-1.3068822821215125e+34, -2.1420516689865724e-70).exp10(), n2i(0.0, 1.0));
    assert_eq2!(n2i(-3.574174482995173e-66, -4.50261252376323e-153).exp10(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-1.97728388112021e+82, -5.495270555084999e-61).exp10(), n2i(0.0, 1.0));
    assert_eq2!(n2i(-6.394132238750146e-126, -1.0903261744152942e-137).exp10(), n2i(0.9999999999999999, 1.0));
    //exp10 [-0X2.7C064F6929234P+292, -0X1.5444E676976F1P+252] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
    assert_eq2!(n2i(-4.3086666028997115e+100, -1.2265863637939853).exp10(), n2i(0.0, 0.05934903149808178));
    assert_eq2!(n2i(-7.949640211843925e+71, -7.92893550594856e-133).exp10(), n2i(0.0, 1.0));
    assert_eq2!(n2i(-3.7844471473955087e+52, -3.8765049524470155e-104).exp10(), n2i(0.0, 1.0));
    assert_eq2!(n2i(-2.5247955982030513e-87, -1.735629038886541e-227).exp10(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-5.840571936196233e-23, -1.2372972348014194e-169).exp10(), n2i(0.9999999999999999, 1.0));
    //exp10 [-0X1.F0D19ADCB5D74P+312, -0X1.BA04D452BBB35P+180] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
    assert_eq2!(n2i(-3.330274496326269e+77, -8.58666888503976e-15).exp10(), n2i(0.0, 0.9999999999999802));
    assert_eq2!(n2i(-2.6540761105245153e+197, -2089.4789112580042).exp10(), n2i(0.0, 5e-324));
    //exp10 [-0X2.A69A969772FDEP+688, -0X3.436DFE8F08194P+48] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
    assert_eq2!(n2i(-378.66439698572424, -1.04297065349669e-51).exp10(), n2i(0.0, 1.0));
    assert_eq2!(n2i(-6.699078654119897e+297, -1.159254403776913e-163).exp10(), n2i(0.0, 1.0));
    assert_eq2!(n2i(-7.532163773886163e-45, -9.6216669723908e-133).exp10(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-1.4853687335806818e+106, -9.139956432627538e-154).exp10(), n2i(0.0, 1.0));
    //exp10 [-0XD.5E2045CEE9720P+236, -0X6.6978492A3064CP+188] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
    assert_eq2!(n2i(-1.2304282748741674e-71, -5.894957732633466e-95).exp10(), n2i(0.9999999999999999, 1.0));
    //exp10 [-0XB.A944253373080P+564, -0XD.05E9CCF66CF58P+424] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
    assert_eq2!(n2i(-1.3769044122288282e+51, -8.878766165166294e-17).exp10(), n2i(0.0, 0.9999999999999999));
    assert_eq2!(n2i(-3.4406801604078773e-20, -1.4424839590411552e-103).exp10(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-7528.651283167651, -5.626945812397601e-71).exp10(), n2i(0.0, 1.0));
    assert_eq2!(n2i(-8.697059728957017e+39, -6.14458190526497e-145).exp10(), n2i(0.0, 1.0));
    assert_eq2!(n2i(-2.9520692024476596e+66, -1.1630464890098972e-57).exp10(), n2i(0.0, 1.0));
    assert_eq2!(n2i(-4.9971841742702367e-42, -7.34011947060184e-203).exp10(), n2i(0.9999999999999999, 1.0));
    //exp10 [-0XB.24D19E00C8460P+324, -0X1.D283CF8F05665P+252] = [0X0.0000000000000P+0, 0X0.0000000000000P+0];
    assert_eq2!(n2i(-1.8453138582390658e+196, -1.0617572270683382e-97).exp10(), n2i(0.0, 1.0));
    assert_eq2!(n2i(-4.488799649180782e-36, -7.269525029365293e-38).exp10(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(4.14742026137149e-79, 5.379571027897612e+28).ln(), n2i(-180.4817358293411, 66.15499124023648));
    assert_eq2!(n2i(1.1108806461872243e-155, 2.373351651082585e-67).ln(), n2i(-356.79553633836497, -153.40889807572228));
    assert_eq2!(n2i(5.129079157666995e-72, 1.7510703625318296e+71).ln(), n2i(-164.15120055393038, 164.04376883927225));
    assert_eq2!(n2i(6.948997631311531e-148, 2.9283016466945798e-136).ln(), n2i(-338.8439963396542, -312.0771500349854));
    assert_eq2!(n2i(1.2289762226241382e+59, 2.234162998792154e+68).ln(), n2i(136.05870197011632, 157.37965298433434));
    assert_eq2!(n2i(3.7658819597444687e-13, 4.2821276071749897e+83).ln(), n2i(-28.607624122847348, 192.56901270906414));
    assert_eq2!(n2i(6.336975772360046e-144, 9.158993707856366e+59).ln(), n2i(-329.72585174401195, 138.06725680207907));
    assert_eq2!(n2i(5.364761505213512e-113, 4.082352475280499e+42).ln(), n2i(-258.5122635870605, 98.11524731508209));
    assert_eq2!(n2i(7.550677903404239e-232, 3.2247509487043704e-99).ln(), n2i(-532.1781042268581, -226.78506848435273));
    assert_eq2!(n2i(1.2252979900742291e-174, 4.817234909117431e-40).ln(), n2i(-400.4466221093461, -90.53120362661866));
    assert_eq2!(n2i(2.1704355125847167e+35, 4.550722777302787e+83).ln(), n2i(81.36540609925065, 192.62984879100745));
    assert_eq2!(n2i(2.5356596321512507e-30, 4.6628667852616304e+61).ln(), n2i(-68.14709897670537, 141.99732112159288));
    assert_eq2!(n2i(75.82817216007211, 2.5333254202269282e+179).ln(), n2i(4.328469887979127, 413.0922644809589));
    assert_eq2!(n2i(2679384.856388388, 3.456099944072673e+189).ln(), n2i(14.80109779494236, 436.42872334540084));
    assert_eq2!(n2i(2.298466163925377e-53, 3.422642591789023e-07).ln(), n2i(-121.20476791346604, -14.887682710595616));
    assert_eq2!(n2i(8.331537116545183e-169, 1.2765750898565157e+278).ln(), n2i(-387.0168327490416, 640.3628366331135));
    assert_eq2!(n2i(3.718156390017819e-141, 1.0846336072121789e-48).ln(), n2i(-323.351270160804, -110.44284222295697));
    assert_eq2!(n2i(3.1572943290354614e-160, 9.898300388558578e+97).ln(), n2i(-367.26389944320726, 225.64311708490126));
    assert_eq2!(n2i(1.0833563616496317e+44, 3.415036575780023e+59).ln(), n2i(101.39380805609296, 137.080708689945));
    assert_eq2!(n2i(8.455584990678977e-99, 6.051563441903092e-73).ln(), n2i(-225.82109703772736, -166.28839512975804));
    assert_eq2!(n2i(2.3603491417159717e+109, 8.567792987486366e+158).ln(), n2i(251.8405846858513, 365.95645486478844));
    assert_eq2!(n2i(2.0129168242992888e-32, 2.8222933423368047e+41).ln(), n2i(-72.98313814928055, 95.44353860916723));
    assert_eq2!(n2i(4.831139778854606e-107, 2.0831343096790316e-23).ln(), n2i(-244.80152253147818, -52.22558349970032));
    assert_eq2!(n2i(8.466268199564697e-76, 1.6807826919239637e-10).ln(), n2i(-172.86037724634215, -22.50659135696745));
    assert_eq2!(n2i(2.2837024268617953e-151, 2.158830003381977e+22).ln(), n2i(-346.86455104475755, 51.42643845571061));
    assert_eq2!(n2i(1.1144284066451232e-64, 1.1374419750898092e+58).ln(), n2i(-147.25710431793172, 133.67871725328646));
    assert_eq2!(n2i(1.4637675938067672e-207, 3.6841782399907814e-44).ln(), n2i(-476.25410059422984, -100.00969659232456));
    assert_eq2!(n2i(1.806590984564743e+58, 4.476357965164358e+78).ln(), n2i(134.14137702909832, 181.1004470151316));
    assert_eq2!(n2i(2.5049493358677617e-102, 4.444462712533866e+177).ln(), n2i(-233.94541097626288, 409.0492204470355));
    assert_eq2!(n2i(1.0278297015325257e-53, 1.7554085478168807e-45).ln(), n2i(-122.0095604353624, -103.05362756412694));
    assert_eq2!(n2i(4.14742026137149e-79, 5.379571027897612e+28).log2(), n2i(-260.3801052520223, 95.44147779234198));
    assert_eq2!(n2i(1.1108806461872243e-155, 2.373351651082585e-67).log2(), n2i(-514.7471508866771, -221.32225648208498));
    assert_eq2!(n2i(5.129079157666995e-72, 1.7510703625318296e+71).log2(), n2i(-236.820122995125, 236.66513179315353));
    assert_eq2!(n2i(6.948997631311531e-148, 2.9283016466945798e-136).log2(), n2i(-488.84855315421714, -450.2321567302344));
    assert_eq2!(n2i(1.2289762226241382e+59, 2.234162998792154e+68).log2(), n2i(196.29121460207625, 227.0508448973251));
    assert_eq2!(n2i(3.7658819597444687e-13, 4.2821276071749897e+83).log2(), n2i(-41.27207745364735, 277.81835966425064));
    assert_eq2!(n2i(6.336975772360046e-144, 9.158993707856366e+59).log2(), n2i(-475.6938511639756, 199.18894669750247));
    assert_eq2!(n2i(5.364761505213512e-113, 4.082352475280499e+42).log2(), n2i(-372.9543606860327, 141.5503807370631));
    assert_eq2!(n2i(7.550677903404239e-232, 3.2247509487043704e-99).log2(), n2i(-767.7707118377781, -327.1816936500396));
    assert_eq2!(n2i(1.2252979900742291e-174, 4.817234909117431e-40).log2(), n2i(-577.7223558578903, -130.60891851783168));
    assert_eq2!(n2i(2.1704355125847167e+35, 4.550722777302787e+83).log2(), n2i(117.38546787930554, 277.9061275779774));
    assert_eq2!(n2i(2.5356596321512507e-30, 4.6628667852616304e+61).log2(), n2i(-98.31548174466218, 204.85883100163971));
    assert_eq2!(n2i(75.82817216007211, 2.5333254202269282e+179).log2(), n2i(6.244662042024693, 595.9661613962714));
    assert_eq2!(n2i(2679384.856388388, 3.456099944072673e+189).log2(), n2i(21.353470388475913, 629.6335548719112));
    assert_eq2!(n2i(2.298466163925377e-53, 3.422642591789023e-07).log2(), n2i(-174.86151760085522, -21.478386016904658));
    assert_eq2!(n2i(8.331537116545183e-169, 1.2765750898565157e+278).log2(), n2i(-558.3472653475957, 923.8482887801823));
    assert_eq2!(n2i(3.718156390017819e-141, 1.0846336072121789e-48).log2(), n2i(-466.4972739261393, -159.33534077674224));
    assert_eq2!(n2i(3.1572943290354614e-160, 9.898300388558578e+97).log2(), n2i(-529.8498064242581, 325.5342060291148));
    assert_eq2!(n2i(1.0833563616496317e+44, 3.415036575780023e+59).log2(), n2i(146.28034405937274, 197.76565862852829));
    assert_eq2!(n2i(8.455584990678977e-99, 6.051563441903092e-73).log2(), n2i(-325.7909768244346, -239.90344301108638));
    assert_eq2!(n2i(2.3603491417159717e+109, 8.567792987486366e+158).log2(), n2i(363.3291626208547, 527.963562614736));
    assert_eq2!(n2i(2.0129168242992888e-32, 2.8222933423368047e+41).log2(), n2i(-105.29241147648116, 137.6959198363399));
    assert_eq2!(n2i(4.831139778854606e-107, 2.0831343096790316e-23).log2(), n2i(-353.17394255823143, -75.34559032255012));
    assert_eq2!(n2i(8.466268199564697e-76, 1.6807826919239637e-10).log2(), n2i(-249.38480901949322, -32.47014773801135));
    assert_eq2!(n2i(2.2837024268617953e-151, 2.158830003381977e+22).log2(), n2i(-500.4197676524484, 74.19266773063518));
    assert_eq2!(n2i(1.1144284066451232e-64, 1.1374419750898092e+58).log2(), n2i(-212.44709413514883, 192.8576224537143));
    assert_eq2!(n2i(1.4637675938067672e-207, 3.6841782399907814e-44).log2(), n2i(-687.0894291303289, -144.2834933145565));
    assert_eq2!(n2i(1.806590984564743e+58, 4.476357965164358e+78).log2(), n2i(193.52509941789688, 261.2727168115049));
    assert_eq2!(n2i(2.5049493358677617e-102, 4.444462712533866e+177).log2(), n2i(-337.5118842541849, 590.1332818184345));
    assert_eq2!(n2i(1.0278297015325257e-53, 1.7554085478168807e-45).log2(), n2i(-176.0225877811396, -148.6749574323841));
    assert_eq2!(n2i(4.14742026137149e-79, 5.379571027897612e+28).log10(), n2i(-78.38222195500325, 28.730747645992665));
    assert_eq2!(n2i(1.1108806461872243e-155, 2.373351651082585e-67).log10(), n2i(-154.95433259946307, -66.62463790914457));
    assert_eq2!(n2i(5.129079157666995e-72, 1.7510703625318296e+71).log10(), n2i(-71.28996059836598, 71.24330359750856));
    assert_eq2!(n2i(6.948997631311531e-148, 2.9283016466945798e-136).log10(), n2i(-147.15807783635748, -135.53338418828736));
    assert_eq2!(n2i(1.2289762226241382e+59, 2.234162998792154e+68).log10(), n2i(59.08954348054062, 68.34911485494504));
    assert_eq2!(n2i(3.7658819597444687e-13, 4.2821276071749897e+83).log10(), n2i(-12.424133296914958, 83.63165960510374));
    assert_eq2!(n2i(6.336975772360046e-144, 9.158993707856366e+59).log10(), n2i(-143.19811795327408, 59.96184776066215));
    assert_eq2!(n2i(5.364761505213512e-113, 4.082352475280499e+42).log10(), n2i(-112.2704495801793, 42.610910499513));
    assert_eq2!(n2i(7.550677903404239e-232, 3.2247509487043704e-99).log10(), n2i(-231.1220140554581, -98.49150382080546));
    assert_eq2!(n2i(1.2252979900742291e-174, 4.817234909117431e-40).log10(), n2i(-173.9117582788857, -39.31720217510015));
    assert_eq2!(n2i(2.1704355125847167e+35, 4.550722777302787e+83).log10(), n2i(35.33654688672175, 83.65808037979232));
    assert_eq2!(n2i(2.5356596321512507e-30, 4.6628667852616304e+61).log10(), n2i(-29.595909043297876, 61.66865300815186));
    assert_eq2!(n2i(75.82817216007211, 2.5333254202269282e+179).log10(), n2i(1.8798305874337213, 179.4036909809991));
    assert_eq2!(n2i(2679384.856388388, 3.456099944072673e+189).log10(), n2i(6.428035098453854, 189.53858629298847));
    assert_eq2!(n2i(2.298466163925377e-53, 3.422642591789023e-07).log10(), n2i(-52.63856188518262, -6.465638449538123));
    assert_eq2!(n2i(8.331537116545183e-169, 1.2765750898565157e+278).log10(), n2i(-168.0792748665825, 278.10604636567473));
    assert_eq2!(n2i(3.718156390017819e-141, 1.0846336072121789e-48).log10(), n2i(-140.42967234724478, -47.96471694314168));
    assert_eq2!(n2i(3.1572943290354614e-160, 9.898300388558578e+97).log10(), n2i(-159.5006849304557, 97.99556062942199));
    assert_eq2!(n2i(1.0833563616496317e+44, 3.415036575780023e+59).log10(), n2i(44.034771337918656, 59.53339535943026));
    assert_eq2!(n2i(8.455584990678977e-99, 6.051563441903092e-73).log10(), n2i(-98.07285634082376, -72.21813240940149));
    assert_eq2!(n2i(2.3603491417159717e+109, 8.567792987486366e+158).log10(), n2i(109.37297624835381, 158.93286896465406));
    assert_eq2!(n2i(2.0129168242992888e-32, 2.8222933423368047e+41).log10(), n2i(-31.696174170215247, 41.450602151281295));
    assert_eq2!(n2i(4.831139778854606e-107, 2.0831343096790316e-23).log10(), n2i(-106.31595039693555, -22.68128272809737));
    assert_eq2!(n2i(8.466268199564697e-76, 1.6807826919239637e-10).log10(), n2i(-75.07230797780082, -9.774488432782384));
    assert_eq2!(n2i(2.2837024268617953e-151, 2.158830003381977e+22).log10(), n2i(-150.64136048658702, 22.334218445252304));
    assert_eq2!(n2i(1.1144284066451232e-64, 1.1374419750898092e+58).log10(), n2i(-63.95294782632926, 58.055929251007335));
    assert_eq2!(n2i(1.4637675938067672e-207, 3.6841782399907814e-44).log10(), n2i(-206.83452787187022, -43.433659366865));
    assert_eq2!(n2i(1.806590984564743e+58, 4.476357965164358e+78).log10(), n2i(58.25685983864103, 78.6509248088839));
    assert_eq2!(n2i(2.5049493358677617e-102, 4.444462712533866e+177).log10(), n2i(-101.6012010535794, 177.64781926697432));
    assert_eq2!(n2i(1.0278297015325257e-53, 1.7554085478168807e-45).log10(), n2i(-52.98807883651921, -44.75562179121318));
    assert_eq2!(n2i(-1.8202506318427055e-45, -9.117403206523164e-284).sin(), n2i(-1.8202506318427055e-45, -9.117403206523163e-284));
    assert_eq2!(n2i(-9.132843019095516e-132, -9.836586939929288e-188).sin(), n2i(-9.132843019095516e-132, -9.836586939929287e-188));
    assert_eq2!(n2i(-86.31384205445318, -2.269091389186822e-289).sin(), n2i(-1.0, 1.0));
    assert_eq2!(n2i(-1.654017949299359e-112, 1.159376035639007e-176).sin(), n2i(-1.654017949299359e-112, 1.159376035639007e-176));
    assert_eq2!(n2i(-2.2615789278302103e-107, -2.921845682025291e-170).sin(), n2i(-2.2615789278302103e-107, -2.9218456820252906e-170));
    assert_eq2!(n2i(-1.4694583917122814e-99, -1.976254011990074e-124).sin(), n2i(-1.4694583917122814e-99, -1.9762540119900736e-124));
    assert_eq2!(n2i(-1.0885881319864263e-12, -3.239993862505299e-238).sin(), n2i(-1.0885881319864263e-12, -3.239993862505298e-238));
    assert_eq2!(n2i(-3.1146001913444843e-60, -1.1510574328152409e-61).sin(), n2i(-3.1146001913444843e-60, -1.1510574328152407e-61));
    assert_eq2!(n2i(3.2157557345980886e-80, 2.86024743464549e-24).sin(), n2i(3.2157557345980882e-80, 2.86024743464549e-24));
    assert_eq2!(n2i(-7.599545156767026e-113, -3.620806299549832e-276).sin(), n2i(-7.599545156767026e-113, -3.620806299549831e-276));
    assert_eq2!(n2i(-8.378054792460111e-178, 0.00021719294064488021).sin(), n2i(-8.378054792460111e-178, 0.00021719293893728134));
    assert_eq2!(n2i(-6.977305240208117e-101, -5.65298707340689e-174).sin(), n2i(-6.977305240208117e-101, -5.652987073406889e-174));
    assert_eq2!(n2i(-5.464129729164142e-282, 9.669182275976748e-117).sin(), n2i(-5.464129729164142e-282, 9.669182275976748e-117));
    assert_eq2!(n2i(-2.609094333453399e-148, 5.011306988287881e-06).sin(), n2i(-2.609094333453399e-148, 5.011306988266907e-06));
    assert_eq2!(n2i(-2.5201641840917325e-91, -6.923225182185906e-252).sin(), n2i(-2.5201641840917325e-91, -6.923225182185905e-252));
    assert_eq2!(n2i(-2.0584112229632026e-150, -1.6910802714540518e-229).sin(), n2i(-2.0584112229632026e-150, -1.6910802714540514e-229));
    assert_eq2!(n2i(-1.1949122607706506e-171, -3.0636415629939144e-235).sin(), n2i(-1.1949122607706506e-171, -3.063641562993914e-235));
    assert_eq2!(n2i(-1.4102130217593183e-164, 2.1133072064564835e-235).sin(), n2i(-1.4102130217593183e-164, 2.1133072064564835e-235));
    assert_eq2!(n2i(-2.7344024762799374e-15, 2.214286456252712e-200).sin(), n2i(-2.7344024762799374e-15, 2.214286456252712e-200));
    assert_eq2!(n2i(-4.736813689297964e-37, -3.7578203261478413e-165).sin(), n2i(-4.736813689297964e-37, -3.757820326147841e-165));
    assert_eq2!(n2i(-1.1788723171116539e-269, -3.6970795304788244e-304).sin(), n2i(-1.1788723171116539e-269, -3.697079530478824e-304));
    assert_eq2!(n2i(-3.170977600535302e-50, 1.7737323532508088e-223).sin(), n2i(-3.170977600535302e-50, 1.7737323532508088e-223));
    assert_eq2!(n2i(-9.582715182984807e-234, -6.481946913158783e-280).sin(), n2i(-9.582715182984807e-234, -6.481946913158782e-280));
    assert_eq2!(n2i(1.5100300592839213e-212, 1.3573815287255817e-08).sin(), n2i(1.510030059283921e-212, 1.3573815287255817e-08));
    assert_eq2!(n2i(-1.3235071960516872e-113, 8.782017701712099e-233).sin(), n2i(-1.3235071960516872e-113, 8.782017701712099e-233));
    assert_eq2!(n2i(-7.715995104235895e-26, -1.8717187851284042e-162).sin(), n2i(-7.715995104235895e-26, -1.871718785128404e-162));
    assert_eq2!(n2i(-3.395185885371618e-83, -1.8923225069950326e-149).sin(), n2i(-3.395185885371618e-83, -1.8923225069950324e-149));
    assert_eq2!(n2i(-1.4492856133171728e-98, -5.707789272110613e-264).sin(), n2i(-1.4492856133171728e-98, -5.707789272110612e-264));
    assert_eq2!(n2i(-1.045711771041449e-76, 2.500374714085601e-183).sin(), n2i(-1.045711771041449e-76, 2.500374714085601e-183));
    assert_eq2!(n2i(-1.069106323474024e-70, -1.3000196111841269e-129).sin(), n2i(-1.069106323474024e-70, -1.3000196111841267e-129));
    assert_eq2!(n2i(-1.8202506318427055e-45, -9.117403206523164e-284).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-9.132843019095516e-132, -9.836586939929288e-188).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-86.31384205445318, -2.269091389186822e-289).cos(), n2i(-1.0, 1.0));
    assert_eq2!(n2i(-1.654017949299359e-112, 1.159376035639007e-176).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-2.2615789278302103e-107, -2.921845682025291e-170).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-1.4694583917122814e-99, -1.976254011990074e-124).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-1.0885881319864263e-12, -3.239993862505299e-238).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-3.1146001913444843e-60, -1.1510574328152409e-61).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(3.2157557345980886e-80, 2.86024743464549e-24).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-7.599545156767026e-113, -3.620806299549832e-276).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-8.378054792460111e-178, 0.00021719294064488021).cos(), n2i(0.9999999764136133, 1.0));
    assert_eq2!(n2i(-6.977305240208117e-101, -5.65298707340689e-174).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-5.464129729164142e-282, 9.669182275976748e-117).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-2.609094333453399e-148, 5.011306988287881e-06).cos(), n2i(0.9999999999874434, 1.0));
    assert_eq2!(n2i(-2.5201641840917325e-91, -6.923225182185906e-252).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-2.0584112229632026e-150, -1.6910802714540518e-229).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-1.1949122607706506e-171, -3.0636415629939144e-235).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-1.4102130217593183e-164, 2.1133072064564835e-235).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-2.7344024762799374e-15, 2.214286456252712e-200).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-4.736813689297964e-37, -3.7578203261478413e-165).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-1.1788723171116539e-269, -3.6970795304788244e-304).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-3.170977600535302e-50, 1.7737323532508088e-223).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-9.582715182984807e-234, -6.481946913158783e-280).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(1.5100300592839213e-212, 1.3573815287255817e-08).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-1.3235071960516872e-113, 8.782017701712099e-233).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-7.715995104235895e-26, -1.8717187851284042e-162).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-3.395185885371618e-83, -1.8923225069950326e-149).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-1.4492856133171728e-98, -5.707789272110613e-264).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-1.045711771041449e-76, 2.500374714085601e-183).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(-1.069106323474024e-70, -1.3000196111841269e-129).cos(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(70.68583836474448, 70.75330512586874).tan(), n2i(-273300.6473448548, -14.798812852149917));
    assert_eq2!(n2i(155.50883635309455, 155.51326378695515).tan(), n2i(-2501337356.624831, -225.8629732531564));
    assert_eq2!(n2i(14.137167805502546, 14.137227391969494).tan(), n2i(-1156940.7790648045, -16542.374023479453));
    assert_eq2!(n2i(58.11952623508043, 58.122601225400146).tan(), n2i(-16091.743708154681, -318.76123971015005));
    assert_eq2!(n2i(1104.2698177371135, 1104.2698439332517).tan(), n2i(-3320322546.7369237, -38173.12678644172));
    assert_eq2!(n2i(7.853981742281576, 10.79991165038145).tan(), n2i(-9233005.655163566, 5.045449840129904));
    assert_eq2!(n2i(52393.91148189279, 52393.994924458944).tan(), n2i(-606422.5515766229, -11.956226574579636));
    assert_eq2!(n2i(758.6946266951879, 758.6949897443036).tan(), n2i(-1171985.5126095195, -2747.989687166772));
    assert_eq2!(n2i(3011.2166240542, 3011.217034712601).tan(), n2i(-15246.602346057645, -2099.75155165814));
    assert_eq2!(n2i(4.7123890014482255, 4.712393345839714).tan(), n2i(-47475410.49162796, -229071.19521491887));
    assert_eq2!(n2i(966.0397409977253, 966.0408736798588).tan(), n2i(-53011396.29714514, -882.84514151453));
    assert_eq2!(n2i(7.853981635987764, 7.85415362667518).tan(), n2i(-496701704.1818811, -5814.200172946293));
    assert_eq2!(n2i(58.11946410445683, 58.21150187298622).tan(), n2i(-76653865.54086588, -10.834406653089859));
    assert_eq2!(n2i(7.853981655490968, 8.89310817317941).tan(), n2i(-46475992.32951005, -0.5881622348891323));
    assert_eq2!(n2i(1352.469666641228, 1352.4702706711319).tan(), n2i(-71.27486560119897, -68.33240428001098));
    assert_eq2!(n2i(26.703544089128407, 26.724306664919038).tan(), n2i(-153054.62211031638, -48.14150626430674));
    assert_eq2!(n2i(100322.04900341017, 100322.0547796015).tan(), n2i(-1979169548.3327806, -173.12251849267423));
    assert_eq2!(n2i(154533.38501376018, 154533.6486881895).tan(), n2i(-75.86811168897188, -3.5192465945162494));
    assert_eq2!(n2i(425.6858100226354, 425.68613913243877).tan(), n2i(-183109.32192680734, -2988.901899973172));
    assert_eq2!(n2i(1892.8095737885637, 1892.8172903994985).tan(), n2i(-1401909320.1275098, -129.58798457577532));
    assert_eq2!(n2i(267319.68969033076, 267321.63474314404).tan(), n2i(-20634416.967433296, 0.39276816804429027));
    assert_eq2!(n2i(39.26990817370414, 39.26991071421139).tan(), n2i(-260979216.85629869, -393029.3916624513));
    assert_eq2!(n2i(29.845130448841697, 29.84607373920065).tan(), n2i(-4171208.7386841727, -1059.8492891507494));
    assert_eq2!(n2i(26.703539466085683, 27.36226360891475).tan(), n2i(-523403.34172959276, -1.291880114820135));
    assert_eq2!(n2i(4500.331685768444, 4500.332498243393).tan(), n2i(-4773.245350635401, -978.4962051021078));
    assert_eq2!(n2i(1220.5087459201022, 1220.5112103357358).tan(), n2i(-2138784586.2469065, -405.77481014911035));
    assert_eq2!(n2i(29.84514872583802, 29.845306643221804).tan(), n2i(-54005.20128356148, -5667.837925038271));
    assert_eq2!(n2i(194456.73128070892, 194458.2117162205).tan(), n2i(-194753.67220555546, -0.09060237858764002));
    assert_eq2!(n2i(23.56194490664901, 23.56194490664901).tan(), n2i(-211615075.56202134, -211615075.56202132));
    assert_eq2!(n2i(23.56194490664901, 23.57580376726279).tan(), n2i(-211615075.56202134, -72.1513595795972));
    assert_eq2!(n2i(-1.3123890470285875e-49, -2.435356662074064e-204).asin(), n2i(-1.3123890470285877e-49, -2.435356662074064e-204));
    assert_eq2!(n2i(-2.826769732140076e-84, -5.561386920473982e-193).asin(), n2i(-2.8267697321400766e-84, -5.561386920473982e-193));
    assert_eq2!(n2i(-1.1659837691385322e-88, -1.4289745775460322e-230).asin(), n2i(-1.1659837691385324e-88, -1.4289745775460322e-230));
    assert_eq2!(n2i(-9.442195953730014e-285, -2.7404603289621324e-294).asin(), n2i(-9.442195953730015e-285, -2.7404603289621324e-294));
    assert_eq2!(n2i(2.0467594231403788e-219, 9.256656556116301e-185).asin(), n2i(2.0467594231403788e-219, 9.256656556116302e-185));
    assert_eq2!(n2i(-3.8085093736833965e-193, 7.757841386304003e-162).asin(), n2i(-3.808509373683397e-193, 7.757841386304004e-162));
    assert_eq2!(n2i(-1.1873973611072656e-112, -2.6683128218483153e-303).asin(), n2i(-1.1873973611072659e-112, -2.6683128218483153e-303));
    assert_eq2!(n2i(-1.2635868674142903e-101, -2.9612578461951855e-240).asin(), n2i(-1.2635868674142905e-101, -2.9612578461951855e-240));
    assert_eq2!(n2i(-3.901714394731277e-270, -3.33013465835358e-294).asin(), n2i(-3.9017143947312775e-270, -3.33013465835358e-294));
    assert_eq2!(n2i(-2.3666507777649184e-246, 1.071483042175133e-285).asin(), n2i(-2.366650777764919e-246, 1.0714830421751331e-285));
    assert_eq2!(n2i(-4.636590066075016e-69, 5.524052139366596e-240).asin(), n2i(-4.636590066075017e-69, 5.524052139366597e-240));
    assert_eq2!(n2i(1.1788227259952494e-253, 3.08076391051516e-167).asin(), n2i(1.1788227259952494e-253, 3.0807639105151604e-167));
    assert_eq2!(n2i(-1.1023467348292997e-19, 6.85044659146734e-81).asin(), n2i(-1.1023467348293e-19, 6.850446591467341e-81));
    assert_eq2!(n2i(-3.8093079244835395e-117, 2.1625452335496485e-70).asin(), n2i(-3.80930792448354e-117, 2.162545233549649e-70));
    assert_eq2!(n2i(-3.325515536019972e-77, -2.504008447335657e-137).asin(), n2i(-3.3255155360199723e-77, -2.504008447335657e-137));
    assert_eq2!(n2i(-1.5598056614332233e-242, 7.909368633706728e-07).asin(), n2i(-1.5598056614332235e-242, 7.909368633707552e-07));
    assert_eq2!(n2i(-5.969914231928148e-104, -6.050096414444652e-262).asin(), n2i(-5.969914231928149e-104, -6.050096414444652e-262));
    assert_eq2!(n2i(-1.3125500475411503e-20, -6.354261176220088e-253).asin(), n2i(-1.3125500475411504e-20, -6.354261176220088e-253));
    assert_eq2!(n2i(4.567490786574824e-149, 4.1981966908869863e-123).asin(), n2i(4.567490786574824e-149, 4.198196690886987e-123));
    assert_eq2!(n2i(-9.884682253430382e-92, -5.579479013164953e-154).asin(), n2i(-9.884682253430384e-92, -5.579479013164953e-154));
    assert_eq2!(n2i(-1.522662321416928e-13, 2.6449583656165776e-170).asin(), n2i(-1.5226623214169284e-13, 2.644958365616578e-170));
    assert_eq2!(n2i(-8.948553501584778e-99, 2.1143264105452587e-257).asin(), n2i(-8.94855350158478e-99, 2.114326410545259e-257));
    assert_eq2!(n2i(-9.422591232382869e-70, -6.531943700592088e-157).asin(), n2i(-9.42259123238287e-70, -6.531943700592088e-157));
    assert_eq2!(n2i(-4.1834915349890016e-145, 7.226922481530354e-207).asin(), n2i(-4.183491534989002e-145, 7.226922481530355e-207));
    assert_eq2!(n2i(-1.2617600952028633e-243, 1.140396740717172e-231).asin(), n2i(-1.2617600952028635e-243, 1.1403967407171721e-231));
    assert_eq2!(n2i(-6.921640701718756e-64, -1.4041799418328618e-165).asin(), n2i(-6.921640701718758e-64, -1.4041799418328618e-165));
    assert_eq2!(n2i(-7.429895589392232e-75, -7.75698335870157e-275).asin(), n2i(-7.429895589392233e-75, -7.75698335870157e-275));
    assert_eq2!(n2i(6.867158476684656e-209, 1.5634412712748094e-199).asin(), n2i(6.867158476684656e-209, 1.5634412712748097e-199));
    assert_eq2!(n2i(-9.032911858299409e-169, 3.0607355348795193e-91).asin(), n2i(-9.03291185829941e-169, 3.06073553487952e-91));
    assert_eq2!(n2i(-5.007253407091103e-155, 2.4318117253583154e-307).asin(), n2i(-5.0072534070911035e-155, 2.431811725358316e-307));
    assert_eq2!(n2i(-1.3123890470285875e-49, -2.435356662074064e-204).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-2.826769732140076e-84, -5.561386920473982e-193).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-1.1659837691385322e-88, -1.4289745775460322e-230).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-9.442195953730014e-285, -2.7404603289621324e-294).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(2.0467594231403788e-219, 9.256656556116301e-185).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-3.8085093736833965e-193, 7.757841386304003e-162).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-1.1873973611072656e-112, -2.6683128218483153e-303).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-1.2635868674142903e-101, -2.9612578461951855e-240).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-3.901714394731277e-270, -3.33013465835358e-294).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-2.3666507777649184e-246, 1.071483042175133e-285).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-4.636590066075016e-69, 5.524052139366596e-240).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(1.1788227259952494e-253, 3.08076391051516e-167).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-1.1023467348292997e-19, 6.85044659146734e-81).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-3.8093079244835395e-117, 2.1625452335496485e-70).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-3.325515536019972e-77, -2.504008447335657e-137).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-1.5598056614332233e-242, 7.909368633706728e-07).acos(), n2i(1.5707955358580332, 1.5707963267948968));
    assert_eq2!(n2i(-5.969914231928148e-104, -6.050096414444652e-262).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-1.3125500475411503e-20, -6.354261176220088e-253).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(4.567490786574824e-149, 4.1981966908869863e-123).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-9.884682253430382e-92, -5.579479013164953e-154).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-1.522662321416928e-13, 2.6449583656165776e-170).acos(), n2i(1.5707963267948966, 1.570796326795049));
    assert_eq2!(n2i(-8.948553501584778e-99, 2.1143264105452587e-257).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-9.422591232382869e-70, -6.531943700592088e-157).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-4.1834915349890016e-145, 7.226922481530354e-207).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-1.2617600952028633e-243, 1.140396740717172e-231).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-6.921640701718756e-64, -1.4041799418328618e-165).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-7.429895589392232e-75, -7.75698335870157e-275).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(6.867158476684656e-209, 1.5634412712748094e-199).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-9.032911858299409e-169, 3.0607355348795193e-91).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(-5.007253407091103e-155, 2.4318117253583154e-307).acos(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(2.1420516689865724e-70, 1.3068822821215125e+34).atan(), n2i(2.142051668986572e-70, 1.5707963267948968));
    assert_eq2!(n2i(4.50261252376323e-153, 3.574174482995173e-66).atan(), n2i(4.5026125237632296e-153, 3.574174482995173e-66));
    assert_eq2!(n2i(5.495270555084999e-61, 1.97728388112021e+82).atan(), n2i(5.4952705550849984e-61, 1.5707963267948968));
    assert_eq2!(n2i(1.0903261744152942e-137, 6.394132238750146e-126).atan(), n2i(1.090326174415294e-137, 6.394132238750146e-126));
    assert_eq2!(n2i(9.619256544849801e+75, 1.976936481141943e+88).atan(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(1.2265863637939853, 4.3086666028997115e+100).atan(), n2i(0.8868130567036107, 1.5707963267948968));
    assert_eq2!(n2i(7.92893550594856e-133, 7.949640211843925e+71).atan(), n2i(7.928935505948559e-133, 1.5707963267948968));
    assert_eq2!(n2i(3.8765049524470155e-104, 3.7844471473955087e+52).atan(), n2i(3.876504952447015e-104, 1.5707963267948968));
    assert_eq2!(n2i(1.735629038886541e-227, 2.5247955982030513e-87).atan(), n2i(1.7356290388865408e-227, 2.5247955982030513e-87));
    assert_eq2!(n2i(1.2372972348014194e-169, 5.840571936196233e-23).atan(), n2i(1.2372972348014193e-169, 5.840571936196233e-23));
    assert_eq2!(n2i(2.646062262797939e+54, 1.6192603307176822e+94).atan(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(8.58666888503976e-15, 3.330274496326269e+77).atan(), n2i(8.586668885039759e-15, 1.5707963267948968));
    assert_eq2!(n2i(2089.4789112580042, 2.6540761105245153e+197).atan(), n2i(1.5703177386080223, 1.5707963267948968));
    assert_eq2!(n2i(918564631414809.2, 3.4041867530177476e+207).atan(), n2i(1.5707963267948954, 1.5707963267948968));
    assert_eq2!(n2i(1.04297065349669e-51, 378.66439698572424).atan(), n2i(1.0429706534966898e-51, 1.5681554720347066));
    assert_eq2!(n2i(1.159254403776913e-163, 6.699078654119897e+297).atan(), n2i(1.1592544037769129e-163, 1.5707963267948968));
    assert_eq2!(n2i(9.6216669723908e-133, 7.532163773886163e-45).atan(), n2i(9.621666972390799e-133, 7.532163773886163e-45));
    assert_eq2!(n2i(9.139956432627538e-154, 1.4853687335806818e+106).atan(), n2i(9.139956432627537e-154, 1.5707963267948968));
    assert_eq2!(n2i(2.515545250733326e+57, 1.4761653792923375e+72).atan(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(5.894957732633466e-95, 1.2304282748741674e-71).atan(), n2i(5.894957732633465e-95, 1.2304282748741674e-71));
    assert_eq2!(n2i(5.6419923856371924e+128, 7.041426524450172e+170).atan(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(8.878766165166294e-17, 1.3769044122288282e+51).atan(), n2i(8.878766165166293e-17, 1.5707963267948968));
    assert_eq2!(n2i(1.4424839590411552e-103, 3.4406801604078773e-20).atan(), n2i(1.442483959041155e-103, 3.4406801604078773e-20));
    assert_eq2!(n2i(5.626945812397601e-71, 7528.651283167651).atan(), n2i(5.6269458123976004e-71, 1.5706635008800671));
    assert_eq2!(n2i(6.14458190526497e-145, 8.697059728957017e+39).atan(), n2i(6.144581905264969e-145, 1.5707963267948968));
    assert_eq2!(n2i(1.1630464890098972e-57, 2.9520692024476596e+66).atan(), n2i(1.163046489009897e-57, 1.5707963267948968));
    assert_eq2!(n2i(7.34011947060184e-203, 4.9971841742702367e-42).atan(), n2i(7.340119470601839e-203, 4.9971841742702367e-42));
    assert_eq2!(n2i(1.3188167307663932e+76, 3.808490005836893e+98).atan(), n2i(1.5707963267948966, 1.5707963267948968));
    assert_eq2!(n2i(1.0617572270683382e-97, 1.8453138582390658e+196).atan(), n2i(1.061757227068338e-97, 1.5707963267948968));
    assert_eq2!(n2i(7.269525029365293e-38, 4.488799649180782e-36).atan(), n2i(7.269525029365292e-38, 4.488799649180782e-36));
    assert_eq2!(n2i(-2.2768257354023808e-48, -1.2475917586241332e-288).sinh(), n2i(-2.276825735402381e-48, -1.2475917586241332e-288));
    assert_eq2!(n2i(-1.555899708023971e-136, -2.066488754605662e-191).sinh(), n2i(-1.5558997080239712e-136, -2.066488754605662e-191));
    assert_eq2!(n2i(-1.0132180508839796, -8.114288896805144e-293).sinh(), n2i(-1.195700971165399, -8.114288896805144e-293));
    assert_eq2!(n2i(-5.223236923356958e-115, 2.4503567334377615e-182).sinh(), n2i(-5.223236923356959e-115, 2.4503567334377618e-182));
    assert_eq2!(n2i(-4.51093206294564e-111, -9.719284552905501e-172).sinh(), n2i(-4.510932062945641e-111, -9.719284552905501e-172));
    assert_eq2!(n2i(-5.243225148031155e-101, -2.926946402493516e-125).sinh(), n2i(-5.2432251480311555e-101, -2.926946402493516e-125));
    assert_eq2!(n2i(-3.572423176829176e-14, -6.433836389930063e-244).sinh(), n2i(-3.572423176829177e-14, -6.433836389930063e-244));
    assert_eq2!(n2i(-2.694213038264476e-63, -7.562777816273446e-67).sinh(), n2i(-2.6942130382644766e-63, -7.562777816273446e-67));
    assert_eq2!(n2i(1.0880389496588822e-80, 1.9554151139146355e-29).sinh(), n2i(1.0880389496588822e-80, 1.9554151139146358e-29));
    assert_eq2!(n2i(-7.367961367144991e-116, -3.479600132086109e-281).sinh(), n2i(-7.367961367144993e-116, -3.479600132086109e-281));
    assert_eq2!(n2i(-8.240014447403599e-179, 4.244031804302998e-06).sinh(), n2i(-8.2400144474036e-179, 4.244031804315739e-06));
    assert_eq2!(n2i(-4.94083534771968e-103, -3.209929124440609e-180).sinh(), n2i(-4.940835347719681e-103, -3.209929124440609e-180));
    assert_eq2!(n2i(-1.0853582407941416e-286, 3.3620950388052526e-121).sinh(), n2i(-1.0853582407941418e-286, 3.362095038805253e-121));
    assert_eq2!(n2i(-2.7731425124963485e-152, 5.0528681057770385e-09).sinh(), n2i(-2.773142512496349e-152, 5.052868105777039e-09));
    assert_eq2!(n2i(-1.5157390642100334e-96, -4.584256552639735e-257).sinh(), n2i(-1.5157390642100336e-96, -4.584256552639735e-257));
    assert_eq2!(n2i(-5.7455052173334935e-155, -4.839121225948963e-233).sinh(), n2i(-5.745505217333494e-155, -4.839121225948963e-233));
    assert_eq2!(n2i(-5.901539399340708e-177, -4.071613085569533e-241).sinh(), n2i(-5.901539399340709e-177, -4.071613085569533e-241));
    assert_eq2!(n2i(-2.800078795581777e-165, 3.959032834373607e-236).sinh(), n2i(-2.8000787955817772e-165, 3.959032834373608e-236));
    assert_eq2!(n2i(-5.299801768007808e-20, 2.4122688895624415e-206).sinh(), n2i(-5.2998017680078084e-20, 2.4122688895624417e-206));
    assert_eq2!(n2i(-4.504594176548485e-37, -1.093025376211848e-167).sinh(), n2i(-4.504594176548486e-37, -1.093025376211848e-167));
    assert_eq2!(n2i(-1.1483874190142467e-274, -5.607529106307212e-306).sinh(), n2i(-1.1483874190142468e-274, -5.607529106307212e-306));
    assert_eq2!(n2i(-8.179611867336582e-53, 3.261973107060699e-227).sinh(), n2i(-8.179611867336583e-53, 3.2619731070606997e-227));
    assert_eq2!(n2i(-5.612415357146818e-236, -1.379963883993877e-283).sinh(), n2i(-5.612415357146819e-236, -1.379963883993877e-283));
    assert_eq2!(n2i(6.3531250602978954e-217, 1.4016754776196554e-13).sinh(), n2i(6.3531250602978954e-217, 1.4016754776196556e-13));
    assert_eq2!(n2i(-5.247726734531364e-115, 1.4617551264697742e-238).sinh(), n2i(-5.247726734531365e-115, 1.4617551264697744e-238));
    assert_eq2!(n2i(-1.6006078206126949e-27, -1.0506214843951056e-166).sinh(), n2i(-1.600607820612695e-27, -1.0506214843951056e-166));
    assert_eq2!(n2i(-1.0523378573450417e-89, -1.5841980962092858e-155).sinh(), n2i(-1.0523378573450419e-89, -1.5841980962092858e-155));
    assert_eq2!(n2i(-2.798033560470429e-102, -9.926975697028545e-270).sinh(), n2i(-2.7980335604704293e-102, -9.926975697028545e-270));
    assert_eq2!(n2i(-1.8077892344648456e-80, 1.3644692897901886e-184).sinh(), n2i(-1.807789234464846e-80, 1.364469289790189e-184));
    assert_eq2!(n2i(-1.5812623635529528e-73, -1.5580350957191581e-130).sinh(), n2i(-1.581262363552953e-73, -1.5580350957191581e-130));
    assert_eq2!(n2i(-2.2768257354023808e-48, -1.2475917586241332e-288).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-1.555899708023971e-136, -2.066488754605662e-191).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-1.0132180508839796, -8.114288896805144e-293).cosh(), n2i(1.0, 1.558749759405235));
    assert_eq2!(n2i(-5.223236923356958e-115, 2.4503567334377615e-182).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-4.51093206294564e-111, -9.719284552905501e-172).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-5.243225148031155e-101, -2.926946402493516e-125).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-3.572423176829176e-14, -6.433836389930063e-244).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-2.694213038264476e-63, -7.562777816273446e-67).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(1.0880389496588822e-80, 1.9554151139146355e-29).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-7.367961367144991e-116, -3.479600132086109e-281).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-8.240014447403599e-179, 4.244031804302998e-06).cosh(), n2i(1.0, 1.000000000009006));
    assert_eq2!(n2i(-4.94083534771968e-103, -3.209929124440609e-180).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-1.0853582407941416e-286, 3.3620950388052526e-121).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-2.7731425124963485e-152, 5.0528681057770385e-09).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-1.5157390642100334e-96, -4.584256552639735e-257).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-5.7455052173334935e-155, -4.839121225948963e-233).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-5.901539399340708e-177, -4.071613085569533e-241).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-2.800078795581777e-165, 3.959032834373607e-236).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-5.299801768007808e-20, 2.4122688895624415e-206).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-4.504594176548485e-37, -1.093025376211848e-167).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-1.1483874190142467e-274, -5.607529106307212e-306).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-8.179611867336582e-53, 3.261973107060699e-227).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-5.612415357146818e-236, -1.379963883993877e-283).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(6.3531250602978954e-217, 1.4016754776196554e-13).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-5.247726734531364e-115, 1.4617551264697742e-238).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-1.6006078206126949e-27, -1.0506214843951056e-166).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-1.0523378573450417e-89, -1.5841980962092858e-155).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-2.798033560470429e-102, -9.926975697028545e-270).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-1.8077892344648456e-80, 1.3644692897901886e-184).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(-1.5812623635529528e-73, -1.5580350957191581e-130).cosh(), n2i(1.0, 1.0000000000000002));
    assert_eq2!(n2i(2.1420516689865724e-70, 1.3068822821215125e+34).tanh(), n2i(2.142051668986572e-70, 1.0));
    assert_eq2!(n2i(4.50261252376323e-153, 3.574174482995173e-66).tanh(), n2i(4.5026125237632296e-153, 3.574174482995173e-66));
    assert_eq2!(n2i(5.495270555084999e-61, 1.97728388112021e+82).tanh(), n2i(5.4952705550849984e-61, 1.0));
    assert_eq2!(n2i(1.0903261744152942e-137, 6.394132238750146e-126).tanh(), n2i(1.090326174415294e-137, 6.394132238750146e-126));
    assert_eq2!(n2i(9.619256544849801e+75, 1.976936481141943e+88).tanh(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(1.2265863637939853, 4.3086666028997115e+100).tanh(), n2i(0.8415863137654881, 1.0));
    assert_eq2!(n2i(7.92893550594856e-133, 7.949640211843925e+71).tanh(), n2i(7.928935505948559e-133, 1.0));
    assert_eq2!(n2i(3.8765049524470155e-104, 3.7844471473955087e+52).tanh(), n2i(3.876504952447015e-104, 1.0));
    assert_eq2!(n2i(1.735629038886541e-227, 2.5247955982030513e-87).tanh(), n2i(1.7356290388865408e-227, 2.5247955982030513e-87));
    assert_eq2!(n2i(1.2372972348014194e-169, 5.840571936196233e-23).tanh(), n2i(1.2372972348014193e-169, 5.840571936196233e-23));
    assert_eq2!(n2i(2.646062262797939e+54, 1.6192603307176822e+94).tanh(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(8.58666888503976e-15, 3.330274496326269e+77).tanh(), n2i(8.586668885039759e-15, 1.0));
    assert_eq2!(n2i(2089.4789112580042, 2.6540761105245153e+197).tanh(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(918564631414809.2, 3.4041867530177476e+207).tanh(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(1.04297065349669e-51, 378.66439698572424).tanh(), n2i(1.0429706534966898e-51, 1.0));
    assert_eq2!(n2i(1.159254403776913e-163, 6.699078654119897e+297).tanh(), n2i(1.1592544037769129e-163, 1.0));
    assert_eq2!(n2i(9.6216669723908e-133, 7.532163773886163e-45).tanh(), n2i(9.621666972390799e-133, 7.532163773886163e-45));
    assert_eq2!(n2i(9.139956432627538e-154, 1.4853687335806818e+106).tanh(), n2i(9.139956432627537e-154, 1.0));
    assert_eq2!(n2i(2.515545250733326e+57, 1.4761653792923375e+72).tanh(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(5.894957732633466e-95, 1.2304282748741674e-71).tanh(), n2i(5.894957732633465e-95, 1.2304282748741674e-71));
    assert_eq2!(n2i(5.6419923856371924e+128, 7.041426524450172e+170).tanh(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(8.878766165166294e-17, 1.3769044122288282e+51).tanh(), n2i(8.878766165166293e-17, 1.0));
    assert_eq2!(n2i(1.4424839590411552e-103, 3.4406801604078773e-20).tanh(), n2i(1.442483959041155e-103, 3.4406801604078773e-20));
    assert_eq2!(n2i(5.626945812397601e-71, 7528.651283167651).tanh(), n2i(5.6269458123976004e-71, 1.0));
    assert_eq2!(n2i(6.14458190526497e-145, 8.697059728957017e+39).tanh(), n2i(6.144581905264969e-145, 1.0));
    assert_eq2!(n2i(1.1630464890098972e-57, 2.9520692024476596e+66).tanh(), n2i(1.163046489009897e-57, 1.0));
    assert_eq2!(n2i(7.34011947060184e-203, 4.9971841742702367e-42).tanh(), n2i(7.340119470601839e-203, 4.9971841742702367e-42));
    assert_eq2!(n2i(1.3188167307663932e+76, 3.808490005836893e+98).tanh(), n2i(0.9999999999999999, 1.0));
    assert_eq2!(n2i(1.0617572270683382e-97, 1.8453138582390658e+196).tanh(), n2i(1.061757227068338e-97, 1.0));
    assert_eq2!(n2i(7.269525029365293e-38, 4.488799649180782e-36).tanh(), n2i(7.269525029365292e-38, 4.488799649180782e-36));
    assert_eq2!(n2i(2.1420516689865724e-70, 1.3068822821215125e+34).asinh(), n2i(2.142051668986572e-70, 79.2486847057065));
    assert_eq2!(n2i(4.50261252376323e-153, 3.574174482995173e-66).asinh(), n2i(4.5026125237632296e-153, 3.574174482995173e-66));
    assert_eq2!(n2i(5.495270555084999e-61, 1.97728388112021e+82).asinh(), n2i(5.4952705550849984e-61, 190.18684893181842));
    assert_eq2!(n2i(1.0903261744152942e-137, 6.394132238750146e-126).asinh(), n2i(1.090326174415294e-137, 6.394132238750146e-126));
    assert_eq2!(n2i(9.619256544849801e+75, 1.976936481141943e+88).asinh(), n2i(175.6507961345644, 204.0021837787968));
    assert_eq2!(n2i(1.2265863637939853, 4.3086666028997115e+100).asinh(), n2i(1.0328826713694474, 232.4122849633374));
    assert_eq2!(n2i(7.92893550594856e-133, 7.949640211843925e+71).asinh(), n2i(7.928935505948559e-133, 166.2498154544075));
    assert_eq2!(n2i(3.8765049524470155e-104, 3.7844471473955087e+52).asinh(), n2i(3.876504952447015e-104, 121.75847182837504));
    assert_eq2!(n2i(1.735629038886541e-227, 2.5247955982030513e-87).asinh(), n2i(1.7356290388865408e-227, 2.5247955982030513e-87));
    assert_eq2!(n2i(1.2372972348014194e-169, 5.840571936196233e-23).asinh(), n2i(1.2372972348014193e-169, 5.840571936196233e-23));
    assert_eq2!(n2i(2.646062262797939e+54, 1.6192603307176822e+94).asinh(), n2i(126.00581479856812, 217.61811538100068));
    assert_eq2!(n2i(8.58666888503976e-15, 3.330274496326269e+77).asinh(), n2i(8.586668885039759e-15, 179.19525407302575));
    //asinh [0X8.297A99ED9ED08P+8, 0XE.33C49CF5B8790P+652] = [0X8.567B3095B8380P+0, 0X1.C7474C3E00682P+8];
    //asinh [0X3.436DFE8F08194P+48, 0X2.A69A969772FDEP+688] = [0X2.325A084AF897EP+4, 0X1.DE8DA2F064858P+8];
    assert_eq2!(n2i(1.04297065349669e-51, 378.66439698572424).asinh(), n2i(1.0429706534966898e-51, 6.629799240811254));
    assert_eq2!(n2i(1.159254403776913e-163, 6.699078654119897e+297).asinh(), n2i(1.1592544037769129e-163, 686.4628898024221));
    assert_eq2!(n2i(9.6216669723908e-133, 7.532163773886163e-45).asinh(), n2i(9.621666972390799e-133, 7.532163773886163e-45));
    assert_eq2!(n2i(9.139956432627538e-154, 1.4853687335806818e+106).asinh(), n2i(9.139956432627537e-154, 245.1628300848023));
    assert_eq2!(n2i(2.515545250733326e+57, 1.4761653792923375e+72).asinh(), n2i(132.86298706077096, 166.8687216416239));
    assert_eq2!(n2i(5.894957732633466e-95, 1.2304282748741674e-71).asinh(), n2i(5.894957732633465e-95, 1.2304282748741674e-71));
    //asinh [0XD.05E9CCF66CF58P+424, 0XB.A944253373080P+564] = [0X1.29277EA798036P+8, 0X1.8A159CCBD552AP+8];
    assert_eq2!(n2i(8.878766165166294e-17, 1.3769044122288282e+51).asinh(), n2i(8.878766165166293e-17, 118.44482472318504));
    assert_eq2!(n2i(1.4424839590411552e-103, 3.4406801604078773e-20).asinh(), n2i(1.442483959041155e-103, 3.4406801604078773e-20));
    assert_eq2!(n2i(5.626945812397601e-71, 7528.651283167651).asinh(), n2i(5.6269458123976004e-71, 9.61961837726088));
    assert_eq2!(n2i(6.14458190526497e-145, 8.697059728957017e+39).asinh(), n2i(6.144581905264969e-145, 92.65695081367733));
    assert_eq2!(n2i(1.1630464890098972e-57, 2.9520692024476596e+66).asinh(), n2i(1.163046489009897e-57, 153.74626966719399));
    assert_eq2!(n2i(7.34011947060184e-203, 4.9971841742702367e-42).asinh(), n2i(7.340119470601839e-203, 4.9971841742702367e-42));
    assert_eq2!(n2i(1.3188167307663932e+76, 3.808490005836893e+98).asinh(), n2i(175.96634916659843, 227.68371908063062));
    //asinh [0X3.A0EE84451C92CP-324, 0XF.CC937FA330E40P+648] = [0X3.A0EE84451C92AP-324, 0X1.C49CCB25BBD50P+8];
    assert_eq2!(n2i(7.269525029365293e-38, 4.488799649180782e-36).asinh(), n2i(7.269525029365292e-38, 4.488799649180782e-36));
    assert_eq2!(n2i(4.308689365264195e+82, 1.8701907670410506e+259).acosh(), n2i(190.96575857235607, 597.6887267061417));
    assert_eq2!(n2i(1.6634903706496164e+104, 1.0130155413477568e+134).acosh(), n2i(240.67091487979172, 309.25248120881395));
    assert_eq2!(n2i(4.740352466070305e+17, 3.41634385488393e+224).acosh(), n2i(41.39320525433158, 517.7007789421815));
    assert_eq2!(n2i(5.64998764549834e+39, 4.0094518788947586e+115).acosh(), n2i(92.22561916584621, 266.879087418296));
    assert_eq2!(n2i(8.616687911287559e+77, 5.944690784478971e+169).acosh(), n2i(180.14590011891133, 391.6125264126404));
    assert_eq2!(n2i(1.3377077519156613e+170, 1.3801104510906833e+220).acosh(), n2i(392.4235705058085, 507.58403117223855));
    assert_eq2!(n2i(122075122679246.94, 7.832127768107454e+156).acosh(), n2i(33.12880491138551, 361.95465590632523));
    assert_eq2!(n2i(4.401102955082982e+23, 1.2874627777144444e+159).acosh(), n2i(55.1344595005441, 367.056850409238));
    assert_eq2!(n2i(1.3013937443524183e+89, 2.7202595982421525e+307).acosh(), n2i(205.8866562582372, 708.587498046016));
    assert_eq2!(n2i(6.939444977341107e+123, 1.9849661700279034e+260).acosh(), n2i(285.84833541570157, 600.0508732301987));
    assert_eq2!(n2i(6.485225963939702e+146, 9.590094226342687e+261).acosh(), n2i(338.7400974189444, 603.9285871663319));
    assert_eq2!(n2i(2.743579466422469e+115, 4.645309981121623e+192).acosh(), n2i(266.499696317317, 444.32534313982006));
    assert_eq2!(n2i(6.315691036069834e+183, 1.2540006643724733e+196).acosh(), n2i(423.9092563760088, 452.2261643794061));
    assert_eq2!(n2i(113878.17295348585, 6.52225295264726e+170).acosh(), n2i(12.33603167819212, 394.00783285068394));
    assert_eq2!(n2i(1.7053175271799505e+68, 1.807502842596086e+136).acosh(), n2i(157.80268483050142, 314.436666075467));
    assert_eq2!(n2i(2.3207004837029524e+153, 1.406262907030545e+207).acosh(), n2i(353.8305354813852, 477.6691971955887));
    assert_eq2!(n2i(148402131315736.7, 6.690353456676458e+66).acosh(), n2i(33.32409398908452, 154.56443002449538));
    assert_eq2!(n2i(1.949448535585449e+38, 1.2860622970098249e+183).acosh(), n2i(88.85892724464935, 422.3178042655773));
    assert_eq2!(n2i(1.3239704874591082e+62, 5.603597588316932e+76).acosh(), n2i(143.7340581130184, 177.41302306606613));
    assert_eq2!(n2i(4.971908888084824e+22, 1.7057374338460732e+263).acosh(), n2i(52.95382307490645, 606.8070241677426));
    assert_eq2!(n2i(3.185265905903948e+68, 1.3967146871034045e+294).acosh(), n2i(158.42746927663433, 677.9872873476586));
    assert_eq2!(n2i(2.4193651692867643e+162, 6.0238395104859e+239).acosh(), n2i(374.5954374246092, 552.806709254594));
    assert_eq2!(n2i(6.36971341636037e+54, 1.7469166844610246e+239).acosh(), n2i(126.88429668122805, 551.5688367455168));
    assert_eq2!(n2i(2.5101218749158216e+141, 1.7605902949007784e+244).acosh(), n2i(326.2779766004286, 563.0895590187549));
    assert_eq2!(n2i(8.413476455681522e+227, 4.9056809624433886e+277).acosh(), n2i(525.5097980504411, 640.0996118535556));
    assert_eq2!(n2i(5.329335402634342e+21, 1.8109445472657588e+289).acosh(), n2i(50.720660673900944, 666.734087614319));
    assert_eq2!(n2i(2.7918509493185987e+238, 1.8924765519721813e+277).acosh(), n2i(549.7351041117033, 639.1471042561883));
    assert_eq2!(n2i(1.8112736744895206e+131, 3.9379724528640564e+191).acosh(), n2i(302.9258246481489, 441.8575659274054));
    assert_eq2!(n2i(1.2977017206860032e+139, 2.3518321895729873e+171).acosh(), n2i(321.01306989944294, 395.2903927620621));
    assert_eq2!(n2i(1.1775434872037611e+25, 4.1564615555571136e+231).acosh(), n2i(58.42120498344542, 534.0149677868964));
    assert_eq2!(n2i(-1.3123890470285875e-49, -2.435356662074064e-204).atanh(), n2i(-1.3123890470285877e-49, -2.435356662074064e-204));
    assert_eq2!(n2i(-2.826769732140076e-84, -5.561386920473982e-193).atanh(), n2i(-2.8267697321400766e-84, -5.561386920473982e-193));
    assert_eq2!(n2i(-1.1659837691385322e-88, -1.4289745775460322e-230).atanh(), n2i(-1.1659837691385324e-88, -1.4289745775460322e-230));
    assert_eq2!(n2i(-9.442195953730014e-285, -2.7404603289621324e-294).atanh(), n2i(-9.442195953730015e-285, -2.7404603289621324e-294));
    assert_eq2!(n2i(2.0467594231403788e-219, 9.256656556116301e-185).atanh(), n2i(2.0467594231403788e-219, 9.256656556116302e-185));
    assert_eq2!(n2i(-3.8085093736833965e-193, 7.757841386304003e-162).atanh(), n2i(-3.808509373683397e-193, 7.757841386304004e-162));
    assert_eq2!(n2i(-1.1873973611072656e-112, -2.6683128218483153e-303).atanh(), n2i(-1.1873973611072659e-112, -2.6683128218483153e-303));
    assert_eq2!(n2i(-1.2635868674142903e-101, -2.9612578461951855e-240).atanh(), n2i(-1.2635868674142905e-101, -2.9612578461951855e-240));
    assert_eq2!(n2i(-3.901714394731277e-270, -3.33013465835358e-294).atanh(), n2i(-3.9017143947312775e-270, -3.33013465835358e-294));
    assert_eq2!(n2i(-2.3666507777649184e-246, 1.071483042175133e-285).atanh(), n2i(-2.366650777764919e-246, 1.0714830421751331e-285));
    assert_eq2!(n2i(-4.636590066075016e-69, 5.524052139366596e-240).atanh(), n2i(-4.636590066075017e-69, 5.524052139366597e-240));
    assert_eq2!(n2i(1.1788227259952494e-253, 3.08076391051516e-167).atanh(), n2i(1.1788227259952494e-253, 3.0807639105151604e-167));
    assert_eq2!(n2i(-1.1023467348292997e-19, 6.85044659146734e-81).atanh(), n2i(-1.1023467348293e-19, 6.850446591467341e-81));
    assert_eq2!(n2i(-3.8093079244835395e-117, 2.1625452335496485e-70).atanh(), n2i(-3.80930792448354e-117, 2.162545233549649e-70));
    assert_eq2!(n2i(-3.325515536019972e-77, -2.504008447335657e-137).atanh(), n2i(-3.3255155360199723e-77, -2.504008447335657e-137));
    assert_eq2!(n2i(-1.5598056614332233e-242, 7.909368633706728e-07).atanh(), n2i(-1.5598056614332235e-242, 7.909368633708377e-07));
    assert_eq2!(n2i(-5.969914231928148e-104, -6.050096414444652e-262).atanh(), n2i(-5.969914231928149e-104, -6.050096414444652e-262));
    assert_eq2!(n2i(-1.3125500475411503e-20, -6.354261176220088e-253).atanh(), n2i(-1.3125500475411504e-20, -6.354261176220088e-253));
    assert_eq2!(n2i(4.567490786574824e-149, 4.1981966908869863e-123).atanh(), n2i(4.567490786574824e-149, 4.198196690886987e-123));
    assert_eq2!(n2i(-9.884682253430382e-92, -5.579479013164953e-154).atanh(), n2i(-9.884682253430384e-92, -5.579479013164953e-154));
    assert_eq2!(n2i(-1.522662321416928e-13, 2.6449583656165776e-170).atanh(), n2i(-1.5226623214169284e-13, 2.644958365616578e-170));
    assert_eq2!(n2i(-8.948553501584778e-99, 2.1143264105452587e-257).atanh(), n2i(-8.94855350158478e-99, 2.114326410545259e-257));
    assert_eq2!(n2i(-9.422591232382869e-70, -6.531943700592088e-157).atanh(), n2i(-9.42259123238287e-70, -6.531943700592088e-157));
    assert_eq2!(n2i(-4.1834915349890016e-145, 7.226922481530354e-207).atanh(), n2i(-4.183491534989002e-145, 7.226922481530355e-207));
    assert_eq2!(n2i(-1.2617600952028633e-243, 1.140396740717172e-231).atanh(), n2i(-1.2617600952028635e-243, 1.1403967407171721e-231));
    assert_eq2!(n2i(-6.921640701718756e-64, -1.4041799418328618e-165).atanh(), n2i(-6.921640701718758e-64, -1.4041799418328618e-165));
    assert_eq2!(n2i(-7.429895589392232e-75, -7.75698335870157e-275).atanh(), n2i(-7.429895589392233e-75, -7.75698335870157e-275));
    assert_eq2!(n2i(6.867158476684656e-209, 1.5634412712748094e-199).atanh(), n2i(6.867158476684656e-209, 1.5634412712748097e-199));
    assert_eq2!(n2i(-9.032911858299409e-169, 3.0607355348795193e-91).atanh(), n2i(-9.03291185829941e-169, 3.06073553487952e-91));
    assert_eq2!(n2i(-5.007253407091103e-155, 2.4318117253583154e-307).atanh(), n2i(-5.0072534070911035e-155, 2.431811725358316e-307));
}

#[test]
fn fi_lib_unary_functions() {
    assert_eq2!(n2i(4.14742026137149e-79, 5.379571027897612e+28).sqrt(), n2i(6.440046786609154e-40, 231939022760242.16));
    assert_eq2!(n2i(1.1108806461872243e-155, 2.373351651082585e-67).sqrt(), n2i(3.332987618019641e-78, 4.871705708561002e-34));
    assert_eq2!(n2i(5.129079157666995e-72, 1.7510703625318296e+71).sqrt(), n2i(2.2647470405471323e-36, 4.1845792650299146e+35));
    assert_eq2!(n2i(6.948997631311531e-148, 2.9283016466945798e-136).sqrt(), n2i(2.636095148379802e-74, 1.71122811065462e-68));
    assert_eq2!(n2i(1.2289762226241382e+59, 2.234162998792154e+68).sqrt(), n2i(3.505675716069782e+29, 1.494711677479023e+34));
    assert_eq2!(n2i(3.7658819597444687e-13, 4.2821276071749897e+83).sqrt(), n2i(6.136678221761728e-07, 6.543796762717337e+41));
    assert_eq2!(n2i(6.336975772360046e-144, 9.158993707856366e+59).sqrt(), n2i(2.517335053654965e-72, 9.570263166630459e+29));
    assert_eq2!(n2i(5.364761505213512e-113, 4.082352475280499e+42).sqrt(), n2i(7.324453225472542e-57, 2.0204832281611495e+21));
    assert_eq2!(n2i(7.550677903404239e-232, 3.2247509487043704e-99).sqrt(), n2i(2.7478496871925577e-116, 5.678689064127715e-50));
    assert_eq2!(n2i(1.2252979900742291e-174, 4.817234909117431e-40).sqrt(), n2i(1.1069317910667435e-87, 2.1948200174769302e-20));
    assert_eq2!(n2i(2.1704355125847167e+35, 4.550722777302787e+83).sqrt(), n2i(4.658793312205121e+17, 6.745904518522915e+41));
    assert_eq2!(n2i(2.5356596321512507e-30, 4.6628667852616304e+61).sqrt(), n2i(1.592375468333788e-15, 6.828518715842867e+30));
    assert_eq2!(n2i(75.82817216007211, 2.5333254202269282e+179).sqrt(), n2i(8.707937308000792, 5.0332150959669194e+89));
    assert_eq2!(n2i(2679384.856388388, 3.456099944072673e+189).sqrt(), n2i(1636.8826642091326, 5.8788603862251e+94));
    assert_eq2!(n2i(2.298466163925377e-53, 3.422642591789023e-07).sqrt(), n2i(4.7942321219621575e-27, 0.0005850335538914861));
    assert_eq2!(n2i(8.331537116545183e-169, 1.2765750898565157e+278).sqrt(), n2i(9.127725410278938e-85, 1.1298562253032534e+139));
    assert_eq2!(n2i(3.718156390017819e-141, 1.0846336072121789e-48).sqrt(), n2i(6.097668726667446e-71, 1.0414574437835561e-24));
    assert_eq2!(n2i(3.1572943290354614e-160, 9.898300388558578e+97).sqrt(), n2i(1.7768776910737162e-80, 9.949020247521149e+48));
    assert_eq2!(n2i(1.0833563616496317e+44, 3.415036575780023e+59).sqrt(), n2i(1.040844062119601e+22, 5.843831427907571e+29));
    assert_eq2!(n2i(8.455584990678977e-99, 6.051563441903092e-73).sqrt(), n2i(9.19542548807774e-50, 7.77917954665085e-37));
    assert_eq2!(n2i(2.3603491417159717e+109, 8.567792987486366e+158).sqrt(), n2i(4.858342455731143e+54, 2.9270792588323206e+79));
    assert_eq2!(n2i(2.0129168242992888e-32, 2.8222933423368047e+41).sqrt(), n2i(1.4187729995666286e-16, 5.312526086841179e+20));
    assert_eq2!(n2i(4.831139778854606e-107, 2.0831343096790316e-23).sqrt(), n2i(6.950640099195617e-54, 4.564136621179335e-12));
    assert_eq2!(n2i(8.466268199564697e-76, 1.6807826919239637e-10).sqrt(), n2i(2.9096852406342335e-38, 1.2964500344880106e-05));
    assert_eq2!(n2i(2.2837024268617953e-151, 2.158830003381977e+22).sqrt(), n2i(4.77880992179203e-76, 146929575082.1453));
    assert_eq2!(n2i(1.1144284066451232e-64, 1.1374419750898092e+58).sqrt(), n2i(1.0556649121028523e-32, 1.0665092475406903e+29));
    assert_eq2!(n2i(1.4637675938067672e-207, 3.6841782399907814e-44).sqrt(), n2i(3.825921580229745e-104, 1.9194213294612473e-22));
    assert_eq2!(n2i(1.806590984564743e+58, 4.476357965164358e+78).sqrt(), n2i(1.344094856981732e+29, 2.115740524063468e+39));
    assert_eq2!(n2i(2.5049493358677617e-102, 4.444462712533866e+177).sqrt(), n2i(1.5827031736455705e-51, 6.666680367719655e+88));
    assert_eq2!(n2i(1.0278297015325257e-53, 1.7554085478168807e-45).sqrt(), n2i(3.205978324213259e-27, 4.1897595967034684e-23));
    assert_eq2!(n2i(-1.8202506318427055e-45, -9.117403206523164e-284).sqr(), n2i(0.0, 3.313312362723769e-90));
    assert_eq2!(n2i(-9.132843019095516e-132, -9.836586939929288e-188).sqr(), n2i(0.0, 8.340882161144171e-263));
    assert_eq2!(n2i(-86.31384205445318, -2.269091389186822e-289).sqr(), n2i(0.0, 7450.07933020109));
    assert_eq2!(n2i(-1.654017949299359e-112, 1.159376035639007e-176).sqr(), n2i(0.0, 2.7357753766044573e-224));
    assert_eq2!(n2i(-2.2615789278302103e-107, -2.921845682025291e-170).sqr(), n2i(0.0, 5.114739246805644e-214));
    assert_eq2!(n2i(-1.4694583917122814e-99, -1.976254011990074e-124).sqr(), n2i(3.905579919906863e-248, 2.1593079649736448e-198));
    assert_eq2!(n2i(-1.0885881319864263e-12, -3.239993862505299e-238).sqr(), n2i(0.0, 1.1850241211016971e-24));
    assert_eq2!(n2i(-3.1146001913444843e-60, -1.1510574328152409e-61).sqr(), n2i(1.3249332136392126e-122, 9.700734351923099e-120));
    assert_eq2!(n2i(3.2157557345980886e-80, 2.86024743464549e-24).sqr(), n2i(1.0341084944600492e-159, 8.181015387396108e-48));
    assert_eq2!(n2i(-7.599545156767026e-113, -3.620806299549832e-276).sqr(), n2i(0.0, 5.775308658974117e-225));
    assert_eq2!(n2i(-8.378054792460111e-178, 0.00021719294064488021).sqr(), n2i(0.0, 4.7172773465970465e-08));
    assert_eq2!(n2i(-6.977305240208117e-101, -5.65298707340689e-174).sqr(), n2i(0.0, 4.868278841503565e-201));
    assert_eq2!(n2i(-5.464129729164142e-282, 9.669182275976748e-117).sqr(), n2i(0.0, 9.34930858860629e-233));
    assert_eq2!(n2i(-2.609094333453399e-148, 5.011306988287881e-06).sqr(), n2i(0.0, 2.5113197730862957e-11));
    assert_eq2!(n2i(-2.5201641840917325e-91, -6.923225182185906e-252).sqr(), n2i(0.0, 6.351227514778748e-182));
    assert_eq2!(n2i(-2.0584112229632026e-150, -1.6910802714540518e-229).sqr(), n2i(0.0, 4.237056762820868e-300));
    assert_eq2!(n2i(-1.1949122607706506e-171, -3.0636415629939144e-235).sqr(), n2i(0.0, 5e-324));
    assert_eq2!(n2i(-1.4102130217593183e-164, 2.1133072064564835e-235).sqr(), n2i(0.0, 5e-324));
    assert_eq2!(n2i(-2.7344024762799374e-15, 2.214286456252712e-200).sqr(), n2i(0.0, 7.476956902285854e-30));
    assert_eq2!(n2i(-4.736813689297964e-37, -3.7578203261478413e-165).sqr(), n2i(0.0, 2.2437403927120588e-73));
    assert_eq2!(n2i(-1.1788723171116539e-269, -3.6970795304788244e-304).sqr(), n2i(0.0, 5e-324));
    assert_eq2!(n2i(-3.170977600535302e-50, 1.7737323532508088e-223).sqr(), n2i(0.0, 1.0055098943096623e-99));
    assert_eq2!(n2i(-9.582715182984807e-234, -6.481946913158783e-280).sqr(), n2i(0.0, 5e-324));
    assert_eq2!(n2i(1.5100300592839213e-212, 1.3573815287255817e-08).sqr(), n2i(0.0, 1.8424846145253973e-16));
    assert_eq2!(n2i(-1.3235071960516872e-113, 8.782017701712099e-233).sqr(), n2i(0.0, 1.7516712980005994e-226));
    assert_eq2!(n2i(-7.715995104235895e-26, -1.8717187851284042e-162).sqr(), n2i(0.0, 5.953658044859231e-51));
    assert_eq2!(n2i(-3.395185885371618e-83, -1.8923225069950326e-149).sqr(), n2i(3.5808844704799652e-298, 1.1527287196226659e-165));
    assert_eq2!(n2i(-1.4492856133171728e-98, -5.707789272110613e-264).sqr(), n2i(0.0, 2.1004287889681337e-196));
    assert_eq2!(n2i(-1.045711771041449e-76, 2.500374714085601e-183).sqr(), n2i(0.0, 1.0935131080946439e-152));
    assert_eq2!(n2i(-1.069106323474024e-70, -1.3000196111841269e-129).sqr(), n2i(1.6900509894633282e-258, 1.1429883308921444e-140));
}
