use std::env;
use dotenv::dotenv;
use tracing::Level;
use imsub_log_crate::RabbitMqClient;



#[cfg(test)]



#[tokio::test]
async fn publish_message() {
    let rabbit_client = build_rabbit_client().await;

    rabbit_client.send_log(
        &Level::INFO,
        Some("USER_TEST".to_string()),
        Some("METHOD_TEST".to_string()),
        Some("MESSAGE_TEST".to_string()),
        Some("DETAILS_TEST".to_string())
    );
}

#[tokio::test]
async fn check_connection() {
    let rabbit_client = build_rabbit_client().await;
    assert!(rabbit_client.check_status());
}

async fn build_rabbit_client() -> RabbitMqClient {
    let rabbit_url = get_rabbit_url().unwrap();
    RabbitMqClient::new(rabbit_url, "TEST".to_string()).await.unwrap()
}

fn get_rabbit_url() -> Option<String> {
    dotenv().ok();
    env::var("RABBIT_URL").ok()
}

