use lapin::Error as LapinError;
use serde_json::Error as SerdeJsonError;
use std::sync::PoisonError;

#[derive(Debug)]
pub enum Error {
    Rabbit(LapinError),
    Lock,
    Serialization(SerdeJsonError)
}

impl From<LapinError> for Error {
    fn from(err: LapinError) -> Self {
        Self::Rabbit(err)
    }
}

impl<T> From<PoisonError<T>> for Error {
    fn from(_err: PoisonError<T>) -> Self {
        Self::Lock
    }
}

impl From<serde_json::Error> for Error {
    fn from(err: SerdeJsonError) -> Self {
        Self::Serialization(err)
    }
}
