// Checks that the impl trait can have where.

use impl_trait::impl_trait;

struct Foo<T>(T);
trait Bar<U> {
}

impl_trait! {
    impl<T> Foo<T> {
        impl trait<U> Bar<U> where Self: From<U> {
        }
    }
}
impl From<()> for Foo<()> {
    fn from(x: ()) -> Self {
        Self { 0: x }
    }
}

fn static_assert_1<T: Bar<U>, U>(_t: T, _u: U) {}

fn main() {
    static_assert_1(Foo(()), ());
}
