// Checks that the impl trait can have its own generics.

use impl_trait::impl_trait;

struct Foo<T>(T);
trait Bar<U> {
}

impl_trait! {
    impl<T> Foo<T> {
        impl trait<U> Bar<U> {
        }
    }
}

fn static_assert_1<T: Bar<U>, U>(_t: T, _u: U) {}

fn main() {
    static_assert_1(Foo(()), ());
}
