// Checks that multiple `impl trait` in a row are valid, with generics and docs.

use impl_trait::impl_trait;

struct Foo<T>(T);
trait Bar {
}
trait Baz {
}

impl_trait! {
    impl<T> Foo<T> {
        /// ABC
        impl trait Bar {
        }
        /// DEF
        impl trait Baz {
        }
    }
}

fn static_assert_1<T: Bar>(_t: T) {}
fn static_assert_2<T: Baz>(_t: T) {}

fn main() {
    static_assert_1(Foo(()));
    static_assert_2(Foo(()));
}
