`impl_trait!`
============

TL;DR: this adds `impl_trait!` which lets you do:

```rust
struct Foo;

trait Bar {}

impl_trait! {
  /// Yes, you can write docs here.
  impl Foo {
    /// You can write docs here too.
    fn as_dyn_bar(&self) -> &dyn Bar {
      self
    }
    /// You can even write docs here!
    impl trait Bar {
    }
  }
}
```

A few things to note:

- You can have generics on the main `impl<T> Foo` block.
- You can have generics on the trait impl with `impl trait<T> Bar`.
- We unfortunately cannot make rustdoc output the trait impls as if they
    were somehow "inherent" to the type. They'll still show up in a separate
    "trait impls" section rather than as part of the appropriate impl block.

A note on licensing
-------------------

This is a proc macro. It basically implements a simple syntax sugar that you
can trivially desugar by hand.

In fact, it's probably easier to desugar by hand than to write a dang proc
macro to do it for you!

Nevertheless, yes, this is AGPLv3-licensed. If using an AGPLv3-licensed
proc macro/compiler plugin that doesn't even add its own code to your code
is a problem for you, you are welcome to contact us about highly expensive
commercial licenses. However, we would find it much more satisfying if you
told your employer to ride a cactus, because *this is a fucking compiler
plugin omg you do not need to care about the license unless you're literally
Godbolt Compiler Explorer or something*.

Thankfully, the AGPLv3 comes with plenty of holes like the system library
exception, as well as the fact that clause 13 specifically starts with the
words "if you modify the Program" i.e. it explicitly doesn't apply if you're
just using the plain old crates.io version of this crate.

Further, this code is awful, so please don't copy it.

License
-------

```text
impl_trait - Rust proc macro that significantly reduces boilerplate
Copyright (C) 2021  Soni L.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
```
