/*
 * Imgur API
 *
 * Imgur's API exposes the entire Imgur infrastructure via a standardized programmatic interface. Using Imgur's API, you can do just about anything you can do on imgur.com, while using your programming language of choice.
 *
 * The version of the OpenAPI document: 0.4.0
 * 
 * Generated by: https://openapi-generator.tech
 */




#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct AccessToken {
    #[serde(rename = "access_token")]
    pub access_token: String,
    #[serde(rename = "account_id")]
    pub account_id: i32,
    #[serde(rename = "account_username")]
    pub account_username: String,
    #[serde(rename = "expires_in")]
    pub expires_in: i32,
    #[serde(rename = "refresh_token")]
    pub refresh_token: String,
    #[serde(rename = "scope", skip_serializing_if = "Option::is_none")]
    pub scope: Option<String>,
    #[serde(rename = "token_type")]
    pub token_type: String,
}

impl AccessToken {
    pub fn new(access_token: String, account_id: i32, account_username: String, expires_in: i32, refresh_token: String, token_type: String) -> AccessToken {
        AccessToken {
            access_token,
            account_id,
            account_username,
            expires_in,
            refresh_token,
            scope: None,
            token_type,
        }
    }
}


