#![feature(backtrace)]
#![feature(result_flattening)]
#![allow(unused_parens)]

//! Provides [Client], an opinionated wrapper around IMDB's dataset.  Because IMDB doesn't provide
//! a searchable API, this crate makes use of [indexkv] to create a local cache, on disk, that
//! provides fast ID lookups.  Datasets are downloaded as-needed.

mod error;
pub use error::Error;

mod client;
pub use client::Client;

mod episode;
use episode::EpisodeLink;
mod movie;
pub use movie::Movie;
mod show;
pub use show::Episode;
pub use show::Show;
mod title;
pub use title::Title;
pub use title::TitleType;
pub(crate) mod util;

