use indexkv::StreamError;

#[derive(thiserror::Error, Debug)]
pub enum Error {
	#[error("year missing")]
	YearMissing,
	#[error("season missing")]
	SeasonMissing,
	#[error("episode missing")]
	EpisodeMissing,
	#[error("wrong media type {0} for {1}")]
	WrongMediaType(&'static str, &'static str),
	#[error("HTTP error")]
	HTTP(#[from] reqwest::Error),
	#[error("CSV error")]
	CSV(#[from] csv_async::Error),
	#[error("I/O error")]
	IO(#[from] std::io::Error),
	#[error("failed to do math on system times")]
	SystemTime(#[from] std::time::SystemTimeError),
	#[error("title ID {0} not found")]
	NotFound(u64),
	#[error("cache failure")]
	Cache(#[from] indexkv::Error)
}

impl From<StreamError<Error>> for Error {
	fn from(other: StreamError<Error>) -> Self {
		match other {
			StreamError::Internal(e) => Self::from(e),
			StreamError::Caller(e) => e
		}
	}
}

