#[derive(thiserror::Error, Debug)]
pub enum Error {
	#[error("year missing")]
	YearMissing,
	#[error("season missing")]
	SeasonMissing,
	#[error("episode missing")]
	EpisodeMissing,
	#[error("wrong media type {0} for {1}")]
	WrongMediaType(String, String),
	#[error("HTTP error")]
	HTTP(#[from] reqwest::Error),
	#[error("CSV error")]
	CSV(#[from] csv_async::Error),
	#[error("I/O error")]
	IO(#[from] std::io::Error),
	#[error("failed to do math on system times")]
	SystemTime(#[from] std::time::SystemTimeError),
	#[error("title ID {0} not found")]
	NotFound(u64),
	#[error("cache failure")]
	Cache(#[from] indexkv::Error)
	//#[error("general failure")]
	//Other(#[from] Box<dyn std::error::Error>)
}

