use serde::Deserialize;
#[derive(Deserialize, Debug)]
pub struct PinPollResult {
    pub state: PinPollState,
    pub code: Option<String>,
    pub expires_in: Option<i64>,
}

#[derive(Deserialize, Debug)]
pub enum PinPollState {
    #[serde(alias = "tentative")]
    Tentative,
    #[serde(alias = "invalid")]
    Invalid,
    #[serde(alias = "granted")]
    Granted,
}
