use chrono::{DateTime, FixedOffset};
use serde::{de, Deserialize, Deserializer};
#[derive(Deserialize, Debug)]
#[serde(rename_all = "PascalCase")]
pub struct MediaItem {
    pub id: u64,
    pub vault_id: u64,
    pub name: String,
    #[serde(deserialize_with = "fixed_date_time_from_str")]
    pub date_added: DateTime<FixedOffset>,
    pub added_by: String,
}

fn fixed_date_time_from_str<'de, D: Deserializer<'de>>(
    deserializer: D,
) -> Result<DateTime<FixedOffset>, D::Error> {
    let s: String = Deserialize::deserialize(deserializer)?;
    DateTime::parse_from_rfc3339(&s).map_err(de::Error::custom)
}
