//! # Authentication
//!
//! ImageVault supports various ways to authenticate. This module
//! holds the main `Authentication` trait and its various implementations.

pub use client_credentials::ClientCredentialsAuthentication;
pub use pin_code::PinCodeAuthentication;
use url::Url;
mod client_credentials;
use crate::error::Error as ImageVaultError;
#[cfg(test)]
mod dummy_authentication;
mod pin_code;

#[cfg(test)]
pub use dummy_authentication::DummyAuth;

use async_trait::async_trait;

#[async_trait]
/// # Authentication
///
/// The underlying trait for ImageVault authentication
pub trait Authentication {
    /// Authenticate is called from the ImageVault `Client`
    /// whenever a request requiring authentication is made.
    /// It shouldn't be called directly.
    ///
    /// ## Remarks
    /// Mutates the authentication if required.
    async fn authenticate(
        &mut self,
        client_identity: &str,
        client_secret: &str,
        base_url: &Url,
        reqwest_client: &reqwest::Client,
    ) -> Result<String, ImageVaultError>;
}
